/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.server.rmi;

import com.sun.enterprise.admin.jmx.remote.IStringManager;
import com.sun.enterprise.admin.jmx.remote.StringManagerFactory;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.logging.Logger;

class RmiStubRegistryHandler {
    private static IStringManager sm = StringManagerFactory.getServerStringManager(RmiStubRegistryHandler.class);
    private final Logger logger;

    RmiStubRegistryHandler(int port, boolean secureRegistry, Logger logger, RMIServerSocketFactory rmiregssf) {
        if (logger == null) {
            throw new IllegalArgumentException("Internal: Null logger");
        }
        this.logger = logger;
        if (secureRegistry) {
            throw new UnsupportedOperationException("Yet to be implemented");
        }
        this.startInsecureRegistry(port, rmiregssf);
    }

    private void startInsecureRegistry(int port, RMIServerSocketFactory rmiregssf) {
        try {
            Registry r = LocateRegistry.createRegistry(port, RMISocketFactory.getDefaultSocketFactory(), rmiregssf);
            this.logBindings(r, port);
        }
        catch (Exception e) {
            String msg = sm.getString("no.port.msg", new Integer(port));
            throw new RuntimeException(e);
        }
    }

    private void logBindings(Registry r, int port) {
        try {
            String[] bs = r.list();
            this.logger.fine("Initial Bindings in RmiRegistry at port: [" + port + "] :");
            for (int i = 0; i < bs.length; ++i) {
                this.logger.fine("JMX Connector RMI Registry binding: " + bs[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

