/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.ManagementObjectManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.common.exception.DeploymentException;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.common.exception.ServerInstanceException;
import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.ElementChangeHelper;
import com.sun.enterprise.admin.mbeanapi.IApplicationsConfigMBean;
import com.sun.enterprise.admin.mbeans.J2EEModule;
import com.sun.enterprise.admin.mbeans.custom.BasicCustomMBeanConfigQueries;
import com.sun.enterprise.admin.mbeans.custom.BasicCustomMBeanOperations;
import com.sun.enterprise.admin.mbeans.custom.CustomMBeanConfigQueries;
import com.sun.enterprise.admin.mbeans.custom.CustomMBeanOperationsMBean;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.server.core.CustomMBeanException;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.admin.util.HostAndPort;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.LifecycleModule;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.connectors.ConnectorConstants;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.InboundResourceAdapter;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentCommand;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.DeploymentUtils;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.io.DescriptorList;
import com.sun.enterprise.deployment.phasing.DeploymentService;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.phasing.DeploymentTargetFactory;
import com.sun.enterprise.deployment.util.DeploymentProperties;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.instance.AppclientModulesManager;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.ConnectorModulesManager;
import com.sun.enterprise.instance.EjbModulesManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.InstanceFactory;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationsConfigMBean
extends BaseConfigMBean
implements IApplicationsConfigMBean,
CustomMBeanOperationsMBean,
CustomMBeanConfigQueries {
    public static final String DEFAULT_TARGET = "domain";
    public static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    protected DeploymentService deployService = null;
    protected String mInstanceName = null;
    protected ConfigContext m_configContext = null;
    protected CustomMBeanOperationsMBean cmo = null;
    protected CustomMBeanConfigQueries cmcq = null;
    protected static final Object[] emptyParams = new Object[0];
    protected static final String[] emptySignature = new String[0];
    protected static final StringManager localStrings = StringManager.getManager(ApplicationsConfigMBean.class);
    protected static final String TYPE_APPLICATION = "application";
    protected static final String TYPE_EJB = "ejb";
    protected static final String TYPE_WEB = "web";
    protected static final String TYPE_CONNECTOR = "connector";
    protected static final String TYPE_APPCLIENT = "appclient";
    protected static final String JSR88_TYPE_APPLICATION = "ear";
    protected static final String JSR88_TYPE_EJB = "ejb";
    protected static final String JSR88_TYPE_WEB = "war";
    protected static final String JSR88_TYPE_CONNECTOR = "rar";
    protected static final String JSR88_TYPE_APPCLIENT = "car";
    protected static final String DOMAIN_TARGET = "domain";
    protected static final DeployableObjectType[] deployableObjectTypes = new DeployableObjectType[]{DeployableObjectType.APP, DeployableObjectType.EJB, DeployableObjectType.WEB, DeployableObjectType.CONN, DeployableObjectType.CAR, DeployableObjectType.LCM, DeployableObjectType.CMB};
    private static final TargetType[] VALID_LIST_TYPES = new TargetType[]{TargetType.CLUSTER, TargetType.SERVER, TargetType.DAS, TargetType.DOMAIN};
    static final String NAME = "name";
    static final String ENABLED = "enabled";
    protected static final String ADMIN_VS = "__asadmin";
    protected static final String PORT = "port";
    protected static final String DEF_VS = "default-virtual-server";
    protected static final String SERVER_NAME = "server-name";
    protected static final String REDIRECT_PORT = "redirect-port";
    protected static final String SEC_ENABLED = "security-enabled";
    protected static final String LISTENER_ENABLED = "enabled";
    protected static final String OBJECT_TYPE = "object-type";
    protected static final String HOSTS = "hosts";
    protected static final String HTTP_LISTENERS = "http_listeners";
    protected static final String DEFAULT_WEB_MODULE = "default_web_module";
    protected static final String STATE = "state";
    protected static final String ID = "id";
    protected static final String DEPLOY_ACTION = "deploy";
    protected static final String REDEPLOY_ACTION = "redeploy";
    protected static final String UNDEPLOY_ACTION = "undeploy";
    protected static final String ENABLE_ACTION = "enable";
    protected static final String DISABLE_ACTION = "disable";
    protected static String[] httpListenerAttrNames = new String[]{"enabled", "default-virtual-server", "server-name", "redirect-port", "port", "security-enabled", "id"};
    protected static String[] vsAttrNames = new String[]{"hosts", "http_listeners", "default_web_module", "state", "id"};

    public ApplicationsConfigMBean(String instanceName, ConfigContext configContext) throws MBeanConfigException {
        this.mInstanceName = instanceName;
        this.m_configContext = configContext;
        this.deployService = DeploymentService.getDeploymentService(configContext);
        this.initCustomMBeanHandlers();
    }

    public ApplicationsConfigMBean() throws MBeanConfigException {
        this.initCustomMBeanHandlers();
    }

    protected void initCustomMBeanHandlers() {
        this.cmo = new BasicCustomMBeanOperations();
        this.cmcq = new BasicCustomMBeanConfigQueries();
    }

    private DeploymentTarget getAndValidateDeploymentTarget(String targetName, String appName, boolean isRegistered) throws IASDeploymentException {
        return this.getAndValidateDeploymentTarget(targetName, appName, isRegistered, false);
    }

    private DeploymentTarget getAndValidateDeploymentTarget(String targetName, String appName, boolean isRegistered, boolean isDeleting) throws IASDeploymentException {
        try {
            DeploymentTarget target = this.getTargetFactory().getTarget(this.getConfigContext(), this.getDomainName(), targetName);
            if (isRegistered) {
                if (targetName == null) {
                    targetName = target.getTarget().getName();
                }
                if (target.getTarget().getType() == TargetType.DOMAIN && isDeleting) {
                    if (ApplicationHelper.isApplicationReferenced(this.getConfigContext(), appName)) {
                        throw new IASDeploymentException(localStrings.getString("applicationIsReferenced", appName, ApplicationHelper.getApplicationReferenceesAsString(this.getConfigContext(), appName)));
                    }
                } else if (target.getTarget().getType() == TargetType.SERVER || target.getTarget().getType() == TargetType.DAS) {
                    if (!ServerHelper.serverReferencesApplication(this.getConfigContext(), targetName, appName) && isDeleting) {
                        throw new IASDeploymentException(localStrings.getString("serverApplicationRefDoesNotExist", targetName, appName));
                    }
                    if (!ApplicationHelper.isApplicationReferencedByServerOnly(this.getConfigContext(), appName, targetName)) {
                        throw new IASDeploymentException(localStrings.getString("applicationHasMultipleRefs", targetName, appName, ApplicationHelper.getApplicationReferenceesAsString(this.getConfigContext(), appName)));
                    }
                } else if (target.getTarget().getType() == TargetType.CLUSTER) {
                    if (!ClusterHelper.clusterReferencesApplication(this.getConfigContext(), targetName, appName) && isDeleting) {
                        throw new IASDeploymentException(localStrings.getString("clusterApplicationRefDoesNotExist", targetName, appName));
                    }
                    if (!ApplicationHelper.isApplicationReferencedByClusterOnly(this.getConfigContext(), appName, targetName)) {
                        throw new IASDeploymentException(localStrings.getString("applicationHasMultipleRefs", targetName, appName, ApplicationHelper.getApplicationReferenceesAsString(this.getConfigContext(), appName)));
                    }
                }
            }
            return target;
        }
        catch (IASDeploymentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IASDeploymentException(ex);
        }
    }

    public DeploymentStatus deploy(Properties props, String[] targets) throws DeploymentException {
        DeploymentStatus status2 = null;
        props.setProperty("target", targets[0]);
        status2 = this.deploy(props);
        for (int i = 1; i < targets.length; ++i) {
            try {
                this.associateApplication(props, targets[i]);
                continue;
            }
            catch (MBeanConfigException m) {
                DeploymentException e = new DeploymentException(m.getMessage());
                e.initCause(m);
                throw e;
            }
        }
        return status2;
    }

    public void associateApplication(Properties props, String targetName) throws MBeanConfigException {
        try {
            DeploymentTarget target = this.getTargetFactory().getTarget(this.getConfigContext(), this.getDomainName(), targetName);
            boolean enabled = Boolean.valueOf(props.getProperty(ENABLE_ACTION));
            target.addAppReference(props.getProperty(NAME), enabled, props.getProperty("virtualservers"));
        }
        catch (Exception e) {
            MBeanConfigException m = new MBeanConfigException(e.getMessage());
            m.initCause(e);
            throw m;
        }
    }

    public DeploymentStatus undeploy(Properties props, String[] targets) throws DeploymentException {
        DeploymentStatus status2 = null;
        props.setProperty("target", targets[0]);
        for (int i = 1; i < targets.length; ++i) {
            try {
                this.disassociateApplication(props, targets[i]);
                continue;
            }
            catch (MBeanConfigException m) {
                DeploymentException e = new DeploymentException(m.getMessage());
                e.initCause(m);
                throw e;
            }
        }
        status2 = this.undeploy(props);
        return status2;
    }

    public void disassociateApplication(Properties props, String targetName) throws MBeanConfigException {
        try {
            DeploymentTarget target = this.getTargetFactory().getTarget(this.getConfigContext(), this.getDomainName(), targetName);
            target.removeAppReference(props.getProperty(NAME));
        }
        catch (Exception e) {
            MBeanConfigException m = new MBeanConfigException(e.getMessage());
            m.initCause(e);
            throw m;
        }
    }

    public Integer getModuleType(String standAloneModuleName) throws ServerInstanceException {
        sLogger.log(Level.FINE, "getModuleType - begin standAloneModuleName = " + standAloneModuleName);
        J2EEModule j2eeModule = new J2EEModule(standAloneModuleName);
        ModuleType moduleType = j2eeModule.getModuleType();
        if (moduleType == null) {
            return null;
        }
        return moduleType.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentStatus deploy(Properties props) throws DeploymentException {
        DeploymentProperties dProps = new DeploymentProperties(props);
        String archiveName = dProps.getArchiveName();
        String name = dProps.getName(archiveName);
        DeployableObjectType type = this.getTypeFromFile(name, archiveName);
        if (archiveName == null) {
            throw new IllegalArgumentException("archiveName not specified");
        }
        sLogger.log(Level.FINE, "mbean.begin_deploy", archiveName);
        File deployFile = new File(archiveName);
        int actionCode = 1;
        try {
            InstanceEnvironment env = new InstanceEnvironment(this.getInstanceName());
            DeploymentRequest req = new DeploymentRequest(env, type, DeploymentCommand.DEPLOY);
            boolean isRegistered = false;
            ObjectName componentON = this.getRegisteredComponentObjectName(name, type);
            if (componentON != null) {
                isRegistered = true;
            }
            if (isRegistered) {
                this.validate(componentON, REDEPLOY_ACTION);
            }
            actionCode = type.isAPP() ? 1 : 4;
            req.setFileSource(deployFile);
            req.setName(name);
            req.setForced(dProps.getForce());
            req.setCascade(true);
            if (type.isWEB()) {
                req.setDefaultContextRoot(dProps.getDefaultContextRoot(archiveName));
                req.setContextRoot(dProps.getContextRoot());
            }
            req.setVerifying(dProps.getVerify());
            req.setPrecompileJSP(dProps.getPrecompileJSP());
            req.setGenerateRMIStubs(dProps.getGenerateRMIStubs());
            req.setAvailabilityEnabled(dProps.getAvailabilityEnabled());
            req.setStartOnDeploy(dProps.getEnable());
            req.setDescription(dProps.getDescription());
            req.setLibraries(dProps.getLibraries());
            req.setJavaWebStartEnabled(dProps.getJavaWebStartEnabled());
            req.setExternallyManagedPath(dProps.getExternallyManaged());
            req.setActionCode(actionCode);
            DeploymentServiceUtils.setResourceOptionsInRequest(req, dProps);
            DeploymentTarget target = this.getAndValidateDeploymentTarget(dProps.getTarget(), name, isRegistered);
            req.setTarget(target);
            Properties optionalAttributes = new Properties();
            String virtualServers = dProps.getVirtualServers();
            if (virtualServers != null) {
                optionalAttributes.put("virtual-servers", dProps.getVirtualServers());
            }
            req.setOptionalAttributes(optionalAttributes);
            props = props == null ? new Properties() : dProps.prune();
            req.addOptionalArguments(props);
            this.setHostAndPort(req);
            DeploymentStatus deploymentStatus = this.getDeploymentService().deploy(req);
            return deploymentStatus;
        }
        catch (Exception e) {
            if (actionCode == 1) {
                sLogger.log(Level.WARNING, "mbean.deploy_failed", e);
            } else {
                sLogger.log(Level.WARNING, "mbean.redeploy_failed", e);
            }
            DeploymentStatus ds = new DeploymentStatus();
            ds.setStageException(e);
            ds.setStageStatus(0);
            ds.setStageStatusMessage(e.getMessage());
            ds.setStageDescription("Deployment");
            DeploymentStatus deploymentStatus = ds;
            return deploymentStatus;
        }
        finally {
            this.deleteFile(archiveName);
        }
    }

    @Override
    public DeploymentStatus undeploy(Properties props) throws DeploymentException {
        String name = props.getProperty(NAME);
        if (name == null) {
            throw new DeploymentException("name not specified in undeploy");
        }
        sLogger.log(Level.FINE, "mbean.begin_undeploy", name);
        try {
            DeployableObjectType objectType = this.getRegisteredType(name);
            ObjectName componentON = this.getRegisteredComponentObjectName(name, objectType);
            this.validate(componentON, UNDEPLOY_ACTION);
            if (objectType.isWEB()) {
                this.checkWebModuleReferences(name);
            }
            DeploymentRequest req = new DeploymentRequest(new InstanceEnvironment(this.getInstanceName()), objectType, DeploymentCommand.UNDEPLOY);
            DeploymentProperties dProps = new DeploymentProperties(props);
            req.setName(name);
            req.setCascade(dProps.getCascade());
            req.setReload(dProps.getReload());
            req.setForced(false);
            req.setExternallyManagedPath(dProps.getExternallyManaged());
            DeploymentServiceUtils.setResourceOptionsInRequest(req, dProps);
            props = dProps.prune();
            req.addOptionalArguments(props);
            if (objectType.isAPP()) {
                req.setActionCode(2);
            } else {
                req.setActionCode(5);
            }
            DeploymentTarget target = this.getAndValidateDeploymentTarget(dProps.getTarget(), name, true, true);
            req.setTarget(target);
            String dependentResource = DeploymentServiceUtils.checkConnectorDependentResourcesForUndeploy(req);
            if (dependentResource != null) {
                String msg = localStrings.getString("admin.mbeans.acmb.dependentresexist", new Object[]{dependentResource});
                throw new IASDeploymentException(msg);
            }
            return this.getDeploymentService().undeploy(req);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.undeploy_failed", e);
            DeploymentStatus ds = new DeploymentStatus();
            ds.setStageException(e);
            ds.setStageStatus(0);
            ds.setStageStatusMessage(e.getMessage());
            ds.setStageDescription("Undeployment");
            return ds;
        }
    }

    public DeploymentStatus createApplicationReference(String targetName, boolean enabled, String virtualServers, String referenceName) {
        try {
            sLogger.log(Level.FINE, "mbean.create_app_reference", referenceName);
            return DeploymentService.getDeploymentService().associate(targetName, enabled, virtualServers, referenceName);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.create_app_reference_failed", e);
            DeploymentStatus ds = new DeploymentStatus();
            ds.setStageException(e);
            ds.setStageStatus(0);
            ds.setStageStatusMessage(e.getMessage());
            ds.setStageDescription("Association");
            return ds;
        }
    }

    public DeploymentStatus deleteApplicationReference(String targetName, String referenceName) {
        try {
            sLogger.log(Level.FINE, "mbean.delete_app_reference", referenceName);
            return DeploymentService.getDeploymentService().disassociate(targetName, referenceName);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.delete_app_reference_failed", e);
            DeploymentStatus ds = new DeploymentStatus();
            ds.setStageException(e);
            ds.setStageStatus(0);
            ds.setStageStatusMessage(e.getMessage());
            ds.setStageDescription("Disassociation");
            return ds;
        }
    }

    public DeploymentStatus createApplicationReference(String targetName, String referenceName, Map options) {
        try {
            sLogger.log(Level.FINE, "mbean.create_app_reference", referenceName);
            return DeploymentService.getDeploymentService().associate(targetName, referenceName, options);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.create_app_reference_failed", e);
            DeploymentStatus ds = new DeploymentStatus();
            ds.setStageException(e);
            ds.setStageStatus(0);
            ds.setStageStatusMessage(e.getMessage());
            ds.setStageDescription("Association");
            return ds;
        }
    }

    public Map createApplicationReferenceAndReturnStatusAsMap(String targetName, String referenceName, Map options) {
        DeploymentStatus oldStatus = this.createApplicationReference(targetName, referenceName, options);
        return oldStatus.asMap();
    }

    public DeploymentStatus deleteApplicationReference(String targetName, String referenceName, Map options) {
        try {
            sLogger.log(Level.FINE, "mbean.delete_app_reference", referenceName);
            return DeploymentService.getDeploymentService().disassociate(targetName, referenceName, options);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.delete_app_reference_failed", e);
            DeploymentStatus ds = new DeploymentStatus();
            ds.setStageException(e);
            ds.setStageStatus(0);
            ds.setStageStatusMessage(e.getMessage());
            ds.setStageDescription("Disassociation");
            return ds;
        }
    }

    public Map deleteApplicationReferenceAndReturnStatusAsMap(String targetName, String referenceName, Map options) {
        DeploymentStatus oldStatus = this.deleteApplicationReference(targetName, referenceName, options);
        return oldStatus.asMap();
    }

    public DeploymentStatus start(String moduleID, String targetName, Map options) {
        try {
            sLogger.log(Level.FINE, "mbean.start", moduleID);
            return DeploymentService.getDeploymentService().start(moduleID, targetName, options);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.start_failed", e);
            DeploymentStatus ds = new DeploymentStatus();
            ds.setStageException(e);
            ds.setStageStatus(0);
            ds.setStageStatusMessage(e.getMessage());
            ds.setStageDescription("Start");
            return ds;
        }
    }

    public Map startAndReturnStatusAsMap(String moduleID, String targetName, Map options) {
        DeploymentStatus oldStatus = this.start(moduleID, targetName, options);
        return oldStatus.asMap();
    }

    public DeploymentStatus stop(String moduleID, String targetName, Map options) {
        try {
            sLogger.log(Level.FINE, "mbean.stop", moduleID);
            DeploymentStatus status2 = DeploymentService.getDeploymentService().stop(moduleID, targetName, options);
            this.getConfigContext().flush();
            this.getConfigContext().resetConfigChangeList();
            return status2;
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.stop_failed", e);
            DeploymentStatus ds = new DeploymentStatus();
            ds.setStageException(e);
            ds.setStageStatus(0);
            ds.setStageStatusMessage(e.getMessage());
            ds.setStageDescription("Stop");
            return ds;
        }
    }

    public Map stopAndReturnStatusAsMap(String moduleID, String targetName, Map options) {
        DeploymentStatus oldStatus = this.stop(moduleID, targetName, options);
        return oldStatus.asMap();
    }

    @Override
    public boolean deployJ2EEApplication(Properties props) throws DeploymentException {
        DeploymentProperties dProps = new DeploymentProperties(props);
        String archiveName = dProps.getArchiveName();
        if (archiveName == null) {
            throw new IllegalArgumentException("archiveName not specified");
        }
        sLogger.log(Level.FINE, "mbean.begin_deploy", archiveName);
        File deployFile = new File(archiveName);
        int actionCode = 1;
        try {
            InstanceEnvironment env = new InstanceEnvironment(this.getInstanceName());
            DeploymentRequest req = new DeploymentRequest(env, DeployableObjectType.APP, DeploymentCommand.DEPLOY);
            String appName = dProps.getName(archiveName);
            boolean isAppExists = this.isRegistered(appName, DeployableObjectType.APP);
            actionCode = isAppExists && dProps.getForce() ? 3 : 1;
            req.setFileSource(deployFile);
            req.setName(appName);
            req.setForced(dProps.getForce());
            req.setVerifying(dProps.getVerify());
            req.setPrecompileJSP(dProps.getPrecompileJSP());
            req.setStartOnDeploy(dProps.getEnable());
            req.setActionCode(actionCode);
            DeploymentTarget target = this.getAndValidateDeploymentTarget(dProps.getTarget(), appName, isAppExists);
            req.setTarget(target);
            Properties optionalAttributes = new Properties();
            String virtualServers = dProps.getVirtualServers();
            if (virtualServers != null) {
                optionalAttributes.put("virtual-servers", dProps.getVirtualServers());
            }
            req.setOptionalAttributes(optionalAttributes);
            props = props == null ? new Properties() : dProps.prune();
            req.addOptionalArguments(props);
            this.setHostAndPort(req);
            this.getDeploymentService().deploy(req);
        }
        catch (Exception e) {
            if (actionCode == 1) {
                sLogger.log(Level.WARNING, "mbean.deploy_failed", e);
            } else {
                sLogger.log(Level.WARNING, "mbean.redeploy_failed", e);
            }
            DeploymentException newE = new DeploymentException(e.getMessage());
            newE.initCause(e);
            throw newE;
        }
        finally {
            this.deleteFile(archiveName);
        }
        return true;
    }

    @Override
    public boolean deployEJBJarModule(Properties props) throws DeploymentException {
        DeploymentProperties dProps = new DeploymentProperties(props);
        String filePath = dProps.getArchiveName();
        if (filePath == null) {
            throw new IllegalArgumentException();
        }
        boolean loadStatus = true;
        sLogger.log(Level.FINE, "deploymentservice.begin_deploy", filePath);
        File deployFile = new File(filePath);
        int actionCode = 4;
        try {
            InstanceEnvironment env = new InstanceEnvironment(this.getInstanceName());
            DeploymentRequest req = new DeploymentRequest(env, DeployableObjectType.EJB, DeploymentCommand.DEPLOY);
            String moduleName = dProps.getName(filePath);
            boolean isModuleExists = this.isRegistered(moduleName, DeployableObjectType.EJB);
            actionCode = isModuleExists && dProps.getForce() ? 6 : 4;
            req.setFileSource(deployFile);
            req.setName(moduleName);
            req.setForced(dProps.getForce());
            req.setVerifying(dProps.getVerify());
            req.setStartOnDeploy(dProps.getEnable());
            req.setActionCode(actionCode);
            DeploymentTarget target = this.getAndValidateDeploymentTarget(dProps.getTarget(), moduleName, isModuleExists);
            req.setTarget(target);
            props = props == null ? new Properties() : dProps.prune();
            req.addOptionalArguments(props);
            this.getDeploymentService().deploy(req);
        }
        catch (Exception e) {
            if (actionCode == 4) {
                sLogger.log(Level.WARNING, "mbean.deploy_failed", e);
            } else {
                sLogger.log(Level.WARNING, "mbean.redeploy_failed", e);
            }
            throw new DeploymentException(e.getMessage());
        }
        finally {
            this.deleteFile(filePath);
        }
        return loadStatus;
    }

    @Override
    public boolean deployWarModule(Properties props) throws DeploymentException {
        DeploymentProperties dProps = new DeploymentProperties(props);
        String filePath = dProps.getArchiveName();
        if (filePath == null) {
            throw new IllegalArgumentException();
        }
        boolean loadStatus = true;
        sLogger.log(Level.FINE, "mbean.begin_deploy", filePath);
        File deployFile = new File(filePath);
        int actionCode = 4;
        try {
            InstanceEnvironment env = new InstanceEnvironment(this.getInstanceName());
            DeploymentRequest req = new DeploymentRequest(env, DeployableObjectType.WEB, DeploymentCommand.DEPLOY);
            String webAppName = dProps.getName(filePath);
            boolean isModuleExists = this.isRegistered(webAppName, DeployableObjectType.WEB);
            actionCode = isModuleExists && dProps.getForce() ? 6 : 4;
            req.setFileSource(deployFile);
            req.setName(webAppName);
            req.setContextRoot(dProps.getContextRoot());
            req.setForced(dProps.getForce());
            req.setVerifying(dProps.getVerify());
            req.setPrecompileJSP(dProps.getPrecompileJSP());
            req.setStartOnDeploy(dProps.getEnable());
            req.setActionCode(actionCode);
            DeploymentTarget target = this.getAndValidateDeploymentTarget(dProps.getTarget(), webAppName, isModuleExists);
            req.setTarget(target);
            this.setHostAndPort(req);
            Properties optionalAttributes = new Properties();
            String virtualServers = dProps.getVirtualServers();
            if (virtualServers != null) {
                optionalAttributes.put("virtual-servers", virtualServers);
            }
            req.setOptionalAttributes(optionalAttributes);
            this.getDeploymentService().deploy(req);
        }
        catch (Exception e) {
            if (actionCode == 4) {
                sLogger.log(Level.WARNING, "mbean.deploy_failed", e);
            } else {
                sLogger.log(Level.WARNING, "mbean.redeploy_failed", e);
            }
            throw new DeploymentException(e.getMessage());
        }
        finally {
            this.deleteFile(filePath);
        }
        return loadStatus;
    }

    @Override
    public boolean deployConnectorModule(Properties props) throws DeploymentException {
        DeploymentProperties dProps = new DeploymentProperties(props);
        String filePath = dProps.getArchiveName();
        if (filePath == null) {
            throw new IllegalArgumentException();
        }
        boolean loadStatus = true;
        sLogger.log(Level.FINE, "mbean.begin_deploy", filePath);
        File deployFile = new File(filePath);
        int actionCode = 4;
        try {
            InstanceEnvironment env = new InstanceEnvironment(this.getInstanceName());
            DeploymentRequest req = new DeploymentRequest(env, DeployableObjectType.CONN, DeploymentCommand.DEPLOY);
            String moduleName = dProps.getName(filePath);
            boolean isModuleExists = this.isRegistered(moduleName, DeployableObjectType.CONN);
            actionCode = isModuleExists && dProps.getForce() ? 6 : 4;
            req.setFileSource(deployFile);
            req.setName(moduleName);
            req.setForced(dProps.getForce());
            req.setVerifying(dProps.getVerify());
            req.setActionCode(actionCode);
            DeploymentTarget target = this.getAndValidateDeploymentTarget(dProps.getTarget(), moduleName, isModuleExists);
            req.setTarget(target);
            req.setStartOnDeploy(dProps.getEnable());
            this.setDeployDirOwner(req, env);
            this.getDeploymentService().deploy(req);
        }
        catch (Exception e) {
            if (actionCode == 4) {
                sLogger.log(Level.WARNING, "mbean.deploy_failed", e);
            } else {
                sLogger.log(Level.WARNING, "mbean.redeploy_failed", e);
            }
            throw new DeploymentException(e.getMessage());
        }
        finally {
            this.deleteFile(filePath);
        }
        return loadStatus;
    }

    @Override
    public String[] getTargets() throws MBeanConfigException {
        try {
            ArrayList<Object> targetList = new ArrayList<Object>();
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            try {
                ObjectName serversON = new ObjectName(this.getDomainName() + ":type=servers,category=config");
                ObjectName[] serverONArr = (ObjectName[])mbs.invoke(serversON, "getServer", emptyParams, emptySignature);
                for (int i = 0; i < serverONArr.length; ++i) {
                    targetList.add(mbs.getAttribute(serverONArr[i], NAME));
                }
            }
            catch (Exception e) {
                targetList.add("server");
            }
            return targetList.toArray(new String[0]);
        }
        catch (Throwable t) {
            throw new MBeanConfigException(t.getMessage());
        }
    }

    @Override
    public String[] getAvailableModules(String moduleType) throws MBeanConfigException {
        String target = "domain";
        return this.getAvailableModules(moduleType, new String[]{target});
    }

    @Override
    public String[] getAvailableModules(String moduleType, String[] targetList) throws MBeanConfigException {
        return this.getAvailableModules(moduleType, targetList, false);
    }

    public String[] getAvailableUserModules(String moduleType, String[] targetList) throws MBeanConfigException {
        return this.getAvailableModules(moduleType, targetList, true);
    }

    private String[] getAvailableModules(String moduleType, String[] targetList, boolean excludeSystemApps) throws MBeanConfigException {
        try {
            DeployableObjectType type = this.getDeployableObjectType(moduleType);
            ArrayList listOfModules = new ArrayList();
            for (int i = 0; i < targetList.length; ++i) {
                listOfModules.addAll(this.getModules(targetList[i], type, null, excludeSystemApps));
            }
            return listOfModules.toArray(new String[listOfModules.size()]);
        }
        catch (Exception e) {
            throw new MBeanConfigException(e.getMessage());
        }
    }

    @Override
    public String[] getRunningModules(String moduleType, String[] targetList) throws MBeanConfigException {
        return this.getRunningModules(moduleType, targetList, false);
    }

    public String[] getRunningUserModules(String moduleType, String[] targetList) throws MBeanConfigException {
        return this.getRunningModules(moduleType, targetList, true);
    }

    private String[] getRunningModules(String moduleType, String[] targetList, boolean excludeSystemApps) throws MBeanConfigException {
        try {
            DeployableObjectType type = this.getDeployableObjectType(moduleType);
            ArrayList listOfModules = new ArrayList();
            for (int i = 0; i < targetList.length; ++i) {
                listOfModules.addAll(this.getModules(targetList[i], type, true, excludeSystemApps));
            }
            return listOfModules.toArray(new String[listOfModules.size()]);
        }
        catch (Exception e) {
            throw new MBeanConfigException(e.getMessage());
        }
    }

    @Override
    public String[] getNonRunningModules(String moduleType, String[] targetList) throws MBeanConfigException {
        return this.getNonRunningModules(moduleType, targetList, false);
    }

    public String[] getNonRunningUserModules(String moduleType, String[] targetList) throws MBeanConfigException {
        return this.getNonRunningModules(moduleType, targetList, false);
    }

    private String[] getNonRunningModules(String moduleType, String[] targetList, boolean excludeSystemApps) throws MBeanConfigException {
        try {
            DeployableObjectType type = this.getDeployableObjectType(moduleType);
            ArrayList listOfModules = new ArrayList();
            for (int i = 0; i < targetList.length; ++i) {
                listOfModules.addAll(this.getModules(targetList[i], type, false, excludeSystemApps));
            }
            return listOfModules.toArray(new String[listOfModules.size()]);
        }
        catch (Exception e) {
            throw new MBeanConfigException(e.getMessage());
        }
    }

    @Override
    public String[] getDeployedJ2EEApplications() throws ServerInstanceException {
        String[] apps = new String[]{};
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            Applications appsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(this.getConfigContext(), "/domain/applications");
            J2eeApplication[] j2eeApps = appsConfigBean.getJ2eeApplication();
            if (j2eeApps != null) {
                apps = new String[j2eeApps.length];
                for (int i = 0; i < j2eeApps.length; ++i) {
                    apps[i] = j2eeApps[i].getName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return apps;
    }

    @Override
    public String[] getDeployedEJBModules() throws ServerInstanceException {
        String[] ejbModules = new String[]{};
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            Applications appsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(this.getConfigContext(), "/domain/applications");
            EjbModule[] modules = appsConfigBean.getEjbModule();
            if (modules != null) {
                ejbModules = new String[modules.length];
                for (int i = 0; i < modules.length; ++i) {
                    ejbModules[i] = modules[i].getName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return ejbModules;
    }

    @Override
    public String[] getDeployedWebModules() throws ServerInstanceException {
        String[] webModules = new String[]{};
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            Applications appsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(this.getConfigContext(), "/domain/applications");
            WebModule[] modules = appsConfigBean.getWebModule();
            if (modules != null) {
                webModules = new String[modules.length];
                for (int i = 0; i < modules.length; ++i) {
                    webModules[i] = modules[i].getName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return webModules;
    }

    @Override
    public String[] getDeployedConnectors() throws ServerInstanceException {
        String[] connectors = new String[]{};
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            Applications appsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(this.getConfigContext(), "/domain/applications");
            ConnectorModule[] connectorConfigBeans = appsConfigBean.getConnectorModule();
            if (connectorConfigBeans != null) {
                connectors = new String[connectorConfigBeans.length];
                for (int i = 0; i < connectors.length; ++i) {
                    connectors[i] = connectorConfigBeans[i].getName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return connectors;
    }

    @Override
    public ObjectName[] getAllDeployedComponents() throws ServerInstanceException {
        int totalCount = 0;
        ObjectName[] allComponents = null;
        try {
            int count;
            sLogger.log(Level.FINE, "mbean.list_components");
            ObjectName[] components = null;
            for (count = 0; count < deployableObjectTypes.length; ++count) {
                components = this.getAllRegisteredComponentsOfType(deployableObjectTypes[count]);
                if (components == null || components.length <= 0) continue;
                totalCount += components.length;
            }
            allComponents = new ObjectName[totalCount];
            if (totalCount > 0) {
                totalCount = 0;
                for (count = 0; count < deployableObjectTypes.length; ++count) {
                    components = this.getAllRegisteredComponentsOfType(deployableObjectTypes[count]);
                    if (components == null || components.length <= 0) continue;
                    int count1 = 0;
                    while (count1 < components.length) {
                        allComponents[totalCount] = components[count1];
                        ++count1;
                        ++totalCount;
                    }
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return allComponents;
    }

    @Override
    public ObjectName[] getAllDeployedJ2EEApplications() throws ServerInstanceException {
        return this.getAllRegisteredComponentsOfType(deployableObjectTypes[0]);
    }

    @Override
    public ObjectName[] getAllDeployedEJBModules() throws ServerInstanceException {
        return this.getAllRegisteredComponentsOfType(deployableObjectTypes[1]);
    }

    @Override
    public ObjectName[] getAllDeployedWebModules() throws ServerInstanceException {
        return this.getAllRegisteredComponentsOfType(deployableObjectTypes[2]);
    }

    @Override
    public ObjectName[] getAllDeployedConnectors() throws ServerInstanceException {
        return this.getAllRegisteredComponentsOfType(deployableObjectTypes[3]);
    }

    public String[] getEmbeddedConnectorNames(String appName, String targetName) throws ServerInstanceException {
        ArrayList<String> names = new ArrayList<String>();
        try {
            Target target = this.getListTarget(targetName);
            String[] apps = this.filterAppsByTargetAndAppName(target, appName);
            for (int i = 0; i < apps.length; ++i) {
                Application ad = this.getDescrForApplication(apps[i]);
                String app_name = ad.getRegistrationName();
                Set bds = ad.getRarDescriptors();
                for (ConnectorDescriptor cd : bds) {
                    String rarJndiName = app_name + "#" + FileUtils.makeFriendlyFilenameNoExtension(cd.getDeployName());
                    names.add(rarJndiName);
                }
            }
        }
        catch (ConfigException e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return names.toArray(new String[0]);
    }

    String[] filterAppsByTargetAndAppName(Target target, String appName) throws ConfigException {
        ObjectName[] appObjectNames = this.getAllRegisteredComponentsOfType(deployableObjectTypes[0]);
        if (target.getType() != TargetType.DOMAIN) {
            ApplicationRef[] appRefs = target.getApplicationRefs();
            appObjectNames = ObjectNameAppRefComparator.intersect(appObjectNames, appRefs);
        }
        HashSet<String> s = new HashSet<String>();
        if (null != appObjectNames) {
            for (int i = 0; i < appObjectNames.length; ++i) {
                s.add(appObjectNames[i].getKeyProperty(NAME));
            }
        }
        if (null != appName) {
            if (s.contains(appName)) {
                return new String[]{appName};
            }
            throw new ConfigException(localStrings.getString("admin.mbeans.acmb.appRefDoesnotExistForTheTarget", appName, target.getName()));
        }
        return s.toArray(new String[0]);
    }

    @Override
    public ObjectName[] getAllDeployedComponents(String targetName) throws ServerInstanceException {
        ObjectName[] oa = new ObjectName[]{};
        try {
            Target target = this.getListTarget(targetName);
            ObjectName[] allComponents = this.getAllDeployedComponents();
            if (target.getType() == TargetType.DOMAIN) {
                return allComponents;
            }
            ApplicationRef[] appRefs = target.getApplicationRefs();
            oa = ObjectNameAppRefComparator.intersect(allComponents, appRefs);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return oa;
    }

    protected Target getListTarget(String targetName) throws ConfigException {
        return TargetBuilder.INSTANCE.createTarget(VALID_LIST_TYPES, targetName, this.getConfigContext());
    }

    public ObjectName[] getAllUserDeployedComponents() throws ServerInstanceException {
        ObjectName[] allComponents = new ObjectName[]{};
        ObjectName[] sysNuserComponents = this.getAllDeployedComponents();
        try {
            ArrayList<ObjectName> arrList = new ArrayList<ObjectName>();
            for (int i = 0; i < sysNuserComponents.length; ++i) {
                String type = sysNuserComponents[i].getKeyProperty("type");
                if (type.equals("appclient-module")) {
                    arrList.add(sysNuserComponents[i]);
                    continue;
                }
                MBeanServer mbs = MBeanServerFactory.getMBeanServer();
                String objectType = (String)mbs.getAttribute(sysNuserComponents[i], OBJECT_TYPE);
                if (objectType != null && objectType.startsWith("system-")) continue;
                arrList.add(sysNuserComponents[i]);
            }
            if (!arrList.isEmpty()) {
                allComponents = arrList.toArray(new ObjectName[arrList.size()]);
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "ApplicationsConfigMBean.getAllUserDeployedComponents", e);
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return allComponents;
    }

    public ObjectName[] getAllUserDeployedComponents(String targetName) throws ServerInstanceException {
        ObjectName[] oa = new ObjectName[]{};
        try {
            Target target = this.getListTarget(targetName);
            ObjectName[] allComponents = this.getAllUserDeployedComponents();
            if (target.getType() == TargetType.DOMAIN) {
                return allComponents;
            }
            ApplicationRef[] appRefs = target.getApplicationRefs();
            oa = ObjectNameAppRefComparator.intersect(allComponents, appRefs);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return oa;
    }

    @Override
    public ObjectName[] getAllDeployedJ2EEApplications(String target) throws ServerInstanceException {
        return this.getAllRegisteredComponentsOfType(deployableObjectTypes[0]);
    }

    @Override
    public ObjectName[] getAllDeployedEJBModules(String target) throws ServerInstanceException {
        return this.getAllRegisteredComponentsOfType(deployableObjectTypes[1]);
    }

    @Override
    public ObjectName[] getAllDeployedWebModules(String target) throws ServerInstanceException {
        return this.getAllRegisteredComponentsOfType(deployableObjectTypes[2]);
    }

    @Override
    public ObjectName[] getAllDeployedConnectors(String target) throws ServerInstanceException {
        return this.getAllRegisteredComponentsOfType(deployableObjectTypes[3]);
    }

    @Override
    public ObjectName[] getAllDeployedAppclientModules(String target) throws ServerInstanceException {
        return this.getAllRegisteredComponentsOfType(DeployableObjectType.CAR);
    }

    private void sendEnableConfigChangeEventExplicitly(String targetName) throws ConfigException, DeploymentException {
        ConfigContext ctx = this.getConfigContext();
        if (ctx.isChanged()) {
            ctx.flush();
        }
        ArrayList changeList = ctx.getConfigChangeList();
        ElementChangeHelper elementHelper = new ElementChangeHelper();
        ConfigChange enabledConfigChange = ElementChangeHelper.removeEnabledChange(changeList);
        if (enabledConfigChange != null) {
            ArrayList<ConfigChange> enabledChangeList = new ArrayList<ConfigChange>();
            ArrayList<AdminEvent> eventList = new ArrayList<AdminEvent>();
            enabledChangeList.add(enabledConfigChange);
            AdminEvent[] elementChangeEvents = elementHelper.generateElementChangeEventsFromChangeList(targetName, enabledChangeList, ctx);
            if (elementChangeEvents != null) {
                for (int i = 0; i < elementChangeEvents.length; ++i) {
                    eventList.add(elementChangeEvents[i]);
                }
            }
            for (AdminEvent event : eventList) {
                if (sLogger.isLoggable(Level.FINEST)) {
                    sLogger.log(Level.FINEST, "mbean.event_sent", event.getEventInfo());
                } else {
                    sLogger.log(Level.INFO, "mbean.send_event", event.toString());
                }
                AdminEventResult result = AdminEventMulticaster.multicastEvent(event);
                sLogger.log(Level.FINE, "mbean.event_res", result.getResultCode());
                sLogger.log(Level.FINEST, "mbean.event_reply", result.getAllMessagesAsString());
                AdminEventListenerException ale = null;
                ale = result.getFirstAdminEventListenerException();
                if (ale == null) continue;
                sLogger.log(Level.WARNING, "mbean.event_failed", ale.getMessage());
                DeploymentException de = new DeploymentException(ale.getMessage());
                de.initCause(ale);
                throw de;
            }
        }
    }

    @Override
    public void enable(String appName, String type, String target) throws MBeanConfigException, DeploymentException {
        try {
            String configMBModuleType;
            ObjectName componentON = null;
            if (type != null) {
                DeployableObjectType objectType = this.getDeployableObjectType(type);
                componentON = this.getRegisteredComponentObjectName(appName, objectType);
            } else {
                componentON = this.getRegisteredComponentObjectName(appName);
            }
            if (componentON != null && (configMBModuleType = componentON.getKeyProperty("type")) != null && configMBModuleType.equals("appclient-module")) {
                throw new DeploymentException(localStrings.getString("admin.mbeans.J2EEModule.not_applicable_op", ENABLE_ACTION, appName));
            }
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            Attribute attr = new Attribute("enabled", "true");
            if (componentON != null) {
                mbs.setAttribute(componentON, attr);
            }
            if (!target.equals("domain")) {
                this.setAppEnableInRefs(appName, target, true);
            }
            this.sendEnableConfigChangeEventExplicitly(target);
        }
        catch (Throwable te) {
            if (!(te instanceof DeploymentException)) {
                sLogger.log(Level.SEVERE, ENABLE_ACTION, te);
                sLogger.log(Level.FINE, "enable exception");
            }
            throw new MBeanConfigException(te.getMessage());
        }
    }

    @Override
    public void disable(String appName, String type, String target) throws MBeanConfigException, DeploymentException {
        try {
            String configMBModuleType;
            ObjectName componentON = null;
            if (type != null) {
                DeployableObjectType objectType = this.getDeployableObjectType(type);
                componentON = this.getRegisteredComponentObjectName(appName, objectType);
            } else {
                componentON = this.getRegisteredComponentObjectName(appName);
            }
            if (componentON != null && (configMBModuleType = componentON.getKeyProperty("type")) != null && configMBModuleType.equals("appclient-module")) {
                throw new DeploymentException(localStrings.getString("admin.mbeans.J2EEModule.not_applicable_op", DISABLE_ACTION, appName));
            }
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            Attribute attr = new Attribute("enabled", "false");
            if (target.equals("domain")) {
                if (componentON != null) {
                    mbs.setAttribute(componentON, attr);
                }
            } else {
                this.setAppEnableInRefs(appName, target, false);
            }
            this.sendEnableConfigChangeEventExplicitly(target);
        }
        catch (Throwable te) {
            if (!(te instanceof DeploymentException)) {
                sLogger.log(Level.FINE, "disable exception");
            }
            throw new MBeanConfigException(te.getMessage());
        }
    }

    private void setAppEnableInRefs(String appName, String target, boolean enable) throws Exception {
        ObjectName[] ons;
        Attribute attr = new Attribute("enabled", "" + enable);
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        ObjectName apprefON = this.getRegisteredAppRefObjectName(appName, target);
        if (apprefON != null) {
            mbs.setAttribute(apprefON, attr);
        }
        if (this.isCluster(target) && (ons = this.getAllRefObjectNames(appName, target)) != null) {
            for (int i = 0; i < ons.length; ++i) {
                mbs.setAttribute(ons[i], attr);
            }
        }
    }

    private ObjectName[] getAllRefObjectNames(String appName, String cluster) throws Exception {
        Server[] servers = ServerHelper.getServersInCluster(this.getConfigContext(), cluster);
        if (servers == null) {
            return null;
        }
        ObjectName[] ons = new ObjectName[servers.length];
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        ObjectName serverON = null;
        for (int j = 0; j < servers.length; ++j) {
            serverON = super.getServerObjectName(servers[j].getName());
            ObjectName[] apprefONArr = (ObjectName[])mbs.invoke(serverON, "getApplicationRef", emptyParams, emptySignature);
            for (int i = 0; i < apprefONArr.length; ++i) {
                String ref = (String)mbs.getAttribute(apprefONArr[i], "ref");
                if (!appName.equals(ref)) continue;
                ons[j] = apprefONArr[i];
            }
        }
        return ons;
    }

    private boolean isCluster(String targetName) throws Exception {
        Target target = TargetBuilder.INSTANCE.createTarget(VALID_LIST_TYPES, targetName, this.getConfigContext());
        return target.getType() == TargetType.CLUSTER;
    }

    @Override
    public boolean getStatus(String name, String target) throws MBeanConfigException {
        try {
            ObjectName apprefON;
            String appRefEnabledStr;
            ObjectName componentON;
            MBeanServer mbs;
            boolean appRefEnabled;
            boolean appEnabled;
            block6: {
                appEnabled = true;
                appRefEnabled = true;
                mbs = MBeanServerFactory.getMBeanServer();
                componentON = null;
                try {
                    componentON = this.getRegisteredComponentObjectName(name);
                }
                catch (Exception e) {
                    if (componentON != null) break block6;
                    throw new MBeanConfigException(e.getMessage());
                }
            }
            String appEnabledStr = (String)mbs.getAttribute(componentON, "enabled");
            if ("false".equalsIgnoreCase(appEnabledStr)) {
                appEnabled = false;
            }
            if (!this.isDefaultTarget(target) && "false".equalsIgnoreCase(appRefEnabledStr = (String)mbs.getAttribute(apprefON = this.getRegisteredAppRefObjectName(name, target), "enabled"))) {
                appRefEnabled = false;
            }
            return appEnabled && appRefEnabled;
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "Exception in getStatus:" + e.getMessage());
            throw new MBeanConfigException(e.getMessage());
        }
    }

    @Override
    public boolean isRedeploySupported() throws MBeanConfigException {
        return true;
    }

    @Override
    public String[] getAvailableVersions(String appName, String type) throws MBeanConfigException {
        throw new MBeanConfigException("Notyet supported");
    }

    @Override
    public String getDefaultVersion(String appName, String type) throws MBeanConfigException {
        return "";
    }

    @Override
    public String getLastModified(String appName, String type) throws MBeanConfigException {
        return "";
    }

    @Override
    public boolean isRepositoryCleanerEnabled() throws MBeanConfigException {
        return true;
    }

    @Override
    public int getRepositoryCleanerPollingInterval() throws MBeanConfigException {
        return 2;
    }

    @Override
    public void setRepositoryCleanerPollingInterval(int interval) throws MBeanConfigException {
    }

    @Override
    public int getMaxApplicationVersions() throws MBeanConfigException {
        return 10;
    }

    @Override
    public void setMaxApplicationVersions(int maxVersions) throws MBeanConfigException {
    }

    @Override
    public boolean isAutoDeployEnabled() throws MBeanConfigException {
        return true;
    }

    @Override
    public void setAutoDeployEnabled() throws MBeanConfigException {
    }

    @Override
    public boolean isAutoDeployJspPreCompilationEnabled() throws MBeanConfigException {
        return true;
    }

    @Override
    public void setAutoDeployJspPreCompilationEnabled() throws MBeanConfigException {
    }

    public ObjectName[] getLifecycleModule(String targetName) throws Exception {
        Target target = TargetBuilder.INSTANCE.createTarget(VALID_LIST_TYPES, targetName, this.getConfigContext());
        ObjectName[] registeredModules = (ObjectName[])this.invoke("getLifecycleModule", null, null);
        if (target.getType() == TargetType.DOMAIN) {
            return registeredModules;
        }
        ApplicationRef[] refs = target.getApplicationRefs();
        ArrayList<ObjectName> al = new ArrayList<ObjectName>();
        for (int i = 0; i < registeredModules.length; ++i) {
            String name = registeredModules[i].getKeyProperty(NAME);
            for (int j = 0; j < refs.length; ++j) {
                if (!refs[j].getRef().equals(name)) continue;
                al.add(registeredModules[i]);
            }
        }
        ObjectName[] refModules = new ObjectName[al.size()];
        for (int i = 0; i < refModules.length; ++i) {
            refModules[i] = (ObjectName)al.get(i);
        }
        return refModules;
    }

    public ObjectName getLifecycleModuleByName(String key, String targetName) throws Exception {
        Target target = TargetBuilder.INSTANCE.createTarget(VALID_LIST_TYPES, targetName, this.getConfigContext());
        ObjectName on = (ObjectName)this.invoke("getLifecycleModuleByName", new Object[]{key}, new String[]{"java.lang.String"});
        if (target.getType() != TargetType.DOMAIN) {
            ApplicationRef[] refs = target.getApplicationRefs();
            boolean isReffed = false;
            for (int i = 0; i < refs.length; ++i) {
                if (!refs[i].getRef().equals(key)) continue;
                isReffed = true;
                break;
            }
            if (!isReffed) {
                throw new ConfigException(localStrings.getString("applicationRefDoesnotExist", targetName, key));
            }
        }
        return on;
    }

    static Map getAttributeValues(AttributeList attributeList, String[] names) {
        int len = names.length;
        HashMap<String, Object> values = new HashMap<String, Object>(len);
        for (Attribute a : attributeList) {
            String name = a.getName();
            for (int i = 0; i < len; ++i) {
                if (!name.equals(names[i])) continue;
                values.put(name, a.getValue());
            }
        }
        return values;
    }

    public Boolean isLifecycleModuleRegistered(String name) {
        Boolean isRegistered = Boolean.FALSE;
        try {
            ObjectName on = (ObjectName)this.invoke("getLifecycleModuleByName", new Object[]{name}, new String[]{"java.lang.String"});
            if (on != null) {
                isRegistered = Boolean.TRUE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isRegistered;
    }

    public ObjectName createLifecycleModule(AttributeList attribute_list, String targetName) throws Exception {
        return this.createLifecycleModule(attribute_list, null, targetName);
    }

    public ObjectName createLifecycleModule(AttributeList attribute_list, Properties props, String targetName) throws Exception {
        Map values = ApplicationsConfigMBean.getAttributeValues(attribute_list, new String[]{NAME, "enabled"});
        String name = (String)values.get(NAME);
        ConfigContext ctx = this.getConfigContext();
        ConfigBean app = ApplicationHelper.findApplication(ctx, name);
        if (app != null && !(app instanceof LifecycleModule)) {
            throw new ConfigException(localStrings.getString("admin.mbeans.acmb.duplicateLCMName", name));
        }
        Boolean isRegistered = this.isLifecycleModuleRegistered(name);
        DeploymentTarget target = this.getAndValidateDeploymentTarget(targetName, name, isRegistered, false);
        ObjectName on = (ObjectName)this.invoke("createLifecycleModule", new Object[]{attribute_list}, new String[]{"javax.management.AttributeList"});
        if (props != null && props.size() > 0) {
            ArrayList<ElementProperty> arr = new ArrayList<ElementProperty>();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                String propValue = props.getProperty(propName);
                if (propValue == null) continue;
                ElementProperty ep = new ElementProperty();
                ep.setName(propName);
                ep.setValue(propValue);
                arr.add(ep);
            }
            if (arr.size() > 0) {
                LifecycleModule lcm = (LifecycleModule)ApplicationHelper.findApplication(ctx, name);
                lcm.setElementProperty(arr.toArray(new ElementProperty[arr.size()]));
            }
        }
        String isEnabled = (String)values.get("enabled");
        boolean enabled = Boolean.valueOf(isEnabled);
        target.addAppReference(name, enabled, null);
        return on;
    }

    public DeploymentStatus createLifecycleModuleReference(String referenceName, String targetName, Map options) {
        DeploymentStatus ds = new DeploymentStatus();
        ds.setStageDescription("CreateLifecycleModuleReference");
        try {
            DeploymentTarget target = this.getAndValidateDeploymentTarget(targetName, referenceName, false, false);
            boolean enabled = new DeploymentProperties(options).getEnable();
            target.addAppReference(referenceName, enabled, null);
            ds.setStageStatus(2);
        }
        catch (Exception e) {
            ds.setStageException(e);
            ds.setStageStatus(0);
            ds.setStageStatusMessage(e.getMessage());
        }
        return ds;
    }

    public DeploymentStatus removeLifecycleModuleReference(String referenceName, String targetName) {
        DeploymentStatus ds = new DeploymentStatus();
        ds.setStageDescription("RemoveLifecycleModuleReference");
        try {
            DeploymentTarget target = this.getAndValidateDeploymentTarget(targetName, referenceName, false, false);
            target.removeAppReference(referenceName);
            ds.setStageStatus(2);
        }
        catch (Exception e) {
            ds.setStageException(e);
            ds.setStageStatus(0);
            ds.setStageStatusMessage(e.getMessage());
        }
        return ds;
    }

    public void removeLifecycleModuleByName(String name, String targetName) throws Exception {
        Boolean isRegistered = this.isLifecycleModuleRegistered(name);
        DeploymentTarget target = this.getAndValidateDeploymentTarget(targetName, name, isRegistered, true);
        target.removeAppReference(name);
        this.invoke("removeLifecycleModuleByName", new Object[]{name}, new String[]{"java.lang.String"});
    }

    private DeploymentService getDeploymentService() throws DeploymentException {
        if (this.deployService == null) {
            this.deployService = DeploymentService.getDeploymentService(this.getConfigContext());
        }
        return this.deployService;
    }

    private String getInstanceName() throws DeploymentException {
        if (this.mInstanceName == null) {
            try {
                MBeanServer mbs = MBeanServerFactory.getMBeanServer();
                ObjectName serversON = new ObjectName(this.getDomainName() + ":type=servers,category=config");
                ObjectName[] serverONArr = (ObjectName[])mbs.invoke(serversON, "getServer", new Object[0], new String[0]);
                this.mInstanceName = (String)mbs.getAttribute(serverONArr[0], NAME);
            }
            catch (Exception e) {
                sLogger.log(Level.WARNING, "Could not obtain instanceName");
                throw new DeploymentException("Could not obtain instanceName");
            }
        }
        return this.mInstanceName;
    }

    private boolean isRegistered(String name, DeployableObjectType type) {
        try {
            return this.getRegisteredComponentObjectName(name, type) != null;
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "appexists failed", e);
            return true;
        }
    }

    private DeployableObjectType getRegisteredType(String name) throws DeploymentException {
        try {
            for (int i = 0; i < deployableObjectTypes.length; ++i) {
                if (!this.isRegistered(name, deployableObjectTypes[i])) continue;
                return deployableObjectTypes[i];
            }
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage());
        }
        throw new DeploymentException("Component not registered");
    }

    private DeployableObjectType getTypeFromFile(String moduleID, String filePath) throws DeploymentException {
        return DeploymentServiceUtils.getTypeFromFile(moduleID, filePath);
    }

    private void checkWebModuleReferences(String webModuleName) throws ConfigException {
        ArrayList<String> virtualServerIds = new ArrayList<String>();
        Config config = (Config)ConfigBeansFactory.getConfigBeanByXPath(this.getConfigContext(), "/domain/configs/config[@name='server-config']");
        HttpService httpService = config.getHttpService();
        VirtualServer[] virtualServers = httpService.getVirtualServer();
        for (int j = 0; j < virtualServers.length; ++j) {
            VirtualServer aServer = virtualServers[j];
            String defWebModule = aServer.getDefaultWebModule();
            if (defWebModule == null || !defWebModule.equals(webModuleName)) continue;
            virtualServerIds.add(aServer.getId());
        }
        if (!virtualServerIds.isEmpty()) {
            throw new ConfigException(localStrings.getString("admin.mbeans.acmb.def_web_module_refs_exist", virtualServerIds.toString(), webModuleName));
        }
    }

    private void deleteFile(String filePath) {
        try {
            File f = new File(filePath);
            if (f.exists()) {
                File parentDir = f.getParentFile();
                File tmpDir = new File(AdminService.getAdminService().getTempDirPath(), this.getInstanceName());
                if (tmpDir != null && tmpDir.equals(parentDir)) {
                    boolean couldDelete = f.delete();
                    if (couldDelete) {
                        sLogger.log(Level.FINE, "mbean.delete_temp_file_ok", filePath);
                    } else {
                        sLogger.log(Level.INFO, "mbean.delete_temp_file_failed", filePath);
                    }
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "could not deletefile" + filePath);
        }
    }

    private DeployableObjectType getDeployableObjectType(String moduleType) throws DeploymentException {
        if (moduleType.equals(TYPE_APPLICATION) || moduleType.equals(JSR88_TYPE_APPLICATION)) {
            return DeployableObjectType.APP;
        }
        if (moduleType.equals("ejb") || moduleType.equals("ejb")) {
            return DeployableObjectType.EJB;
        }
        if (moduleType.equals(TYPE_WEB) || moduleType.equals(JSR88_TYPE_WEB)) {
            return DeployableObjectType.WEB;
        }
        if (moduleType.equals(TYPE_CONNECTOR) || moduleType.equals(JSR88_TYPE_CONNECTOR)) {
            return DeployableObjectType.CONN;
        }
        if (moduleType.equals(TYPE_APPCLIENT) || moduleType.equals(JSR88_TYPE_APPCLIENT)) {
            return DeployableObjectType.CAR;
        }
        if (moduleType.equals(XModuleType.LCM.toString())) {
            return DeployableObjectType.LCM;
        }
        if (moduleType.equals(XModuleType.CMB.toString())) {
            return DeployableObjectType.CMB;
        }
        throw new DeploymentException("Unknown deployable object type");
    }

    private void chownDir(File dir, String user) {
        if (dir == null || user == null || user.trim().equals("")) {
            return;
        }
        Object err = null;
    }

    public HostAndPort getHostAndPort() throws ServerInstanceException {
        return this.getHostAndPort(false);
    }

    public HostAndPort getHostAndPort(boolean securityEnabled) throws ServerInstanceException {
        HostAndPort hAndp = null;
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            ObjectName objectName = new ObjectName(this.getDomainName() + ":type=configs,category=config");
            String operationName1 = "getConfig";
            ObjectName[] configs = (ObjectName[])mbs.invoke(objectName, operationName1, emptyParams, emptySignature);
            String configName = (String)mbs.getAttribute(configs[0], NAME);
            ObjectName httpService = new ObjectName(this.getDomainName() + ":type=http-service,config=" + configName + ",category=config");
            String operationName2 = "getHttpListener";
            ObjectName[] httpListener = (ObjectName[])mbs.invoke(httpService, operationName2, emptyParams, emptySignature);
            String serverName = null;
            int port = 0;
            for (int i = 0; i < httpListener.length; ++i) {
                boolean sec_on;
                String vs;
                boolean enabled;
                AttributeList attrs = mbs.getAttributes(httpListener[i], httpListenerAttrNames);
                Boolean bb = Boolean.valueOf((String)this.getNamedAttributeValue(attrs, "enabled"));
                boolean bl = enabled = bb == null ? false : bb;
                if (!enabled || ADMIN_VS.equals(vs = (String)this.getNamedAttributeValue(attrs, DEF_VS))) continue;
                bb = Boolean.valueOf((String)this.getNamedAttributeValue(attrs, SEC_ENABLED));
                boolean bl2 = sec_on = bb == null ? false : bb;
                if (securityEnabled != sec_on) continue;
                serverName = (String)this.getNamedAttributeValue(attrs, SERVER_NAME);
                if (serverName == null || serverName.trim().equals("")) {
                    serverName = this.getDefaultHostName();
                }
                String portStr = (String)this.getNamedAttributeValue(attrs, PORT);
                String redirPort = (String)this.getNamedAttributeValue(attrs, REDIRECT_PORT);
                if (redirPort != null && !redirPort.trim().equals("")) {
                    portStr = redirPort;
                }
                String resolvedPort = new PropertyResolver(this.getConfigContext(), this.getInstanceName()).resolve(portStr);
                port = Integer.parseInt(resolvedPort);
                break;
            }
            hAndp = new HostAndPort(serverName, port);
        }
        catch (Exception e) {
            ServerInstanceException sie = new ServerInstanceException(e.getLocalizedMessage());
            sie.initCause(e);
            throw sie;
        }
        return hAndp;
    }

    public HostAndPort getHostAndPort(String standAloneModuleId, boolean securityEnabled) throws ServerInstanceException {
        Object hAndp = null;
        boolean setHP = false;
        try {
            String appRefXPath = ServerXPathHelper.getServerIdXpath(this.getInstanceName()) + "/" + "application-ref" + "[@" + "ref" + "='" + standAloneModuleId + "']";
            ApplicationRef appRef = (ApplicationRef)ConfigBeansFactory.getConfigBeanByXPath(this.getConfigContext(), appRefXPath);
            if (appRef.getVirtualServers() != null) {
                return this.getHostAndPort(securityEnabled);
            }
            Object appRefvs = null;
            List vsList = StringUtils.parseStringList(appRef.getVirtualServers(), " ,");
            if (vsList == null) {
                return this.getHostAndPort(securityEnabled);
            }
            ListIterator vsListIter = vsList.listIterator();
            while (vsListIter.hasNext()) {
                String virtualServer = (String)vsListIter.next();
                HostAndPort hp = this.getVirtualServerHostAndPort(virtualServer, securityEnabled);
                if (hp == null) continue;
                return hp;
            }
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return null;
    }

    public HostAndPort getVirtualServerHostAndPort(String vs, boolean securityEnabled) throws ServerInstanceException {
        String serverName = null;
        int port = 0;
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            ObjectName objectName = new ObjectName(this.getDomainName() + ":type=configs,category=config");
            String operationName1 = "getConfig";
            ObjectName[] configs = (ObjectName[])mbs.invoke(objectName, operationName1, emptyParams, emptySignature);
            String configName = (String)mbs.getAttribute(configs[0], NAME);
            ObjectName httpService = new ObjectName(this.getDomainName() + ":type=http-service,config=" + configName + ",category=config");
            String operationName2 = "getHttpListener";
            ObjectName[] httpListener = (ObjectName[])mbs.invoke(httpService, operationName2, emptyParams, emptySignature);
            operationName2 = "getVirtualServer";
            ObjectName[] virtualServer = (ObjectName[])mbs.invoke(httpService, operationName2, emptyParams, emptySignature);
            for (int i = 0; i < virtualServer.length; ++i) {
                AttributeList vsAttrs = mbs.getAttributes(virtualServer[i], vsAttrNames);
                String id = (String)this.getNamedAttributeValue(vsAttrs, ID);
                if (!id.equals(vs)) continue;
                String httpListeners = (String)this.getNamedAttributeValue(vsAttrs, "http-listeners");
                String vsHttpListener = null;
                List httpListenerList = StringUtils.parseStringList(httpListeners, " ,");
                ListIterator hlListIter = httpListenerList.listIterator();
                while (hlListIter.hasNext()) {
                    vsHttpListener = (String)hlListIter.next();
                    for (int j = 0; j < httpListener.length; ++j) {
                        boolean sec_on;
                        boolean enabled;
                        AttributeList attrs = mbs.getAttributes(httpListener[j], httpListenerAttrNames);
                        String listenerId = (String)this.getNamedAttributeValue(attrs, ID);
                        if (!listenerId.equals(vsHttpListener)) continue;
                        Boolean bb = Boolean.valueOf((String)this.getNamedAttributeValue(attrs, "enabled"));
                        boolean bl = enabled = bb == null ? false : bb;
                        if (!enabled) continue;
                        bb = Boolean.valueOf((String)this.getNamedAttributeValue(attrs, SEC_ENABLED));
                        boolean bl2 = sec_on = bb == null ? false : bb;
                        if (securityEnabled != sec_on) continue;
                        serverName = (String)this.getNamedAttributeValue(attrs, SERVER_NAME);
                        if (serverName == null || serverName.trim().equals("")) {
                            serverName = this.getDefaultHostName();
                        }
                        String portStr = (String)this.getNamedAttributeValue(attrs, PORT);
                        String redirPort = (String)this.getNamedAttributeValue(attrs, REDIRECT_PORT);
                        if (redirPort != null && !redirPort.trim().equals("")) {
                            portStr = redirPort;
                        }
                        String resolvedPort = new PropertyResolver(this.getConfigContext(), this.getInstanceName()).resolve(portStr);
                        port = Integer.parseInt(resolvedPort);
                        return new HostAndPort(serverName, port);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return null;
    }

    private void setDeployDirOwner(DeploymentRequest request, InstanceEnvironment env) {
    }

    private ObjectName[] getAllRegisteredComponentsOfType(DeployableObjectType type) {
        String operationName = null;
        ObjectName[] ONArr = null;
        try {
            if (type.isAPP()) {
                operationName = "getJ2eeApplication";
            } else if (type.isEJB()) {
                operationName = "getEjbModule";
            } else if (type.isWEB()) {
                operationName = "getWebModule";
            } else if (type.isCONN()) {
                operationName = "getConnectorModule";
            } else if (type.isCAR()) {
                operationName = "getAppclientModule";
            }
            ONArr = (ObjectName[])this.invoke(operationName, emptyParams, emptySignature);
        }
        catch (Exception e) {
            sLogger.log(Level.FINE, e.getMessage());
            ONArr = new ObjectName[]{};
        }
        return ONArr;
    }

    private ArrayList getModules(String target, DeployableObjectType type, Boolean state, boolean excludeSystemApps) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        String operationName = "getApplicationRef";
        try {
            ObjectName[] appONArr = this.getAllRegisteredComponentsOfType(type);
            ObjectName serverON = new ObjectName(this.getDomainName() + ":type=server,name=" + target + ",category=config");
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            ObjectName[] apprefONArr = (ObjectName[])mbs.invoke(serverON, operationName, emptyParams, emptySignature);
            block2: for (int i = 0; i < apprefONArr.length; ++i) {
                String refName = (String)mbs.getAttribute(apprefONArr[i], "ref");
                String refenabled = (String)mbs.getAttribute(apprefONArr[i], "enabled");
                for (int j = 0; j < appONArr.length; ++j) {
                    String enabled;
                    String objectType;
                    String name = (String)mbs.getAttribute(appONArr[j], NAME);
                    if (!name.equals(refName)) continue;
                    String string = objectType = type.equals(DeployableObjectType.CAR) ? "user" : (String)mbs.getAttribute(appONArr[j], OBJECT_TYPE);
                    if (excludeSystemApps && objectType != null && objectType.startsWith("system-")) continue block2;
                    if (state == null) {
                        list.add(refName);
                        continue;
                    }
                    String string2 = enabled = type.equals(DeployableObjectType.CAR) ? "true" : (String)mbs.getAttribute(appONArr[j], "enabled");
                    if (state.equals(Boolean.TRUE)) {
                        if (!enabled.equalsIgnoreCase("true") || !refenabled.equalsIgnoreCase("true")) continue;
                        list.add(refName);
                        continue;
                    }
                    if (!state.equals(Boolean.FALSE) || !enabled.equalsIgnoreCase("false") && !refenabled.equalsIgnoreCase("false")) continue;
                    list.add(refName);
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.FINE, e.getMessage());
            throw e;
        }
        return list;
    }

    private ObjectName constructComponentObjectName(String name, DeployableObjectType type) {
        ObjectName ON = null;
        try {
            if (type.isAPP()) {
                ON = new ObjectName(this.getDomainName() + ":type=j2ee-application,name=" + name + ",category=config");
            } else if (type.isEJB()) {
                ON = new ObjectName(this.getDomainName() + ":type=ejb-module,name=" + name + ",category=config");
            } else if (type.isAPP()) {
                ON = new ObjectName(this.getDomainName() + ":type=web-module,name=" + name + ",category=config");
            } else if (type.isAPP()) {
                ON = new ObjectName(this.getDomainName() + ":type=connector-module,name=" + name + ",category=config");
            } else if (type.isAPP()) {
                ON = new ObjectName(this.getDomainName() + ":type=appclient-module,name=" + name + ",category=config");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return ON;
    }

    private ObjectName getRegisteredComponentObjectName(String name, DeployableObjectType type) {
        ObjectName ret = null;
        try {
            String operationName = null;
            if (type.equals(DeployableObjectType.APP)) {
                operationName = "getJ2eeApplicationByName";
            } else if (type.equals(DeployableObjectType.EJB)) {
                operationName = "getEjbModuleByName";
            } else if (type.equals(DeployableObjectType.WEB)) {
                operationName = "getWebModuleByName";
            } else if (type.equals(DeployableObjectType.CONN)) {
                operationName = "getConnectorModuleByName";
            } else if (type.equals(DeployableObjectType.CAR)) {
                operationName = "getAppclientModuleByName";
            } else if (type.equals(DeployableObjectType.LCM)) {
                operationName = "getLifecycleModuleByName";
            } else if (type.equals(DeployableObjectType.CMB)) {
                operationName = "getMbeanByName";
            }
            Object[] params = new Object[]{name};
            String[] signature = new String[]{"java.lang.String"};
            ret = (ObjectName)this.invoke(operationName, params, signature);
        }
        catch (Exception e) {
            // empty catch block
        }
        return ret;
    }

    private ObjectName getRegisteredComponentObjectName(String name) throws DeploymentException {
        ObjectName ret = null;
        for (int i = 0; i < deployableObjectTypes.length; ++i) {
            ret = this.getRegisteredComponentObjectName(name, deployableObjectTypes[i]);
            if (ret == null) continue;
            return ret;
        }
        throw new DeploymentException("Component not registered");
    }

    private ObjectName getRegisteredAppRefObjectName(String name, String targetName) throws DeploymentException {
        try {
            Target target = TargetBuilder.INSTANCE.createTarget(VALID_LIST_TYPES, targetName, this.getConfigContext());
            assert (target != null);
            ObjectName targetON = null;
            if (target.getType() == TargetType.CLUSTER) {
                targetON = super.getClusterObjectName(targetName);
            } else {
                if (target.getType() == TargetType.DOMAIN) {
                    return null;
                }
                targetON = super.getServerObjectName(targetName);
            }
            assert (targetON != null);
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            ObjectName[] apprefONArr = (ObjectName[])mbs.invoke(targetON, "getApplicationRef", emptyParams, emptySignature);
            for (int i = 0; i < apprefONArr.length; ++i) {
                String ref = (String)mbs.getAttribute(apprefONArr[i], "ref");
                if (!name.equals(ref)) continue;
                return apprefONArr[i];
            }
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage());
        }
        throw new DeploymentException("Component not registered");
    }

    @Override
    public String[] getModuleComponents(String standAloneModuleName) throws ServerInstanceException {
        String[] modComponents = new String[]{};
        if (standAloneModuleName == null || standAloneModuleName.length() < 1) {
            throw new ServerInstanceException(localStrings.getString("admin.mbeans.ssmb.invalid_app_or_module_name", ""));
        }
        try {
            sLogger.log(Level.FINE, "ApplicationsConfigMBean.getModuleComponents for " + standAloneModuleName);
            String j2eeType = this.getJ2eeType(standAloneModuleName);
            if (j2eeType == null) {
                throw new ServerInstanceException(localStrings.getString("admin.mbeans.ssmb.invalid_app_or_module_name", standAloneModuleName));
            }
            if (j2eeType.equals("EJBModule")) {
                BundleDescriptor bd = this.getDescrForStandAloneEjbModule(standAloneModuleName);
                modComponents = this.getValidatedObjectNames(this.getEjbModuleComponents((EjbBundleDescriptor)bd));
                return modComponents;
            }
            if (j2eeType.equals("WebModule")) {
                BundleDescriptor bd = this.getDescrForStandAloneWebModule(standAloneModuleName);
                modComponents = this.getValidatedObjectNames(this.getWebModuleComponents((WebBundleDescriptor)bd));
                return modComponents;
            }
            if (j2eeType.equals("ResourceAdapterModule")) {
                BundleDescriptor bd = this.getDescrForStandAloneRarModule(standAloneModuleName);
                modComponents = this.getValidatedObjectNames(this.getRarModuleComponents((ConnectorDescriptor)bd));
                return modComponents;
            }
            if (j2eeType.equals("AppClientModule")) {
                BundleDescriptor bd = this.getDescrForStandAloneCarModule(standAloneModuleName);
                modComponents = this.getValidatedObjectNames(this.getCarModuleComponents(bd));
                return modComponents;
            }
            if (j2eeType.equals("J2EEApplication")) {
                Application ad = this.getDescrForApplication(standAloneModuleName);
                modComponents = this.getValidatedObjectNames(this.getApplicationComponents(ad));
                return modComponents;
            }
            throw new ServerInstanceException(localStrings.getString("admin.mbeans.ssmb.invalid_app_or_module_name", standAloneModuleName));
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "ApplicationsConfigMBean.getModuleComponents failed", e);
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
    }

    @Override
    public String[] getModuleComponents(String appName, String modName) throws ServerInstanceException {
        String[] modComponents = new String[]{};
        if (modName == null || modName.length() < 1) {
            throw new ServerInstanceException("invalid ModuleName");
        }
        try {
            sLogger.log(Level.FINE, "ApplicationsConfigMBean.getModuleComponents for application = " + appName + " and module = " + modName);
            AppsManager am = InstanceFactory.createAppsManager(this.getInstanceName());
            Application appD = null;
            try {
                appD = (Application)DeploymentUtils.getDescriptor(appName, am);
            }
            catch (NullPointerException npe) {
                throw new ServerInstanceException(localStrings.getString("admin.mbeans.ssmb.invalid_appname", appName));
            }
            BundleDescriptor bd2 = null;
            ModuleType modType = null;
            Set bds = appD.getBundleDescriptors();
            for (BundleDescriptor bd2 : bds) {
                if (!bd2.getModuleDescriptor().getArchiveUri().equals(modName) && !bd2.getModuleID().equals(modName) && !bd2.getName().equals(modName)) continue;
                modType = bd2.getModuleType();
                break;
            }
            if (modType == ModuleType.EJB) {
                modComponents = this.getValidatedObjectNames(this.getEjbModuleComponents((EjbBundleDescriptor)bd2));
                return modComponents;
            }
            if (modType == ModuleType.WAR) {
                modComponents = this.getValidatedObjectNames(this.getWebModuleComponents((WebBundleDescriptor)bd2));
                return modComponents;
            }
            if (modType == ModuleType.RAR) {
                modComponents = this.getValidatedObjectNames(this.getRarModuleComponents((ConnectorDescriptor)bd2));
                return modComponents;
            }
            if (modType == ModuleType.CAR) {
                modComponents = this.getValidatedObjectNames(this.getCarModuleComponents(bd2));
                return modComponents;
            }
            throw new ServerInstanceException("invalid module or application name");
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "ApplicationsConfigMBean.getModuleComponents failed", e);
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
    }

    String getJ2eeType(String dName) throws ServerInstanceException {
        String j2eeType = null;
        try {
            ConnectorModule[] connectorConfigBeans;
            WebModule[] wModules;
            EjbModule[] eModules;
            Applications appsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(this.getConfigContext(), "/domain/applications");
            J2eeApplication[] j2eeApps = appsConfigBean.getJ2eeApplication();
            if (j2eeApps != null) {
                for (int i = 0; i < j2eeApps.length; ++i) {
                    if (!j2eeApps[i].getName().equals(dName)) continue;
                    return "J2EEApplication";
                }
            }
            if ((eModules = appsConfigBean.getEjbModule()) != null) {
                for (int i = 0; i < eModules.length; ++i) {
                    if (!eModules[i].getName().equals(dName)) continue;
                    return "EJBModule";
                }
            }
            if ((wModules = appsConfigBean.getWebModule()) != null) {
                for (int i = 0; i < wModules.length; ++i) {
                    if (!wModules[i].getName().equals(dName)) continue;
                    return "WebModule";
                }
            }
            if ((connectorConfigBeans = appsConfigBean.getConnectorModule()) != null) {
                for (int i = 0; i < connectorConfigBeans.length; ++i) {
                    if (!connectorConfigBeans[i].getName().equals(dName)) continue;
                    return "ResourceAdapterModule";
                }
            }
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return j2eeType;
    }

    BundleDescriptor getDescrForStandAloneEjbModule(String ejbModuleName) throws ServerInstanceException {
        try {
            EjbModulesManager ejbModMgr = InstanceFactory.createEjbModuleManager(this.getInstanceName());
            return (BundleDescriptor)DeploymentUtils.getDescriptor(ejbModuleName, ejbModMgr);
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
    }

    String[] getEjbModuleComponents(EjbBundleDescriptor bd) throws ServerInstanceException {
        String[] sArr = null;
        try {
            Set ejbs = bd.getEjbs();
            ManagementObjectManager mom = Switch.getSwitch().getManagementObjectManager();
            String moduleName = mom.getModuleName(bd);
            String applicationName = mom.getApplicationName(bd);
            EjbDescriptor ed2 = null;
            sArr = new String[ejbs.size()];
            int i = 0;
            String j2eeType = null;
            for (EjbDescriptor ed2 : ejbs) {
                j2eeType = mom.getJ2eeTypeForEjb(ed2);
                sArr[i] = "j2eeType=" + j2eeType + "," + "name=" + ed2.getName() + "," + "EJBModule=" + moduleName + "," + "J2EEApplication=" + applicationName;
                ++i;
            }
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return sArr;
    }

    BundleDescriptor getDescrForStandAloneWebModule(String moduleName) throws ServerInstanceException {
        try {
            WebModulesManager webModMgr = InstanceFactory.createWebModuleManager(this.getInstanceName());
            return (BundleDescriptor)DeploymentUtils.getDescriptor(moduleName, webModMgr);
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
    }

    String[] getWebModuleComponents(WebBundleDescriptor bd) throws ServerInstanceException {
        String[] sArr = null;
        try {
            Set webDescriptors = bd.getWebDescriptors();
            ManagementObjectManager mom = Switch.getSwitch().getManagementObjectManager();
            String moduleName = mom.getModuleName(bd);
            String applicationName = mom.getApplicationName(bd);
            WebComponentDescriptor wd2 = null;
            sArr = new String[webDescriptors.size()];
            int i = 0;
            String j2eeType = null;
            String servletName = null;
            String cName = null;
            String dName = null;
            String sName = null;
            for (WebComponentDescriptor wd2 : webDescriptors) {
                dName = wd2.getDisplayName();
                sName = wd2.getName();
                cName = wd2.getCanonicalName();
                servletName = dName != null && dName.length() > 0 ? dName : (sName != null && sName.length() > 0 ? sName : (cName != null && cName.length() > 0 ? cName : ""));
                j2eeType = "Servlet";
                sArr[i] = "j2eeType=" + j2eeType + "," + "name=" + servletName + "," + "WebModule=" + moduleName + "," + "J2EEApplication=" + applicationName;
                ++i;
            }
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return sArr;
    }

    BundleDescriptor getDescrForStandAloneCarModule(String moduleName) throws ServerInstanceException {
        try {
            AppclientModulesManager appClModMgr = InstanceFactory.createAppclientModulesManager(this.getInstanceName());
            return (BundleDescriptor)DeploymentUtils.getDescriptor(moduleName, appClModMgr);
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
    }

    String[] getCarModuleComponents(BundleDescriptor bd) throws ServerInstanceException {
        String[] sArr = new String[1];
        try {
            ManagementObjectManager mom = Switch.getSwitch().getManagementObjectManager();
            String moduleName = bd.getModuleID();
            String applicationName = mom.getApplicationName(bd);
            sArr[0] = "j2eeType=AppClientModule,name=" + moduleName + "," + "J2EEApplication=" + applicationName;
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return sArr;
    }

    BundleDescriptor getDescrForStandAloneRarModule(String moduleName) throws ServerInstanceException {
        try {
            ConnectorModulesManager connModMgr = InstanceFactory.createConnectorModulesManager(this.getInstanceName());
            return (BundleDescriptor)DeploymentUtils.getDescriptor(moduleName, connModMgr);
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
    }

    String[] getRarModuleComponents(ConnectorDescriptor bd) throws ServerInstanceException {
        String[] sArr = null;
        try {
            ManagementObjectManager mom = Switch.getSwitch().getManagementObjectManager();
            String moduleName = mom.getModuleName(bd);
            String applicationName = mom.getApplicationName(bd);
            String j2eeType = null;
            int i = 0;
            InboundResourceAdapter ibRA = bd.getInboundResourceAdapter();
            OutboundResourceAdapter obRA = bd.getOutboundResourceAdapter();
            int kount = 0;
            if (ibRA != null) {
                ++kount;
            }
            if (obRA != null) {
                ++kount;
            }
            if (kount > 0) {
                sArr = new String[kount];
            }
            if (ibRA != null) {
                j2eeType = "ResourceAdapter";
                sArr[i] = "j2eeType=" + j2eeType + "," + "name=" + ibRA.getName() + "," + "ResourceAdapterModule=" + moduleName + "," + "J2EEApplication=" + applicationName;
                ++i;
            }
            if (obRA != null) {
                j2eeType = "ResourceAdapter";
                sArr[i] = "j2eeType=" + j2eeType + "," + "name=" + obRA.getName() + "," + "ResourceAdapterModule=" + moduleName + "," + "J2EEApplication=" + applicationName;
                ++i;
            }
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return sArr;
    }

    Application getDescrForApplication(String appName) throws ServerInstanceException {
        try {
            AppsManager appsMgr = InstanceFactory.createAppsManager(this.getInstanceName());
            return (Application)DeploymentUtils.getDescriptor(appName, appsMgr);
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
    }

    @Override
    public String[] getAllSystemConnectors() throws ServerInstanceException {
        List<String> names = ConnectorConstants.systemRarNames;
        return names.toArray(new String[names.size()]);
    }

    String[] getApplicationComponents(Application ad) throws ServerInstanceException {
        String[] sArr = null;
        try {
            ManagementObjectManager mom = Switch.getSwitch().getManagementObjectManager();
            String applicationName = ad.getRegistrationName();
            Object j2eeType = null;
            Set bds = null;
            BundleDescriptor bd2 = null;
            int i = 0;
            sArr = new String[ad.getApplicationClientDescriptors().size() + ad.getEjbBundleDescriptors().size() + ad.getRarDescriptors().size() + ad.getWebBundleDescriptors().size()];
            bds = ad.getApplicationClientDescriptors();
            for (BundleDescriptor bd2 : bds) {
                sArr[i] = "j2eeType=AppClientModule,name=" + bd2.getModuleDescriptor().getArchiveUri() + "," + "J2EEApplication=" + applicationName;
                ++i;
            }
            bds = ad.getEjbBundleDescriptors();
            for (BundleDescriptor bd2 : bds) {
                sArr[i] = "j2eeType=EJBModule,name=" + bd2.getModuleDescriptor().getArchiveUri() + "," + "J2EEApplication=" + applicationName;
                ++i;
            }
            bds = ad.getRarDescriptors();
            for (BundleDescriptor bd2 : bds) {
                sArr[i] = "j2eeType=ResourceAdapterModule,name=" + bd2.getModuleDescriptor().getArchiveUri() + "," + "J2EEApplication=" + applicationName;
                ++i;
            }
            bds = ad.getWebBundleDescriptors();
            for (BundleDescriptor bd2 : bds) {
                sArr[i] = "j2eeType=WebModule,name=" + bd2.getModuleDescriptor().getArchiveUri() + "," + "J2EEApplication=" + applicationName;
                ++i;
            }
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return sArr;
    }

    private String[] getValidatedObjectNames(String[] strArr) throws ServerInstanceException {
        String[] sArr = new String[strArr.length];
        try {
            for (int i = 0; i < strArr.length; ++i) {
                sArr[i] = "com.sun.appserv:" + strArr[i] + "," + "J2EEServer=" + this.getInstanceName();
            }
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return sArr;
    }

    private boolean isDefaultTarget(String target) {
        return target == null || target.length() == 0 || target.equalsIgnoreCase("domain");
    }

    private void setHostAndPort(DeploymentRequest req) throws ServerInstanceException {
        String virtualServers = (String)req.getOptionalAttributes().get("virtual-servers");
        if (virtualServers == null) {
            HostAndPort hap = this.getHostAndPort(false);
            if (hap != null) {
                req.setHttpHostName(this.getHostName(hap));
                req.setHttpPort(this.getPort(hap, false));
            }
            if ((hap = this.getHostAndPort(true)) != null) {
                req.setHttpsHostName(this.getHostName(hap));
                req.setHttpsPort(this.getPort(hap, true));
            }
        } else {
            StringTokenizer st = new StringTokenizer(virtualServers, ",");
            if (st.hasMoreTokens()) {
                String aVirtualServer = st.nextToken();
                HostAndPort hap = this.getVirtualServerHostAndPort(aVirtualServer, false);
                if (hap != null) {
                    req.setHttpHostName(this.getHostName(hap));
                    req.setHttpPort(this.getPort(hap, false));
                }
                if ((hap = this.getVirtualServerHostAndPort(aVirtualServer, true)) != null) {
                    req.setHttpsHostName(this.getHostName(hap));
                    req.setHttpsPort(this.getPort(hap, true));
                }
            }
        }
    }

    public String getHostName(HostAndPort hap) {
        String hostName = hap.getHost();
        if (hostName == null || hostName.trim().equals("")) {
            hostName = this.getDefaultHostName();
        }
        return hostName;
    }

    private String getDefaultHostName() {
        String defaultHostName = "localhost";
        try {
            InetAddress host = InetAddress.getLocalHost();
            defaultHostName = host.getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            sLogger.log(Level.FINEST, "mbean.get_local_host_error", uhe);
            sLogger.log(Level.INFO, "mbean.use_default_host");
        }
        return defaultHostName;
    }

    private int getPort(HostAndPort hap, boolean securityEnabled) {
        int port = hap.getPort();
        if (port == 0) {
            port = this.getDefaultPort(securityEnabled);
        }
        return port;
    }

    private int getDefaultPort(boolean securityEnabled) {
        int port = 0;
        port = securityEnabled ? 8181 : 8080;
        sLogger.log(Level.INFO, "mbean.use_default_port", String.valueOf(port));
        return port;
    }

    private Object getNamedAttributeValue(AttributeList attrs, String attrName) {
        if (attrs == null || attrName == null) {
            return null;
        }
        Object value = null;
        for (Attribute attr : attrs) {
            if (!attrName.equals(attr.getName())) continue;
            value = attr.getValue();
            break;
        }
        return value;
    }

    private void validate(ObjectName componentON, String action) throws MBeanConfigException {
        if (componentON == null) {
            return;
        }
        String componentType = componentON.getKeyProperty("type");
        if (componentType != null && componentType.length() > 0 && componentType.equals("appclient-module")) {
            return;
        }
        boolean allowSystemAppModification = Boolean.valueOf(System.getProperty("com.sun.aas.deployment.AllowSysAppDeployment", "false"));
        if (allowSystemAppModification) {
            return;
        }
        String objectType = null;
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            objectType = (String)mbs.getAttribute(componentON, OBJECT_TYPE);
        }
        catch (Exception e) {
            String msg = localStrings.getString("admin.mbeans.acmb.exception_object_type");
            sLogger.log(Level.FINE, msg);
            throw new MBeanConfigException(e.getMessage());
        }
        if (objectType != null && objectType.startsWith("system-")) {
            String msg = localStrings.getString("admin.mbeans.acmb.component_is_system", new Object[]{action});
            throw new MBeanConfigException(msg);
        }
    }

    @Override
    public void associate(String appName, String target) throws MBeanException, MBeanConfigException {
    }

    @Override
    public void disassociate(String appName, String target) throws MBeanException, MBeanConfigException {
    }

    private DeploymentTargetFactory getTargetFactory() {
        return DeploymentTargetFactory.getDeploymentTargetFactory();
    }

    public String[] getDeploymentDescriptorLocations(String standAloneModuleName, String subComponentName) throws ServerInstanceException {
        sLogger.log(Level.FINE, "getDeploymentDescriptorLocations - begin standAloneModuleName = " + standAloneModuleName + " subComponentName = " + subComponentName);
        J2EEModule j2eeModule = null;
        j2eeModule = subComponentName != null ? new J2EEModule(standAloneModuleName, subComponentName) : new J2EEModule(standAloneModuleName);
        ModuleType moduleType = j2eeModule.getModuleType();
        if (moduleType == null) {
            throw new ServerInstanceException(localStrings.getString("admin.mbeans.acmb.invalidModuleType"));
        }
        sLogger.log(Level.FINE, "getDeploymentDescriptorLocations - moduleType" + moduleType);
        String ddLocation = j2eeModule.getDeploymentDescriptorsLocation();
        if (ddLocation == null) {
            throw new ServerInstanceException(localStrings.getString("admin.mbeans.acmb.invalidDeplDescrLoc"));
        }
        sLogger.log(Level.FINE, "getDeploymentDescriptorLocations - ddLocation" + ddLocation);
        String[] ddList = DescriptorList.getDescriptorsList(moduleType);
        if (ddList == null || ddList.length < 1) {
            return null;
        }
        ArrayList<String> arrL = new ArrayList<String>();
        String fileLocation = null;
        for (int i = 0; i < ddList.length; ++i) {
            fileLocation = ddLocation + File.separator + ddList[i];
            try {
                File file = new File(fileLocation);
                if (!file.exists()) continue;
                arrL.add(fileLocation);
                continue;
            }
            catch (Exception e) {
                sLogger.log(Level.WARNING, "getDeploymentDescriptorLocations - descriptor does not exist for " + fileLocation);
            }
        }
        if (arrL.size() > 0) {
            String[] strArr = new String[arrL.size()];
            for (int j = 0; j < arrL.size(); ++j) {
                strArr[j] = (String)arrL.get(j);
                sLogger.log(Level.FINE, "getDeploymentDescriptorLocations: next dd location = " + strArr[j]);
            }
            return strArr;
        }
        return null;
    }

    public String getDeploymentDescriptor(String deploymentDescriptorLocation) throws ServerInstanceException {
        sLogger.log(Level.FINE, "getDeploymentDescriptor - begin deploymentDescriptorLocation = " + deploymentDescriptorLocation);
        if (deploymentDescriptorLocation == null) {
            return null;
        }
        J2EEModule j2eeModule = new J2EEModule();
        String str = j2eeModule.getStringForDDxml(deploymentDescriptorLocation);
        if (str != null) {
            sLogger.log(Level.FINE, "getDeploymentDescriptor: for " + deploymentDescriptorLocation + " = " + str);
        }
        return str;
    }

    @Override
    public String createMBean(String target, String className) throws CustomMBeanException {
        return this.cmo.createMBean(target, className);
    }

    @Override
    public String createMBean(String target, Map<String, String> params) throws CustomMBeanException {
        HashMap<String, String> paramsCopy = new HashMap<String, String>(params);
        return this.cmo.createMBean(target, paramsCopy);
    }

    @Override
    public String createMBean(String target, Map<String, String> params, Map<String, String> attributes) throws CustomMBeanException {
        HashMap<String, String> paramsCopy = new HashMap<String, String>(params);
        return this.cmo.createMBean(target, paramsCopy, attributes);
    }

    @Override
    public void createMBeanRef(String target, String ref) throws CustomMBeanException {
        this.cmo.createMBeanRef(target, ref);
    }

    @Override
    public String deleteMBean(String target, String name) throws CustomMBeanException {
        return this.cmo.deleteMBean(target, name);
    }

    @Override
    public void deleteMBeanRef(String target, String ref) throws CustomMBeanException {
        this.cmo.deleteMBeanRef(target, ref);
    }

    @Override
    public boolean existsMBean(String target, String name) throws CustomMBeanException {
        return this.cmcq.existsMBean(target, name);
    }

    @Override
    public boolean isMBeanEnabled(String target, String name) throws CustomMBeanException {
        return this.cmcq.isMBeanEnabled(target, name);
    }

    @Override
    public List<ObjectName> listMBeanConfigObjectNames(String target) throws CustomMBeanException {
        return this.cmcq.listMBeanConfigObjectNames(target);
    }

    @Override
    public List<ObjectName> listMBeanConfigObjectNames(String target, int type, boolean state) throws CustomMBeanException {
        return this.cmcq.listMBeanConfigObjectNames(target, type, state);
    }

    @Override
    public List<String> listMBeanNames(String target) throws CustomMBeanException {
        return this.cmcq.listMBeanNames(target);
    }

    @Override
    public MBeanInfo getMBeanInfo(String classname) throws CustomMBeanException {
        return this.cmo.getMBeanInfo(classname);
    }

    private static final class ObjectNameAppRefComparator {
        private ObjectNameAppRefComparator() {
        }

        private static int compare(ObjectName on, ApplicationRef ref) {
            String k1 = on.getKeyProperty(ApplicationsConfigMBean.NAME);
            String k2 = ref.getRef();
            return k1.compareTo(k2);
        }

        public static ObjectName[] intersect(ObjectName[] oa, ApplicationRef[] ra) {
            if (null == oa || 0 == oa.length || null == ra || 0 == ra.length) {
                return new ObjectName[0];
            }
            ArrayList<ObjectName> al = new ArrayList<ObjectName>();
            block0: for (int i = 0; i < ra.length; ++i) {
                for (int j = 0; j < oa.length; ++j) {
                    if (0 != ObjectNameAppRefComparator.compare(oa[j], ra[i])) continue;
                    al.add(oa[j]);
                    continue block0;
                }
            }
            return al.toArray(new ObjectName[al.size()]);
        }
    }
}

