/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.jmx.remote.server.rmi.JmxServiceUrlFactory;
import com.sun.enterprise.admin.mbeans.DomainMBean;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.util.i18n.StringManager;
import java.net.UnknownHostException;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.remote.JMXServiceURL;

public class JmxConnectorMBean
extends BaseConfigMBean {
    private static final String HOST_HOLDER_VALUE = "<host-name>";
    private static final int PORT_HOLDER_VALUE = 12345;
    private static final StringManager localStrings = StringManager.getManager(DomainMBean.class);
    public static final String JMX_SERVICE_URL_ATTRNAME = "JMXServiceURL";

    private String getJMXServiceURL() throws UnknownHostException {
        JMXServiceURL url = JmxServiceUrlFactory.forJconsoleOverRmiWithJndiInAppserver(HOST_HOLDER_VALUE, 12345);
        String strUrl = url.toString();
        JmxConnector bean = (JmxConnector)this.getBaseConfigBean();
        String host = bean.getAddress();
        if (host != null && host.trim().equals("0.0.0.0")) {
            host = null;
        }
        if (host != null) {
            strUrl = strUrl.replaceAll(HOST_HOLDER_VALUE, host);
        }
        try {
            int port = Integer.parseInt(bean.getPort());
            strUrl = strUrl.replaceAll(String.valueOf(12345), String.valueOf(port));
        }
        catch (Exception e) {
            strUrl = strUrl.replaceAll(String.valueOf(12345), "<port>");
        }
        return strUrl;
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (name.equals(JMX_SERVICE_URL_ATTRNAME)) {
            try {
                return this.getJMXServiceURL();
            }
            catch (UnknownHostException uhe) {
                throw new MBeanException(uhe);
            }
        }
        return super.getAttribute(name);
    }
}

