/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.meta;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;

public abstract class XPathHelper {
    public static int getNumberOfElemTokens(String xpath) {
        int[] cuts = XPathHelper.getElemDelimitersPositions(xpath);
        int iTokens = cuts.length;
        if (iTokens > 0 && cuts[0] == 0) {
            --iTokens;
        }
        if (cuts.length > 0 && cuts[cuts.length - 1] < xpath.length() - 1) {
            ++iTokens;
        }
        return iTokens;
    }

    public static String getXPathPrefix(String xpath, int numberOfTokensInPrefix) {
        if (numberOfTokensInPrefix <= 0) {
            return "";
        }
        int[] cuts = XPathHelper.getElemDelimitersPositions(xpath);
        int delimIdx = numberOfTokensInPrefix;
        if (cuts.length > 0 && cuts[0] != 0) {
            --delimIdx;
        }
        if (delimIdx < cuts.length) {
            return xpath.substring(0, cuts[delimIdx]);
        }
        if (delimIdx == cuts.length && cuts[cuts.length - 1] < xpath.length() - 1) {
            return xpath;
        }
        return "";
    }

    public static String[] extractTokens(String xpath) {
        ArrayList<String> arr = new ArrayList<String>();
        int[] cuts = XPathHelper.getElemDelimitersPositions(xpath);
        int iTokenPos = 0;
        for (int i = 0; i < cuts.length; ++i) {
            if (iTokenPos == cuts[i]) {
                arr.add("");
            } else {
                arr.add(xpath.substring(iTokenPos, cuts[i]));
            }
            iTokenPos = cuts[i] + 1;
        }
        if (iTokenPos < xpath.length() - 1) {
            arr.add(xpath.substring(iTokenPos));
        }
        return arr.toArray(new String[arr.size()]);
    }

    public static int[] getElemDelimitersPositions(String xpath) {
        return XPathHelper.getElemDelimitersPositions(xpath, -1);
    }

    public static int[] getElemDelimitersPositions(String xpath, int maxDeep) {
        int iNext;
        int[] arr = new int[100];
        int length = 0;
        char[] buf = xpath.toCharArray();
        int i = 0;
        while (maxDeep != 0 && (iNext = XPathHelper.getNextElemDelimiterPos(buf, i)) >= 0) {
            arr[length++] = iNext;
            --maxDeep;
            i = iNext + 1;
        }
        int[] ret_arr = new int[length];
        for (i = 0; i < length; ++i) {
            ret_arr[i] = arr[i];
        }
        return ret_arr;
    }

    public static boolean isAbsoluteXPath(String xpath) {
        return xpath != null && xpath.startsWith("/");
    }

    private static int getNextElemDelimiterPos(char[] buf, int iFrom) {
        int i = iFrom;
        while (i >= 0 && i < buf.length) {
            if (buf[i] == '/') {
                return i;
            }
            if (buf[i] == '\'' || buf[i] == '\"') {
                if ((i = XPathHelper.indexOf(buf, i + 1, buf[i])) <= 0) continue;
                ++i;
                continue;
            }
            ++i;
        }
        return -1;
    }

    private static int indexOf(char[] buf, int iFrom, char chr) {
        for (int i = iFrom; i < buf.length; ++i) {
            if (buf[i] != chr) continue;
            return i;
        }
        return -1;
    }

    public static String convertName(String name) {
        StringBuffer n = new StringBuffer();
        boolean up = true;
        boolean keepCase = false;
        if (name.equals("property")) {
            name = "element-property";
        }
        StringCharacterIterator ci = new StringCharacterIterator(name);
        char c = ci.first();
        while (c != '\uffff') {
            if (Character.isLowerCase(c)) {
                keepCase = true;
                break;
            }
            c = ci.next();
        }
        c = ci.first();
        while (c != '\uffff') {
            if (c == '-' || c == '_') {
                up = true;
            } else {
                if (up) {
                    c = Character.toUpperCase(c);
                } else if (!keepCase) {
                    c = Character.toLowerCase(c);
                }
                n.append(c);
                up = false;
            }
            c = ci.next();
        }
        return n.toString();
    }

    static AttributeList resolve(ConfigContext ctx, ArrayList xpathes, String onlyPrefix) {
        AttributeList merge_list = null;
        if (xpathes != null) {
            merge_list = new AttributeList();
            for (int i = 0; i < xpathes.size(); ++i) {
                AttributeList list = XPathHelper.resolve(ctx, (String)xpathes.get(i), onlyPrefix);
                if (list == null) continue;
                merge_list.addAll(list);
            }
        }
        return merge_list;
    }

    static AttributeList resolve(ConfigContext ctx, String xpath, String prefixFilter) {
        if (xpath == null) {
            return null;
        }
        String[] elems = XPathHelper.extractTokens(xpath);
        if (elems.length == 0 || elems[0].length() != 0) {
            return null;
        }
        ConfigBean cb = null;
        try {
            cb = ctx.getRootConfigBean();
        }
        catch (ConfigException ce) {
            // empty catch block
        }
        AttributeList list = new AttributeList();
        XPathHelper.navigate(cb, elems, 1, prefixFilter, list);
        return list;
    }

    private static void addAttributeToList(String attrName, ConfigBean cb, AttributeList list, String xpath) {
        String attrValue = XPathHelper.getBeanAttributeValue(cb, attrName);
        if (attrValue != null) {
            list.add(new Attribute(xpath + "/@" + attrName, attrValue));
        }
    }

    private static ConfigBean getNextBean(ConfigBean cb, String name) {
        try {
            if ("..".equals(name)) {
                return (ConfigBean)cb.parent();
            }
            return (ConfigBean)cb.getValue(XPathHelper.convertName(name));
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static ConfigBean[] getNextBeans(ConfigBean cb, String name) {
        try {
            if ("..".equals(name)) {
                ConfigBean parent = (ConfigBean)cb.parent();
                if (parent == null) {
                    return null;
                }
                ConfigBean grand = (ConfigBean)parent.parent();
                if (grand == null) {
                    return new ConfigBean[]{parent};
                }
                return (ConfigBean[])grand.getValue(parent.name());
            }
            return (ConfigBean[])cb.getValues(XPathHelper.convertName(name));
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getBeanAttributeValue(ConfigBean cb, String name) {
        try {
            return cb.getAttributeValue(XPathHelper.convertName(name));
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static void navigate(ConfigBean cb, String[] tokens, int iCurrentToken, String prefixFilter, AttributeList list) {
        if (cb == null || tokens == null || tokens.length <= iCurrentToken) {
            return;
        }
        String xpath = cb.getXPath();
        if (xpath == null) {
            return;
        }
        if (prefixFilter != null && prefixFilter.length() > 0 && (xpath.length() >= prefixFilter.length() ? !xpath.startsWith(prefixFilter) : !prefixFilter.startsWith(xpath))) {
            return;
        }
        if (iCurrentToken == tokens.length - 1) {
            list.add(new Attribute(xpath, cb));
            return;
        }
        int iNextToken = iCurrentToken + 1;
        String nextToken = tokens[iNextToken];
        if (iNextToken == tokens.length - 1 && nextToken.startsWith("@")) {
            if ("@*".equals(nextToken)) {
                String[] names = cb.getAttributeNames();
                if (names.length > 0) {
                    for (int i = 0; i < names.length; ++i) {
                        XPathHelper.addAttributeToList(names[i], cb, list, xpath);
                    }
                }
            } else {
                XPathHelper.addAttributeToList(nextToken.substring(1), cb, list, xpath);
            }
            return;
        }
        if (nextToken.length() == 0 || "*".equals(nextToken)) {
            ConfigBean[] children = cb.getAllChildBeans();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    if (nextToken.length() == 0) {
                        XPathHelper.navigate(children[i], tokens, iCurrentToken, prefixFilter, list);
                    }
                    XPathHelper.navigate(children[i], tokens, iNextToken, prefixFilter, list);
                }
            }
            return;
        }
        if (!nextToken.endsWith("]")) {
            ConfigBean cbNext = XPathHelper.getNextBean(cb, nextToken);
            if (cbNext != null) {
                XPathHelper.navigate(cbNext, tokens, iNextToken, prefixFilter, list);
            }
            return;
        }
        int indexStartPos = nextToken.indexOf("[");
        String indexStr = nextToken.substring(indexStartPos + 1, nextToken.length() - 1);
        String baseName = nextToken.substring(0, indexStartPos);
        if ("*".equals(indexStr)) {
            ConfigBean[] beans = XPathHelper.getNextBeans(cb, baseName);
            if (beans != null) {
                for (int i = 0; i < beans.length; ++i) {
                    XPathHelper.navigate(beans[i], tokens, iNextToken, prefixFilter, list);
                }
            }
            return;
        }
        if (indexStr.startsWith("@") && indexStr.startsWith("'")) {
            String attrName = indexStr.substring(1, indexStr.indexOf(61));
            String attrValue = indexStr.substring(indexStr.indexOf("='") + 2, indexStr.length() - 2);
            ConfigBean[] beans = XPathHelper.getNextBeans(cb, baseName);
            if (beans != null) {
                for (int i = 0; i < beans.length; ++i) {
                    String value = XPathHelper.getBeanAttributeValue(beans[i], XPathHelper.convertName(attrName));
                    if (value == null || !attrValue.equals("*") && !attrValue.equals(value)) continue;
                    XPathHelper.navigate(beans[i], tokens, iNextToken, prefixFilter, list);
                }
            }
            return;
        }
    }
}

