/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.callflow;

import com.sun.enterprise.admin.monitor.callflow.AbstractTableAccessObject;
import com.sun.enterprise.admin.monitor.callflow.RequestEndTO;
import com.sun.enterprise.admin.monitor.callflow.TableAccessObject;
import com.sun.enterprise.admin.monitor.callflow.TransferObject;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RequestEndAccessObjectImpl
extends AbstractTableAccessObject {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static RequestEndAccessObjectImpl _singletonRE = new RequestEndAccessObjectImpl();

    private RequestEndAccessObjectImpl() {
        String serverName = super.getServerInstanceName();
        this.tableName = "REQUEST_END_TBL" + serverName.toUpperCase();
        super.setName("RequestEnd");
    }

    public boolean dropTable(Connection connection) {
        this.con = connection;
        return super.createStatmentAndExecuteUpdate("drop table REQUEST_END_TBL", "REQUEST_END_TBL");
    }

    public boolean createTable(Connection connection) {
        this.con = connection;
        return super.createTable(" create table REQUEST_END_TBL ( REQUEST_ID VARCHAR(255)  NOT NULL  , TIME_STAMP BIGINT  ,  primary key (REQUEST_ID))", "REQUEST_END_TBL");
    }

    public static TableAccessObject getInstance() {
        return _singletonRE;
    }

    public boolean insert(PreparedStatement pstmt, TransferObject[] transferObject) {
        if (pstmt == null) {
            return false;
        }
        boolean result = false;
        try {
            for (int i = 0; i < transferObject.length; ++i) {
                RequestEndTO request = (RequestEndTO)transferObject[i];
                pstmt.setString(1, request.getRequestId());
                pstmt.setLong(2, request.getTimeStamp());
                pstmt.addBatch();
            }
            int[] updated = pstmt.executeBatch();
            result = updated.length == transferObject.length;
            this.addTotalEntriesProcessed(updated.length);
            if (this.isTraceOn()) {
                logger.log(Level.INFO, "Callflow: RequestEndAccessObjectImpl  Attempting to Insert : " + transferObject.length + " Inserted " + updated.length + " rows." + " Total Entries written so far : " + this.getTotalEntriesProcessed());
            }
        }
        catch (BatchUpdateException bue) {
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", bue);
            result = false;
        }
        catch (SQLException se) {
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", se);
            result = false;
        }
        return result;
    }

    public String getInsertSQL() {
        String newsql = super.updateSqlWithTableName(" INSERT INTO REQUEST_END_TBL VALUES  (  ?, ?   ) ", "REQUEST_END_TBL");
        return newsql;
    }

    public String getDeleteSQL() {
        String newsql = super.updateSqlWithTableName(" DELETE  FROM REQUEST_END_TBL WHERE REQUEST_ID =  ? ", "REQUEST_END_TBL");
        return newsql;
    }
}

