/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi;

import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.monitor.jndi.JndiMBeanManager;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.registry.StatsHolder;
import com.sun.enterprise.admin.monitor.registry.spi.DottedNameFactory;
import com.sun.enterprise.admin.monitor.registry.spi.MonitoringObjectNames;
import com.sun.enterprise.admin.monitor.registry.spi.StatsHolderImpl;
import com.sun.enterprise.admin.monitor.registry.spi.ValueListMap;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.DynamicReconfigurator;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.MonitoringConfigChangeListener;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.MonitoringConfigurationHandler;
import com.sun.enterprise.admin.monitor.stats.ConnectionFactoryStats;
import com.sun.enterprise.admin.monitor.stats.ConnectionPoolStats;
import com.sun.enterprise.admin.monitor.stats.ConnectorConnectionPoolStats;
import com.sun.enterprise.admin.monitor.stats.ConnectorWorkMgmtStats;
import com.sun.enterprise.admin.monitor.stats.EJBCacheStats;
import com.sun.enterprise.admin.monitor.stats.EJBMethodStats;
import com.sun.enterprise.admin.monitor.stats.EJBPoolStats;
import com.sun.enterprise.admin.monitor.stats.HAStatefulSessionStoreStats;
import com.sun.enterprise.admin.monitor.stats.HTTPListenerStats;
import com.sun.enterprise.admin.monitor.stats.JDBCConnectionPoolStats;
import com.sun.enterprise.admin.monitor.stats.JTAStats;
import com.sun.enterprise.admin.monitor.stats.OrbConnectionManagerStats;
import com.sun.enterprise.admin.monitor.stats.PWCConnectionQueueStats;
import com.sun.enterprise.admin.monitor.stats.PWCDnsStats;
import com.sun.enterprise.admin.monitor.stats.PWCFileCacheStats;
import com.sun.enterprise.admin.monitor.stats.PWCHttpServiceStats;
import com.sun.enterprise.admin.monitor.stats.PWCKeepAliveStats;
import com.sun.enterprise.admin.monitor.stats.PWCRequestStats;
import com.sun.enterprise.admin.monitor.stats.PWCThreadPoolStats;
import com.sun.enterprise.admin.monitor.stats.PWCVirtualServerStats;
import com.sun.enterprise.admin.monitor.stats.ServletStats;
import com.sun.enterprise.admin.monitor.stats.StatefulSessionStoreStats;
import com.sun.enterprise.admin.monitor.stats.ThreadPoolStats;
import com.sun.enterprise.admin.monitor.stats.TimerServiceStats;
import com.sun.enterprise.admin.monitor.stats.WebModuleStats;
import com.sun.enterprise.server.stats.JVMStatsImpl;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.EJBStats;
import javax.management.j2ee.statistics.EntityBeanStats;
import javax.management.j2ee.statistics.JVMStats;
import javax.management.j2ee.statistics.MessageDrivenBeanStats;
import javax.management.j2ee.statistics.StatefulSessionBeanStats;
import javax.management.j2ee.statistics.StatelessSessionBeanStats;
import javax.management.j2ee.statistics.Stats;

public class MonitoringRegistrationHelper
implements MonitoringRegistry {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager sm = StringManager.getManager(MonitoringRegistrationHelper.class);
    private final MBeanServer mbeanserver;
    Vector listeners = new Vector();
    private final ValueListMap objTypeListeners;
    private static MonitoringRegistrationHelper mrh = new MonitoringRegistrationHelper();
    private final StatsHolder rootStatsHolder = new StatsHolderImpl(MonitoredObjectType.ROOT.getTypeName(), MonitoredObjectType.ROOT);

    private MonitoringRegistrationHelper() {
        this.mbeanserver = this.getMBeanServer();
        this.objTypeListeners = new ValueListMap();
        this.initialize();
        AdminEventListenerRegistry.addMonitoringLevelChangeEventListener(new MonitoringConfigChangeListener(new DynamicReconfigurator(this.objTypeListeners)));
    }

    public static MonitoringRegistrationHelper getInstance() {
        return mrh;
    }

    private MBeanServer getMBeanServer() {
        MBeanServer server = null;
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers.isEmpty()) {
            String msg = sm.getString("gen.no_mbs");
            throw new NullPointerException(msg);
        }
        server = servers.get(0);
        return server;
    }

    public void registerEJBCacheStats(EJBCacheStats cs, MonitoredObjectType ejbType, String ejb, String module, String app, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        StatsHolder currChild = null;
        Object dottedName = null;
        String name = MonitoredObjectType.BEAN_CACHE.getTypeName();
        if (cs == null || module == null || ejb == null) {
            throw new IllegalArgumentException("MRH:EjbCacheStats, module, ejb can't be null");
        }
        this.addMonitoringLevelListener(listener);
        currChild = this.getEjb(app, module, ejbType, ejb);
        currChild = currChild.addChild(name, MonitoredObjectType.BEAN_CACHE);
        currChild.setStats(cs);
        currChild.setStatsClass(EJBCacheStats.class);
        ObjectName on = MonitoringObjectNames.getEjbCacheObjectName(ejbType, ejb, module, app);
        currChild.setObjectName(on);
        currChild.setDottedName(DottedNameFactory.getEJBCacheDottedName(app, module, ejb));
        if (this.shouldRegisterMBean(MonitoredObjectType.BEAN_CACHE)) {
            currChild.registerMBean();
        }
    }

    public void unregisterEJBCacheStats(MonitoredObjectType ejbType, String ejb, String module, String app) throws MonitoringRegistrationException {
        StatsHolder currChild = null;
        StatsHolder cacheNode = null;
        String name = MonitoredObjectType.BEAN_CACHE.getTypeName();
        currChild = this.getEjb(app, module, ejbType, ejb);
        assert (currChild != null) : "MRH:unregisterEJBCacheStats: method registerEJBCacheStats was never called";
        cacheNode = currChild.getChild(name);
        cacheNode.unregisterMBean();
        currChild.removeChild(name);
    }

    public void registerEJBPoolStats(EJBPoolStats ps, MonitoredObjectType ejbType, String ejb, String module, String app, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        StatsHolder currChild = null;
        Object dottedName = null;
        String name = MonitoredObjectType.BEAN_POOL.getTypeName();
        if (ps == null || module == null || ejb == null) {
            throw new IllegalArgumentException("MRH:EjbPoolStats, module, ejb can't be null");
        }
        this.addMonitoringLevelListener(listener);
        currChild = this.getEjb(app, module, ejbType, ejb);
        currChild = currChild.addChild(name, MonitoredObjectType.BEAN_POOL);
        currChild.setStats(ps);
        currChild.setStatsClass(EJBPoolStats.class);
        ObjectName on = MonitoringObjectNames.getEjbPoolObjectName(ejbType, ejb, module, app);
        currChild.setObjectName(on);
        currChild.setDottedName(DottedNameFactory.getEJBPoolDottedName(app, module, ejb));
        if (this.shouldRegisterMBean(MonitoredObjectType.BEAN_POOL)) {
            currChild.registerMBean();
        }
    }

    public void unregisterEJBPoolStats(MonitoredObjectType ejbType, String ejb, String module, String app) throws MonitoringRegistrationException {
        StatsHolder currChild = null;
        StatsHolder poolNode = null;
        String name = MonitoredObjectType.BEAN_POOL.getTypeName();
        currChild = this.getEjb(app, module, ejbType, ejb);
        assert (currChild != null) : "MRH:unregisterEJBPoolStats: method registerEJBPoolStats was never called";
        poolNode = currChild.getChild(name);
        poolNode.unregisterMBean();
        currChild.removeChild(name);
    }

    public void registerEJBMethodStats(EJBMethodStats ms, String method, MonitoredObjectType ejbType, String ejb, String module, String app, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        StatsHolder currChild = null;
        Object dottedName = null;
        if (ms == null || module == null || ejb == null) {
            throw new IllegalArgumentException("MRH:EjbMethodStats, module, ejb can't be null");
        }
        this.addMonitoringLevelListener(listener);
        currChild = this.getEjbMethods(app, module, ejbType, ejb);
        currChild = currChild.addChild(method, MonitoredObjectType.BEAN_METHOD);
        currChild.setStats(ms);
        currChild.setStatsClass(EJBMethodStats.class);
        ObjectName on = MonitoringObjectNames.getEjbMethodObjectName(method, ejbType, ejb, module, app);
        currChild.setObjectName(on);
        currChild.setDottedName(DottedNameFactory.getEJBMethodDottedName(app, module, ejb, method));
        if (this.shouldRegisterMBean(MonitoredObjectType.BEAN_METHOD)) {
            currChild.registerMBean();
        }
    }

    public void unregisterEJBMethodStats(String method, MonitoredObjectType ejbType, String ejb, String module, String app) throws MonitoringRegistrationException {
        if (method == null || ejb == null || module == null) {
            throw new IllegalArgumentException("MRH: unregister method called with null arguments");
        }
        StatsHolder currChild = null;
        StatsHolder methodNode = null;
        currChild = this.getEjbMethods(app, module, ejbType, ejb);
        assert (currChild != null) : "Serious: EjbMethodsNode is not created at all";
        methodNode = currChild.getChild(method);
        assert (methodNode != null) : "MRH:unregisterEJBMethodStats - methodNode null";
        methodNode.unregisterMBean();
        currChild.removeChild(method);
    }

    private void registerAnyEjbStats(EJBStats es, MonitoredObjectType ejbType, String ejb, String module, String app, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        StatsHolder currChild = null;
        Object dottedName = null;
        if (es == null || module == null || ejb == null) {
            throw new IllegalArgumentException("MRH:registerEntityBeanStats, module, ejb can't be null");
        }
        this.addMonitoringLevelListener(listener);
        currChild = this.getEjb(app, module, ejbType, ejb);
        assert (currChild != null) : "MRH:registerEntityBeanStats - Serious: EjbNode is null";
        currChild.setStats(es);
        this.setEjbStatsClass(currChild, ejbType);
        currChild.setType(ejbType);
        ObjectName on = MonitoringObjectNames.getEjbObjectName(ejbType, ejb, module, app);
        currChild.setObjectName(on);
        currChild.setDottedName(DottedNameFactory.getEJBDottedName(app, module, ejb));
        if (this.shouldRegisterMBean(ejbType)) {
            currChild.registerMBean();
        }
    }

    private void setEjbStatsClass(StatsHolder s, MonitoredObjectType t) {
        assert (t == MonitoredObjectType.ENTITY_BEAN || t == MonitoredObjectType.STATEFUL_BEAN || t == MonitoredObjectType.STATELESS_BEAN || t == MonitoredObjectType.MESSAGE_DRIVEN_BEAN) : "Invalid Ejb Type: " + t.getTypeName();
        if (t == MonitoredObjectType.ENTITY_BEAN) {
            s.setStatsClass(EntityBeanStats.class);
        } else if (t == MonitoredObjectType.STATEFUL_BEAN) {
            s.setStatsClass(StatefulSessionBeanStats.class);
        } else if (t == MonitoredObjectType.STATELESS_BEAN) {
            s.setStatsClass(StatelessSessionBeanStats.class);
        } else {
            s.setStatsClass(MessageDrivenBeanStats.class);
        }
    }

    private void unregisterAnyEjbStats(String ejb, String module, String app) throws MonitoringRegistrationException {
        if (module == null || ejb == null) {
            throw new IllegalArgumentException("MRH: UnregisterEntityBeanStats, method and ejb name should be non-null");
        }
        StatsHolder ejbRoot = this.getEjbRootNode(app, module);
        assert (ejbRoot != null) : "MRH:unregisterEntityBeanStats: method registerEntityBeanStats was never called";
        StatsHolder ejbNode = ejbRoot.getChild(ejb);
        assert (ejbNode != null) : "MRH:unregisterEntityBeanStats: null node received for ejb: " + ejb;
        ejbNode.removeAllChildren();
        ejbNode.unregisterMBean();
        ejbRoot.removeChild(ejb);
    }

    public void registerEntityBeanStats(EntityBeanStats es, String ejb, String module, String app, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        this.registerAnyEjbStats(es, MonitoredObjectType.ENTITY_BEAN, ejb, module, app, listener);
    }

    public void unregisterEntityBeanStats(String ejb, String module, String app) throws MonitoringRegistrationException {
        this.unregisterAnyEjbStats(ejb, module, app);
    }

    public void registerStatefulSessionBeanStats(StatefulSessionBeanStats ss, String ejb, String module, String app, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        this.registerAnyEjbStats(ss, MonitoredObjectType.STATEFUL_BEAN, ejb, module, app, listener);
    }

    public void unregisterStatefulSessionBeanStats(String ejb, String module, String app) throws MonitoringRegistrationException {
        this.unregisterAnyEjbStats(ejb, module, app);
    }

    public void registerStatelessSessionBeanStats(StatelessSessionBeanStats ss, String ejb, String module, String app, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        this.registerAnyEjbStats(ss, MonitoredObjectType.STATELESS_BEAN, ejb, module, app, listener);
    }

    public void unregisterStatelessSessionBeanStats(String ejb, String module, String app) throws MonitoringRegistrationException {
        this.unregisterAnyEjbStats(ejb, module, app);
    }

    public void registerMessageDrivenBeanStats(MessageDrivenBeanStats ms, String ejb, String module, String app, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        this.registerAnyEjbStats(ms, MonitoredObjectType.MESSAGE_DRIVEN_BEAN, ejb, module, app, listener);
    }

    public void unregisterMessageDrivenBeanStats(String ejb, String module, String app) throws MonitoringRegistrationException {
        this.unregisterAnyEjbStats(ejb, module, app);
    }

    private void registerConnectionPoolStats(ConnectionPoolStats ps, String name, MonitoredObjectType type, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        assert (type == MonitoredObjectType.JDBC_CONN_POOL || type == MonitoredObjectType.CONNECTOR_CONN_POOL) : "MRH:registerConnectionPool - type is invalid";
        if (name == null || ps == null) {
            throw new IllegalArgumentException("MRH:registerConnectionPoolStats - null name");
        }
        StatsHolder resourcesNode = this.rootStatsHolder.getChild(MonitoredObjectType.RESOURCES.getTypeName());
        assert (resourcesNode != null) : "MRH: registerConnectionPoolStats - Resources top-level node not registered";
        StatsHolder added = resourcesNode.addChild(name, type);
        assert (added != null) : "Connection Pool Addtion Error: " + name;
        added.setStats(ps);
        if (type == MonitoredObjectType.JDBC_CONN_POOL) {
            added.setStatsClass(JDBCConnectionPoolStats.class);
        } else {
            added.setStatsClass(ConnectorConnectionPoolStats.class);
        }
        ObjectName on = MonitoringObjectNames.getConnectionPoolObjectName(name, type);
        added.setObjectName(on);
        added.setDottedName(DottedNameFactory.getConnectionPoolDottedName(name, type.getTypeName()));
        if (this.shouldRegisterMBean(type)) {
            added.registerMBean();
        }
    }

    private void unregisterConnectionPoolStats(String name) throws MonitoringRegistrationException {
        if (name == null) {
            throw new IllegalArgumentException("MRH:unregisterConnectionPoolStats - null name");
        }
        StatsHolder resourcesNode = this.rootStatsHolder.getChild(MonitoredObjectType.RESOURCES.getTypeName());
        assert (resourcesNode != null) : "MRH: registerConnectionPoolStats - Resources top-level node not registered";
        StatsHolder pool = resourcesNode.getChild(name);
        assert (pool != null) : "MRH:unregisterConnectionPoolStats -  null node - Serious";
        pool.unregisterMBean();
        resourcesNode.removeChild(name);
    }

    public void registerJDBCConnectionPoolStats(JDBCConnectionPoolStats ps, String name, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        this.registerConnectionPoolStats(ps, name, MonitoredObjectType.JDBC_CONN_POOL, listener);
    }

    public void unregisterJDBCConnectionPoolStats(String name) throws MonitoringRegistrationException {
        this.unregisterConnectionPoolStats(name);
    }

    public void registerConnectorConnectionPoolStats(ConnectorConnectionPoolStats ps, String name, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        this.registerConnectionPoolStats(ps, name, MonitoredObjectType.CONNECTOR_CONN_POOL, listener);
    }

    public void unregisterConnectorConnectionPoolStats(String name) throws MonitoringRegistrationException {
        this.unregisterConnectionPoolStats(name);
    }

    public void registerOrbConnectionManagerStats(OrbConnectionManagerStats cms, String name, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (cms == null || name == null) {
            throw new IllegalArgumentException("MRH:registerOrbCMStats - null arguments");
        }
        StatsHolder orb = this.rootStatsHolder.getChild(MonitoredObjectType.ORB.getTypeName());
        StatsHolder managers = orb.getChild(MonitoredObjectType.CONNECTION_MANAGERS.getTypeName());
        assert (managers != null) : "MRH:registerOrbConnectionManagerStats ORB Node not created yet";
        managers.setDottedName(DottedNameFactory.getConnectionManagersDottedName());
        StatsHolder added = managers.addChild(name, MonitoredObjectType.CONNECTION_MANAGER);
        assert (added != null) : "Addition of Connection Manager failed: " + name;
        added.setStats(cms);
        added.setStatsClass(OrbConnectionManagerStats.class);
        ObjectName on = MonitoringObjectNames.getOrbConnectionManagerObjectName(name);
        added.setObjectName(on);
        added.setDottedName(DottedNameFactory.getOrbConnectionManagerDottedName(name));
        if (this.shouldRegisterMBean(MonitoredObjectType.CONNECTION_MANAGER)) {
            added.registerMBean();
        }
    }

    public void unregisterOrbConnectionManagerStats(String name) throws MonitoringRegistrationException {
        StatsHolder orb = this.rootStatsHolder.getChild(MonitoredObjectType.ORB.getTypeName());
        StatsHolder managers = orb.getChild(MonitoredObjectType.CONNECTION_MANAGERS.getTypeName());
        assert (managers != null) : "MRH:registerOrbConnectionManagerStats ORB Node not created yet";
        StatsHolder cm = managers.getChild(name);
        assert (cm != null) : "Connection Manager to be removed is null";
        cm.unregisterMBean();
        managers.removeChild(name);
    }

    public void registerThreadPoolStats(ThreadPoolStats tps, String name, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (tps == null || name == null) {
            throw new IllegalArgumentException("registerThreadPoolStats - null arguments");
        }
        StatsHolder pools = this.rootStatsHolder.getChild(MonitoredObjectType.THREAD_POOLS.getTypeName());
        assert (pools != null) : "ThreadPools Node not initialized";
        StatsHolder added = pools.addChild(name, MonitoredObjectType.THREAD_POOL);
        assert (added != null) : "No matching thread pool: " + name;
        added.setStats(tps);
        added.setStatsClass(ThreadPoolStats.class);
        ObjectName on = MonitoringObjectNames.getThreadPoolObjectName(name);
        added.setObjectName(on);
        added.setDottedName(DottedNameFactory.getThreadPoolDottedName(name));
        if (this.shouldRegisterMBean(MonitoredObjectType.THREAD_POOL)) {
            added.registerMBean();
        }
    }

    public void unregisterThreadPoolStats(String name) throws MonitoringRegistrationException {
        StatsHolder tps = this.rootStatsHolder.getChild(MonitoredObjectType.THREAD_POOLS.getTypeName());
        assert (tps != null) : "MRH:unregisterThreadPoolStats - null";
        StatsHolder tp = tps.getChild(name);
        assert (tp != null) : "Thread Pool to be removed is null";
        tp.unregisterMBean();
        tps.removeChild(name);
    }

    public void registerJTAStats(JTAStats js, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (js == null) {
            throw new IllegalArgumentException("JTA - null stats provided");
        }
        StatsHolder tsNode = this.rootStatsHolder.getChild(MonitoredObjectType.TRANSACTION_SERVICE.getTypeName());
        assert (tsNode != null) : "MRH:registerJTAStats - Initialization failed";
        tsNode.setStats(js);
        tsNode.setStatsClass(JTAStats.class);
        if (listener != null) {
            this.registerMonitoringLevelListener(listener, MonitoredObjectType.TRANSACTION_SERVICE);
        }
        if (this.shouldRegisterMBean(MonitoredObjectType.TRANSACTION_SERVICE)) {
            tsNode.registerMBean();
        }
    }

    public void unregisterJTAStats() throws MonitoringRegistrationException {
        String name = MonitoredObjectType.TRANSACTION_SERVICE.getTypeName();
        StatsHolder ts = this.rootStatsHolder.getChild(name);
        assert (ts != null) : "Serious JTS is null";
        ts.unregisterMBean();
        this.rootStatsHolder.removeChild(name);
    }

    public void registerJVMStats(JVMStats js, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (js == null) {
            throw new IllegalArgumentException("JVM  - null stats provided");
        }
        StatsHolder vmNode = this.rootStatsHolder.getChild(MonitoredObjectType.JVM.getTypeName());
        assert (vmNode != null) : "MRH:registerJVMStats - Initialization failed";
        vmNode.setStats(js);
        vmNode.setStatsClass(JVMStats.class);
        vmNode.registerMBean();
    }

    public void unregisterJVMStats() throws MonitoringRegistrationException {
        String name = MonitoredObjectType.JVM.getTypeName();
        StatsHolder js = this.rootStatsHolder.getChild(name);
        assert (js != null) : "Serious JVM is null";
        js.unregisterMBean();
        this.rootStatsHolder.removeChild(name);
    }

    public void registerHttpListenerStats(HTTPListenerStats hs, String ls, String vs, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (hs == null || ls == null || vs == null) {
            throw new IllegalArgumentException("MRH:registerHttpListenerStats - Null argunments");
        }
        StatsHolder added = this.getRootVs(vs);
        added = added.addChild(ls, MonitoredObjectType.HTTP_LISTENER);
        assert (added != null) : "MRH: Listener is null - " + ls;
        added.setObjectName(MonitoringObjectNames.getHttpListenerObjectName(vs, ls));
        added.setDottedName(DottedNameFactory.getHttpListenerDottedName(ls, vs));
        added.setStats(hs);
        added.setStatsClass(HTTPListenerStats.class);
        if (this.shouldRegisterMBean(MonitoredObjectType.HTTP_LISTENER)) {
            added.registerMBean();
        }
    }

    public void unregisterHttpListenerStats(String name, String vs) throws MonitoringRegistrationException {
        if (name == null || vs == null) {
            throw new IllegalArgumentException("Null args");
        }
        StatsHolder vsNode = this.getRootVs(vs);
        StatsHolder ls = vsNode.getChild(name);
        assert (ls != null) : "Unexpected this http listener should be non null : vs = " + vs + " ls = " + name;
        ls.unregisterMBean();
        vsNode.removeChild(name);
    }

    public void registerServletStats(ServletStats ss, String app, String module, String ctxRoot, String vs, String servlet, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (ss == null || module == null || ctxRoot == null || vs == null || servlet == null) {
            throw new IllegalArgumentException("Null arguments");
        }
        StatsHolder sRootNode = this.getServletRootNode(app, module, ctxRoot, vs);
        StatsHolder sNode = sRootNode.addChild(servlet, MonitoredObjectType.SERVLET);
        assert (sNode != null) : "Added Servlet Node is not null";
        sNode.setStats(ss);
        sNode.setStatsClass(ServletStats.class);
        sNode.setObjectName(MonitoringObjectNames.getServletObjectName(app, ctxRoot, vs, servlet));
        sNode.setDottedName(DottedNameFactory.getServletDottedName(app, module, vs, servlet));
        if (this.shouldRegisterMBean(MonitoredObjectType.SERVLET)) {
            sNode.registerMBean();
        }
    }

    public void unregisterServletStats(String app, String module, String ctxRoot, String vs, String servlet) throws MonitoringRegistrationException {
        StatsHolder sRootNode = this.getServletRootNode(app, module, ctxRoot, vs);
        StatsHolder tmp = sRootNode.getChild(servlet);
        assert (tmp != null) : "Registration of this servlet was not called before: " + servlet;
        tmp.unregisterMBean();
        sRootNode.removeChild(servlet);
    }

    public void registerWebModuleStats(WebModuleStats stats, String appName, String webModuleName, String ctxRoot, String vs, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (stats == null || webModuleName == null || ctxRoot == null || vs == null) {
            throw new IllegalArgumentException("Null arguments");
        }
        StatsHolder sNode = this.getServletRootNode(appName, webModuleName, ctxRoot, vs);
        sNode.setStats(stats);
        Class beanMethods = WebModuleStats.class;
        Class<?>[] interfaces = stats.getClass().getInterfaces();
        for (int i = 0; interfaces != null && i < interfaces.length; ++i) {
            if (!beanMethods.isAssignableFrom(interfaces[i])) continue;
            beanMethods = interfaces[i];
            break;
        }
        sNode.setStatsClass(beanMethods);
        if (this.shouldRegisterMBean(MonitoredObjectType.WEBMODULE)) {
            sNode.registerMBean();
        }
    }

    public void unregisterWebModuleStats(String appName, String webModuleName, String ctxRoot, String vs) throws MonitoringRegistrationException {
        StatsHolder webModule;
        StatsHolder parent;
        StatsHolder sNode = this.getServletRootNode(appName, webModuleName, ctxRoot, vs);
        sNode.unregisterMBean();
        StatsHolder statsHolder = parent = null == appName ? this.rootStatsHolder.getChild(MonitoredObjectType.APPLICATIONS.getTypeName()) : this.rootStatsHolder.getChild(MonitoredObjectType.APPLICATIONS.getTypeName()).getChild(appName);
        if (null != parent && null != (webModule = parent.getChild(webModuleName))) {
            webModule.removeChild(vs);
            Collection children = webModule.getAllChildren();
            if (children == null || children.isEmpty()) {
                webModule.unregisterMBean();
                parent.removeChild(webModuleName);
            }
        }
    }

    public WebModuleStats getWebModuleStats(String appName, String webModuleName, String ctxRoot, String vs) {
        WebModuleStats stats = null;
        StatsHolder sNode = this.getServletRootNode(appName, webModuleName, ctxRoot, vs);
        if (sNode != null) {
            stats = (WebModuleStats)sNode.getStats();
        }
        return stats;
    }

    private StatsHolder getServletRootNode(String app, String module, String ctxRoot, String vs) {
        StatsHolder tmp = this.rootStatsHolder.getChild(MonitoredObjectType.APPLICATIONS.getTypeName());
        if (app != null) {
            tmp = tmp.addChild(app, MonitoredObjectType.APPLICATION);
            tmp.setObjectName(MonitoringObjectNames.getApplicationObjectName(app));
            tmp.setDottedName(DottedNameFactory.getAppDottedName(app));
            tmp.registerMBean();
            tmp = tmp.addChild(module, MonitoredObjectType.WEBMODULE);
            tmp.setDottedName(DottedNameFactory.getAppModuleDottedName(app, module));
        } else {
            tmp = tmp.addChild(module, MonitoredObjectType.STANDALONE_WEBMODULE);
            tmp.setDottedName(DottedNameFactory.getStandAloneWebModuleDottedName(module));
        }
        tmp.setObjectName(MonitoringObjectNames.getWebModuleObjectName(app, ctxRoot, vs));
        tmp.registerMBean();
        tmp = tmp.addChild(vs, MonitoredObjectType.VIRTUAL_SERVER);
        tmp.setObjectName(MonitoringObjectNames.getVirtualServerObjectName(app, ctxRoot, vs));
        tmp.setDottedName(DottedNameFactory.getWebAppsVirtualServerDottedName(app, module, vs));
        return tmp;
    }

    private StatsHolder getEjbRootNode(String app, String module) {
        StatsHolder tmp = this.rootStatsHolder.getChild(MonitoredObjectType.APPLICATIONS.getTypeName());
        if (app != null) {
            tmp = tmp.addChild(app, MonitoredObjectType.APPLICATION);
            tmp.setObjectName(MonitoringObjectNames.getApplicationObjectName(app));
            tmp.setDottedName(DottedNameFactory.getAppDottedName(app));
            tmp.registerMBean();
            tmp = tmp.addChild(module, MonitoredObjectType.EJBMODULE);
            tmp.setDottedName(DottedNameFactory.getAppModuleDottedName(app, module));
        } else {
            tmp = tmp.addChild(module, MonitoredObjectType.STANDALONE_EJBMODULE);
            tmp.setDottedName(DottedNameFactory.getStandAloneEJBModuleDottedName(module));
        }
        tmp.setObjectName(MonitoringObjectNames.getEjbModuleObjectName(app, module));
        tmp.registerMBean();
        return tmp;
    }

    private StatsHolder getWebServiceEndpointForWeb(String app, String module, String ctxRoot, String vs, String endpoint) {
        StatsHolder sRoot = this.getServletRootNode(app, module, ctxRoot, vs);
        assert (sRoot != null) : "MRH:getWebService, unexpectedly sRoot is null: " + app + ":" + module;
        StatsHolder wsNode = sRoot.addChild(endpoint, MonitoredObjectType.WEBSERVICE_ENDPOINT);
        assert (wsNode != null) : "Web Service node should not be null: " + endpoint;
        return wsNode;
    }

    private StatsHolder getWebServiceEndpointForEjb(String app, String module, String endpoint) {
        StatsHolder ejbRoot = this.getEjbRootNode(app, module);
        assert (ejbRoot != null) : "MRH:getEjb, unexpectedly ejbRoot is null: " + app + ":" + module;
        StatsHolder wsNode = ejbRoot.addChild(endpoint, MonitoredObjectType.WEBSERVICE_ENDPOINT);
        assert (wsNode != null) : "Web Service node should not be null: " + endpoint;
        return wsNode;
    }

    private StatsHolder getEjb(String app, String module, MonitoredObjectType ejbType, String ejb) {
        StatsHolder ejbRoot = this.getEjbRootNode(app, module);
        assert (ejbRoot != null) : "MRH:getEjb, unexpectedly ejbRoot is null: " + app + ":" + module;
        StatsHolder ejbNode = ejbRoot.addChild(ejb, ejbType);
        assert (ejbNode != null) : "Ejb node should not be null: " + ejb;
        return ejbNode;
    }

    private StatsHolder getEjbMethods(String app, String module, MonitoredObjectType ejbType, String ejb) {
        StatsHolder ejbNode = this.getEjb(app, module, ejbType, ejb);
        assert (ejbNode != null) : "MRH:getEjbMethods, unexpectedly ejb node is null: " + app + ":" + module + ":" + ejb;
        String methods = MonitoredObjectType.BEAN_METHODS.getTypeName();
        StatsHolder added = ejbNode.addChild(methods, MonitoredObjectType.BEAN_METHODS);
        added.setObjectName(MonitoringObjectNames.getEjbMethodsObjectName(app, module, ejbType, ejb));
        added.setDottedName(DottedNameFactory.getEJBMethodsDottedName(app, module, ejb));
        added.registerMBean();
        return added;
    }

    private StatsHolder getRootVs(String vs) {
        StatsHolder https = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        assert (https != null) : "MRH:registerHttpListener HTTP Service is not initialized - Serious";
        https.setDottedName(DottedNameFactory.getHttpServiceDottedName());
        StatsHolder added = https.addChild(vs, MonitoredObjectType.VIRTUAL_SERVER);
        assert (added != null) : "MRH: VS is null: " + vs;
        added.setObjectName(MonitoringObjectNames.getVirtualServerObjectName(vs));
        added.setDottedName(DottedNameFactory.getHttpSvcVirtualServerDottedName(vs));
        added.registerMBean();
        return added;
    }

    public Collection getThreadPoolNodes() {
        StatsHolder tps = this.rootStatsHolder.getChild(MonitoredObjectType.THREAD_POOLS.getTypeName());
        return tps.getAllChildren();
    }

    public Collection getOrbNodes() {
        StatsHolder tmp = this.rootStatsHolder.getChild(MonitoredObjectType.ORB.getTypeName());
        tmp = tmp.getChild(MonitoredObjectType.CONNECTION_MANAGERS.getTypeName());
        return tmp.getAllChildren();
    }

    public Collection getHttpServiceNodes() {
        ArrayList all = new ArrayList();
        Collection vss = this.getVsNodes();
        all.addAll(vss);
        for (StatsHolder vs : vss) {
            all.addAll(vs.getAllChildren());
        }
        return all;
    }

    private Collection getVsNodes() {
        StatsHolder https = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        return https.getAllChildren();
    }

    public Collection getTransactionServiceNodes() {
        ArrayList<StatsHolder> all = new ArrayList<StatsHolder>();
        all.add(this.rootStatsHolder.getChild(MonitoredObjectType.TRANSACTION_SERVICE.getTypeName()));
        return all;
    }

    public Collection getConnectionPoolNodes() {
        StatsHolder res = this.rootStatsHolder.getChild(MonitoredObjectType.RESOURCES.getTypeName());
        return res.getAllChildren();
    }

    public Collection getWebContainerNodes() {
        ArrayList all = new ArrayList();
        StatsHolder appsNode = this.rootStatsHolder.getChild(MonitoredObjectType.APPLICATIONS.getTypeName());
        Collection apps = appsNode.getAllChildren();
        for (StatsHolder appOrStandaloneModule : apps) {
            if (appOrStandaloneModule.getType() == MonitoredObjectType.APPLICATION) {
                Collection modulesInApp = appOrStandaloneModule.getAllChildren();
                for (StatsHolder embedded : modulesInApp) {
                    if (embedded.getType() != MonitoredObjectType.WEBMODULE) continue;
                    all.addAll(this.getWebModuleNodes(embedded));
                }
                continue;
            }
            if (appOrStandaloneModule.getType() != MonitoredObjectType.STANDALONE_WEBMODULE) continue;
            StatsHolder standaloneWebModule = appOrStandaloneModule;
            all.addAll(this.getWebModuleNodes(standaloneWebModule));
        }
        return all;
    }

    private Collection getWebModuleNodes(StatsHolder node) {
        ArrayList<StatsHolder> nodes = new ArrayList<StatsHolder>();
        assert (node.getType() == MonitoredObjectType.WEBMODULE || node.getType() == MonitoredObjectType.STANDALONE_WEBMODULE);
        Collection vss = node.getAllChildren();
        for (StatsHolder vs : vss) {
            nodes.add(vs);
            nodes.addAll(vs.getAllChildren());
        }
        return nodes;
    }

    public Collection getEjbContainerNodes(boolean includeMethods) {
        ArrayList all = new ArrayList();
        StatsHolder appsNode = this.rootStatsHolder.getChild(MonitoredObjectType.APPLICATIONS.getTypeName());
        Collection apps = appsNode.getAllChildren();
        for (StatsHolder appOrStandaloneModule : apps) {
            if (appOrStandaloneModule.getType() == MonitoredObjectType.APPLICATION) {
                Collection modulesInApp = appOrStandaloneModule.getAllChildren();
                for (StatsHolder embedded : modulesInApp) {
                    if (embedded.getType() != MonitoredObjectType.EJBMODULE) continue;
                    all.addAll(this.getEjbNodesInEjbModule(embedded, includeMethods));
                }
                continue;
            }
            if (appOrStandaloneModule.getType() != MonitoredObjectType.STANDALONE_EJBMODULE) continue;
            StatsHolder standaloneEjbModule = appOrStandaloneModule;
            all.addAll(this.getEjbNodesInEjbModule(standaloneEjbModule, includeMethods));
        }
        return all;
    }

    private Collection getEjbNodesInEjbModule(StatsHolder node, boolean includeMethods) {
        ArrayList ejbNodes = new ArrayList();
        assert (node.getType() == MonitoredObjectType.EJBMODULE || node.getType() == MonitoredObjectType.STANDALONE_EJBMODULE);
        Collection ejbs = node.getAllChildren();
        ejbNodes.addAll(ejbs);
        for (StatsHolder ejb : ejbs) {
            ejbNodes.addAll(ejb.getAllChildren());
            StatsHolder methodsNode = ejb.getChild(MonitoredObjectType.BEAN_METHODS.getTypeName());
            if (includeMethods) {
                if (methodsNode == null) continue;
                ejbNodes.addAll(this.getEjbMethodNodes(methodsNode));
                continue;
            }
            ejbNodes.remove(methodsNode);
        }
        return ejbNodes;
    }

    private Collection getEjbMethodNodes(StatsHolder methodsNode) {
        assert (methodsNode.getType() == MonitoredObjectType.BEAN_METHODS);
        return methodsNode.getAllChildren();
    }

    public Collection getEjbMethodNodes() {
        ArrayList ejbNodes = new ArrayList();
        ArrayList<StatsHolder> ejbMethodNodes = new ArrayList<StatsHolder>();
        ejbNodes.addAll(this.getEjbContainerNodes(true));
        for (StatsHolder ejbNode : ejbNodes) {
            if (ejbNode.getType() != MonitoredObjectType.BEAN_METHODS && ejbNode.getType() != MonitoredObjectType.BEAN_METHOD) continue;
            ejbMethodNodes.add(ejbNode);
        }
        return ejbMethodNodes;
    }

    private void addMonitoringLevelListener(MonitoringLevelListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void registerMonitoringLevelListener(MonitoringLevelListener listener, MonitoredObjectType objType) {
        if (listener != null && objType != null) {
            this.objTypeListeners.put(objType, listener);
            MonitoringLevel monitoringLevel = MonitoringConfigurationHandler.getLevel(objType);
        }
    }

    public void unregisterMonitoringLevelListener(MonitoringLevelListener listener) {
        if (listener != null) {
            this.objTypeListeners.remove(listener);
        }
    }

    private void initialize() {
        this.initializeRoot();
        this.initializeJvm();
        this.initializeApplications();
        this.initializeThreadPools();
        this.initializeOrb();
        this.initializeTransactionService();
        this.initializeHttpService();
        this.initializeResources();
        this.initializeConnectorService();
        this.initializeJmsService();
        this.initializeJndi();
    }

    private void initializeRoot() {
        this.rootStatsHolder.setObjectName(MonitoringObjectNames.getRootObjectName());
        this.rootStatsHolder.setDottedName(DottedNameFactory.getRootDottedName());
        this.rootStatsHolder.registerMBean();
    }

    private void initializeJvm() {
        StatsHolder jvmNode = this.rootStatsHolder.addChild(MonitoredObjectType.JVM.getTypeName(), MonitoredObjectType.JVM);
        assert (jvmNode != null) : "Initialization Error in jvmNodeCreation";
        jvmNode.setObjectName(MonitoringObjectNames.getJvmObjectName());
        jvmNode.setDottedName(DottedNameFactory.getJVMDottedName());
        try {
            this.registerJVMStats(new JVMStatsImpl(), null);
        }
        catch (Exception cause) {
            throw new RuntimeException(cause);
        }
        this.initializeJvmMonitoring(this.rootStatsHolder);
    }

    private void initializeApplications() {
        StatsHolder appsNode = this.rootStatsHolder.addChild(MonitoredObjectType.APPLICATIONS.getTypeName(), MonitoredObjectType.APPLICATIONS);
        assert (appsNode != null) : "Initialization Error in appsNodeCreation";
        appsNode.setObjectName(MonitoringObjectNames.getApplicationsObjectName());
        appsNode.setDottedName(DottedNameFactory.getApplicationsDottedName());
        appsNode.registerMBean();
    }

    private void initializeThreadPools() {
        StatsHolder tpsNode = this.rootStatsHolder.addChild(MonitoredObjectType.THREAD_POOLS.getTypeName(), MonitoredObjectType.THREAD_POOLS);
        assert (tpsNode != null) : "Initialization Error in tpsNodeCreation";
        tpsNode.setObjectName(MonitoringObjectNames.getThreadPoolsObjectName());
        tpsNode.setDottedName(DottedNameFactory.getThreadPoolsDottedName());
        tpsNode.registerMBean();
    }

    private void initializeOrb() {
        StatsHolder orbNode = this.rootStatsHolder.addChild(MonitoredObjectType.ORB.getTypeName(), MonitoredObjectType.ORB);
        assert (orbNode != null) : "Initialization Error in orbNodeCreation";
        orbNode.setObjectName(MonitoringObjectNames.getOrbObjectName());
        orbNode.setDottedName(DottedNameFactory.getOrbDottedName());
        orbNode.registerMBean();
        StatsHolder cmsNode = orbNode.addChild(MonitoredObjectType.CONNECTION_MANAGERS.getTypeName(), MonitoredObjectType.CONNECTION_MANAGERS);
        assert (cmsNode != null) : "Initialization Error in Connection Managers Creation";
        cmsNode.setObjectName(MonitoringObjectNames.getConnectionManagersObjectName());
        cmsNode.setDottedName(DottedNameFactory.getConnectionManagersDottedName());
        cmsNode.registerMBean();
    }

    private void initializeTransactionService() {
        StatsHolder tsNode = this.rootStatsHolder.addChild(MonitoredObjectType.TRANSACTION_SERVICE.getTypeName(), MonitoredObjectType.TRANSACTION_SERVICE);
        assert (tsNode != null) : "Initialization Error in Transaction Service";
        tsNode.setObjectName(MonitoringObjectNames.getTransactionServiceObjectName());
        tsNode.setDottedName(DottedNameFactory.getTransactionServiceDottedName());
    }

    private void initializeHttpService() {
        StatsHolder hsNode = this.rootStatsHolder.addChild(MonitoredObjectType.HTTP_SERVICE.getTypeName(), MonitoredObjectType.HTTP_SERVICE);
        assert (hsNode != null) : "Initialization Error in HttpServiceCreation";
        hsNode.setObjectName(MonitoringObjectNames.getHttpServiceObjectName());
        hsNode.setDottedName(DottedNameFactory.getHttpServiceDottedName());
        hsNode.registerMBean();
    }

    private void initializeResources() {
        StatsHolder resNode = this.rootStatsHolder.addChild(MonitoredObjectType.RESOURCES.getTypeName(), MonitoredObjectType.RESOURCES);
        assert (resNode != null) : "Initialization Error in Resources";
        resNode.setObjectName(MonitoringObjectNames.getResourcesObjectName());
        resNode.setDottedName(DottedNameFactory.getResourcesDottedName());
        resNode.registerMBean();
    }

    private void initializeJndi() {
        JndiMBeanManager mgr = new JndiMBeanManager();
        mgr.registerMBean(MonitoringObjectNames.getJndiObjectName());
    }

    private void initializeJvmMonitoring(StatsHolder rootNode) {
        String JMM_CLASS = "com.sun.enterprise.admin.monitor.registry.spi.JVMMonitoringManager";
        String METHOD = "getInstance";
        String REG_METHOD = "registerStats";
        try {
            Class<?> c = Class.forName("com.sun.enterprise.admin.monitor.registry.spi.JVMMonitoringManager");
            Method m = c.getMethod("getInstance", new Class[0]);
            Object jmm = m.invoke(c, new Object[0]);
            this.registerMonitoringLevelListener((MonitoringLevelListener)jmm, MonitoredObjectType.JVM);
            Method m1 = c.getMethod("registerStats", StatsHolder.class);
            m1.invoke(jmm, this.rootStatsHolder);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private boolean shouldRegisterMBean(MonitoredObjectType type) {
        return MonitoringConfigurationHandler.shouldRegisterMBean(type);
    }

    private void initializeConnectorService() {
        StatsHolder adaptorsNode = this.rootStatsHolder.addChild(MonitoredObjectType.CONNECTOR_SERVICE.getTypeName(), MonitoredObjectType.CONNECTOR_SERVICE);
        assert (adaptorsNode != null) : "connector-service node not created";
        adaptorsNode.setObjectName(MonitoringObjectNames.getConnectorServiceObjectName());
        adaptorsNode.setDottedName(DottedNameFactory.getConnectorServiceDottedName());
        adaptorsNode.registerMBean();
    }

    private void initializeJmsService() {
        StatsHolder adaptorsNode = this.rootStatsHolder.addChild(MonitoredObjectType.JMS_SERVICE.getTypeName(), MonitoredObjectType.JMS_SERVICE);
        assert (adaptorsNode != null) : "jms-service node not created";
        adaptorsNode.setObjectName(MonitoringObjectNames.getJmsServiceObjectName());
        adaptorsNode.setDottedName(DottedNameFactory.getJmsServiceDottedName());
        adaptorsNode.registerMBean();
    }

    private StatsHolder getConnectorRootNode(String j2eeAppName, String moduleName) {
        StatsHolder tmp = this.rootStatsHolder.getChild(MonitoredObjectType.CONNECTOR_SERVICE.getTypeName());
        assert (tmp != null) : "connector-service node not created";
        tmp = j2eeAppName != null ? tmp.addChild(j2eeAppName + "#" + moduleName, MonitoredObjectType.CONNECTOR_MODULE) : tmp.addChild(moduleName, MonitoredObjectType.STANDALONE_CONNECTOR_MODULE);
        tmp.setDottedName(DottedNameFactory.getConnectorModuleDottedName(j2eeAppName, moduleName));
        tmp.setObjectName(MonitoringObjectNames.getConnectorModuleObjectName(j2eeAppName, moduleName));
        tmp.registerMBean();
        return tmp;
    }

    public void registerConnectorWorkMgmtStats(ConnectorWorkMgmtStats stats, String j2eeAppName, String moduleName, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        this.registerConnectorWorkMgmtStats(stats, j2eeAppName, moduleName, false, listener);
    }

    public void registerConnectorWorkMgmtStats(ConnectorWorkMgmtStats stats, String j2eeAppName, String moduleName, boolean isJms, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        StatsHolder adapterNode = null;
        if (isJms) {
            if (stats == null) {
                throw new IllegalArgumentException("Invalid Arguments for ConnectorWorkManagementStats registration");
            }
            adapterNode = this.rootStatsHolder.getChild(MonitoredObjectType.JMS_SERVICE.getTypeName());
        } else {
            if (stats == null || moduleName == null || moduleName.equals("")) {
                throw new IllegalArgumentException("Invalid Arguments for ConnectorWorkManagementStats registration");
            }
            adapterNode = this.getConnectorRootNode(j2eeAppName, moduleName);
        }
        assert (adapterNode != null) : "connector node is null";
        adapterNode = adapterNode.addChild(MonitoredObjectType.CONNECTOR_WORKMGMT.getTypeName(), MonitoredObjectType.CONNECTOR_WORKMGMT);
        adapterNode.setStats(stats);
        adapterNode.setStatsClass(ConnectorWorkMgmtStats.class);
        adapterNode.setDottedName(DottedNameFactory.getConnectorWorkMgmtDottedName(j2eeAppName, moduleName, isJms));
        adapterNode.setObjectName(MonitoringObjectNames.getConnectorWorkMgmtObjectName(j2eeAppName, moduleName, isJms));
        adapterNode.registerMBean();
        if (this.shouldRegisterMBean(MonitoredObjectType.CONNECTOR_WORKMGMT)) {
            adapterNode.registerMBean();
        }
    }

    public void unregisterConnectorWorkMgmtStats(String j2eeAppName, String moduleName) throws MonitoringRegistrationException {
        this.unregisterConnectorWorkMgmtStats(j2eeAppName, moduleName, false);
    }

    public void unregisterConnectorWorkMgmtStats(String j2eeAppName, String moduleName, boolean isJms) throws MonitoringRegistrationException {
        StatsHolder connectorNode = null;
        if (isJms) {
            connectorNode = this.rootStatsHolder.getChild(MonitoredObjectType.JMS_SERVICE.getTypeName());
        } else {
            if (moduleName == null || j2eeAppName != null && j2eeAppName.equals("") || moduleName.equals("")) {
                throw new IllegalArgumentException("Invalid Arguments for ConnectorWorkManagementStats unregistration");
            }
            connectorNode = this.getConnectorRootNode(j2eeAppName, moduleName);
        }
        assert (connectorNode != null) : "connector node not initialized";
        StatsHolder workmgmtNode = connectorNode.getChild(MonitoredObjectType.CONNECTOR_WORKMGMT.getTypeName());
        assert (workmgmtNode != null) : "Connector Work Management node not initialized";
        workmgmtNode.unregisterMBean();
        connectorNode.removeChild(MonitoredObjectType.CONNECTOR_WORKMGMT.getTypeName());
    }

    public void registerConnectionFactoryStats(ConnectionFactoryStats stats, String factoryName, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (stats == null || factoryName == null) {
            throw new IllegalArgumentException("Invalid arguments for registraion of ConnectionFactory Stats");
        }
        StatsHolder cfNode = this.getConnectionFactoriesNode();
        assert (cfNode != null) : "connection-factories node not initialized correctly";
        cfNode = cfNode.addChild(factoryName, MonitoredObjectType.CONNECTION_FACTORY);
        cfNode.setStats(stats);
        cfNode.setStatsClass(ConnectionFactoryStats.class);
        cfNode.setDottedName(DottedNameFactory.getConnectionFactoryDottedName(factoryName));
        cfNode.setObjectName(MonitoringObjectNames.getConnectionFactoryObjectName(factoryName));
        if (this.shouldRegisterMBean(MonitoredObjectType.CONNECTION_FACTORY)) {
            cfNode.registerMBean();
        }
    }

    private StatsHolder getConnectionFactoriesNode() {
        StatsHolder tmpNode = this.rootStatsHolder.getChild(MonitoredObjectType.JMS_SERVICE.getTypeName());
        assert (tmpNode != null) : "jms-service node initialized correctly";
        tmpNode = tmpNode.addChild(MonitoredObjectType.CONNECTION_FACTORIES.getTypeName(), MonitoredObjectType.CONNECTION_FACTORIES);
        tmpNode.setDottedName(DottedNameFactory.getConnectionFactoriesDottedName());
        tmpNode.setObjectName(MonitoringObjectNames.getConnectionFactoriesObjectName());
        tmpNode.registerMBean();
        return tmpNode;
    }

    public void unregisterConnectionFactoryStats(String factoryName) throws MonitoringRegistrationException {
        if (factoryName == null) {
            throw new IllegalArgumentException("Invalid arguments for the unregistration of ConnectionFactory Stats");
        }
        StatsHolder tmpNode = this.rootStatsHolder.getChild(MonitoredObjectType.JMS_SERVICE.getTypeName());
        assert (tmpNode != null) : "jms-service node not initialized correctly";
        tmpNode = tmpNode.getChild(MonitoredObjectType.CONNECTION_FACTORIES.getTypeName());
        assert (tmpNode != null) : "connection-factories node not initialized correctly";
        StatsHolder cfNode = tmpNode.getChild(factoryName);
        assert (cfNode != null) : "connection-factory node not initialized correctly";
        cfNode.unregisterMBean();
        tmpNode.removeChild(factoryName);
    }

    public void registerConnectorConnectionPoolStats(ConnectorConnectionPoolStats stats, String poolName, String j2eeAppName, String moduleName, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (stats == null || moduleName == null || poolName == null) {
            throw new IllegalArgumentException("Invalid arguments for the registration of connection-pool stats");
        }
        StatsHolder poolsNode = this.getConnectionPoolsNode(j2eeAppName, moduleName);
        assert (poolsNode != null) : "connection-pools node not initialized correctly";
        StatsHolder poolNode = poolsNode.addChild(poolName, MonitoredObjectType.CONNECTOR_CONN_POOL);
        poolNode.setStats(stats);
        poolNode.setStatsClass(ConnectorConnectionPoolStats.class);
        poolNode.setDottedName(DottedNameFactory.getConnectionPoolDottedName(poolName, j2eeAppName, moduleName));
        poolNode.setObjectName(MonitoringObjectNames.getConnectionPoolObjectName(poolName, j2eeAppName, moduleName));
        if (this.shouldRegisterMBean(MonitoredObjectType.CONNECTOR_CONN_POOL)) {
            poolNode.registerMBean();
        }
        this.registerConnectionPoolStats(stats, poolName, MonitoredObjectType.CONNECTOR_CONN_POOL, listener);
    }

    private StatsHolder getConnectionPoolsNode(String j2eeAppName, String moduleName) {
        StatsHolder connNode = this.getConnectorRootNode(j2eeAppName, moduleName);
        assert (connNode != null) : "connector node initialized correctly";
        connNode = connNode.addChild(MonitoredObjectType.CONNECTION_POOLS.getTypeName(), MonitoredObjectType.CONNECTION_POOLS);
        connNode.setDottedName(DottedNameFactory.getConnectionPoolsDottedName(j2eeAppName, moduleName));
        connNode.setObjectName(MonitoringObjectNames.getConnectionPoolsObjectName(j2eeAppName, moduleName));
        connNode.registerMBean();
        return connNode;
    }

    public void unregisterConnectorConnectionPoolStats(String poolName, String j2eeAppName, String moduleName) throws MonitoringRegistrationException {
        StatsHolder poolsNode = this.getConnectionPoolsNode(j2eeAppName, moduleName);
        assert (poolsNode != null) : "connection-pools node not initialized";
        StatsHolder poolNode = poolsNode.getChild(poolName);
        assert (poolNode != null) : "connection-pool node not initialized";
        poolNode.unregisterMBean();
        poolsNode.removeChild(poolName);
        this.unregisterConnectionPoolStats(poolName);
    }

    public Collection getConnectorRelatedNodes() {
        Collection c = this.getConnectionPoolNodes(MonitoredObjectType.CONNECTOR_CONN_POOL);
        c.addAll(this.getConnectorServiceChildren());
        c.addAll(this.getJmsServiceChildren());
        return c;
    }

    private Collection getConnectorServiceChildren() {
        StatsHolder connservNode = this.rootStatsHolder.getChild(MonitoredObjectType.CONNECTOR_SERVICE.getTypeName());
        assert (connservNode != null) : "connector-service node is null";
        ArrayList c = new ArrayList();
        Collection cNodes = connservNode.getAllChildren();
        c.addAll(cNodes);
        for (StatsHolder connectorNode : cNodes) {
            c.addAll(connectorNode.getAllChildren());
            StatsHolder poolsNode = connectorNode.getChild(MonitoredObjectType.CONNECTION_POOLS.getTypeName());
            c.addAll(poolsNode.getAllChildren());
        }
        return c;
    }

    private Collection getJmsServiceChildren() {
        StatsHolder jmsservNode = this.rootStatsHolder.getChild(MonitoredObjectType.JMS_SERVICE.getTypeName());
        assert (jmsservNode != null) : "jms-service node is null";
        ArrayList c = new ArrayList();
        Collection jmsNodes = jmsservNode.getAllChildren();
        c.addAll(jmsNodes);
        for (StatsHolder childNode : jmsNodes) {
            Collection c1 = childNode.getAllChildren();
            if (c1 == null) continue;
            c.addAll(c1);
        }
        return c;
    }

    public Collection getConnectionPoolNodes(MonitoredObjectType t) {
        StatsHolder resNode = this.rootStatsHolder.getChild(MonitoredObjectType.RESOURCES.getTypeName());
        Collection c = resNode.getAllChildren();
        Iterator iter = c.iterator();
        ArrayList<StatsHolder> poolNodes = new ArrayList<StatsHolder>();
        while (iter.hasNext()) {
            StatsHolder tmp = (StatsHolder)iter.next();
            if (tmp.getType() != t) continue;
            poolNodes.add(tmp);
        }
        return poolNodes;
    }

    public void registerPWCConnectionQueueStats(PWCConnectionQueueStats stats, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (stats == null) {
            throw new IllegalArgumentException("PWCConnectionQueueStats is null");
        }
        StatsHolder httpsvcNode = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        assert (httpsvcNode != null) : "HttpService is not initialized correctly";
        httpsvcNode = httpsvcNode.addChild(MonitoredObjectType.CONNECTION_QUEUE.getTypeName(), MonitoredObjectType.CONNECTION_QUEUE);
        httpsvcNode.setStats(stats);
        httpsvcNode.setStatsClass(PWCConnectionQueueStats.class);
        httpsvcNode.setDottedName(DottedNameFactory.getConnectionQueueDottedName());
        httpsvcNode.setObjectName(MonitoringObjectNames.getConnectionQueueObjectName());
        if (this.shouldRegisterMBean(MonitoredObjectType.CONNECTION_QUEUE)) {
            httpsvcNode.registerMBean();
        }
    }

    public void unregisterPWCConnectionQueueStats() throws MonitoringRegistrationException {
        StatsHolder httpsvcNode = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        assert (httpsvcNode != null) : "http-service node is null";
        StatsHolder targetNode = httpsvcNode.getChild(MonitoredObjectType.CONNECTION_QUEUE.getTypeName());
        assert (targetNode != null) : "connection-queue node is null";
        targetNode.unregisterMBean();
    }

    public void registerPWCDnsStats(PWCDnsStats stats, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (stats == null) {
            throw new IllegalArgumentException("PWCDnsStats is null");
        }
        StatsHolder httpsvcNode = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        assert (httpsvcNode != null) : "HttpService is not initialized correctly";
        httpsvcNode = httpsvcNode.addChild(MonitoredObjectType.DNS.getTypeName(), MonitoredObjectType.DNS);
        httpsvcNode.setStats(stats);
        httpsvcNode.setStatsClass(PWCDnsStats.class);
        httpsvcNode.setDottedName(DottedNameFactory.getDnsDottedName());
        httpsvcNode.setObjectName(MonitoringObjectNames.getDnsObjectName());
        if (this.shouldRegisterMBean(MonitoredObjectType.DNS)) {
            httpsvcNode.registerMBean();
        }
    }

    public void unregisterPWCDnsStats() throws MonitoringRegistrationException {
        StatsHolder httpsvcNode = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        assert (httpsvcNode != null) : "http-service node is null";
        StatsHolder dnsNode = httpsvcNode.getChild(MonitoredObjectType.DNS.getTypeName());
        assert (dnsNode != null) : "dns node is null";
        dnsNode.unregisterMBean();
    }

    public void registerPWCFileCacheStats(PWCFileCacheStats stats, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (stats == null) {
            throw new IllegalArgumentException("PWCFileCacheStats is null");
        }
        StatsHolder httpsvcNode = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        assert (httpsvcNode != null) : "HttpService is not initialized correctly";
        httpsvcNode = httpsvcNode.addChild(MonitoredObjectType.FILE_CACHE.getTypeName(), MonitoredObjectType.FILE_CACHE);
        httpsvcNode.setStats(stats);
        httpsvcNode.setStatsClass(PWCFileCacheStats.class);
        httpsvcNode.setDottedName(DottedNameFactory.getFileCacheDottedName());
        httpsvcNode.setObjectName(MonitoringObjectNames.getFileCacheObjectName());
        if (this.shouldRegisterMBean(MonitoredObjectType.FILE_CACHE)) {
            httpsvcNode.registerMBean();
        }
    }

    public void unregisterPWCFileCacheStats() throws MonitoringRegistrationException {
        StatsHolder httpsvcNode = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        assert (httpsvcNode != null) : "http-service node is null";
        StatsHolder fcNode = httpsvcNode.getChild(MonitoredObjectType.FILE_CACHE.getTypeName());
        assert (fcNode != null) : "file-cache node is null";
        fcNode.unregisterMBean();
    }

    public void registerPWCHttpServiceStats(PWCHttpServiceStats stats, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (stats == null) {
            throw new IllegalArgumentException("PWCHttpServiceStats is null");
        }
        StatsHolder httpsvcNode = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        assert (httpsvcNode != null) : "HttpService is not initialized correctly";
        httpsvcNode.setStats(stats);
        httpsvcNode.setStatsClass(PWCHttpServiceStats.class);
        if (this.shouldRegisterMBean(MonitoredObjectType.HTTP_SERVICE)) {
            httpsvcNode.unregisterMBean();
            httpsvcNode.registerMBean();
        }
    }

    public void unregisterPWCHttpServiceStats() throws MonitoringRegistrationException {
        StatsHolder httpsvcNode = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        assert (httpsvcNode != null) : "http-service node is null";
        httpsvcNode.unregisterMBean();
        httpsvcNode.setStats(null);
        httpsvcNode.setStatsClass(Stats.class);
        httpsvcNode.registerMBean();
    }

    public void registerPWCKeepAliveStats(PWCKeepAliveStats stats, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (stats == null) {
            throw new IllegalArgumentException("PWCHttpServiceStats is null");
        }
        StatsHolder httpsvcNode = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        assert (httpsvcNode != null) : "HttpService is not initialized correctly";
        httpsvcNode = httpsvcNode.addChild(MonitoredObjectType.KEEP_ALIVE.getTypeName(), MonitoredObjectType.KEEP_ALIVE);
        httpsvcNode.setStats(stats);
        httpsvcNode.setStatsClass(PWCKeepAliveStats.class);
        httpsvcNode.setDottedName(DottedNameFactory.getKeepAliveDottedName());
        httpsvcNode.setObjectName(MonitoringObjectNames.getKeepAliveObjectName());
        if (this.shouldRegisterMBean(MonitoredObjectType.KEEP_ALIVE)) {
            httpsvcNode.registerMBean();
        }
    }

    public void unregisterPWCKeepAliveStats() throws MonitoringRegistrationException {
        StatsHolder httpsvcNode = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        assert (httpsvcNode != null) : "http-service node is null";
        StatsHolder kaNode = httpsvcNode.getChild(MonitoredObjectType.KEEP_ALIVE.getTypeName());
        assert (kaNode != null) : "keep-alive node is null";
        kaNode.unregisterMBean();
    }

    public void registerPWCRequestStats(PWCRequestStats stats, String vsId, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (stats == null || vsId == null || vsId.equals("")) {
            throw new IllegalArgumentException("Invalid arguments for registration of request stats");
        }
        StatsHolder httpsvcNode = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        assert (httpsvcNode != null) : "http-service node is null";
        StatsHolder vsNode = httpsvcNode.getChild(vsId);
        assert (vsNode != null) : "virtual-server is not initialized correctly";
        vsNode = vsNode.addChild(MonitoredObjectType.REQUEST.getTypeName(), MonitoredObjectType.REQUEST);
        vsNode.setStats(stats);
        vsNode.setStatsClass(PWCRequestStats.class);
        vsNode.setDottedName(DottedNameFactory.getRequestDottedName(vsId));
        vsNode.setObjectName(MonitoringObjectNames.getRequestObjectName(vsId));
        if (this.shouldRegisterMBean(MonitoredObjectType.REQUEST)) {
            vsNode.registerMBean();
        }
    }

    public void unregisterPWCRequestStats(String vsId) throws MonitoringRegistrationException {
        StatsHolder httpsvcNode = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        assert (httpsvcNode != null) : "http-service node is null";
        StatsHolder vsNode = httpsvcNode.getChild(vsId);
        assert (vsNode != null) : "virtual-server node is null";
        StatsHolder requestNode = vsNode.getChild(MonitoredObjectType.REQUEST.getTypeName());
        assert (requestNode != null) : "request node is null";
        requestNode.unregisterMBean();
    }

    public void registerPWCThreadPoolStats(PWCThreadPoolStats stats, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (stats == null) {
            throw new IllegalArgumentException("PWCThreadPoolStats is null");
        }
        StatsHolder httpsvcNode = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        assert (httpsvcNode != null) : "HttpService is not initialized correctly";
        httpsvcNode = httpsvcNode.addChild(MonitoredObjectType.PWC_THREAD_POOL.getTypeName(), MonitoredObjectType.PWC_THREAD_POOL);
        httpsvcNode.setStats(stats);
        httpsvcNode.setStatsClass(PWCThreadPoolStats.class);
        httpsvcNode.setDottedName(DottedNameFactory.getPWCThreadPoolDottedName());
        httpsvcNode.setObjectName(MonitoringObjectNames.getPWCThreadPoolObjectName());
        if (this.shouldRegisterMBean(MonitoredObjectType.PWC_THREAD_POOL)) {
            httpsvcNode.registerMBean();
        }
    }

    public void unregisterPWCThreadPoolStats() throws MonitoringRegistrationException {
        StatsHolder httpsvcNode = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        assert (httpsvcNode != null) : "http-service node is null";
        StatsHolder tpNode = httpsvcNode.getChild(MonitoredObjectType.PWC_THREAD_POOL.getTypeName());
        assert (tpNode != null) : "pwc-thread-pool node is null";
        tpNode.unregisterMBean();
    }

    public void registerPWCVirtualServerStats(PWCVirtualServerStats stats, String vsId, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (stats == null || vsId == null || vsId.equals("")) {
            throw new IllegalArgumentException("Invalid arguments for registration of vs stats");
        }
        StatsHolder httpsvcNode = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        assert (httpsvcNode != null) : "HttpService is not initialized correctly";
        httpsvcNode = httpsvcNode.addChild(vsId, MonitoredObjectType.VIRTUAL_SERVER);
        httpsvcNode.setStats(stats);
        httpsvcNode.setStatsClass(PWCVirtualServerStats.class);
        httpsvcNode.setDottedName(DottedNameFactory.getHttpSvcVirtualServerDottedName(vsId));
        httpsvcNode.setObjectName(MonitoringObjectNames.getVirtualServerObjectName(vsId));
        if (this.shouldRegisterMBean(MonitoredObjectType.VIRTUAL_SERVER)) {
            httpsvcNode.registerMBean();
        }
    }

    public void unregisterPWCVirtualServerStats(String vsId) throws MonitoringRegistrationException {
        StatsHolder httpsvcNode = this.rootStatsHolder.getChild(MonitoredObjectType.HTTP_SERVICE.getTypeName());
        assert (httpsvcNode != null) : "http-service node is null";
        StatsHolder vsNode = httpsvcNode.getChild(vsId);
        assert (vsNode != null) : "virtual-server node is null";
        Collection c = vsNode.getAllChildren();
        for (StatsHolder childNode : c) {
            childNode.unregisterMBean();
        }
        vsNode.unregisterMBean();
    }

    public void registerStatefulSessionStoreStats(StatefulSessionStoreStats stats, MonitoredObjectType ejbType, String ejbName, String moduleName, String j2eeAppName, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (stats == null || ejbName == null || moduleName == null) {
            throw new IllegalArgumentException("Invalid arguments for registration of StatefulSessionStore stats");
        }
        StatsHolder ejbNode = this.getEjb(j2eeAppName, moduleName, ejbType, ejbName);
        assert (ejbNode != null) : "EJB node is not initialized correctly";
        ejbNode = ejbNode.addChild(MonitoredObjectType.SESSION_STORE.getTypeName(), MonitoredObjectType.SESSION_STORE);
        ejbNode.setStats(stats);
        if (stats instanceof HAStatefulSessionStoreStats) {
            ejbNode.setStatsClass(HAStatefulSessionStoreStats.class);
        } else {
            ejbNode.setStatsClass(StatefulSessionStoreStats.class);
        }
        ejbNode.setDottedName(DottedNameFactory.getStatefulSessionStoreDottedName(ejbName, moduleName, j2eeAppName));
        ejbNode.setObjectName(MonitoringObjectNames.getStatefulSessionStoreObjectName(ejbType, ejbName, moduleName, j2eeAppName));
        this.addMonitoringLevelListener(listener);
        if (this.shouldRegisterMBean(MonitoredObjectType.SESSION_STORE)) {
            ejbNode.registerMBean();
        }
    }

    public void unregisterStatefulSessionStoreStats(MonitoredObjectType ejbType, String ejbName, String moduleName, String j2eeAppName) throws MonitoringRegistrationException {
        if (ejbName == null || moduleName == null) {
            throw new IllegalArgumentException("Invalid arguments for the unregistration of StatefulSessionStore stats");
        }
        StatsHolder ejbNode = this.getEjb(j2eeAppName, moduleName, ejbType, ejbName);
        assert (ejbNode != null) : "EJB node is not initialized correctly";
        StatsHolder storeNode = ejbNode.getChild(MonitoredObjectType.SESSION_STORE.getTypeName());
        assert (storeNode != null) : "SessionStore node is not initialized correctly";
        storeNode.unregisterMBean();
        ejbNode.removeChild(MonitoredObjectType.SESSION_STORE.getTypeName());
    }

    public void registerTimerStats(TimerServiceStats stats, MonitoredObjectType ejbType, String ejbName, String moduleName, String j2eeAppName, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (stats == null || ejbName == null || moduleName == null) {
            throw new IllegalArgumentException("Invalid arguments for registration of Timer stats");
        }
        StatsHolder ejbNode = this.getEjb(j2eeAppName, moduleName, ejbType, ejbName);
        assert (ejbNode != null) : "EJB node is not initialized correctly";
        ejbNode = ejbNode.addChild(MonitoredObjectType.TIMERS.getTypeName(), MonitoredObjectType.TIMERS);
        ejbNode.setStats(stats);
        ejbNode.setStatsClass(TimerServiceStats.class);
        ejbNode.setDottedName(DottedNameFactory.getTimerDottedName(ejbName, moduleName, j2eeAppName));
        ejbNode.setObjectName(MonitoringObjectNames.getTimerObjectName(ejbType, ejbName, moduleName, j2eeAppName));
        this.addMonitoringLevelListener(listener);
        if (this.shouldRegisterMBean(MonitoredObjectType.TIMERS)) {
            ejbNode.registerMBean();
        }
    }

    public void unregisterTimerStats(MonitoredObjectType ejbType, String ejbName, String moduleName, String j2eeAppName) throws MonitoringRegistrationException {
        if (ejbName == null || moduleName == null) {
            throw new IllegalArgumentException("Invalid arguments for the unregistration of Timer stats");
        }
        StatsHolder ejbNode = this.getEjb(j2eeAppName, moduleName, ejbType, ejbName);
        assert (ejbNode != null) : "EJB node is not initialized correctly";
        StatsHolder timerNode = ejbNode.getChild(MonitoredObjectType.TIMERS.getTypeName());
        assert (timerNode != null) : "Timer node is not initialized correctly";
        timerNode.unregisterMBean();
        ejbNode.removeChild(MonitoredObjectType.TIMERS.getTypeName());
    }

    public void registerWSAggregateStatsForWeb(Stats stats, String endpointName, String moduleName, String ctxRoot, String j2eeAppName, String vs, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (stats == null || endpointName == null || moduleName == null) {
            throw new IllegalArgumentException("Invalid arguments for registration of WS aggregate stats");
        }
        StatsHolder wsNode = this.getWebServiceEndpointForWeb(j2eeAppName, moduleName, ctxRoot, vs, endpointName);
        assert (wsNode != null) : "Web Service node is not initialized correctly";
        wsNode = wsNode.addChild(MonitoredObjectType.WEBSERVICE_ENDPOINT.getTypeName(), MonitoredObjectType.WEBSERVICE_ENDPOINT);
        wsNode.setStats(stats);
        wsNode.setStatsClassName("com.sun.appserv.management.monitor.statistics.WebServiceEndpointAggregateStats");
        wsNode.setDottedName(DottedNameFactory.getWebServiceAggregateStatsInWebDottedName(endpointName, moduleName, j2eeAppName));
        wsNode.setObjectName(MonitoringObjectNames.getWebServiceObjectNameForWeb(endpointName, j2eeAppName, ctxRoot, vs));
        this.addMonitoringLevelListener(listener);
        if (this.shouldRegisterMBean(MonitoredObjectType.WEBSERVICE_ENDPOINT)) {
            wsNode.registerMBean();
        }
    }

    public void unregisterWSAggregateStatsForWeb(String endpointName, String moduleName, String ctxRoot, String j2eeAppName, String vs) throws MonitoringRegistrationException {
        if (endpointName == null || moduleName == null) {
            throw new IllegalArgumentException("Invalid arguments for the unregistration of Web Service stats");
        }
        StatsHolder wsNode = this.getWebServiceEndpointForWeb(j2eeAppName, moduleName, ctxRoot, vs, endpointName);
        assert (wsNode != null) : "Web Service node is not initialized correctly";
        StatsHolder endpointNode = wsNode.getChild(MonitoredObjectType.WEBSERVICE_ENDPOINT.getTypeName());
        assert (endpointNode != null) : "Endpoint node is not initialized correctly";
        endpointNode.unregisterMBean();
        wsNode.removeChild(MonitoredObjectType.WEBSERVICE_ENDPOINT.getTypeName());
    }

    public void registerWSAggregateStatsForEjb(Stats stats, String endpointName, String moduleName, String j2eeAppName, MonitoringLevelListener listener) throws MonitoringRegistrationException {
        if (stats == null || endpointName == null || moduleName == null) {
            throw new IllegalArgumentException("Invalid arguments for registration of WS aggregate stats");
        }
        StatsHolder wsNode = this.getWebServiceEndpointForEjb(j2eeAppName, moduleName, endpointName);
        assert (wsNode != null) : "Web Service node is not initialized correctly";
        wsNode = wsNode.addChild(MonitoredObjectType.WEBSERVICE_ENDPOINT.getTypeName(), MonitoredObjectType.WEBSERVICE_ENDPOINT);
        wsNode.setStats(stats);
        wsNode.setStatsClassName("com.sun.appserv.management.monitor.statistics.WebServiceEndpointAggregateStats");
        wsNode.setDottedName(DottedNameFactory.getWebServiceAggregateStatsInEjbDottedName(endpointName, moduleName, j2eeAppName));
        wsNode.setObjectName(MonitoringObjectNames.getWebServiceObjectNameForEjb(endpointName, moduleName, j2eeAppName));
        this.addMonitoringLevelListener(listener);
        if (this.shouldRegisterMBean(MonitoredObjectType.WEBSERVICE_ENDPOINT)) {
            wsNode.registerMBean();
        }
    }

    public void unregisterWSAggregateStatsForEjb(String endpointName, String moduleName, String j2eeAppName) throws MonitoringRegistrationException {
        if (endpointName == null || moduleName == null) {
            throw new IllegalArgumentException("Invalid arguments for the unregistration of Web Service stats");
        }
        StatsHolder wsNode = this.getWebServiceEndpointForEjb(j2eeAppName, moduleName, endpointName);
        assert (wsNode != null) : "Web Service node is not initialized correctly";
        StatsHolder endpointNode = wsNode.getChild(MonitoredObjectType.WEBSERVICE_ENDPOINT.getTypeName());
        assert (endpointNode != null) : "Endpoint node is not initialized correctly";
        endpointNode.unregisterMBean();
        wsNode.removeChild(MonitoredObjectType.WEBSERVICE_ENDPOINT.getTypeName());
    }

    public Collection getJvmNodes(boolean threadInfo) {
        ArrayList<StatsHolder> all = new ArrayList<StatsHolder>();
        StatsHolder jvmNode = this.rootStatsHolder.getChild(MonitoredObjectType.JVM.getTypeName());
        Collection systemNodes = jvmNode.getAllChildren();
        if (systemNodes != null) {
            for (StatsHolder childNode : systemNodes) {
                all.add(childNode);
                if (childNode.getType() == MonitoredObjectType.JVM_GCS) {
                    all.addAll(childNode.getAllChildren());
                }
                if (childNode.getType() != MonitoredObjectType.JVM_THREAD || !threadInfo) continue;
                all.addAll(childNode.getAllChildren());
            }
        }
        return all;
    }

    public Collection getJvmThreadInfoNodes() {
        ArrayList all = new ArrayList();
        StatsHolder jvmNode = this.rootStatsHolder.getChild(MonitoredObjectType.JVM.getTypeName());
        StatsHolder threadNode = jvmNode.getChild(MonitoredObjectType.JVM_THREAD.getTypeName());
        if (threadNode != null) {
            all.addAll(threadNode.getAllChildren());
        }
        return all;
    }

    public StatsHolder getRootStatsHolder() {
        return this.rootStatsHolder;
    }
}

