/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi;

import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.StatsHolder;
import com.sun.enterprise.admin.monitor.registry.spi.StatsHolderMBeanImpl;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;

public class StatsHolderImpl
implements StatsHolder {
    private final String name;
    private final Hashtable children;
    private final MBeanServer server;
    private Class statsClass = null;
    private String statsClassName = null;
    MonitoredObjectType type = null;
    Stats stats = null;
    ObjectName objectName = null;
    String dottedName = null;
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager sm = StringManager.getManager(StatsHolderImpl.class);

    public StatsHolderImpl(String name) {
        this.name = name;
        this.children = new Hashtable();
        this.server = this.findMBeanServer();
        logger.fine("StatsHolderImpl initialized, name = " + name);
    }

    public StatsHolderImpl(String name, MonitoredObjectType type) {
        this(name);
        this.setType(type);
    }

    private MBeanServer findMBeanServer() {
        MBeanServer server = null;
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (!servers.isEmpty()) {
            server = servers.get(0);
        }
        return server;
    }

    private StatsHolder addChild(StatsHolder sh) {
        assert (sh != null) : "Null StatsHolder to be added";
        if (!this.children.containsKey(sh.getName())) {
            this.children.put(sh.getName(), sh);
            logger.fine("StatsHolder.addChild: New key created with statsHolder key name = " + sh.getName() + " type = " + sh.getType().toString());
        } else {
            sh = this.getChild(sh.getName());
            logger.fine("Not adding, StatsHolder.addChild: Child exists, name = " + sh.getName() + " type = " + sh.getType().toString());
        }
        return sh;
    }

    public StatsHolder addChild(String name, MonitoredObjectType type) {
        assert (name != null && type != null) : "Asked to add a null name-type child";
        StatsHolder child = this.getChild(name);
        if (child == null) {
            child = this.addChild(new StatsHolderImpl(name, type));
        }
        return child;
    }

    public Collection getAllChildren() {
        return this.children.values();
    }

    public void removeAllChildren() {
        if (this.children.isEmpty()) {
            this.unregisterMBean();
        } else {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                StatsHolder sh = (StatsHolder)e.nextElement();
                sh.removeAllChildren();
            }
            this.children.clear();
        }
    }

    public void removeChild(String name) {
        this.children.remove(name);
    }

    public String getName() {
        return this.name;
    }

    public MonitoredObjectType getType() {
        return this.type;
    }

    public void setStats(Stats stats) {
        this.stats = stats;
    }

    public Stats getStats() {
        return this.stats;
    }

    public void setObjectName(ObjectName name) {
        this.objectName = name;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setDottedName(String dottedName) {
        this.dottedName = dottedName;
    }

    public String getDottedName() {
        return this.dottedName;
    }

    public void registerMBean() {
        try {
            if (this.server.isRegistered(this.objectName)) {
                logger.fine("ObjectName obj is already registered - this is an error, ignoring for now : " + this.objectName);
                return;
            }
            StatsHolderMBeanImpl mbean = new StatsHolderMBeanImpl(this);
            this.server.registerMBean(mbean, this.objectName);
            logger.finer("Registered the MBean for this StatsHolder: " + this.objectName);
        }
        catch (Exception e) {
            logger.fine("SH.registerMBean: Exception for object-name " + this.objectName);
            logger.throwing(StatsHolderImpl.class.getName(), "registerMBean()", e);
        }
    }

    public void unregisterMBean() {
        Object msg = null;
        try {
            if (this.server.isRegistered(this.objectName)) {
                this.server.unregisterMBean(this.objectName);
                logger.fine("SH.unregisterMonitoringMBean(): unregistered - " + this.objectName);
            } else {
                logger.fine("SH.unregisterMonitoringMBean(): never registered - so not unregistering" + this.objectName);
            }
        }
        catch (Exception e) {
            logger.fine("SH.unregisterMBeanUnregistration failed, objectName = " + this.objectName);
        }
    }

    public void setType(MonitoredObjectType type) {
        this.type = type;
    }

    public StatsHolder getChild(String name) {
        StatsHolder child = (StatsHolder)this.children.get(name);
        if (child == null) {
            logger.fine("SH.getChild - child is null with name = " + name);
        }
        return child;
    }

    void write() {
    }

    public Class getStatsClass() {
        return this.statsClass;
    }

    public void setStatsClass(Class c) {
        if (!Stats.class.isAssignableFrom(c)) {
            String msg = sm.getString("sh.not_a_stats_interface", c.getName());
            throw new IllegalArgumentException(msg);
        }
        if (!c.isInterface()) {
            String msg = sm.getString("sh.should_be_an_interface", c.getName());
            throw new IllegalArgumentException(msg);
        }
        this.statsClass = c;
        this.statsClassName = c.getName();
    }

    public String getStatsClassName() {
        return this.statsClassName;
    }

    public void setStatsClassName(String cName) {
        Class<?> c = null;
        try {
            c = Class.forName(cName);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = sm.getString("invalidclassname.statsholder", cName);
            throw new IllegalArgumentException(msg);
        }
        if (!Stats.class.isAssignableFrom(c)) {
            String msg = sm.getString("sh.not_a_stats_interface", c.getName());
            throw new IllegalArgumentException(msg);
        }
        if (!c.isInterface()) {
            String msg = sm.getString("sh.should_be_an_interface", c.getName());
            throw new IllegalArgumentException(msg);
        }
        this.statsClass = c;
        this.statsClassName = cName;
    }

    private class DumpThread
    extends Thread {
        private DumpThread() {
        }

        public void run() {
            while (true) {
                logger.fine("Start Element: " + StatsHolderImpl.this.name);
                if (StatsHolderImpl.this.children.isEmpty()) {
                    logger.fine("Leaf Element");
                } else {
                    Enumeration e = StatsHolderImpl.this.children.elements();
                    while (e.hasMoreElements()) {
                        StatsHolderImpl c = (StatsHolderImpl)e.nextElement();
                        c.write();
                    }
                }
                logger.fine("End Element: " + StatsHolderImpl.this.name);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

