/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi;

import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class ValueListMap
implements Map {
    public static final Class LISTENER_CLASS = MonitoringLevelListener.class;
    private static final StringManager sm = StringManager.getManager(ValueListMap.class);
    private final Class valueClass;
    private final Map map;

    public ValueListMap(Class valueClass) {
        if (valueClass == null) {
            String msg = sm.getString("gen.illegal_arg");
            throw new IllegalArgumentException(msg);
        }
        this.map = new HashMap();
        this.valueClass = valueClass;
    }

    public ValueListMap() {
        this(LISTENER_CLASS);
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("ValueListMap:containsValue() - Not supported");
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object put(Object key, Object value) {
        String msg = null;
        if (key == null || value == null) {
            msg = sm.getString("sm.illegal_arg");
            throw new IllegalArgumentException("Null Argument");
        }
        if (!this.implementsValueClass(value)) {
            msg = sm.getString("sm.illegal_arg_class", this.valueClass.getName());
            throw new IllegalArgumentException(msg);
        }
        Map mm = (Map)this.map.get(key);
        if (mm == null) {
            mm = this.addNewKey(key);
        }
        return mm.put(value, 1);
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException("ValueListMap:putAll() - Not supported");
    }

    public Object remove(Object keyOrValue) {
        Collection removed = null;
        if (this.valueClass.isAssignableFrom(keyOrValue.getClass())) {
            Object value = keyOrValue;
            removed = this.removeValues(value);
        } else {
            Object key = keyOrValue;
            removed = this.removeKeyedValues(key);
            this.map.remove(key);
        }
        return removed;
    }

    private Collection removeValues(Object value) {
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            Map mm = (Map)this.map.get(iter.next());
            mm.remove(value);
            list.add(value);
        }
        return list;
    }

    private Collection removeKeyedValues(Object key) {
        Collection<Object> list = new ArrayList();
        Object value = this.get(key);
        if (value != null && value instanceof Map) {
            list = ((Map)value).keySet();
        }
        return list;
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        ArrayList values = new ArrayList();
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            Map mm = (Map)this.map.get(iter.next());
            values.addAll(mm.keySet());
        }
        return values;
    }

    private Map addNewKey(Object key) {
        HashMap v = new HashMap();
        this.map.put(key, v);
        return v;
    }

    private boolean implementsValueClass(Object value) {
        boolean ivc = false;
        Class<?>[] ics = value.getClass().getInterfaces();
        for (int i = 0; i < ics.length; ++i) {
            if (!this.valueClass.equals(ics[i])) continue;
            ivc = true;
            break;
        }
        return ivc;
    }
}

