/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi.reconfig;

import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.StatsHolder;
import com.sun.enterprise.admin.monitor.registry.spi.MonitoringRegistrationHelper;
import com.sun.enterprise.admin.monitor.registry.spi.ValueListMap;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.ChangeHandler;
import java.util.Map;
import java.util.logging.Logger;

class EjbContainerChangeHandler
implements ChangeHandler {
    private final ChangeHandler successor;
    private final ValueListMap listeners;
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    EjbContainerChangeHandler(ChangeHandler successor, ValueListMap listeners) {
        this.successor = successor;
        this.listeners = listeners;
    }

    public void handleChange(MonitoredObjectType t, MonitoringLevel from, MonitoringLevel to) {
        if (this.isEjbContainerType(t)) {
            this.handleChange(from, to, t);
        } else {
            this.successor.handleChange(t, from, to);
        }
    }

    private boolean isEjbContainerType(MonitoredObjectType t) {
        return t == MonitoredObjectType.BEAN_CACHE || t == MonitoredObjectType.BEAN_METHOD || t == MonitoredObjectType.BEAN_POOL || t == MonitoredObjectType.ENTITY_BEAN || t == MonitoredObjectType.STATEFUL_BEAN || t == MonitoredObjectType.STATELESS_BEAN || t == MonitoredObjectType.MESSAGE_DRIVEN_BEAN;
    }

    private void handleChange(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType t) {
        boolean includeMethods;
        if (this.off2Low(from, to) || this.off2High(from, to)) {
            includeMethods = false;
            this.notifyListeners(from, to, t);
            if (to == MonitoringLevel.HIGH) {
                includeMethods = true;
            }
            this.registerMBeans(includeMethods);
        }
        if (this.low2Off(from, to) || this.high2Off(from, to)) {
            includeMethods = false;
            if (from == MonitoringLevel.HIGH) {
                includeMethods = true;
            }
            this.unregisterMBeans(includeMethods);
            this.notifyListeners(from, to, t);
        }
        if (this.low2High(from, to)) {
            this.notifyListeners(from, to, t);
            this.registerMethodMBeans();
        }
        if (this.high2Low(from, to)) {
            this.unregisterMethodMBeans();
            this.notifyListeners(from, to, t);
        }
    }

    private void notifyListeners(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType t) {
        logger.finer("DynamicReconfigurator: Now notifying the listeners for ejb stats --- from = " + from.toString() + " to = " + to.toString());
        Map l = (Map)this.listeners.get(t);
        if (l == null) {
            return;
        }
        for (MonitoringLevelListener ml : l.keySet()) {
            ml.changeLevel(from, to, t);
        }
    }

    private void registerMBeans(boolean includeMethods) {
        MonitoringRegistrationHelper registryImpl = MonitoringRegistrationHelper.getInstance();
        for (StatsHolder c : registryImpl.getEjbContainerNodes(includeMethods)) {
            c.registerMBean();
            logger.finer("DynamicReconfigurator: Now Registering MBean for --- " + c.getName());
        }
    }

    private void unregisterMBeans(boolean includeMethods) {
        MonitoringRegistrationHelper registryImpl = MonitoringRegistrationHelper.getInstance();
        for (StatsHolder c : registryImpl.getEjbContainerNodes(includeMethods)) {
            c.unregisterMBean();
            logger.finer("DynamicReconfigurator: Now UnRegistering MBean for --- " + c.getName());
        }
    }

    private void registerMethodMBeans() {
        MonitoringRegistrationHelper registryImpl = MonitoringRegistrationHelper.getInstance();
        for (StatsHolder c : registryImpl.getEjbMethodNodes()) {
            c.registerMBean();
            logger.finer("DynamicReconfigurator: Now Registering MBean for --- " + c.getName());
        }
    }

    private void unregisterMethodMBeans() {
        MonitoringRegistrationHelper registryImpl = MonitoringRegistrationHelper.getInstance();
        for (StatsHolder c : registryImpl.getEjbMethodNodes()) {
            c.unregisterMBean();
            logger.finer("DynamicReconfigurator: Now UnRegistering MBean for --- " + c.getName());
        }
    }

    private boolean off2Low(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.OFF && to == MonitoringLevel.LOW;
    }

    private boolean off2High(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.OFF && to == MonitoringLevel.HIGH;
    }

    private boolean low2Off(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.LOW && to == MonitoringLevel.OFF;
    }

    private boolean high2Off(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.HIGH && to == MonitoringLevel.OFF;
    }

    private boolean low2High(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.LOW && to == MonitoringLevel.HIGH;
    }

    private boolean high2Low(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.HIGH && to == MonitoringLevel.LOW;
    }
}

