/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi.reconfig;

import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.StatsHolder;
import com.sun.enterprise.admin.monitor.registry.spi.MonitoringRegistrationHelper;
import com.sun.enterprise.admin.monitor.registry.spi.ValueListMap;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.ChangeHandler;
import java.util.logging.Logger;

class OrbChangeHandler
implements ChangeHandler {
    private final ChangeHandler successor;
    private final ValueListMap listeners;
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    OrbChangeHandler(ChangeHandler successor, ValueListMap listeners) {
        this.successor = successor;
        this.listeners = listeners;
    }

    public void handleChange(MonitoredObjectType t, MonitoringLevel from, MonitoringLevel to) {
        if (this.isOrbType(t)) {
            this.handleChange(from, to);
        } else {
            this.successor.handleChange(t, from, to);
        }
    }

    private boolean isOrbType(MonitoredObjectType t) {
        return t == MonitoredObjectType.ORB || t == MonitoredObjectType.CONNECTION_MANAGER;
    }

    private void handleChange(MonitoringLevel from, MonitoringLevel to) {
        if (this.off2Low(from, to) || this.off2High(from, to)) {
            this.notifyListeners(from, to);
            this.registerMBeans();
        }
        if (this.low2Off(from, to) || this.high2Off(from, to)) {
            this.unregisterMBeans();
            this.notifyListeners(from, to);
        }
        if (this.low2High(from, to) || this.high2Low(from, to)) {
            // empty if block
        }
    }

    private void notifyListeners(MonitoringLevel from, MonitoringLevel to) {
        logger.finer("DynamicReconfigurator: Now notifying the listeners for ORB stats --- from = " + from.toString() + " to = " + to.toString());
    }

    private void registerMBeans() {
        MonitoringRegistrationHelper registryImpl = MonitoringRegistrationHelper.getInstance();
        for (StatsHolder c : registryImpl.getOrbNodes()) {
            c.registerMBean();
            logger.finer("DynamicReconfigurator: Now Registering MBean for --- " + c.getName());
        }
    }

    private void unregisterMBeans() {
        MonitoringRegistrationHelper registryImpl = MonitoringRegistrationHelper.getInstance();
        for (StatsHolder c : registryImpl.getOrbNodes()) {
            c.unregisterMBean();
            logger.finer("DynamicReconfigurator: Now UnRegistering MBean for --- " + c.getName());
        }
    }

    private boolean off2Low(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.OFF && to == MonitoringLevel.LOW;
    }

    private boolean off2High(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.OFF && to == MonitoringLevel.HIGH;
    }

    private boolean low2Off(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.LOW && to == MonitoringLevel.OFF;
    }

    private boolean high2Off(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.HIGH && to == MonitoringLevel.OFF;
    }

    private boolean low2High(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.LOW && to == MonitoringLevel.HIGH;
    }

    private boolean high2Low(MonitoringLevel from, MonitoringLevel to) {
        return from == MonitoringLevel.HIGH && to == MonitoringLevel.LOW;
    }
}

