/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.appserv.management.event.StatisticMonitorNotification;
import com.sun.enterprise.admin.selfmanagement.event.StatisticMonitorMBean;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.logging.LogDomains;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatisticMonitor
extends NotificationBroadcasterSupport
implements StatisticMonitorMBean,
MBeanRegistration {
    private List<ObjectName> observedObjects = new ArrayList<ObjectName>();
    private String observedAttribute;
    private long granularityPeriod = 10000L;
    private boolean isActive = false;
    private long sequenceNumber = 0L;
    private boolean isComplexTypeAttribute = false;
    private String firstAttribute;
    private List<String> remainingAttributes = new ArrayList<String>();
    private AccessControlContext acc;
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory("Scheduler"));
    private static final int maximumPoolSize;
    private static final ExecutorService executor;
    protected static final Logger _logger;
    private MonitorTask monitorTask = new MonitorTask();
    private Runnable schedulerTask = new SchedulerTask(this.monitorTask);
    private ScheduledFuture<?> schedulerFuture;
    protected static final int capacityIncrement = 16;
    protected int elementCount = 0;
    @Deprecated
    protected int alreadyNotified = 0;
    protected int[] alreadyNotifieds = new int[16];
    protected MBeanServer server;
    protected static final int RESET_FLAGS_ALREADY_NOTIFIED = 0;
    protected static final int OBSERVED_OBJECT_ERROR_NOTIFIED = 1;
    protected static final int OBSERVED_ATTRIBUTE_ERROR_NOTIFIED = 2;
    protected static final int OBSERVED_ATTRIBUTE_TYPE_ERROR_NOTIFIED = 4;
    protected static final int RUNTIME_ERROR_NOTIFIED = 8;
    static final int THRESHOLD_ERROR_NOTIFIED = 16;
    Object[] derivedGauge = new Object[16];
    long[] derivedGaugeTimestamp = new long[16];
    static final Integer INTEGER_ZERO;

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "Initialize reference on the MBean Server");
        }
        this.server = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "Stop the statistic monitor");
        }
        this.stop();
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public abstract void start();

    @Override
    public abstract void stop();

    @Override
    @Deprecated
    public synchronized ObjectName getObservedObject() {
        if (this.observedObjects.isEmpty()) {
            return null;
        }
        return this.observedObjects.get(0);
    }

    @Override
    @Deprecated
    public synchronized void setObservedObject(ObjectName object) throws IllegalArgumentException {
        while (!this.observedObjects.isEmpty()) {
            this.removeObservedObject(this.observedObjects.get(0));
        }
        this.addObservedObject(object);
    }

    @Override
    public synchronized void addObservedObject(ObjectName object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("Null observed object");
        }
        if (this.observedObjects.contains(object)) {
            return;
        }
        this.observedObjects.add(object);
        if (this.elementCount >= this.alreadyNotifieds.length) {
            this.alreadyNotifieds = this.expandArray(this.alreadyNotifieds);
            this.derivedGauge = this.expandArray(this.derivedGauge);
            this.derivedGaugeTimestamp = this.expandArray(this.derivedGaugeTimestamp);
        }
        this.alreadyNotifieds[this.elementCount] = 0;
        this.updateDeprecatedAlreadyNotified();
        this.derivedGauge[this.elementCount] = null;
        this.derivedGaugeTimestamp[this.elementCount] = System.currentTimeMillis();
        this.insertSpecificElementAt(this.elementCount);
        ++this.elementCount;
    }

    @Override
    public synchronized void removeObservedObject(ObjectName object) {
        if (object == null) {
            return;
        }
        int index = this.observedObjects.indexOf(object);
        if (index >= 0) {
            this.observedObjects.remove(index);
            this.removeElementAt(this.alreadyNotifieds, index);
            this.updateDeprecatedAlreadyNotified();
            this.removeElementAt(this.derivedGauge, index);
            this.removeElementAt(this.derivedGaugeTimestamp, index);
            this.removeSpecificElementAt(index);
            --this.elementCount;
        }
    }

    @Override
    public synchronized boolean containsObservedObject(ObjectName object) {
        return this.observedObjects.contains(object);
    }

    @Override
    public synchronized ObjectName[] getObservedObjects() {
        return this.observedObjects.toArray(new ObjectName[0]);
    }

    @Override
    public String getObservedAttribute() {
        return this.observedAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObservedAttribute(String attribute) throws IllegalArgumentException {
        if (attribute == null) {
            throw new IllegalArgumentException("Null observed attribute");
        }
        StatisticMonitor statisticMonitor = this;
        synchronized (statisticMonitor) {
            this.observedAttribute = attribute;
            this.firstAttribute = null;
            this.remainingAttributes.clear();
            this.isComplexTypeAttribute = false;
            for (int i = 0; i < this.elementCount; ++i) {
                this.resetAlreadyNotified(i, 6);
            }
        }
    }

    @Override
    public synchronized long getGranularityPeriod() {
        return this.granularityPeriod;
    }

    @Override
    public synchronized void setGranularityPeriod(long period) throws IllegalArgumentException {
        if (period <= 0L) {
            throw new IllegalArgumentException("Nonpositive granularity period");
        }
        this.granularityPeriod = period;
        if (this.isActive()) {
            this.schedulerFuture.cancel(false);
            this.schedulerFuture = scheduler.schedule(this.schedulerTask, period, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized boolean isActive() {
        return this.isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStart() {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "Start the statistic monitor");
        }
        StatisticMonitor statisticMonitor = this;
        synchronized (statisticMonitor) {
            if (this.isActive()) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "The StatisticMonitor is already active");
                }
                return;
            }
            this.isActive = true;
            this.firstAttribute = null;
            this.remainingAttributes.clear();
            this.isComplexTypeAttribute = false;
            this.acc = AccessController.getContext();
            this.schedulerFuture = scheduler.schedule(this.schedulerTask, this.getGranularityPeriod(), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStop() {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "Stop the StatisticMonitor");
        }
        StatisticMonitor statisticMonitor = this;
        synchronized (statisticMonitor) {
            if (!this.isActive()) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "StatisticMonitor is not active");
                }
                return;
            }
            this.isActive = false;
            this.schedulerFuture.cancel(false);
            this.acc = null;
            this.firstAttribute = null;
            this.remainingAttributes.clear();
            this.isComplexTypeAttribute = false;
        }
    }

    synchronized Object getDerivedGauge(ObjectName object) {
        int index = this.indexOf(object);
        if (index != -1) {
            return this.derivedGauge[index];
        }
        return null;
    }

    synchronized long getDerivedGaugeTimeStamp(ObjectName object) {
        int index = this.indexOf(object);
        if (index != -1) {
            return this.derivedGaugeTimestamp[index];
        }
        return 0L;
    }

    Object getAttribute(MBeanServerConnection mbsc, ObjectName object, String attribute) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        if (this.firstAttribute == null) {
            if (attribute.indexOf(46) != -1) {
                MBeanAttributeInfo[] mbaiArray;
                MBeanInfo mbi;
                try {
                    mbi = mbsc.getMBeanInfo(object);
                }
                catch (IntrospectionException e) {
                    throw new IllegalArgumentException(e);
                }
                for (MBeanAttributeInfo mbai : mbaiArray = mbi.getAttributes()) {
                    if (!attribute.equals(mbai.getName())) continue;
                    this.firstAttribute = attribute;
                    break;
                }
                if (this.firstAttribute == null) {
                    String[] tokens = attribute.split("\\.", -1);
                    this.firstAttribute = tokens[0];
                    for (int i = 1; i < tokens.length; ++i) {
                        this.remainingAttributes.add(tokens[i]);
                    }
                    this.isComplexTypeAttribute = true;
                }
            } else {
                this.firstAttribute = attribute;
            }
        }
        return mbsc.getAttribute(object, this.firstAttribute);
    }

    Comparable<?> getComparableFromAttribute(ObjectName object, String attribute, Object value) throws AttributeNotFoundException {
        if (this.isComplexTypeAttribute) {
            Object v = value;
            for (String attr : this.remainingAttributes) {
                v = this.introspect(object, attr, v);
            }
            return (Comparable)v;
        }
        return (Comparable)value;
    }

    Object introspect(ObjectName object, String attribute, Object value) throws AttributeNotFoundException {
        try {
            PropertyDescriptor[] pds;
            if (value.getClass().isArray() && attribute.equals("length")) {
                return Array.getLength(value);
            }
            if (value instanceof CompositeData) {
                return ((CompositeData)value).get(attribute);
            }
            BeanInfo bi = Introspector.getBeanInfo(value.getClass());
            for (PropertyDescriptor pd : pds = bi.getPropertyDescriptors()) {
                if (!pd.getName().equals(attribute)) continue;
                return pd.getReadMethod().invoke(value, new Object[0]);
            }
            throw new AttributeNotFoundException("Could not find the getter method for the property " + attribute + " using the Java Beans introspector");
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw (AttributeNotFoundException)new AttributeNotFoundException(e.getMessage()).initCause(e);
        }
    }

    boolean isComparableTypeValid(ObjectName object, String attribute, Comparable<?> value) {
        return true;
    }

    String buildErrorNotification(ObjectName object, String attribute, Comparable<?> value) {
        return null;
    }

    void onErrorNotification(StatisticMonitorNotification notification) {
    }

    Comparable<?> getDerivedGaugeFromComparable(ObjectName object, String attribute, Comparable<?> value) {
        return value;
    }

    StatisticMonitorNotification buildAlarmNotification(ObjectName object, String attribute, Comparable<?> value) {
        return null;
    }

    boolean isThresholdTypeValid(ObjectName object, String attribute, Comparable<?> value) {
        return true;
    }

    static Class<? extends Number> classForType(NumericalType type) {
        switch (type) {
            case BYTE: {
                return Byte.class;
            }
            case SHORT: {
                return Short.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
        }
        throw new IllegalArgumentException("Unsupported numerical type");
    }

    static boolean isValidForType(Object value, Class<? extends Number> c) {
        return value == INTEGER_ZERO || c.isInstance(value);
    }

    synchronized ObjectName getObservedObject(int index) throws ArrayIndexOutOfBoundsException {
        return this.observedObjects.get(index);
    }

    synchronized void updateDeprecatedAlreadyNotified() {
        this.alreadyNotified = this.elementCount > 0 ? this.alreadyNotifieds[0] : 0;
    }

    synchronized void setAlreadyNotified(int index, int mask) {
        int n = index;
        this.alreadyNotifieds[n] = this.alreadyNotifieds[n] | mask;
        if (index == 0) {
            this.updateDeprecatedAlreadyNotified();
        }
    }

    synchronized void resetAlreadyNotified(int index, int mask) {
        int n = index;
        this.alreadyNotifieds[n] = this.alreadyNotifieds[n] & ~mask;
        if (index == 0) {
            this.updateDeprecatedAlreadyNotified();
        }
    }

    synchronized boolean alreadyNotified(int index, int mask) {
        return (this.alreadyNotifieds[index] & mask) != 0;
    }

    synchronized void resetAllAlreadyNotified(int index) {
        this.alreadyNotifieds[index] = 0;
        if (index == 0) {
            this.updateDeprecatedAlreadyNotified();
        }
    }

    int[] expandArray(int[] array) {
        int[] newArray = new int[array.length + 16];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    long[] expandArray(long[] array) {
        long[] newArray = new long[array.length + 16];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    boolean[] expandArray(boolean[] array) {
        boolean[] newArray = new boolean[array.length + 16];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    Number[] expandArray(Number[] array) {
        Number[] newArray = new Number[array.length + 16];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    String[] expandArray(String[] array) {
        String[] newArray = new String[array.length + 16];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    NumericalType[] expandArray(NumericalType[] array) {
        NumericalType[] newArray = new NumericalType[array.length + 16];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    Object[] expandArray(Object[] array) {
        Object[] newArray = new Object[array.length + 16];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    synchronized void removeElementAt(int[] array, int index) {
        if (index < 0 || index >= this.elementCount) {
            return;
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(array, index + 1, array, index, j);
        }
    }

    synchronized void removeElementAt(long[] array, int index) {
        if (index < 0 || index >= this.elementCount) {
            return;
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(array, index + 1, array, index, j);
        }
    }

    synchronized void removeElementAt(boolean[] array, int index) {
        if (index < 0 || index >= this.elementCount) {
            return;
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(array, index + 1, array, index, j);
        }
    }

    synchronized void removeElementAt(Object[] array, int index) {
        if (index < 0 || index >= this.elementCount) {
            return;
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(array, index + 1, array, index, j);
        }
        array[this.elementCount - 1] = null;
    }

    synchronized int indexOf(ObjectName object) {
        return this.observedObjects.indexOf(object);
    }

    void insertSpecificElementAt(int index) {
    }

    void removeSpecificElementAt(int index) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotification(String type, long timeStamp, String msg, Object derGauge, Object trigger, ObjectName object, boolean onError) {
        long seqno;
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "send notification: \n\tNotification observed object = " + object + "\n\tNotification observed attribute = " + this.observedAttribute + "\n\tNotification derived gauge = " + derGauge);
        }
        StatisticMonitor statisticMonitor = this;
        synchronized (statisticMonitor) {
            seqno = this.sequenceNumber++;
        }
        StatisticMonitorNotification mn = new StatisticMonitorNotification(type, this, seqno, timeStamp, msg, object, this.observedAttribute, derGauge, trigger);
        if (onError) {
            this.onErrorNotification(mn);
        }
        this.sendNotification(mn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitor(int index) {
        String notifType = null;
        String msg = null;
        Comparable<?> derGauge = null;
        Object trigger = null;
        ObjectName object = null;
        Comparable<?> value = null;
        Notification alarm = null;
        StatisticMonitor statisticMonitor = this;
        synchronized (statisticMonitor) {
            String attribute;
            block49: {
                Object attributeValue;
                block48: {
                    if (!this.isActive()) {
                        return;
                    }
                    object = this.getObservedObject(index);
                    attribute = this.getObservedAttribute();
                    if (object == null || attribute == null) {
                        return;
                    }
                    attributeValue = null;
                    try {
                        attributeValue = this.getAttribute(this.server, object, attribute);
                        if (attributeValue == null) {
                            if (this.alreadyNotified(index, 4)) {
                                return;
                            }
                            notifType = "jmx.monitor.error.type";
                            this.setAlreadyNotified(index, 4);
                            msg = "The observed attribute value is null.";
                            if (_logger.isLoggable(Level.WARNING)) {
                                _logger.log(Level.WARNING, msg);
                            }
                        }
                    }
                    catch (NullPointerException np_ex) {
                        if (this.alreadyNotified(index, 8)) {
                            return;
                        }
                        notifType = "jmx.monitor.error.runtime";
                        this.setAlreadyNotified(index, 8);
                        msg = "The monitor must be registered in the MBean server or an MBeanServerConnection must be explicitly supplied.";
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.WARNING, msg);
                            _logger.log(Level.WARNING, np_ex.toString());
                        }
                    }
                    catch (InstanceNotFoundException inf_ex) {
                        if (this.alreadyNotified(index, 1)) {
                            return;
                        }
                        notifType = "jmx.monitor.error.mbean";
                        this.setAlreadyNotified(index, 1);
                        msg = "The observed object must be accessible in the MBeanServerConnection.";
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.WARNING, msg);
                            _logger.log(Level.WARNING, inf_ex.toString());
                        }
                    }
                    catch (AttributeNotFoundException anf_ex) {
                        if (this.alreadyNotified(index, 2)) {
                            return;
                        }
                        notifType = "jmx.monitor.error.attribute";
                        this.setAlreadyNotified(index, 2);
                        msg = "The observed attribute must be accessible in the observed object.";
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.WARNING, msg);
                            _logger.log(Level.WARNING, anf_ex.toString());
                        }
                    }
                    catch (MBeanException mb_ex) {
                        if (this.alreadyNotified(index, 8)) {
                            return;
                        }
                        notifType = "jmx.monitor.error.runtime";
                        this.setAlreadyNotified(index, 8);
                        msg = mb_ex.getMessage();
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.WARNING, msg);
                            _logger.log(Level.WARNING, mb_ex.toString());
                        }
                    }
                    catch (ReflectionException ref_ex) {
                        if (this.alreadyNotified(index, 8)) {
                            return;
                        }
                        notifType = "jmx.monitor.error.runtime";
                        this.setAlreadyNotified(index, 8);
                        msg = ref_ex.getMessage();
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.WARNING, msg);
                            _logger.log(Level.WARNING, ref_ex.toString());
                        }
                    }
                    catch (IOException io_ex) {
                        if (this.alreadyNotified(index, 8)) {
                            return;
                        }
                        notifType = "jmx.monitor.error.runtime";
                        this.setAlreadyNotified(index, 8);
                        msg = io_ex.getMessage();
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.WARNING, msg);
                            _logger.log(Level.WARNING, io_ex.toString());
                        }
                    }
                    catch (RuntimeException rt_ex) {
                        if (this.alreadyNotified(index, 8)) {
                            return;
                        }
                        notifType = "jmx.monitor.error.runtime";
                        this.setAlreadyNotified(index, 8);
                        msg = rt_ex.getMessage();
                        if (!_logger.isLoggable(Level.WARNING)) break block48;
                        _logger.log(Level.WARNING, msg);
                        _logger.log(Level.WARNING, rt_ex.toString());
                    }
                }
                if (msg == null) {
                    try {
                        value = this.getComparableFromAttribute(object, attribute, attributeValue);
                    }
                    catch (AttributeNotFoundException e) {
                        if (this.alreadyNotified(index, 2)) {
                            return;
                        }
                        notifType = "jmx.monitor.error.attribute";
                        this.setAlreadyNotified(index, 2);
                        msg = "The observed attribute must be accessible in the observed object.";
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.WARNING, msg);
                            _logger.log(Level.WARNING, e.toString());
                        }
                    }
                    catch (RuntimeException e) {
                        if (this.alreadyNotified(index, 8)) {
                            return;
                        }
                        notifType = "jmx.monitor.error.runtime";
                        this.setAlreadyNotified(index, 8);
                        msg = e.getMessage();
                        if (!_logger.isLoggable(Level.WARNING)) break block49;
                        _logger.log(Level.WARNING, msg);
                        _logger.log(Level.WARNING, e.toString());
                    }
                }
            }
            if (msg == null && !this.isComparableTypeValid(object, attribute, value)) {
                if (this.alreadyNotified(index, 4)) {
                    return;
                }
                notifType = "jmx.monitor.error.type";
                this.setAlreadyNotified(index, 4);
                msg = "The observed attribute type is not valid.";
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, msg);
                }
            }
            if (msg == null && !this.isThresholdTypeValid(object, attribute, value)) {
                if (this.alreadyNotified(index, 16)) {
                    return;
                }
                notifType = "jmx.monitor.error.threshold";
                this.setAlreadyNotified(index, 16);
                msg = "The threshold type is not valid.";
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, msg);
                }
            }
            if (msg == null && (msg = this.buildErrorNotification(object, attribute, value)) != null) {
                if (this.alreadyNotified(index, 8)) {
                    return;
                }
                notifType = "jmx.monitor.error.runtime";
                this.setAlreadyNotified(index, 8);
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, msg);
                }
            }
            if (msg == null) {
                this.resetAllAlreadyNotified(index);
                this.derivedGauge[index] = derGauge = this.getDerivedGaugeFromComparable(object, attribute, value);
                this.derivedGaugeTimestamp[index] = System.currentTimeMillis();
                alarm = this.buildAlarmNotification(object, attribute, derGauge);
            }
        }
        if (msg != null) {
            this.sendNotification(notifType, System.currentTimeMillis(), msg, derGauge, trigger, object, true);
        }
        if (alarm != null && alarm.getType() != null) {
            this.sendNotification(alarm.getType(), System.currentTimeMillis(), alarm.getMessage(), derGauge, ((StatisticMonitorNotification)alarm).getTrigger(), object, false);
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.selfmanagement");
        String maximumPoolSizeSysProp = "jmx.x.monitor.maximum.pool.size";
        String maximumPoolSizeStr = AccessController.doPrivileged(new GetPropertyAction("jmx.x.monitor.maximum.pool.size"));
        if (maximumPoolSizeStr == null || maximumPoolSizeStr.trim().length() == 0) {
            maximumPoolSize = 10;
        } else {
            int maximumPoolSizeTmp = 10;
            try {
                maximumPoolSizeTmp = Integer.parseInt(maximumPoolSizeStr);
            }
            catch (NumberFormatException e) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "Wrong value for jmx.x.monitor.maximum.pool.size system property: " + e);
                    _logger.log(Level.WARNING, "jmx.x.monitor.maximum.pool.size defaults to 10.");
                }
                maximumPoolSizeTmp = 10;
            }
            maximumPoolSize = maximumPoolSizeTmp < 1 ? 1 : maximumPoolSizeTmp;
        }
        executor = new ThreadPoolExecutor(maximumPoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("Executor"));
        INTEGER_ZERO = new Integer(0);
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        final String nameSuffix = "]";

        public DaemonThreadFactory(String poolName) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "JMX Monitor " + poolName + " Pool [Thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement() + "]", 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private class MonitorTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            StatisticMonitor statisticMonitor = StatisticMonitor.this;
            synchronized (statisticMonitor) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        if (StatisticMonitor.this.isActive()) {
                            for (int i = 0; i < StatisticMonitor.this.elementCount; ++i) {
                                StatisticMonitor.this.monitor(i);
                            }
                        }
                        return null;
                    }
                }, StatisticMonitor.this.acc);
                StatisticMonitor.this.schedulerFuture = scheduler.schedule(StatisticMonitor.this.schedulerTask, StatisticMonitor.this.getGranularityPeriod(), TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NumericalType {
        BYTE,
        SHORT,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE;

    }

    private static class SchedulerTask
    implements Runnable {
        private Runnable task = null;

        public SchedulerTask(Runnable task) {
            this.task = task;
        }

        public void run() {
            executor.submit(this.task);
        }
    }
}

