/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core;

import com.sun.appserv.management.client.AdminRMISSLClientSocketFactory;
import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.jmx.remote.server.rmi.JmxConnectorServerDriver;
import com.sun.enterprise.admin.jmx.remote.server.rmi.RemoteJmxProtocol;
import com.sun.enterprise.admin.server.core.jmx.auth.ASJMXAuthenticator;
import com.sun.enterprise.admin.server.core.jmx.auth.ASLoginDriverImpl;
import com.sun.enterprise.admin.server.core.jmx.nonssl.RMIMultiHomedServerSocketFactory;
import com.sun.enterprise.admin.server.core.jmx.ssl.AdminSslServerSocketFactory;
import com.sun.enterprise.admin.server.core.jmx.ssl.ServerClientEnvSetter;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.rmi.server.RMIServerSocketFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;

public class JmxConnectorLifecycle
implements ServerLifecycle {
    public static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager sm = StringManager.getManager(JmxConnectorLifecycle.class);
    private ServerContext initContext = null;
    private JmxConnector connectorConfig = null;
    private JMXConnectorServer cs = null;
    private JMXConnectorServer jconsolecs = null;
    private JmxConnectorServerDriver driver;
    private boolean isEnabled = false;

    public JmxConnectorLifecycle() {
        sLogger.log(Level.FINE, "rjmx.lc.init");
    }

    public void onInitialization(ServerContext sc) throws ServerLifecycleException {
        try {
            this.initContext = sc;
            this.initConnectorConfig();
            this.handleIsEnabled(this.connectorConfig.getPort());
            this.handleSupportedProtocol();
            if (this.isEnabled) {
                this.driver = new JmxConnectorServerDriver();
                this.configureJmxConnectorServerDriver();
            }
        }
        catch (Exception e) {
            throw new ServerLifecycleException(e.getMessage(), e);
        }
    }

    public void onStartup(ServerContext sc) throws ServerLifecycleException {
        try {
            this.setupClientSide();
            if (this.isEnabled) {
                this.cs = this.driver.startConnectorServer();
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            JmxConnectorLifecycle.this.jconsolecs = JmxConnectorLifecycle.this.driver.startJconsoleConnectorServer();
                        }
                        catch (IOException ex) {
                            sLogger.info("rjmx.connector_server.failed_startup");
                        }
                    }
                }).start();
            } else {
                String msg = "JmxConnectorLifeCycle.onStartup: Connector Server not enabled at port: " + this.connectorConfig.getPort();
                sLogger.fine(msg);
            }
        }
        catch (Exception e) {
            throw new ServerLifecycleException(e.getMessage(), e);
        }
    }

    public void onReady(ServerContext sc) throws ServerLifecycleException {
    }

    public void onShutdown() throws ServerLifecycleException {
        try {
            if (this.isEnabled) {
                this.driver.stopConnectorServer(this.cs);
                this.driver.stopConnectorServer(this.jconsolecs);
            } else {
                String msg = "JmxConnectorLifeCycle.onShutdown: Connector Server not enabled at port: " + this.connectorConfig.getPort() + ", its shutdown is not required";
                sLogger.fine(msg);
            }
        }
        catch (Exception e) {
            throw new ServerLifecycleException(e.getMessage());
        }
    }

    private MBeanServer getAssociatedMBS() {
        return MBeanServerFactory.getMBeanServer();
    }

    private Map getEnvironment() {
        HashMap env = new HashMap();
        return env;
    }

    public void onTermination() throws ServerLifecycleException {
    }

    private void initConnectorConfig() throws ConfigException {
        AdminService as = ServerBeansFactory.getConfigBean(this.initContext.getConfigContext()).getAdminService();
        this.connectorConfig = as.getJmxConnectorByName(as.getSystemJmxConnectorName());
        if (this.connectorConfig.isEnabled()) {
            this.isEnabled = true;
        }
    }

    private JMXAuthenticator createJMXAuthenticator() {
        ASJMXAuthenticator authenticator = new ASJMXAuthenticator();
        authenticator.setRealmName(this.connectorConfig.getAuthRealmName());
        authenticator.setLoginDriver(new ASLoginDriverImpl());
        return authenticator;
    }

    private void configureJmxConnectorServerDriver() throws ServerLifecycleException {
        this.driver.setAuthentication(true);
        this.driver.setAuthenticator(this.createJMXAuthenticator());
        this.driver.setLogger(sLogger);
        this.driver.setMBeanServer(this.getAssociatedMBS());
        this.driver.setRmiRegistrySecureFlag(new Boolean(System.getProperty("com.sun.aas.jsr160.SecureRmiRegistry")));
        try {
            this.driver.setProtocol(RemoteJmxProtocol.instance(this.connectorConfig.getProtocol()));
            this.driver.setPort(Integer.parseInt(this.connectorConfig.getPort()));
            this.driver.setBindAddress(this.connectorConfig.getAddress());
            this.handleSsl();
        }
        catch (Exception e) {
            throw new ServerLifecycleException(e.getMessage());
        }
    }

    private void handleIsEnabled(String port) throws ServerLifecycleException {
        if (this.isEE() && !this.isEnabled) {
            String msg = sm.getString("rjmx.lc.disabled_ee_na", port);
            throw new ServerLifecycleException(msg);
        }
        if (!this.isEE() && !this.isEnabled) {
            sLogger.log(Level.INFO, "rjmx.lc.not_enabled", port);
        }
    }

    private boolean isEE() {
        boolean isEE = false;
        String eepffc = "com.sun.enterprise.ee.server.pluggable.EEPluggableFeatureImpl";
        String pn = "com.sun.appserv.pluggable.features";
        String pv = System.getProperty("com.sun.appserv.pluggable.features");
        if ("com.sun.enterprise.ee.server.pluggable.EEPluggableFeatureImpl".equals(pv)) {
            isEE = true;
        }
        return isEE;
    }

    private void handleSupportedProtocol() throws ServerLifecycleException {
        String pfc = this.connectorConfig.getProtocol();
        if (RemoteJmxProtocol.RMIJRMP != RemoteJmxProtocol.instance(pfc)) {
            String port = this.connectorConfig.getPort();
            String setP = this.connectorConfig.getProtocol();
            String supportedP = RemoteJmxProtocol.RMIJRMP.getName();
            String msg = sm.getString("rjmx.lc.unsupported_protocol", port, setP, supportedP);
            throw new ServerLifecycleException(msg);
        }
    }

    private void handleSsl() {
        boolean ssl = this.connectorConfig.isSecurityEnabled();
        RMIServerSocketFactory sf = null;
        if (ssl) {
            this.driver.setSsl(ssl);
            Ssl sslc = this.connectorConfig.getSsl();
            if (sslc == null) {
                sslc = this.initDefaultSslConfiguration();
            }
            sf = new AdminSslServerSocketFactory(sslc, this.connectorConfig.getAddress());
            AdminRMISSLClientSocketFactory cf = new AdminRMISSLClientSocketFactory();
            this.driver.setRmiClientSocketFactory(cf);
        } else {
            sf = new RMIMultiHomedServerSocketFactory(this.connectorConfig.getAddress());
        }
        this.driver.setRmiServerSocketFactory(sf);
    }

    private void setupClientSide() throws ConfigException {
        String serverName = System.getProperty("com.sun.aas.instanceName");
        String certNickName = ServerHelper.getCertNickname(this.initContext.getConfigContext(), serverName);
        new ServerClientEnvSetter(certNickName).setup();
    }

    private Ssl initDefaultSslConfiguration() {
        Ssl ssl = new Ssl();
        ssl.setCertNickname("s1as");
        ssl.setClientAuthEnabled(false);
        ssl.setSsl2Enabled(false);
        ssl.setSsl3Enabled(true);
        ssl.setTlsEnabled(true);
        ssl.setTlsRollbackEnabled(true);
        return ssl;
    }

    private static class RmiTweaks {
        static final String SECURE_RMI_REGISTRY = "com.sun.aas.jsr160.SecureRmiRegistry";

        private RmiTweaks() {
        }
    }
}

