/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.jmx.nonssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.server.RMIServerSocketFactory;

public class RMIMultiHomedServerSocketFactory
implements RMIServerSocketFactory {
    private static final String DEFAULT_ADDRESS = "0.0.0.0";
    private final String address;

    public RMIMultiHomedServerSocketFactory(String host) {
        this.address = host;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        try {
            InetAddress bindAddress = null;
            ServerSocket ss = null;
            if (this.address.equals(DEFAULT_ADDRESS)) {
                ss = new ServerSocket(port);
            } else {
                bindAddress = InetAddress.getByName(this.address);
                ss = new ServerSocket(port, 0, bindAddress);
            }
            this.debug(ss);
            return ss;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public int hashCode() {
        return super.hashCode() ^ this.address.hashCode();
    }

    public boolean equals(Object anotherFactory) {
        if (anotherFactory != null && anotherFactory.getClass().equals(this.getClass())) {
            RMIMultiHomedServerSocketFactory rmhssf = (RMIMultiHomedServerSocketFactory)anotherFactory;
            if (this.address == null && rmhssf.address == null) {
                return true;
            }
            if (this.address == null ^ rmhssf.address == null) {
                return false;
            }
            return this.address.equals(rmhssf.address);
        }
        return false;
    }

    private void debug(ServerSocket sss) {
        String prefix = "RMI/TLS Server Debug Message: ";
        boolean DEBUG = Boolean.getBoolean("Debug");
        if (sss != null) {
            if (DEBUG) {
                System.out.println(prefix + "ServerSocket local port = " + sss.getLocalPort());
                System.out.println(prefix + "ServerSocket host address = " + sss.getInetAddress().getHostAddress());
                System.out.println(prefix + "ServerSocket bound status = " + sss.isBound());
            }
        } else {
            System.out.println(prefix + " Catastrophe: no server socket");
        }
    }
}

