/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.jmx.ssl;

import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.ssl.J2EEKeyManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.server.RMIServerSocketFactory;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;

public class AdminSslServerSocketFactory
implements RMIServerSocketFactory {
    private final Ssl sslc;
    private static final String DEFAULT_ADDRESS = "0.0.0.0";
    private String address = "0.0.0.0";

    public AdminSslServerSocketFactory(Ssl sslc, String address) {
        if (sslc == null) {
            throw new IllegalArgumentException("Internal: null ssl configuration");
        }
        this.sslc = sslc;
        this.address = address;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        try {
            SSLContext ctx = SSLContext.getInstance("TLSv1");
            KeyManager[] kms = SSLUtils.getKeyManagers();
            KeyManager[] jkms = new J2EEKeyManager[kms.length];
            for (int i = 0; i < kms.length; ++i) {
                jkms[i] = new J2EEKeyManager((X509KeyManager)kms[i], this.sslc.getCertNickname());
            }
            TrustManager[] tms = null;
            SecureRandom sr = null;
            ctx.init(jkms, tms, sr);
            SSLServerSocketFactory sf = ctx.getServerSocketFactory();
            InetAddress bindAddress = null;
            ServerSocket sss = null;
            if (this.address.equals(DEFAULT_ADDRESS)) {
                sss = sf.createServerSocket(port);
            } else {
                bindAddress = InetAddress.getByName(this.address);
                sss = sf.createServerSocket(port, 0, bindAddress);
            }
            this.debug(sss);
            return sss;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private void debug(ServerSocket sss) {
        String prefix = "RMI/TLS Server Debug Message: ";
        boolean DEBUG = Boolean.getBoolean("Debug");
        if (sss != null) {
            if (DEBUG) {
                System.out.println("RMI/TLS Server Debug Message: ServerSocket local port = " + sss.getLocalPort());
                System.out.println("RMI/TLS Server Debug Message: ServerSocket host address = " + sss.getInetAddress().getHostAddress());
                System.out.println("RMI/TLS Server Debug Message: ServerSocket bound status = " + sss.isBound());
            }
        } else {
            System.out.println("RMI/TLS Server Debug Message:  Catastrophe: no server socket");
        }
    }
}

