/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.enterprise.admin.util.LineTokenReplacer;
import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class Domain2ServerTransformer {
    private static final String ORIG_EXT = ".orig";
    private static final String XSL_NAME = "domain2server.xsl";
    private static final String DOCTYPE_TOKEN = "DTDREF";
    private static final String SERVER_DTD_NAME = "sun-server_1_0.dtd";
    private static final String SERVER_DTD_PATH = System.getProperty("com.sun.aas.installRoot") + "/lib/dtds/" + "sun-server_1_0.dtd";
    private static String XSL_PATH = System.getProperty("com.sun.aas.installRoot") + "/lib/install/templates/" + "domain2server.xsl";
    private TransformerFactory tFactory;
    private final String domainXmlPath;
    private final String serverXmlPath;
    private final String origServerXmlPath;

    public Domain2ServerTransformer(String domainXmlPath, String serverXmlPath) {
        this.domainXmlPath = domainXmlPath;
        this.serverXmlPath = serverXmlPath;
        this.origServerXmlPath = serverXmlPath + ORIG_EXT;
        this.createFactory();
    }

    private void createFactory() {
        try {
            this.tFactory = TransformerFactory.newInstance();
            System.out.println("Created xform factory = " + this.tFactory);
        }
        catch (Exception e) {
            System.out.println("Exception while creating transformer factory");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public final void transform() {
        this.transform(true);
    }

    public final void transform(boolean backup) {
        if (backup) {
            try {
                if (new File(this.serverXmlPath).exists()) {
                    FileUtils.copy(this.serverXmlPath, this.origServerXmlPath);
                }
                System.out.println("ServerXmlPath = " + this.serverXmlPath);
                System.out.println("DomainXmlPath = " + this.domainXmlPath);
                System.out.println("ServerDtdPath = " + SERVER_DTD_PATH);
                System.out.println("XslPath = " + XSL_PATH);
            }
            catch (Exception e) {
                System.out.println("Could not backup server.xml before xform");
                throw new RuntimeException(e);
            }
        }
        String dtdPath = this.getDtdPathForServerXml();
        this.convert();
        this.replaceDocTypePath(dtdPath);
    }

    private void convert() {
        try {
            InputStream xslStream = this.getXslStream();
            StreamSource xsl = new StreamSource(xslStream);
            File domainXmlFile = new File(this.domainXmlPath);
            System.out.println("The source xml = " + domainXmlFile.getAbsolutePath());
            StreamSource xml = new StreamSource(domainXmlFile);
            File serverXmlFile = new File(this.serverXmlPath);
            StreamResult out = new StreamResult(serverXmlFile);
            Transformer transformer = this.tFactory.newTransformer(xsl);
            transformer.transform(xml, out);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private InputStream getXslStream() throws FileNotFoundException {
        return new FileInputStream(XSL_PATH);
    }

    private void replaceDocTypePath(String dtdPath) {
        try {
            File tmpFile = File.createTempFile("temp", ".xml");
            String tmpFilePath = tmpFile.getAbsolutePath();
            FileUtils.copy(this.serverXmlPath, tmpFilePath);
            TokenValue tv = new TokenValue(DOCTYPE_TOKEN, dtdPath);
            System.out.println("TV = " + tv);
            TokenValueSet ts = new TokenValueSet();
            ts.add(tv);
            LineTokenReplacer replacer = new LineTokenReplacer(ts);
            replacer.replace(tmpFilePath, this.serverXmlPath);
            tmpFile.delete();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getDtdPathForServerXml() {
        String PREFIX = "file://";
        if (OS.isWindows()) {
            PREFIX = PREFIX + "/";
        }
        return PREFIX + SERVER_DTD_PATH;
    }
}

