/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.InitConfFileBean;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.common.ObjectNameHelper;
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.common.RequestID;
import com.sun.enterprise.admin.common.ServerInstanceStatus;
import com.sun.enterprise.admin.common.constant.ConfigAttributeName;
import com.sun.enterprise.admin.common.exception.AFException;
import com.sun.enterprise.admin.common.exception.AFResourceException;
import com.sun.enterprise.admin.common.exception.AFRuntimeStoreException;
import com.sun.enterprise.admin.common.exception.ControlException;
import com.sun.enterprise.admin.common.exception.DeploymentException;
import com.sun.enterprise.admin.common.exception.IllegalStateException;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.common.exception.PortInUseException;
import com.sun.enterprise.admin.common.exception.ServerInstanceException;
import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventCache;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.ApplicationDeployEvent;
import com.sun.enterprise.admin.event.EventBuilder;
import com.sun.enterprise.admin.event.EventContext;
import com.sun.enterprise.admin.event.EventStack;
import com.sun.enterprise.admin.event.ModuleDeployEvent;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.server.core.ManualChangeManager;
import com.sun.enterprise.admin.server.core.channel.AdminChannel;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.admin.server.core.mbean.config.ConfigMBeanBase;
import com.sun.enterprise.admin.server.core.mbean.config.ManagedJ2EEApplication;
import com.sun.enterprise.admin.server.core.mbean.config.ManagedStandaloneJ2EEEjbJarModule;
import com.sun.enterprise.admin.server.core.mbean.config.Resource;
import com.sun.enterprise.admin.server.core.mbean.config.ResourcesXMLParser;
import com.sun.enterprise.admin.server.core.mbean.config.ShutdownThread;
import com.sun.enterprise.admin.util.ArgChecker;
import com.sun.enterprise.admin.util.ExceptionUtil;
import com.sun.enterprise.admin.util.HostAndPort;
import com.sun.enterprise.admin.util.StringValidator;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.CustomResource;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.LifecycleModule;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.PersistenceManagerFactoryResource;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.JmsRaMapping;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.EjbModulesManager;
import com.sun.enterprise.instance.InstanceDefinition;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ServerManager;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ManagedServerInstance
extends ConfigMBeanBase
implements ConfigAttributeName.Server {
    private HostAndPort mHostAndPort = null;
    private int mStartMode = 1;
    private String mInstanceName = null;
    private boolean mAutoStart = false;
    public static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final int CONFIG_CHANGED = 7;
    static final boolean PORT_DOMAIN_TO_SERVER = false;
    private static final String[][] MAPLIST = new String[0][];
    private static final String[] ATTRIBUTES = new String[0];
    private static final String[] OPERATIONS = new String[]{"start(),  ACTION, ManagedServerInstance.start1.operation", "start(String[] passwords),  ACTION, ManagedServerInstance.start1.operation", "start(boolean debug, String[] passwords), ACTION, ManagedServerInstance.start2.operation", "startInDebugMode(), ACTION", "startInDebugMode(String[] passwords), ACTION", "restart(),  ACTION", "stop(int timeoutSeconds), ACTION", "getDeployedJ2EEApplications(), INFO ", "getDeployedJ2EEModules(),      INFO ", "getEnabledJ2EEApplications(),  INFO ", "getDisabledJ2EEApplications(), INFO ", "getEnabledJ2EEModules(),       INFO ", "getDisabledJ2EEModules(),      INFO ", "setHttpPort(int port ),    ACTION ", "getHostAndPort(),  INFO ", "getHttpPort(),            INFO ", "getStatus(),              INFO ", "reconfigure(),            ACTION ", "startMonitor(),           ACTION ", "getMonitorableComponentNames(), INFO ", "stopMonitor(),            ACTION ", "postRegister(Boolean registrationDone), ACTION ", "preRegister(javax.management.MBeanServer server, javax.management.ObjectName name), ACTION ", "postDeregister(),         ACTION ", "preDeregister(),          ACTION ", "getInstanceRoot(),        INFO ", "getSecurityPasswordTokens(),       INFO ", "isRestartNeeded(),        INFO", "getUserNames(),        INFO", "getGroupNames(),        INFO", "getUserGroupNames(String userName),        INFO", "addUser(String userName, String password, String[] groupList),       INFO ", "removeUser(String userName),       INFO ", "updateUser(String userName, String password, String[] groupList),       INFO "};
    private static final int TIME_OUT_SECONDS = 120;
    private static StringManager localStrings = StringManager.getManager(ManagedServerInstance.class);

    public ManagedServerInstance() throws MBeanConfigException {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    public ManagedServerInstance(String instanceName, HostAndPort hostPort, boolean autoStart) throws PortInUseException, MBeanConfigException {
        this(instanceName, hostPort, autoStart, null);
    }

    public ManagedServerInstance(String instanceName, HostAndPort hostPort, boolean autoStart, AdminContext adminContext) throws PortInUseException, MBeanConfigException {
        this();
        this.setAdminContext(adminContext);
        this.initialize("server-instance", new String[]{instanceName});
        if (instanceName == null || hostPort == null) {
            throw new IllegalArgumentException();
        }
        this.mInstanceName = instanceName;
        this.mHostAndPort = hostPort;
        this.mAutoStart = autoStart;
    }

    public RequestID start() throws ControlException {
        return this.start(false, null);
    }

    public RequestID start(String[] passwords) throws ControlException {
        return this.start(false, passwords);
    }

    public RequestID start(boolean debug, String[] passwords) throws ControlException {
        try {
            if (this.getInstanceStatusCode() == 0) {
                String msg = localStrings.getString("admin.server.core.mbean.config.cannot_start_already_running");
                throw new IllegalStateException(msg);
            }
            if (debug) {
                this.mStartMode = 0;
            } else if (this.isDebug()) {
                this.setDebug(false);
                this.setDebugOptions(null);
                super.getConfigContext().flush();
                this.applyConfigChanges();
            }
            if (debug) {
                String strPort = "?";
                try {
                    strPort = String.valueOf(this.getDebugPort());
                }
                catch (Exception e) {
                    // empty catch block
                }
                sLogger.log(Level.INFO, "mbean.start_instance_debug", new Object[]{this.mInstanceName, strPort});
            } else {
                sLogger.log(Level.INFO, "mbean.start_instance", this.mInstanceName);
            }
            InstanceDefinition instance = new InstanceDefinition(this.mInstanceName, this.mHostAndPort.getPort());
            ServerManager.instance().startServerInstance(instance, passwords);
            sLogger.log(Level.INFO, "mbean.check_start_instance", this.mInstanceName);
            long timeoutMillis = 240000L;
            long sleepTime = 2000L;
            long timeBefore = System.currentTimeMillis();
            long timeAfter = System.currentTimeMillis();
            boolean timeoutReached = false;
            while (!timeoutReached && this.getInstanceStatusCode() != 0) {
                Thread.sleep(sleepTime);
                timeAfter = System.currentTimeMillis();
                timeoutReached = timeAfter - timeBefore >= timeoutMillis;
            }
            if (timeoutReached) {
                sLogger.log(Level.INFO, "mbean.start_instance_timeout", this.mInstanceName);
                try {
                    Long tLong = new Long(timeoutMillis / 1000L);
                    this.stop(tLong.intValue());
                }
                catch (ControlException cex) {
                    String msg = localStrings.getString("admin.server.core.mbean.config.timeout_reached_server_stopping_exception", this.mInstanceName);
                }
                String msg = localStrings.getString("admin.server.core.mbean.config.timeout_reached_server_starting_exception", this.mInstanceName);
                throw new ControlException(msg);
            }
            sLogger.log(Level.INFO, "mbean.start_instance_success", this.mInstanceName);
        }
        catch (Exception e) {
            sLogger.log(Level.SEVERE, "mbean.start_instance_failed", this.mInstanceName);
            sLogger.log(Level.SEVERE, "mbean.start_instance_failed_details", e);
            throw new ControlException(e.getMessage());
        }
        return null;
    }

    public int startInDebugMode(String[] passwords) throws ControlException {
        int port = -1;
        try {
            boolean isChanged = false;
            if (!this.isDebug()) {
                this.setDebug(true);
                isChanged = true;
            }
            if ((port = this.getDebugPort()) == -1) {
                port = NetUtils.getFreePort();
                if (port == 0) {
                    sLogger.log(Level.SEVERE, "general.free_port_failed");
                    String msg = localStrings.getString("admin.server.core.mbean.config.no_free_port");
                    throw new Exception(msg);
                }
                this.setDebugPort(port);
                isChanged = true;
            }
            if (isChanged) {
                super.getConfigContext().flush();
                this.applyConfigChanges();
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.set_debug_failed", e);
            throw new ControlException(e.getLocalizedMessage());
        }
        this.start(true, passwords);
        return port;
    }

    public int startInDebugMode() throws ControlException {
        return this.startInDebugMode(null);
    }

    public String[] getSecurityPasswordTokens() throws ControlException {
        try {
            InstanceEnvironment env = new InstanceEnvironment(this.mInstanceName);
            String pwdFileName = env.getSecurityPasswordsFilePath();
            File pwdFile = new File(pwdFileName);
            if (pwdFile.exists()) {
                return null;
            }
            InitConfFileBean conf = new InitConfFileBean();
            conf.initialise(this.mInstanceName, false);
            String security = conf.get_mag_var("Security");
            if (security.equalsIgnoreCase("on")) {
                InstanceDefinition instance = new InstanceDefinition(this.mInstanceName, this.mHostAndPort.getPort());
                return ServerManager.instance().getSecurityTokensForInstance(instance);
            }
            return null;
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.security_check_failed", e);
            throw new ControlException(e.getMessage());
        }
    }

    public RequestID restart() throws ControlException {
        RequestID reqId = null;
        String adminId = AdminService.getAdminService().getInstanceName();
        final RMIClient rmiClient = AdminChannel.getRMIClient(this.mInstanceName);
        if (rmiClient.getInstanceStatusCode() != 0) {
            String msg = localStrings.getString("admin.server.core.mbean.config.instance_not_running_cannot_restart");
            throw new IllegalStateException(msg);
        }
        try {
            sLogger.log(Level.INFO, "mbean.restart_instance", this.mInstanceName);
            InstanceDefinition instance = new InstanceDefinition(this.mInstanceName, this.getHostAndPort().getPort());
            ServerManager.instance().restartServerInstance(instance);
            int MAX_TIMES = 3;
            for (int i = 0; rmiClient.getInstanceStatusCode() != 3 && i < MAX_TIMES; ++i) {
                Thread.currentThread();
                Thread.sleep(5000L);
            }
        }
        catch (Exception e) {
            throw new ControlException(e.getMessage());
        }
        ManagedInstanceTimer tt = new ManagedInstanceTimer(120, 0, new TimerCallback(){

            public boolean check() throws Exception {
                return rmiClient.getInstanceStatusCode() == 0;
            }
        });
        tt.run();
        if (rmiClient.getInstanceStatusCode() != 0) {
            String msg = localStrings.getString("admin.server.core.mbean.config.timeout_while_restarting_server");
            try {
                this.stop(120);
            }
            catch (ControlException ce) {
                msg = msg + localStrings.getString("admin.server.core.mbean.config.server_stop_exception");
            }
            throw new ControlException(msg + this.mInstanceName);
        }
        return reqId;
    }

    public void stop(int timeoutSeconds) throws ControlException {
        String adminId = AdminService.getAdminService().getInstanceName();
        if (this.mInstanceName.equals(adminId)) {
            sLogger.log(Level.INFO, "mbean.shutdown_started");
            new Thread(new ShutdownThread(adminId)).start();
            return;
        }
        if (this.getInstanceStatusCode() == 3) {
            String msg = localStrings.getString("admin.server.core.mbean.config.not_running_cannot_stop");
            throw new IllegalStateException(msg);
        }
        try {
            sLogger.log(Level.INFO, "mbean.stop_instance", this.mInstanceName);
            InstanceDefinition instance = new InstanceDefinition(this.mInstanceName, this.mHostAndPort.getPort());
            ServerManager.instance().stopServerInstance(instance);
            sLogger.log(Level.INFO, "mbean.check_stop_instance", this.mInstanceName);
            long timeoutMillis = timeoutSeconds * 1000;
            long sleepTime = 2000L;
            long timeBefore = System.currentTimeMillis();
            long timeAfter = System.currentTimeMillis();
            boolean timeoutReached = false;
            while (!timeoutReached && this.getInstanceStatusCode() != 3) {
                Thread.sleep(sleepTime);
                timeAfter = System.currentTimeMillis();
                timeoutReached = timeAfter - timeBefore >= timeoutMillis;
            }
            if (timeoutReached) {
                sLogger.log(Level.INFO, "mbean.stop_instance_timeout", this.mInstanceName);
                String msg = localStrings.getString("admin.server.core.mbean.config.timeout_while_stopping_server", this.mInstanceName);
                throw new ControlException(msg);
            }
            sLogger.log(Level.INFO, "mbean.stop_instance_success", this.mInstanceName);
        }
        catch (Exception e) {
            sLogger.log(Level.SEVERE, "mbean.stop_instance_failed", this.mInstanceName);
            throw new ControlException(e.getMessage());
        }
    }

    public String[] getDeployedJ2EEApplications() throws ServerInstanceException {
        String[] apps = new String[]{};
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Applications appsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/applications");
            J2eeApplication[] j2eeApps = appsConfigBean.getJ2eeApplication();
            if (j2eeApps != null) {
                apps = new String[j2eeApps.length];
                for (int i = 0; i < j2eeApps.length; ++i) {
                    apps[i] = j2eeApps[i].getName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return apps;
    }

    public String[] getDeployedJ2EEModules() throws ServerInstanceException {
        String msg = localStrings.getString("admin.server.core.mbean.config.not_supported_yet");
        throw new UnsupportedOperationException(msg);
    }

    public String[] getDeployedEJBModules() throws ServerInstanceException {
        String[] ejbModules = new String[]{};
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Applications appsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/applications");
            EjbModule[] modules = appsConfigBean.getEjbModule();
            if (modules != null) {
                ejbModules = new String[modules.length];
                for (int i = 0; i < modules.length; ++i) {
                    ejbModules[i] = modules[i].getName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return ejbModules;
    }

    public String[] getDeployedWebModules() throws ServerInstanceException {
        String[] webModules = new String[]{};
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Applications appsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/applications");
            WebModule[] modules = appsConfigBean.getWebModule();
            if (modules != null) {
                webModules = new String[modules.length];
                for (int i = 0; i < modules.length; ++i) {
                    webModules[i] = modules[i].getName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return webModules;
    }

    public String[] getDeployedConnectors() throws ServerInstanceException {
        String[] connectors = new String[]{};
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Applications appsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/applications");
            ConnectorModule[] connectorConfigBeans = appsConfigBean.getConnectorModule();
            if (connectorConfigBeans != null) {
                connectors = new String[connectorConfigBeans.length];
                for (int i = 0; i < connectors.length; ++i) {
                    connectors[i] = connectorConfigBeans[i].getName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return connectors;
    }

    public String[] getEnabledJ2EEApplications() throws ServerInstanceException {
        return null;
    }

    public String[] getDisabledJ2EEApplications() throws ServerInstanceException {
        return null;
    }

    public String[] getEnabledJ2EEModules() throws ServerInstanceException {
        return null;
    }

    public String[] getDisabledJ2EEModules() throws ServerInstanceException {
        return null;
    }

    public void createResource(String resourceXMLFile) throws AFResourceException {
        try {
            ResourcesXMLParser allResources = new ResourcesXMLParser(resourceXMLFile);
            Iterator resourceIter = allResources.getResources();
            while (resourceIter.hasNext()) {
                String resType;
                String jndiName;
                Properties attributes;
                Resource resource = (Resource)resourceIter.next();
                if (resource.getType() == 4) {
                    attributes = resource.getAttributes();
                    jndiName = attributes.getProperty("jndi-name");
                    String poolName = attributes.getProperty("pool-name");
                    this.createJDBCResource(jndiName, poolName);
                    this.addJDBCResourceAttribute(resource, attributes, jndiName);
                    continue;
                }
                if (resource.getType() == 1) {
                    attributes = resource.getAttributes();
                    jndiName = attributes.getProperty("jndi-name");
                    resType = attributes.getProperty("res-type");
                    this.createJMSResource(jndiName, resType, new Properties());
                    this.addJMSResourceAttribute(resource, attributes, jndiName);
                    continue;
                }
                if (resource.getType() == 7) {
                    attributes = resource.getAttributes();
                    jndiName = attributes.getProperty("jndi-name");
                    String jndiLookupName = attributes.getProperty("jndi-lookup-name");
                    String resType2 = attributes.getProperty("res-type");
                    String factoryClass = attributes.getProperty("factory-class");
                    this.createJNDIResource(jndiName, jndiLookupName, resType2, factoryClass);
                    this.addJNDIResourceAttribute(resource, attributes, jndiName);
                    continue;
                }
                if (resource.getType() == 3) {
                    attributes = resource.getAttributes();
                    jndiName = attributes.getProperty("jndi-name");
                    this.createPersistenceManagerFactoryResource(jndiName);
                    this.addPersistenceManagerFactoryAttribute(resource, attributes, jndiName);
                    continue;
                }
                if (resource.getType() == 2) {
                    attributes = resource.getAttributes();
                    jndiName = attributes.getProperty("jndi-name");
                    String host = attributes.getProperty("host");
                    String user = attributes.getProperty("user");
                    String fromAddress = attributes.getProperty("from");
                    this.createJavaMailResource(jndiName, host, user, fromAddress);
                    this.addJavaMailAttribute(resource, attributes, jndiName);
                    continue;
                }
                if (resource.getType() == 6) {
                    attributes = resource.getAttributes();
                    jndiName = attributes.getProperty("jndi-name");
                    resType = attributes.getProperty("res-type");
                    String factoryClass = attributes.getProperty("factory-class");
                    this.createCustomResource(jndiName, resType, factoryClass);
                    this.addCustomResourceAttribute(resource, attributes, jndiName);
                    continue;
                }
                if (resource.getType() != 5) continue;
                attributes = resource.getAttributes();
                String name = attributes.getProperty("name");
                String datasourceClass = attributes.getProperty("datasource-classname");
                this.createJDBCConnectionPool(name, datasourceClass);
                this.addJDBCConnectionPoolAttribute(resource, attributes, name);
            }
        }
        catch (Exception e) {
            throw new AFResourceException(e.getMessage());
        }
    }

    public void createJDBCConnectionPool(String id, String datasourceClassName) throws AFResourceException {
        ArgChecker.checkValid(id, "id", StringValidator.getInstance());
        ArgChecker.checkValid(datasourceClassName, "datasourceClassName", StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.create_resource", id);
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            JdbcConnectionPool resource = new JdbcConnectionPool();
            resource.setName(id);
            resource.setDatasourceClassname(datasourceClassName);
            resourcesBean.addJdbcConnectionPool(resource);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.create_resource_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    private void addJDBCConnectionPoolAttribute(Resource resource, Properties attributes, String name) throws AFResourceException {
        try {
            ElementProperty[] epArray;
            String sDescription;
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            JdbcConnectionPool jdbc_pool_resource = resourcesBean.getJdbcConnectionPoolByName(name);
            String sSteadyPoolSize = attributes.getProperty("steady-pool-size");
            String sMaxPoolSize = attributes.getProperty("max-pool-size");
            String sMaxWaitTimeInMillis = attributes.getProperty("max-wait-time-in-millis");
            String sPoolSizeQuantity = attributes.getProperty("pool-resize-quantity");
            String sIdleTimeoutInSec = attributes.getProperty("idle-timeout-in-seconds");
            String sIsConnectionValidationRequired = attributes.getProperty("is-connection-validation-required");
            String sConnectionValidationMethod = attributes.getProperty("connection-validation-method");
            String sFailAllConnection = attributes.getProperty("fail-all-connections");
            String sValidationTableName = attributes.getProperty("validation-table-name");
            String sResType = attributes.getProperty("res-type");
            String sTransIsolationLevel = attributes.getProperty("transaction-isolation-level");
            String sIsIsolationLevelQuaranteed = attributes.getProperty("is-isolation-level-guaranteed");
            if (sSteadyPoolSize != null) {
                jdbc_pool_resource.setSteadyPoolSize(sSteadyPoolSize);
            }
            if (sMaxPoolSize != null) {
                jdbc_pool_resource.setMaxPoolSize(sMaxPoolSize);
            }
            if (sMaxWaitTimeInMillis != null) {
                jdbc_pool_resource.setMaxWaitTimeInMillis(sMaxWaitTimeInMillis);
            }
            if (sPoolSizeQuantity != null) {
                jdbc_pool_resource.setPoolResizeQuantity(sPoolSizeQuantity);
            }
            if (sIdleTimeoutInSec != null) {
                jdbc_pool_resource.setIdleTimeoutInSeconds(sIdleTimeoutInSec);
            }
            if (sIsConnectionValidationRequired != null) {
                jdbc_pool_resource.setIsConnectionValidationRequired(Boolean.valueOf(sIsConnectionValidationRequired));
            }
            if (sConnectionValidationMethod != null) {
                jdbc_pool_resource.setConnectionValidationMethod(sConnectionValidationMethod);
            }
            if (sFailAllConnection != null) {
                jdbc_pool_resource.setFailAllConnections(Boolean.valueOf(sFailAllConnection));
            }
            if (sValidationTableName != null) {
                jdbc_pool_resource.setValidationTableName(sValidationTableName);
            }
            if (sResType != null) {
                jdbc_pool_resource.setResType(sResType);
            }
            if (sTransIsolationLevel != null) {
                jdbc_pool_resource.setTransactionIsolationLevel(sTransIsolationLevel);
            }
            if (sIsIsolationLevelQuaranteed != null) {
                jdbc_pool_resource.setIsIsolationLevelGuaranteed(Boolean.valueOf(sIsIsolationLevelQuaranteed));
            }
            if ((sDescription = resource.getDescription()) != null) {
                jdbc_pool_resource.setDescription(sDescription);
            }
            if ((epArray = resource.getElementProperty()) != null) {
                for (int ii = 0; ii < epArray.length; ++ii) {
                    jdbc_pool_resource.addElementProperty(epArray[ii]);
                }
            }
            serverContext.flush();
        }
        catch (Exception e) {
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public void deleteJDBCConnectionPool(String poolName) throws AFResourceException {
        ArgChecker.checkValid(poolName, "poolName", StringValidator.getInstance());
        sLogger.log(Level.FINE, "mbean.delele_jdbc_pool", poolName);
        try {
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            JdbcConnectionPool resource = resourcesBean.getJdbcConnectionPoolByName(poolName);
            if (resource == null) {
                String msg = localStrings.getString("admin.server.core.mbean.config.no_such_resource", poolName);
                throw new Exception(msg);
            }
            resourcesBean.removeJdbcConnectionPool(resource);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.delete_jdbc_pool_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public String[] listJDBCConnectionPools() throws AFException {
        String[] sa = null;
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            JdbcConnectionPool[] connectionPools = resourcesBean.getJdbcConnectionPool();
            if (connectionPools != null) {
                sa = new String[connectionPools.length];
                for (int i = 0; i < connectionPools.length; ++i) {
                    sa[i] = connectionPools[i].getName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new AFException(e.getLocalizedMessage());
        }
        return sa;
    }

    public void createJDBCResource(String jndiName, String poolName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        ArgChecker.checkValid(poolName, "poolName", StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.create_resource", jndiName);
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            JdbcResource resource = new JdbcResource();
            resource.setJndiName(jndiName);
            resource.setPoolName(poolName);
            resourcesBean.addJdbcResource(resource);
            this.createResourceRef(jndiName);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.create_resource_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    private void createResourceRef(String name) throws Exception {
        ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
        Server server = ServerBeansFactory.getServerBean(serverContext);
        ResourceRef rr = new ResourceRef();
        rr.setRef(name);
        server.addResourceRef(rr);
    }

    private void deleteResourceRef(String name) throws Exception {
        ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
        Server server = ServerBeansFactory.getServerBean(serverContext);
        ResourceRef rr = server.getResourceRefByRef(name);
        if (rr != null) {
            server.removeResourceRef(rr);
        }
    }

    private void addJDBCResourceAttribute(Resource resource, Properties attributes, String jndiName) throws AFResourceException {
        try {
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            JdbcResource jdbc_resource = resourcesBean.getJdbcResourceByJndiName(jndiName);
            String sDescription = resource.getDescription();
            if (sDescription != null) {
                jdbc_resource.setDescription(sDescription);
            }
            serverContext.flush();
        }
        catch (Exception e) {
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public void deleteJDBCResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.delete_resource", jndiName);
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            JdbcResource resource = resourcesBean.getJdbcResourceByJndiName(jndiName);
            if (resource == null) {
                String msg = localStrings.getString("admin.server.core.mbean.config.no_such_resource", jndiName);
                throw new Exception(msg);
            }
            resourcesBean.removeJdbcResource(resource);
            this.deleteResourceRef(jndiName);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.delete_resource_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public String[] listJDBCResources() throws AFException {
        String[] sa = null;
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            JdbcResource[] jdbcResources = resourcesBean.getJdbcResource();
            if (jdbcResources != null) {
                sa = new String[jdbcResources.length];
                for (int i = 0; i < jdbcResources.length; ++i) {
                    sa[i] = jdbcResources[i].getJndiName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new AFException(e.getLocalizedMessage());
        }
        return sa;
    }

    public void createJavaMailResource(String jndiName, String host, String user, String fromAddress) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        ArgChecker.checkValid(host, "host", StringValidator.getInstance());
        ArgChecker.checkValid(user, "user", StringValidator.getInstance());
        ArgChecker.checkValid(fromAddress, "fromAddress", StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.create_resource", jndiName);
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            MailResource resource = new MailResource();
            resource.setJndiName(jndiName);
            resource.setHost(host);
            resource.setUser(user);
            resource.setFrom(fromAddress);
            resourcesBean.addMailResource(resource);
            this.createResourceRef(jndiName);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.FINE, "mbean.create_resource_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    private void addJavaMailAttribute(Resource resource, Properties attributes, String jndiName) throws AFResourceException {
        try {
            ElementProperty[] epArray;
            String sDescription;
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            MailResource mail_resource = resourcesBean.getMailResourceByJndiName(jndiName);
            String sStoreProto = attributes.getProperty("store-protocol");
            String sStoreProtoClass = attributes.getProperty("store-protocol-class");
            String sTransProto = attributes.getProperty("transport-protocol");
            String sTransProtoClass = attributes.getProperty("transport-protocol-class");
            String sDebug = attributes.getProperty("debug");
            if (sStoreProto != null) {
                mail_resource.setStoreProtocol(sStoreProto);
            }
            if (sStoreProtoClass != null) {
                mail_resource.setStoreProtocolClass(sStoreProtoClass);
            }
            if (sTransProto != null) {
                mail_resource.setTransportProtocol(sTransProto);
            }
            if (sTransProtoClass != null) {
                mail_resource.setTransportProtocolClass(sTransProtoClass);
            }
            if (sDebug != null) {
                mail_resource.setDebug(Boolean.valueOf(sDebug));
            }
            if ((sDescription = resource.getDescription()) != null) {
                mail_resource.setDescription(sDescription);
            }
            if ((epArray = resource.getElementProperty()) != null) {
                for (int ii = 0; ii < epArray.length; ++ii) {
                    mail_resource.addElementProperty(epArray[ii]);
                }
            }
            serverContext.flush();
        }
        catch (Exception e) {
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public void deleteJavaMailResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.delete_resource", jndiName);
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            MailResource resource = resourcesBean.getMailResourceByJndiName(jndiName);
            if (resource == null) {
                String msg = localStrings.getString("admin.server.core.mbean.config.no_such_resource", jndiName);
                throw new Exception(msg);
            }
            resourcesBean.removeMailResource(resource);
            this.deleteResourceRef(jndiName);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.delete_resource_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public String[] listJavaMailResources() throws AFException {
        String[] sa = null;
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            MailResource[] mailResources = resourcesBean.getMailResource();
            if (mailResources != null) {
                sa = new String[mailResources.length];
                for (int i = 0; i < mailResources.length; ++i) {
                    sa[i] = mailResources[i].getJndiName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new AFException(e.getLocalizedMessage());
        }
        return sa;
    }

    public void createJMSResource(String jndiName, String resourceType) throws AFResourceException {
        this.createJMSResource(jndiName, resourceType, new Properties());
    }

    public void createJMSResource(String jndiName, String resourceType, Properties props) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        ArgChecker.checkValid(resourceType, "resourceType", StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.create_resource", jndiName);
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            JmsRaMapping ramap = ConnectorRuntime.getRuntime().getJmsRaMapping();
            Enumeration<Object> en = props.keys();
            Properties properties = new Properties();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String raKey = ramap.getMappedName(key);
                if (raKey == null) {
                    raKey = key;
                }
                properties.put(raKey, (String)props.get(key));
            }
            ConnectorRuntime.getRuntime();
            String raName = "jmsra";
            if (resourceType.equalsIgnoreCase("javax.jms.TopicConnectionFactory") || resourceType.equalsIgnoreCase("javax.jms.QueueConnectionFactory")) {
                String defPoolName = ConnectorRuntime.getRuntime().getDefaultPoolName(jndiName);
                ConnectorConnectionPool conPool = new ConnectorConnectionPool();
                conPool.setResourceAdapterName(raName);
                conPool.setConnectionDefinitionName(resourceType);
                conPool.setName(defPoolName);
                conPool.setMaxPoolSize("250");
                conPool.setSteadyPoolSize("1");
                resourcesBean.addConnectorConnectionPool(conPool);
                ConnectorResource resource = new ConnectorResource();
                resource.setJndiName(jndiName);
                resource.setPoolName(defPoolName);
                if (properties != null) {
                    Enumeration<Object> e = properties.keys();
                    ElementProperty el = null;
                    while (e.hasMoreElements()) {
                        String n = (String)e.nextElement();
                        String v = (String)properties.get(n);
                        el = new ElementProperty();
                        el.setName(n);
                        el.setValue(v);
                        conPool.addElementProperty(el);
                    }
                }
                resourcesBean.addConnectorResource(resource);
                this.createResourceRef(jndiName);
            } else {
                this.addAdminObject(resourceType, properties, raName, jndiName);
            }
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.create_resource_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    private void addJMSResourceAttribute(Resource resource, Properties attributes, String jndiName) throws AFResourceException {
    }

    public void deleteJMSResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        try {
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            ConnectorResource resource = resourcesBean.getConnectorResourceByJndiName(jndiName);
            if (resource == null) {
                this.deleteAdminObject(jndiName);
            } else {
                String defPoolName = ConnectorRuntime.getRuntime().getDefaultPoolName(jndiName);
                if (resource.getPoolName().equals(defPoolName)) {
                    resourcesBean.removeConnectorResource(resource);
                    this.deleteConnectorConnectionPool(defPoolName);
                }
            }
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.delete_resource_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public String[] listJMSResources() throws AFException {
        Object sa = null;
        return null;
    }

    public void createJNDIResource(String jndiName, String jndiLookupName, String resourceType, String factoryClass) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        ArgChecker.checkValid(jndiLookupName, "jndiLookupName", StringValidator.getInstance());
        ArgChecker.checkValid(resourceType, "resourceType", StringValidator.getInstance());
        ArgChecker.checkValid(factoryClass, "factoryClass", StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.create_resource", jndiName);
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            ExternalJndiResource resource = new ExternalJndiResource();
            resource.setJndiName(jndiName);
            resource.setJndiLookupName(jndiLookupName);
            resource.setResType(resourceType);
            resource.setFactoryClass(factoryClass);
            resourcesBean.addExternalJndiResource(resource);
            this.createResourceRef(jndiName);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.create_resource_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    private void addJNDIResourceAttribute(Resource resource, Properties attributes, String jndiName) throws AFResourceException {
        try {
            ElementProperty[] epArray;
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            ExternalJndiResource jndi_resource = resourcesBean.getExternalJndiResourceByJndiName(jndiName);
            String sDescription = resource.getDescription();
            if (sDescription != null) {
                jndi_resource.setDescription(sDescription);
            }
            if ((epArray = resource.getElementProperty()) != null) {
                for (int ii = 0; ii < epArray.length; ++ii) {
                    jndi_resource.addElementProperty(epArray[ii]);
                }
            }
            serverContext.flush();
        }
        catch (Exception e) {
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public void deleteJNDIResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.delete_resource", jndiName);
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            ExternalJndiResource resource = resourcesBean.getExternalJndiResourceByJndiName(jndiName);
            if (resource == null) {
                String msg = localStrings.getString("admin.server.core.mbean.config.no_such_resource", jndiName);
                throw new Exception(msg);
            }
            resourcesBean.removeExternalJndiResource(resource);
            this.deleteResourceRef(jndiName);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.delete_resource_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public String[] listJNDIResources() throws AFException {
        String[] sa = null;
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            ExternalJndiResource[] jndiResources = resourcesBean.getExternalJndiResource();
            if (jndiResources != null) {
                sa = new String[jndiResources.length];
                for (int i = 0; i < jndiResources.length; ++i) {
                    sa[i] = jndiResources[i].getJndiName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new AFException(e.getLocalizedMessage());
        }
        return sa;
    }

    public void createPersistenceManagerFactoryResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.create_resource", jndiName);
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            PersistenceManagerFactoryResource resource = new PersistenceManagerFactoryResource();
            resource.setJndiName(jndiName);
            resourcesBean.addPersistenceManagerFactoryResource(resource);
            this.createResourceRef(jndiName);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.create_resource_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    private void addPersistenceManagerFactoryAttribute(Resource resource, Properties attributes, String jndiName) throws AFResourceException {
        try {
            ElementProperty[] epArray;
            String sDescription;
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            PersistenceManagerFactoryResource pmf_resource = resourcesBean.getPersistenceManagerFactoryResourceByJndiName(jndiName);
            String factoryClass = attributes.getProperty("factory-class");
            String resName = attributes.getProperty("jdbc-resource-jndi-name");
            String sEnabled = attributes.getProperty("enabled");
            if (factoryClass != null) {
                pmf_resource.setFactoryClass(factoryClass);
            }
            if (resName != null) {
                pmf_resource.setJdbcResourceJndiName(resName);
            }
            if ((sDescription = resource.getDescription()) != null) {
                pmf_resource.setDescription(sDescription);
            }
            if ((epArray = resource.getElementProperty()) != null) {
                for (int ii = 0; ii < epArray.length; ++ii) {
                    pmf_resource.addElementProperty(epArray[ii]);
                }
            }
            serverContext.flush();
        }
        catch (Exception e) {
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public void deletePersistenceManagerFactoryResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.delete_resource", jndiName);
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            PersistenceManagerFactoryResource resource = resourcesBean.getPersistenceManagerFactoryResourceByJndiName(jndiName);
            if (resource == null) {
                String msg = localStrings.getString("admin.server.core.mbean.config.no_such_resource");
                throw new Exception(msg);
            }
            resourcesBean.removePersistenceManagerFactoryResource(resource);
            this.deleteResourceRef(jndiName);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.delete_resource_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public String[] listPersistenceManagerFactoryResources() throws AFException {
        String[] sa = null;
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            PersistenceManagerFactoryResource[] pmFactoryResources = resourcesBean.getPersistenceManagerFactoryResource();
            if (pmFactoryResources != null) {
                sa = new String[pmFactoryResources.length];
                for (int i = 0; i < pmFactoryResources.length; ++i) {
                    sa[i] = pmFactoryResources[i].getJndiName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new AFException(e.getLocalizedMessage());
        }
        return sa;
    }

    public void createCustomResource(String jndiName, String resourceType, String factoryClass) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        ArgChecker.checkValid(factoryClass, "factoryClass", StringValidator.getInstance());
        ArgChecker.checkValid(resourceType, "resourceType", StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.create_resource", jndiName);
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            CustomResource resource = new CustomResource();
            resource.setJndiName(jndiName);
            resource.setResType(resourceType);
            resource.setFactoryClass(factoryClass);
            resourcesBean.addCustomResource(resource);
            this.createResourceRef(jndiName);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.create_resource_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    private void addCustomResourceAttribute(Resource resource, Properties attributes, String jndiName) throws AFResourceException {
        try {
            ElementProperty[] epArray;
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            CustomResource custom_resource = resourcesBean.getCustomResourceByJndiName(jndiName);
            String sEnabled = attributes.getProperty("enabled");
            String sDescription = resource.getDescription();
            if (sDescription != null) {
                custom_resource.setDescription(sDescription);
            }
            if ((epArray = resource.getElementProperty()) != null) {
                for (int ii = 0; ii < epArray.length; ++ii) {
                    custom_resource.addElementProperty(epArray[ii]);
                }
            }
            serverContext.flush();
        }
        catch (Exception e) {
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public void deleteCustomResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.delete_resource", jndiName);
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            CustomResource resource = resourcesBean.getCustomResourceByJndiName(jndiName);
            if (resource == null) {
                String msg = localStrings.getString("admin.server.core.mbean.config.no_such_resource", jndiName);
                throw new Exception(msg);
            }
            resourcesBean.removeCustomResource(resource);
            this.deleteResourceRef(jndiName);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.delete_resource_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public String[] listCustomResources() throws AFException {
        String[] sa = null;
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            CustomResource[] customResources = resourcesBean.getCustomResource();
            if (customResources != null) {
                sa = new String[customResources.length];
                for (int i = 0; i < customResources.length; ++i) {
                    sa[i] = customResources[i].getJndiName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new AFException(e.getLocalizedMessage());
        }
        return sa;
    }

    public void setHttpPort(int port) {
    }

    public HostAndPort getHostAndPort() throws ServerInstanceException {
        return this.getHostAndPort(false);
    }

    public HostAndPort getHostAndPort(boolean securityEnabled) throws ServerInstanceException {
        HostAndPort hAndp = null;
        try {
            Config config = (Config)super.getConfigBeanByXPath("/domain/configs/config[@name='server-config']");
            HttpService https = config.getHttpService();
            HttpListener[] hlArray = https.getHttpListener();
            HttpListener ls = hlArray[0];
            for (int i = 0; i < hlArray.length; ++i) {
                if (!hlArray[i].isEnabled() || hlArray[i].isSecurityEnabled() != securityEnabled) continue;
                ls = hlArray[i];
                break;
            }
            String port = ls.getPort();
            int intPort = Integer.parseInt(port);
            hAndp = new HostAndPort(ls.getServerName(), intPort);
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return hAndp;
    }

    public int getHttpPort() {
        return 9000;
    }

    public ServerInstanceStatus getStatus() throws ControlException {
        int statusCode = this.getInstanceStatusCode();
        ServerInstanceStatus status2 = new ServerInstanceStatus(statusCode);
        if (this.isDebug()) {
            status2.setDebug(true);
            try {
                status2.setDebugPort(this.getDebugPort());
            }
            catch (Exception e) {
                sLogger.finest("Problem with getting port:ManagedServerInstance:getStatus");
                throw new ControlException(e.getLocalizedMessage());
            }
        }
        sLogger.exiting(this.getClass().getName(), "getStatus", status2.getStatusString());
        return status2;
    }

    public boolean isRestartNeeded() {
        RMIClient rc;
        AdminEventCache cache = AdminEventCache.getInstance(this.mInstanceName);
        boolean restartRequired = cache.isInstanceRestartNeeded();
        if (restartRequired && !(rc = AdminChannel.getRMIClient(this.mInstanceName)).isAlive()) {
            restartRequired = false;
        }
        return restartRequired;
    }

    private boolean isAlive() {
        boolean alive = false;
        RMIClient serverInstancePinger = AdminChannel.getRMIClient(this.mInstanceName);
        alive = serverInstancePinger.isAlive();
        return alive;
    }

    private int getInstanceStatusCode() {
        int statusCode = 3;
        RMIClient serverInstancePinger = AdminChannel.getRMIClient(this.mInstanceName);
        statusCode = serverInstancePinger.getInstanceStatusCode();
        return statusCode;
    }

    public void reconfigure() {
    }

    public boolean isApplyNeeded() throws ServerInstanceException {
        return this.isApplyNeeded(true);
    }

    public boolean isApplyNeeded(boolean checkAllFiles) throws ServerInstanceException {
        boolean applyNeeded = false;
        try {
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            applyNeeded = serverContext.isChanged();
        }
        catch (ConfigException e) {
            throw new ServerInstanceException(e.getMessage());
        }
        if (!applyNeeded && checkAllFiles) {
            InstanceEnvironment ie = new InstanceEnvironment(this.mInstanceName);
            applyNeeded = ie.hasRealmsKeyConfFileChanged();
        }
        return applyNeeded;
    }

    public boolean overwriteConfigChanges() throws ServerInstanceException {
        try {
            return this.applyChanges(true);
        }
        catch (AFRuntimeStoreException e) {
            InstanceEnvironment ie = new InstanceEnvironment(this.mInstanceName);
            if (ie.canReloadManualXmlChanges()) {
                try {
                    ie.useManualServerXmlChanges();
                    this.reloadAfterChange(ie);
                }
                catch (ConfigException configException) {
                    // empty catch block
                }
                return true;
            }
            throw e;
        }
    }

    public boolean applyConfigChanges() throws ServerInstanceException {
        return this.applyChanges(false);
    }

    private boolean applyChanges(boolean force) throws ServerInstanceException {
        boolean requiresRestart = false;
        try {
            InstanceEnvironment instanceEnv = new InstanceEnvironment(this.mInstanceName);
            boolean hasConfChanges = false;
            boolean hasMimeChanges = false;
            hasConfChanges = instanceEnv.hasRealmsKeyConfFileChanged();
            instanceEnv.applyChangesFromBackup(force);
            this.transform(instanceEnv);
            requiresRestart = this.sendNotificationOnApply(hasConfChanges, hasMimeChanges);
        }
        catch (ConfigException e) {
            throw new ServerInstanceException(e.getMessage());
        }
        return requiresRestart;
    }

    public boolean canApplyConfigChanges() throws ConfigException {
        boolean b = false;
        InstanceEnvironment ie = new InstanceEnvironment(this.mInstanceName);
        boolean bl = b = !ManualChangeManager.hasHotChanged(this.mInstanceName);
        if (!b && ie.canReloadManualXmlChanges()) {
            ie.useManualServerXmlChanges();
            this.reloadAfterChange(ie);
            boolean requiresRestart = ie.restartRequired();
            if (requiresRestart) {
                AdminEventCache cache = AdminEventCache.getInstance(this.mInstanceName);
                cache.setRestartNeeded(true);
            }
            return true;
        }
        return b;
    }

    void reloadAfterChange(InstanceEnvironment instanceEnv) throws ConfigException {
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        ObjectName[] objectNames = ObjectNameHelper.getInstanceRelatedMBeans(mbs, this.mInstanceName);
        for (int i = 0; i < objectNames.length; ++i) {
            try {
                mbs.unregisterMBean(objectNames[i]);
                continue;
            }
            catch (Exception e) {
                sLogger.log(Level.WARNING, "Exception: ", e);
            }
        }
        String fileUrl = instanceEnv.getBackupConfigFilePath();
        ConfigFactory.removeConfigContext(fileUrl);
    }

    public boolean useManualConfigChanges() throws ServerInstanceException {
        boolean requiresRestart = false;
        try {
            InstanceEnvironment instanceEnv = new InstanceEnvironment(this.mInstanceName);
            instanceEnv.useManualConfigChanges();
            this.reloadAfterChange(instanceEnv);
            this.transform(instanceEnv);
            requiresRestart = instanceEnv.restartRequired();
            if (requiresRestart) {
                AdminEventCache cache = AdminEventCache.getInstance(this.mInstanceName);
                cache.setRestartNeeded(true);
            }
        }
        catch (ConfigException e) {
            throw new ServerInstanceException(e.getMessage());
        }
        return requiresRestart;
    }

    public void startMonitor() {
    }

    public String[] getMonitorableComponentNames() {
        return null;
    }

    public void stopMonitor() {
    }

    public void createLifeCycleModule(String moduleName, String className) throws AFException {
        ArgChecker.checkValid(moduleName, "moduleName", StringValidator.getInstance());
        ArgChecker.checkValid(className, "className", StringValidator.getInstance());
        try {
            sLogger.log(Level.FINEST, "mbean.create_lifecycle", moduleName);
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Applications applicationsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/applications");
            LifecycleModule module = new LifecycleModule();
            module.setName(moduleName);
            module.setClassName(className);
            applicationsConfigBean.addLifecycleModule(module);
            this.createResourceRef(moduleName);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.create_lifecycle_failed", e);
            throw new AFException(e.getMessage());
        }
    }

    public void deleteLifeCycleModule(String moduleName) throws AFException {
        ArgChecker.checkValid(moduleName, "moduleName", StringValidator.getInstance());
        try {
            sLogger.log(Level.FINEST, "mbean.delete_lifecycle", moduleName);
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Applications applicationsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/applications");
            LifecycleModule module = applicationsConfigBean.getLifecycleModuleByName(moduleName);
            applicationsConfigBean.removeLifecycleModule(module);
            this.deleteResourceRef(moduleName);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.delete_lifecycle_failed", e);
            throw new AFException(e.getMessage());
        }
    }

    public String[] listLifeCycleModules() throws AFException {
        String[] modules = new String[]{};
        try {
            sLogger.log(Level.FINEST, "mbean.list_components");
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Applications applicationsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/applications");
            LifecycleModule[] lifecycleConfigBeans = applicationsConfigBean.getLifecycleModule();
            if (lifecycleConfigBeans != null && lifecycleConfigBeans.length > 0) {
                modules = new String[lifecycleConfigBeans.length];
                for (int i = 0; i < lifecycleConfigBeans.length; ++i) {
                    modules[i] = lifecycleConfigBeans[i].getName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new AFException(e.getMessage());
        }
        return modules;
    }

    public String getClientStubJarLocation(String appName, int appType) throws AFException {
        ArgChecker.checkValid(appName, "appName", StringValidator.getInstance());
        if (appType != 1001 && appType != 1003) {
            String msg = localStrings.getString("admin.server.core.mbean.config.expected_application_type");
            throw new AFException(msg);
        }
        String clientJarLocation = null;
        try {
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            InstanceEnvironment iEnv = new InstanceEnvironment(this.mInstanceName);
            Applications applicationsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/applications");
            String appLocation = null;
            switch (appType) {
                case 1001: {
                    J2eeApplication app = applicationsConfigBean.getJ2eeApplicationByName(appName);
                    AppsManager appsManager = new AppsManager(iEnv);
                    appLocation = appsManager.getGeneratedXMLLocation(appName);
                    if (appLocation != null && FileUtils.safeIsDirectory(appLocation)) break;
                    appLocation = app.getLocation();
                    break;
                }
                case 1003: {
                    EjbModule module = applicationsConfigBean.getEjbModuleByName(appName);
                    EjbModulesManager ejbManager = new EjbModulesManager(iEnv);
                    appLocation = ejbManager.getGeneratedXMLLocation(appName);
                    if (appLocation != null && FileUtils.safeIsDirectory(appLocation)) break;
                    appLocation = module.getLocation();
                }
            }
            clientJarLocation = appLocation + File.separator + appName + "Client.jar";
            sLogger.log(Level.INFO, "mbean.cl_jar_loc", clientJarLocation);
        }
        catch (Exception e) {
            throw new AFException(e.getLocalizedMessage());
        }
        return clientJarLocation;
    }

    public String getWsdlFileLocation(String appName, String moduleName, int appType, String wsdlFileUri) throws AFException {
        ArgChecker.checkValid(appName, "appName", StringValidator.getInstance());
        if (appType != 1001 && appType != 1003 && appType != 1002) {
            String msg = localStrings.getString("admin.server.core.mbean.config.expected_application_type");
            throw new AFException(msg);
        }
        String wsdlFileLocation = null;
        try {
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            InstanceEnvironment iEnv = new InstanceEnvironment(this.mInstanceName);
            Applications applicationsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/applications");
            String appLocation = null;
            AbstractArchive moduleArchive = null;
            switch (appType) {
                case 1001: {
                    AppsManager appsManager = new AppsManager(iEnv);
                    appLocation = appsManager.getGeneratedXMLLocation(appName);
                    if (appLocation != null && FileUtils.safeIsDirectory(appLocation)) break;
                    J2eeApplication app = applicationsConfigBean.getJ2eeApplicationByName(appName);
                    appLocation = app.getLocation();
                    break;
                }
                case 1003: {
                    EjbModulesManager ejbManager = new EjbModulesManager(iEnv);
                    appLocation = ejbManager.getGeneratedXMLLocation(appName);
                    if (appLocation != null && FileUtils.safeIsDirectory(appLocation)) break;
                    EjbModule module = applicationsConfigBean.getEjbModuleByName(appName);
                    appLocation = module.getLocation();
                    break;
                }
                case 1002: {
                    WebModulesManager webManager = new WebModulesManager(iEnv);
                    appLocation = webManager.getGeneratedXMLLocation(appName);
                    if (appLocation != null && FileUtils.safeIsDirectory(appLocation)) break;
                    WebModule webModule = applicationsConfigBean.getWebModuleByName(appName);
                    appLocation = webModule.getLocation();
                }
            }
            FileArchive appArchive = new FileArchive();
            appArchive.open(appLocation);
            moduleArchive = moduleName != null ? appArchive.getEmbeddedArchive(moduleName) : appArchive;
            wsdlFileLocation = moduleArchive.getArchiveUri() + File.separator + wsdlFileUri.replace('/', File.separatorChar);
        }
        catch (Exception e) {
            throw new AFException(e.getLocalizedMessage());
        }
        return wsdlFileLocation;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        ObjectName serverInstanceMBeanObjectName = null;
        serverInstanceMBeanObjectName = new ObjectName("ias:type=serverinstance, name=");
        return serverInstanceMBeanObjectName;
    }

    public void postDeregister() {
    }

    public void preDeregister() throws Exception {
    }

    private void registerApplicationMBean(String archiveName) throws MBeanException {
        ObjectName appObjectName = ObjectNames.getApplicationObjectName(this.mInstanceName, archiveName);
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        if (!mbs.isRegistered(appObjectName)) {
            try {
                ManagedJ2EEApplication app = new ManagedJ2EEApplication(this.mInstanceName, archiveName, this.getAdminContext());
                mbs.registerMBean(app, appObjectName);
            }
            catch (InstanceAlreadyExistsException iae) {
                ExceptionUtil.ignoreException(iae);
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
        }
    }

    private void registerEJBModuleMBean(String archiveName) throws MBeanException {
        ObjectName moduleObjectName = ObjectNames.getEjbModuleObjectName(this.mInstanceName, archiveName);
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        if (!mbs.isRegistered(moduleObjectName)) {
            try {
                ManagedStandaloneJ2EEEjbJarModule module = new ManagedStandaloneJ2EEEjbJarModule(this.mInstanceName, archiveName, this.getAdminContext());
                mbs.registerMBean(module, moduleObjectName);
            }
            catch (InstanceAlreadyExistsException iae) {
                ExceptionUtil.ignoreException(iae);
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
        }
    }

    private void registerWebModuleMBean(String archiveName) {
        ObjectName moduleObjectName = ObjectNames.getWebModuleObjectName(this.mInstanceName, archiveName);
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        if (!mbs.isRegistered(moduleObjectName)) {
            // empty if block
        }
    }

    private void registerConnectorModuleMBean(String archiveName) {
        ObjectName moduleObjectName = ObjectNames.getConnectorModuleObjectName(this.mInstanceName, archiveName);
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        if (!mbs.isRegistered(moduleObjectName)) {
            // empty if block
        }
    }

    ConfigContext getConfigContext(String instanceName) throws ConfigException {
        return this.getConfigContext();
    }

    private String getModuleTypeString(int moduleType) {
        String moduleTypeString = null;
        switch (moduleType) {
            case 1003: {
                moduleTypeString = "ejb";
                break;
            }
            case 1002: {
                moduleTypeString = "web";
                break;
            }
            case 1004: {
                moduleTypeString = "connector";
            }
        }
        return moduleTypeString;
    }

    private boolean multicastEvent(int eventType, String entityName) throws DeploymentException {
        return this.multicastEvent(eventType, entityName, null);
    }

    public boolean multicastEvent(int eventType, String entityName, String moduleType) throws DeploymentException {
        return this.multicastEvent(eventType, entityName, moduleType, false);
    }

    public boolean multicastEvent(int eventType, String entityName, String moduleType, boolean cascade) throws DeploymentException {
        return this.multicastEvent(eventType, entityName, moduleType, cascade, false, null);
    }

    public boolean multicastEvent(int eventType, String entityName, String moduleType, boolean cascade, boolean forceDeploy, String targetName) throws DeploymentException {
        int statusCode;
        AdminEvent event;
        String name;
        block22: {
            name = this.getInstanceName();
            event = null;
            EventBuilder builder = new EventBuilder();
            EventStack stack = EventContext.getEventStackFromThreadLocal();
            ConfigContext ctx = stack.getConfigContext();
            stack.setTarget(targetName);
            stack.setConfigChangeList(ctx.getConfigChangeList());
            try {
                if (eventType == 1) {
                    event = builder.createApplicationDeployEvent("deploy", entityName, false, forceDeploy);
                    break block22;
                }
                if (eventType == 2) {
                    event = builder.createApplicationDeployEvent("undeploy", entityName, cascade, forceDeploy);
                    break block22;
                }
                if (eventType == 3) {
                    event = builder.createApplicationDeployEvent("redeploy", entityName, false, forceDeploy);
                    break block22;
                }
                if (eventType == 4) {
                    event = builder.createModuleDeployEvent("deploy", entityName, moduleType, cascade, forceDeploy);
                    break block22;
                }
                if (eventType == 5) {
                    event = builder.createModuleDeployEvent("undeploy", entityName, moduleType, cascade, forceDeploy);
                    break block22;
                }
                if (eventType == 6) {
                    event = builder.createModuleDeployEvent("redeploy", entityName, moduleType);
                    break block22;
                }
                if (eventType == 9) {
                    event = builder.createApplicationDeployEvent("enable", entityName, false, forceDeploy);
                    break block22;
                }
                if (eventType == 10) {
                    event = builder.createApplicationDeployEvent("disable", entityName, false, forceDeploy);
                    break block22;
                }
                if (eventType == 7) {
                    event = builder.createModuleDeployEvent("enable", entityName, moduleType, false, forceDeploy);
                    break block22;
                }
                if (eventType == 8) {
                    event = builder.createModuleDeployEvent("disable", entityName, moduleType, false, forceDeploy);
                    break block22;
                }
                if (eventType == 11) {
                    event = builder.createApplicationDeployEvent("reference-added", entityName, false, forceDeploy);
                    break block22;
                }
                if (eventType == 12) {
                    event = builder.createApplicationDeployEvent("reference-removed", entityName, false, forceDeploy);
                    break block22;
                }
                if (eventType == 7) {
                    event = builder.createConfigChangeEvent(targetName, null);
                    break block22;
                }
                String msg = localStrings.getString("admin.server.core.mbean.config.no_such_event", new Integer(eventType));
                throw new RuntimeException(msg);
            }
            catch (ConfigException ex) {
                DeploymentException de = new DeploymentException(ex.getMessage());
                de.initCause(ex);
                throw de;
            }
        }
        if (targetName != null) {
            event.setTargetDestination(targetName);
        }
        this.transform(new InstanceEnvironment(name));
        if (event instanceof ApplicationDeployEvent || event instanceof ModuleDeployEvent) {
            AdminEventCache.populateConfigChange(this.getConfigContext(), event);
        }
        if ((statusCode = this.getInstanceStatusCode()) == 2 || statusCode == 3) {
            sLogger.log(Level.INFO, "mbean.inst_down_skip_event", this.mInstanceName);
            return true;
        }
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.log(Level.FINEST, "mbean.event_sent", event.getEventInfo());
        } else {
            sLogger.log(Level.INFO, "mbean.send_event", ((AdminEvent)event).toString());
        }
        AdminEventResult multicastResult = AdminEventMulticaster.multicastEvent(event);
        sLogger.log(Level.FINE, "mbean.event_res", multicastResult.getResultCode());
        sLogger.log(Level.INFO, "mbean.event_reply", multicastResult.getAllMessagesAsString());
        boolean eventSuccess = true;
        if (!"success".equals(multicastResult.getResultCode())) {
            AdminEventCache cache = AdminEventCache.getInstance(this.mInstanceName);
            cache.setRestartNeeded(true);
            AdminEventListenerException ale = null;
            ale = multicastResult.getFirstAdminEventListenerException();
            if (ale != null) {
                sLogger.log(Level.WARNING, "mbean.event_failed", ale.getMessage());
                DeploymentException de = new DeploymentException(ale.getMessage());
                de.initCause(ale);
                throw de;
            }
        }
        return eventSuccess;
    }

    public String getInstanceName() {
        return this.mInstanceName;
    }

    private boolean sendNotificationOnApply(boolean confFilesChanged, boolean mimeFilesChanged) throws ConfigException {
        ConfigContext context = this.getConfigContext(this.mInstanceName);
        AdminEventCache cache = AdminEventCache.getInstance(this.mInstanceName);
        ArrayList changeList = context.getConfigChangeList();
        context.resetConfigChangeList();
        cache.processConfigChangeList(changeList, confFilesChanged, mimeFilesChanged);
        ArrayList eventList = cache.getAndResetCachedEvents();
        if (this.getInstanceStatusCode() != 0) {
            sLogger.log(Level.INFO, "mbean.inst_down_skip_event", this.mInstanceName);
            return false;
        }
        boolean requiresRestart = cache.isInstanceRestartNeeded();
        for (AdminEvent event : eventList) {
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.log(Level.FINEST, "mbean.event_sent", event.getEventInfo());
            } else {
                sLogger.log(Level.INFO, "mbean.send_event", event.toString());
            }
            AdminEventResult result = AdminEventMulticaster.multicastEvent(event);
            sLogger.log(Level.FINE, "mbean.event_res", result.getResultCode());
            sLogger.log(Level.FINEST, "mbean.event_reply", result.getAllMessagesAsString());
            if ("success".equals(result.getResultCode())) continue;
            requiresRestart = true;
            cache.setRestartNeeded(true);
            sLogger.log(Level.INFO, "applyChanges: AdminEventMulticaster.multiCastEvent indicates serverRestart=true , resultCode=" + result.getResultCode(), event.toString());
            sLogger.log(Level.WARNING, "mbean.notif_failed");
        }
        return requiresRestart;
    }

    private void deleteFile(String filePath) {
        File f = new File(filePath);
        if (f.exists()) {
            File parentDir = f.getParentFile();
            File tmpDir = new File(AdminService.getAdminService().getTempDirPath(), this.mInstanceName);
            if (tmpDir != null && tmpDir.equals(parentDir)) {
                boolean couldDelete = f.delete();
                if (couldDelete) {
                    sLogger.log(Level.FINE, "mbean.delete_temp_file_ok", filePath);
                } else {
                    sLogger.log(Level.INFO, "mbean.delete_temp_file_failed", filePath);
                }
            }
        }
    }

    private boolean isAppExists(String appName, int appType) {
        ConfigBean appConfigBean = null;
        try {
            ConfigContext serverContext = super.getConfigContext();
            Applications applicationsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/applications");
            if (applicationsConfigBean != null) {
                switch (appType) {
                    case 1001: {
                        appConfigBean = applicationsConfigBean.getJ2eeApplicationByName(appName);
                        break;
                    }
                    case 1003: {
                        appConfigBean = applicationsConfigBean.getEjbModuleByName(appName);
                        break;
                    }
                    case 1002: {
                        appConfigBean = applicationsConfigBean.getWebModuleByName(appName);
                        break;
                    }
                    case 1004: {
                        appConfigBean = applicationsConfigBean.getConnectorModuleByName(appName);
                    }
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "appexists failed", e);
        }
        return appConfigBean != null;
    }

    private boolean isAppExists(String moduleName, ModuleType moduleType) {
        ConfigBean moduleConfigBean = null;
        try {
            ConfigContext serverContext = super.getConfigContext();
            Applications applicationsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/applications");
            if (applicationsConfigBean != null) {
                if (moduleType.equals(ModuleType.EAR)) {
                    moduleConfigBean = applicationsConfigBean.getJ2eeApplicationByName(moduleName);
                } else if (moduleType.equals(ModuleType.EJB)) {
                    moduleConfigBean = applicationsConfigBean.getEjbModuleByName(moduleName);
                } else if (moduleType.equals(ModuleType.WAR)) {
                    moduleConfigBean = applicationsConfigBean.getWebModuleByName(moduleName);
                } else if (moduleType.equals(ModuleType.RAR)) {
                    moduleConfigBean = applicationsConfigBean.getConnectorModuleByName(moduleName);
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "appexists failed", e);
        }
        return moduleConfigBean != null;
    }

    private final boolean isDebug() {
        boolean isDebug = false;
        try {
            JavaConfig jvmConfig = this.getJavaConfigBean();
            String value = jvmConfig.getAttributeValue("debug-enabled");
            if (value != null) {
                isDebug = Boolean.valueOf(value);
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.is_debug_failed", e);
        }
        return isDebug;
    }

    private final void setDebug(boolean debug) throws Exception {
        JavaConfig jvmConfig = this.getJavaConfigBean();
        String value = String.valueOf(debug);
        jvmConfig.setAttributeValue("debug-enabled", value);
    }

    private final void setDebugOptions(String options) throws Exception {
        JavaConfig jvmConfig = this.getJavaConfigBean();
        jvmConfig.setAttributeValue("debug-options", options);
    }

    private final String getDebugOptions() throws Exception {
        JavaConfig jvmConfig = this.getJavaConfigBean();
        return jvmConfig.getAttributeValue("debug-options");
    }

    private final String getDefaultDebugOptions() throws Exception {
        return JavaConfig.getDefaultAttributeValue("debug-options");
    }

    private final int getDebugPort() throws Exception {
        String jdwpOption;
        int index;
        int debugPort = -1;
        String debugOptions = this.getDebugOptions();
        if (debugOptions != null && (index = debugOptions.indexOf("-Xrunjdwp")) >= 0 && (index = (jdwpOption = debugOptions.substring(index)).indexOf("address=")) >= 0) {
            String nvPairs = jdwpOption.substring(index);
            StringTokenizer optionTok = new StringTokenizer(nvPairs, "=, ");
            optionTok.nextToken();
            String portValue = optionTok.nextToken();
            debugPort = Integer.parseInt(portValue);
        }
        return debugPort;
    }

    private final void setDebugPort(int port) throws Exception {
        StringBuffer sb = new StringBuffer();
        String debugOptions = this.getDefaultDebugOptions();
        StringTokenizer strTok = new StringTokenizer(debugOptions, " ");
        while (strTok.hasMoreTokens()) {
            String option = strTok.nextToken();
            sb.append(option);
            if (option.startsWith("-Xrunjdwp")) {
                sb.append(",address=" + port);
            }
            if (!strTok.hasMoreTokens()) continue;
            sb.append(' ');
        }
        debugOptions = sb.toString();
        debugOptions = debugOptions + " -Xnoagent -Djava.compiler=NONE";
        sLogger.log(Level.INFO, "mbean.debug_options", debugOptions);
        this.setDebugOptions(debugOptions);
    }

    private final JavaConfig getJavaConfigBean() throws Exception {
        Config config = (Config)super.getConfigBeanByXPath("/domain/configs/config[@name='server-config']");
        JavaConfig jvmConfig = config.getJavaConfig();
        jvmConfig.setConfigContext(super.getConfigContext());
        return jvmConfig;
    }

    private FileRealm getInstanceRealmKeyFile() throws MBeanConfigException {
        InstanceEnvironment env = new InstanceEnvironment(this.mInstanceName);
        try {
            return new FileRealm(env.getBackupRealmsKeyFilePath());
        }
        catch (BadRealmException bre) {
            throw new MBeanConfigException(bre.getMessage());
        }
        catch (NoSuchRealmException nsr) {
            throw new MBeanConfigException(nsr.getMessage());
        }
    }

    private void saveInstanceRealmKeyFile(FileRealm realm) throws MBeanConfigException {
        InstanceEnvironment env = new InstanceEnvironment(this.mInstanceName);
        try {
            String filePath = env.getBackupRealmsKeyFilePath();
            sLogger.log(Level.INFO, "filerealm.write", filePath);
            realm.writeKeyFile(filePath);
        }
        catch (IOException ioe) {
            sLogger.log(Level.WARNING, "filerealm.writeerror", ioe);
            throw new MBeanConfigException(ioe.getMessage());
        }
    }

    private String[] convertEnumerationToStringArray(Enumeration e) {
        ArrayList list = new ArrayList();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] getUserNames() throws MBeanConfigException {
        FileRealm realm = this.getInstanceRealmKeyFile();
        try {
            return this.convertEnumerationToStringArray(realm.getUserNames());
        }
        catch (BadRealmException bre) {
            throw new MBeanConfigException(bre.getMessage());
        }
    }

    public String[] getGroupNames() throws MBeanConfigException {
        FileRealm realm = this.getInstanceRealmKeyFile();
        try {
            return this.convertEnumerationToStringArray(realm.getGroupNames());
        }
        catch (BadRealmException bre) {
            throw new MBeanConfigException(bre.getMessage());
        }
    }

    public String[] getUserGroupNames(String userName) throws MBeanConfigException {
        FileRealm realm = this.getInstanceRealmKeyFile();
        try {
            return this.convertEnumerationToStringArray(realm.getGroupNames(userName));
        }
        catch (NoSuchUserException nse) {
            throw new MBeanConfigException(nse.getMessage());
        }
    }

    public void addUser(String userName, String password, String[] groupList) throws MBeanConfigException {
        FileRealm realm = this.getInstanceRealmKeyFile();
        try {
            realm.addUser(userName, password, groupList);
            this.saveInstanceRealmKeyFile(realm);
        }
        catch (BadRealmException bre) {
            throw new MBeanConfigException(bre.getMessage());
        }
        catch (IASSecurityException ise) {
            throw new MBeanConfigException(ise.getMessage());
        }
    }

    public void removeUser(String userName) throws MBeanConfigException {
        FileRealm realm = this.getInstanceRealmKeyFile();
        try {
            realm.removeUser(userName);
            this.saveInstanceRealmKeyFile(realm);
        }
        catch (NoSuchUserException nse) {
            throw new MBeanConfigException(nse.getMessage());
        }
    }

    public void updateUser(String userName, String password, String[] groupList) throws MBeanConfigException {
        FileRealm realm = this.getInstanceRealmKeyFile();
        try {
            realm.updateUser(userName, userName, password, groupList);
            this.saveInstanceRealmKeyFile(realm);
        }
        catch (BadRealmException bre) {
            throw new MBeanConfigException(bre.getMessage());
        }
        catch (NoSuchUserException nse) {
            throw new MBeanConfigException(nse.getMessage());
        }
        catch (IASSecurityException ise) {
            throw new MBeanConfigException(ise.getMessage());
        }
    }

    private void testDeployedFile(String archiveName, boolean bDirectory) throws DeploymentException {
        if (archiveName == null) {
            String msg = localStrings.getString("admin.server.core.mbean.config.deploy_null_name");
            throw new DeploymentException(msg);
        }
        File f = new File(archiveName);
        if (bDirectory && !f.isDirectory()) {
            String msg = localStrings.getString("admin.server.core.mbean.config.deploy_not_directory", archiveName);
            throw new DeploymentException(msg);
        }
        if (!bDirectory && !f.isFile()) {
            String msg = localStrings.getString("admin.server.core.mbean.config.deploy_not_file", archiveName);
            throw new DeploymentException(msg);
        }
    }

    public String getInstanceRoot() {
        InstanceEnvironment env = new InstanceEnvironment(this.mInstanceName);
        return env.getInstancesRoot();
    }

    private void checkWebModuleReferences(String webModuleName) throws ConfigException {
        ArrayList<String> virtualServerIds = new ArrayList<String>();
        ConfigContext context = super.getConfigContext();
        Config config = (Config)super.getConfigBeanByXPath("/domain/configs/config[@name='server-config']");
        HttpService httpService = config.getHttpService();
        VirtualServer[] virtualServers = httpService.getVirtualServer();
        for (int j = 0; j < virtualServers.length; ++j) {
            VirtualServer aServer = virtualServers[j];
            String defWebModule = aServer.getDefaultWebModule();
            if (defWebModule == null || !defWebModule.equals(webModuleName)) continue;
            virtualServerIds.add(aServer.getId());
        }
        if (!virtualServerIds.isEmpty()) {
            throw new ConfigException(localStrings.getString("admin.server.core.mbean.config.def_web_module_refs_exist", virtualServerIds.toString(), webModuleName));
        }
    }

    private void chownDir(File dir, String user) {
        if (dir == null || user == null || user.trim().equals("")) {
            return;
        }
        Object err = null;
    }

    public void addAdminObject(String type, Properties properties, String raName, String jndiName) throws AFResourceException {
        try {
            sLogger.log(Level.FINE, "mbean.create_admin_object_resource", jndiName);
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            AdminObjectResource resource = new AdminObjectResource();
            resource.setJndiName(jndiName);
            resource.setResType(type);
            resource.setResAdapter(raName);
            resourcesBean.addAdminObjectResource(resource);
            Enumeration<Object> e = properties.keys();
            ElementProperty el = null;
            while (e.hasMoreElements()) {
                String n = (String)e.nextElement();
                String v = (String)properties.get(n);
                el = new ElementProperty();
                el.setName(n);
                el.setValue(v);
                resource.addElementProperty(el);
            }
            this.createResourceRef(jndiName);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.create_resource_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public void deleteAdminObject(String jndiName) throws AFResourceException {
        sLogger.log(Level.FINE, "mbean.delele_admin_object", jndiName);
        try {
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            AdminObjectResource resource = resourcesBean.getAdminObjectResourceByJndiName(jndiName);
            if (resource == null) {
                String msg = localStrings.getString("admin.server.core.mbean.config.no_such_resource", jndiName);
                throw new Exception(msg);
            }
            resourcesBean.removeAdminObjectResource(resource);
            this.deleteResourceRef(jndiName);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.delete_connector_connection_pool_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public String[] listAdminObjects() throws AFException {
        String[] sa = null;
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            AdminObjectResource[] resources = resourcesBean.getAdminObjectResource();
            if (resources != null) {
                sa = new String[resources.length];
                for (int i = 0; i < resources.length; ++i) {
                    sa[i] = resources[i].getJndiName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new AFException(e.getLocalizedMessage());
        }
        return sa;
    }

    public void createConnectorConnectionPool(String raName, String conDefn, String steadyPoolSize, String maxPoolSize, String maxWaitTime, String poolResizeQty, String idleTimeout, Boolean failAllConns, Properties properties, String poolName) throws AFResourceException {
        try {
            sLogger.log(Level.FINE, "mbean.create_connector_connection_pool", poolName);
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            ConnectorConnectionPool conPool = new ConnectorConnectionPool();
            conPool.setResourceAdapterName(raName);
            conPool.setConnectionDefinitionName(conDefn);
            if (steadyPoolSize != null) {
                conPool.setSteadyPoolSize(steadyPoolSize);
            }
            if (maxPoolSize != null) {
                conPool.setMaxPoolSize(maxPoolSize);
            }
            if (maxWaitTime != null) {
                conPool.setMaxWaitTimeInMillis(maxWaitTime);
            }
            if (poolResizeQty != null) {
                conPool.setPoolResizeQuantity(poolResizeQty);
            }
            if (idleTimeout != null) {
                conPool.setIdleTimeoutInSeconds(idleTimeout);
            }
            if (failAllConns != null) {
                conPool.setFailAllConnections(failAllConns);
            }
            conPool.setName(poolName);
            resourcesBean.addConnectorConnectionPool(conPool);
            if (properties != null) {
                Enumeration<Object> e = properties.keys();
                ElementProperty el = null;
                while (e.hasMoreElements()) {
                    String n = (String)e.nextElement();
                    String v = (String)properties.get(n);
                    el = new ElementProperty();
                    el.setName(n);
                    el.setValue(v);
                    conPool.addElementProperty(el);
                }
            }
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.create_resource_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public void deleteConnectorConnectionPool(String poolName) throws AFResourceException {
        ArgChecker.checkValid(poolName, "poolName", StringValidator.getInstance());
        sLogger.log(Level.FINE, "mbean.delele_connector_connection_pool", poolName);
        try {
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            ConnectorConnectionPool resource = resourcesBean.getConnectorConnectionPoolByName(poolName);
            if (resource == null) {
                // empty if block
            }
            resourcesBean.removeConnectorConnectionPool(resource);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.delete_connector_connection_pool_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public String[] listConnectorConnectionPools() throws AFException {
        String[] sa = null;
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            ConnectorConnectionPool[] connectionPools = resourcesBean.getConnectorConnectionPool();
            if (connectionPools != null) {
                sa = new String[connectionPools.length];
                for (int i = 0; i < connectionPools.length; ++i) {
                    sa[i] = connectionPools[i].getName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new AFException(e.getLocalizedMessage());
        }
        return sa;
    }

    public void createConnectorResource(String jndiName, String poolName, String description, Boolean enabled, Properties properties) throws AFResourceException {
        try {
            sLogger.log(Level.FINE, "mbean.create_resource", jndiName);
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            ConnectorResource resource = new ConnectorResource();
            resource.setJndiName(jndiName);
            resource.setPoolName(poolName);
            if (description != null) {
                resource.setDescription(description);
            }
            resourcesBean.addConnectorResource(resource);
            if (properties != null) {
                Enumeration<Object> e = properties.keys();
                ElementProperty el = null;
                while (e.hasMoreElements()) {
                    String n = (String)e.nextElement();
                    String v = (String)properties.get(n);
                    el = new ElementProperty();
                    el.setName(n);
                    el.setValue(v);
                    resource.addElementProperty(el);
                }
            }
            this.createResourceRef(jndiName);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.create_resource_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public void deleteConnectorResource(String jndiName) throws AFResourceException {
        sLogger.log(Level.FINE, "mbean.delete_connector_resource", jndiName);
        try {
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            ConnectorResource resource = resourcesBean.getConnectorResourceByJndiName(jndiName);
            if (resource == null) {
                String msg = localStrings.getString("admin.server.core.mbean.config.no_such_resource", jndiName);
                throw new Exception(msg);
            }
            resourcesBean.removeConnectorResource(resource);
            this.deleteResourceRef(jndiName);
            serverContext.flush();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.delete_connector_connection_pool_failed", e);
            throw new AFResourceException(e.getLocalizedMessage());
        }
    }

    public String[] listConnectorResources() throws AFException {
        String[] sa = null;
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            ConnectorResource[] resources = resourcesBean.getConnectorResource();
            if (resources != null) {
                sa = new String[resources.length];
                for (int i = 0; i < resources.length; ++i) {
                    sa[i] = resources[i].getJndiName();
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_failed", e);
            throw new AFException(e.getLocalizedMessage());
        }
        return sa;
    }

    private void transform(InstanceEnvironment ie) {
    }

    public String[] listConnectorJMSResources(String type) throws AFException {
        Vector<String> v = new Vector<String>();
        String[] sa = null;
        boolean j = false;
        try {
            int i;
            ConfigBean[] resources;
            sLogger.log(Level.FINE, "mbean.list_jms_resources");
            ConfigContext serverContext = this.getConfigContext(this.mInstanceName);
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            if ((type == null || type.equals("javax.jms.TopicConnectionFactory") || type.equals("javax.jms.QueueConnectionFactory")) && (resources = resourcesBean.getConnectorResource()) != null) {
                sa = new String[resources.length];
                for (i = 0; i < resources.length; ++i) {
                    String jndiName = ((ConnectorResource)resources[i]).getJndiName();
                    String defPoolName = ConnectorRuntime.getRuntime().getDefaultPoolName(jndiName);
                    if (!((ConnectorResource)resources[i]).getPoolName().equals(defPoolName)) continue;
                    ConnectorConnectionPool poolResource = resourcesBean.getConnectorConnectionPoolByName(defPoolName);
                    if (type != null && (poolResource == null || !poolResource.getConnectionDefinitionName().equals(type))) continue;
                    v.addElement(((ConnectorResource)resources[i]).getJndiName());
                }
            }
            if ((type == null || type.equals("javax.jms.Topic") || type.equals("javax.jms.Queue")) && (resources = resourcesBean.getAdminObjectResource()) != null) {
                sa = new String[resources.length];
                for (i = 0; i < resources.length; ++i) {
                    if (type != null && !((AdminObjectResource)resources[i]).getResType().equals(type)) continue;
                    v.addElement(((AdminObjectResource)resources[i]).getJndiName());
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.list_jms_resources_failed", e);
            throw new AFException(e.getLocalizedMessage());
        }
        sa = new String[v.size()];
        for (int k = 0; k < sa.length; ++k) {
            sa[k] = (String)v.elementAt(k);
        }
        return sa;
    }

    private static final class ManagedInstanceTimer
    implements Runnable {
        private final int timeOutSeconds;
        private final TimerCallback callBack;
        private final int startAfterSeconds;
        private boolean timeOutReached;
        private long startTime;

        ManagedInstanceTimer(int timeOutSeconds, int startAfterSeconds, TimerCallback callBack) {
            this.timeOutSeconds = timeOutSeconds;
            this.startAfterSeconds = startAfterSeconds;
            this.callBack = callBack;
            this.timeOutReached = false;
        }

        public void run() {
            this.startTime = System.currentTimeMillis();
            try {
                Thread.currentThread();
                Thread.sleep(this.startAfterSeconds * 1000);
                while (!this.timeOutReached() && !this.callBack.check()) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                        this.computeTimeOut();
                    }
                    catch (InterruptedException ie) {
                        sLogger.warning(ie.toString());
                        this.timeOutReached = true;
                    }
                }
            }
            catch (Exception e) {
                sLogger.warning(e.toString());
                this.timeOutReached = true;
            }
        }

        private boolean timeOutReached() {
            return this.timeOutReached;
        }

        private void computeTimeOut() {
            long currentTime = System.currentTimeMillis();
            this.timeOutReached = currentTime - this.startTime >= (long)(this.timeOutSeconds * 1000);
        }
    }

    static interface TimerCallback {
        public boolean check() throws Exception;
    }
}

