/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config.naming;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.enterprise.admin.common.Name;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.server.core.mbean.config.naming.ConfigMBeanNamingInfo;
import com.sun.enterprise.admin.server.core.mbean.config.naming.MBeanNamingDescriptor;
import com.sun.enterprise.admin.server.core.mbean.config.naming.MBeansDescriptions;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.instance.InstanceEnvironment;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class ConfigMBeansNaming
extends MBeansDescriptions {
    static MBeanNamingDescriptor[] m_mbeanDescr = ConfigMBeansNaming.initConfigMBeanNaming();
    public static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final String MSG_FINDNAMINDESCRIPTOR_FAILED = "mbean.config.findnamingdescriptor_failed";
    private static final String MSG_MALFORMED_DOTTED_NAME = "mbean.config.malformed_dotted_name";
    private static final String MSG_EXCEPTION_DURING_LIST_NAMES = "mbean.config.list_names_failed";

    static MBeanNamingDescriptor findNamingDescriptorByType(String type) {
        try {
            for (int i = 0; i < m_mbeanDescr.length; ++i) {
                if (!type.equals(m_mbeanDescr[i].getType())) continue;
                return m_mbeanDescr[i];
            }
        }
        catch (Exception e) {
            sLogger.log(Level.FINE, MSG_FINDNAMINDESCRIPTOR_FAILED, e);
        }
        return null;
    }

    static MBeanNamingDescriptor findNamingDescriptor(String dottedName) {
        try {
            Name name = new Name(dottedName);
            for (int i = 0; i < m_mbeanDescr.length; ++i) {
                if (!m_mbeanDescr[i].isDottedPatternMatch(name)) continue;
                return m_mbeanDescr[i];
            }
        }
        catch (Exception e) {
            sLogger.log(Level.FINE, MSG_FINDNAMINDESCRIPTOR_FAILED, e);
        }
        return null;
    }

    static MBeanNamingDescriptor findNamingDescriptor(ObjectName objectName) {
        try {
            Hashtable<String, String> ht = objectName.getKeyPropertyList();
            for (int i = 0; i < m_mbeanDescr.length; ++i) {
                if (!m_mbeanDescr[i].isObjectNamePatternMatch(ht)) continue;
                return m_mbeanDescr[i];
            }
        }
        catch (Exception e) {
            sLogger.log(Level.FINE, MSG_FINDNAMINDESCRIPTOR_FAILED, e);
        }
        return null;
    }

    public static String[] findNameContinuation(String instanceName, String dottedName) {
        HashSet<String> hs = new HashSet<String>();
        int wildDescrIndex = -1;
        Name name = null;
        int nNameTokens = 0;
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment(instanceName);
        try {
            name = new Name(dottedName);
            nNameTokens = name.getNumParts();
        }
        catch (Exception e) {
            sLogger.log(Level.FINE, MSG_MALFORMED_DOTTED_NAME, e);
            return new String[0];
        }
        for (int i = 0; i < m_mbeanDescr.length; ++i) {
            Object[][] tokens = m_mbeanDescr[i].getDottedTokens();
            if (tokens == null) continue;
            for (int j = 0; j < tokens.length; ++j) {
                if (!MBeanNamingDescriptor.isDottedPatternMatch(name, tokens[j], false) || tokens[j].length <= nNameTokens) continue;
                if (!(tokens[j][nNameTokens] instanceof String)) {
                    if (tokens[j].length != nNameTokens + 1) continue;
                    wildDescrIndex = i;
                    continue;
                }
                hs.add(dottedName + "." + tokens[j][nNameTokens]);
            }
        }
        String xpath = null;
        if (wildDescrIndex >= 0) {
            try {
                ConfigMBeanNamingInfo info = new ConfigMBeanNamingInfo(dottedName + ".fake");
                xpath = info.getXPath();
            }
            catch (Exception e) {
                sLogger.log(Level.FINE, MSG_EXCEPTION_DURING_LIST_NAMES, e);
            }
        }
        if (xpath != null) {
            String attributeName = null;
            String elementName = null;
            if ((xpath = xpath.trim()).length() > 0 && xpath.endsWith("]")) {
                int i = xpath.lastIndexOf(64) + 1;
                int j = xpath.indexOf(61, i);
                if (i > 0 && j > i) {
                    attributeName = xpath.substring(i, j).trim();
                    j = xpath.lastIndexOf(91);
                    if (j > 0 && j < i && (j = (xpath = xpath.substring(0, j)).lastIndexOf(47)) > 0 && j < xpath.length() - 2) {
                        elementName = xpath.substring(j + 1).trim();
                        xpath = xpath.substring(0, j);
                    }
                }
            }
            if (attributeName != null && elementName != null) {
                try {
                    String fileUrl = instanceEnvironment.getConfigFilePath();
                    ConfigContext configContext = ConfigFactory.createConfigContext(fileUrl);
                    ConfigBean bean = ConfigBeansFactory.getConfigBeanByXPath(configContext, xpath);
                    ConfigBean[] childs = bean.getChildBeansByName(elementName);
                    for (int i = 0; i < childs.length; ++i) {
                        String next = childs[i].getAttributeValue(attributeName);
                        if (next == null) continue;
                        hs.add(dottedName + "." + next);
                    }
                }
                catch (ConfigException ce) {
                    sLogger.log(Level.FINE, MSG_EXCEPTION_DURING_LIST_NAMES, ce);
                }
                catch (NullPointerException npe) {
                    sLogger.log(Level.FINE, MSG_EXCEPTION_DURING_LIST_NAMES, npe);
                }
            }
        }
        return hs.toArray(new String[hs.size()]);
    }

    private static synchronized MBeanNamingDescriptor[] initConfigMBeanNaming() {
        MBeanNamingDescriptor[] descrs = null;
        try {
            descrs = new MBeanNamingDescriptor[mbean_descriptions.length];
            for (int i = 0; i < mbean_descriptions.length; ++i) {
                descrs[i] = new MBeanNamingDescriptor(mbean_descriptions[i]);
            }
        }
        catch (MBeanConfigException mBeanConfigException) {
            // empty catch block
        }
        return descrs;
    }

    public static void main(String[] args) {
        ConfigMBeansNaming.testDottedName("myInstance.http-listener.myListener");
        ConfigMBeansNaming.testDottedName("myInstance.http-listener");
        ConfigMBeansNaming.testDottedName("myInstance.http-server");
        ConfigMBeansNaming.testDottedName("myInstance.http-server.mymy");
        ConfigMBeansNaming.testDottedName("myInstance.http-listeners.myListener");
        ConfigMBeansNaming.testDottedName("myInstance.http-serve");
        ConfigMBeansNaming.testDottedName("myInstance.http-server.http-listener.myListener");
        try {
            String dmn = "com.sun.appserv";
            ConfigMBeansNaming.testObjectName(JMXUtil.newObjectName("com.sun.appserv", "type=http-listener,instance-name=myServer,name=myListener"));
            ConfigMBeansNaming.testObjectName(JMXUtil.newObjectName("com.sun.appserv", "type=http-listener,instance-name=myServer,name=myListener,chtoto=to"));
            ConfigMBeansNaming.testObjectName(JMXUtil.newObjectName("com.sun.appserv", "type=http-service,instance-name=myServer,name=jhgv"));
            ConfigMBeansNaming.testObjectName(JMXUtil.newObjectName("com.sun.appserv", "type=http-service,server-instances=myServer"));
            ConfigMBeansNaming.testObjectName(JMXUtil.newObjectName("com.sun.appserv", "type=http-service,instance-name=myServer"));
            ConfigMBeansNaming.testObjectName(JMXUtil.newObjectName("com.sun.appserv", "type=http-listener,name=myListener,instance-name=myServer"));
        }
        catch (Throwable e) {
            ConfigMBeansNaming.print(">>>>>>EXCEPTION: " + e);
            e.printStackTrace();
        }
    }

    private static void print(String str) {
        System.out.println(str);
    }

    private static void testDottedName(String dottedName) {
        try {
            ConfigMBeansNaming.print("\n\n\n>>>>>>test for dotted name: " + dottedName);
            ConfigMBeanNamingInfo mbi = new ConfigMBeanNamingInfo(dottedName);
            ConfigMBeansNaming.print("       ConfigMBeanNamingInfo =" + mbi);
            ConfigMBeansNaming.print("       ObjectName =" + mbi.getObjectName());
            ConfigMBeansNaming.print("       XPath      =" + mbi.getXPath());
        }
        catch (Throwable e) {
            ConfigMBeansNaming.print(">>>>>>EXCEPTION: " + e);
        }
    }

    private static void testObjectName(ObjectName name) {
        try {
            ConfigMBeansNaming.print("\n\n\n>>>>>>test for object name: " + name);
            ConfigMBeanNamingInfo mbi = new ConfigMBeanNamingInfo(name);
            ConfigMBeansNaming.print("       ConfigMBeanNamingInfo =" + mbi);
            ConfigMBeansNaming.print("       ObjectName =" + mbi.getObjectName());
            ConfigMBeansNaming.print("       XPath      =" + mbi.getXPath());
        }
        catch (Throwable e) {
            ConfigMBeansNaming.print(">>>>>>EXCEPTION: " + e);
            e.printStackTrace();
        }
    }
}

