/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.servermgmt.InstancesManager;
import com.sun.enterprise.server.logging.FileandSyslogHandler;
import com.sun.enterprise.util.LocalStrings;
import com.sun.enterprise.util.LocalStringsImpl;
import java.io.Serializable;
import java.util.Vector;

public class RuntimeStatus
implements Serializable {
    private boolean _restartNeeded;
    private Status _status;
    private Vector _recentErrorMessages;
    private String _name;
    private boolean stopCluster = false;
    private boolean startCluster = false;
    private RuntimeStatus beforeRTStatus = null;

    public static RuntimeStatus getRuntimeStatus(String name, InstancesManager manager) throws InstanceException {
        int status2 = manager.getInstanceStatus();
        return new RuntimeStatus(name, manager.isRestartNeeded(), new Status(status2, Status.getStatusString(status2)), FileandSyslogHandler.getRecentErrorMessages());
    }

    public static void clearRuntimeStatus() {
        FileandSyslogHandler.clearRecentErrorMessages();
    }

    public RuntimeStatus() {
        this("", true, new Status(3, Status.kInstanceNotRunningMsg), new Vector());
    }

    public RuntimeStatus(String name) {
        this();
        this._name = name;
    }

    public RuntimeStatus(String name, boolean restartNeeded, Status status2, Vector recentErrors) {
        this._name = name;
        this._restartNeeded = restartNeeded;
        this._status = status2;
        this._recentErrorMessages = recentErrors;
    }

    public void setStopClusterFlag(RuntimeStatus before) {
        this.stopCluster = true;
        this.beforeRTStatus = before;
    }

    public void setStartClusterFlag(RuntimeStatus before) {
        this.startCluster = true;
        this.beforeRTStatus = before;
    }

    public boolean isRestartNeeded() {
        return this._restartNeeded;
    }

    public String getName() {
        return this._name;
    }

    public void setStatus(Status status2) {
        this._status = status2;
    }

    public Status getStatus() {
        return this._status;
    }

    public Vector getRecentErrorMessages() {
        return this._recentErrorMessages;
    }

    public boolean isRunning() {
        return this.getStatus().getStatusCode() == 0;
    }

    public boolean isStopped() {
        return this.getStatus().getStatusCode() == 3;
    }

    public String toShortString() {
        String result = this.getStatus().getStatusString();
        if (this.isRunning() && this.isRestartNeeded()) {
            result = LocalStrings.get("requiresRestartYes");
        }
        return result;
    }

    public String toString() {
        if (this.stopCluster) {
            return this.toStringStopCluster();
        }
        if (this.startCluster) {
            return this.toStringStartCluster();
        }
        return this.toStringRegular();
    }

    public void resetRecentErrorMessages() {
        this._recentErrorMessages = new Vector();
    }

    public String toStringStartCluster() {
        if (this.beforeRTStatus == null) {
            return this.toStringRegular();
        }
        int afterCode = this.getStatus().getStatusCode();
        int beforeCode = this.beforeRTStatus.getStatus().getStatusCode();
        boolean beforeStarted = beforeCode == 0;
        boolean afterStarted = afterCode == 0;
        LocalStringsImpl stringy = new LocalStringsImpl();
        String name = this.getName();
        String beforeString = this.beforeRTStatus.getStatus().getStatusString();
        String afterString = this.getStatus().getStatusString();
        String result = "";
        if (beforeStarted && afterStarted) {
            result = stringy.get("runtimeStatusToStringStartCluster.alreadyStarted", name);
        } else if (!beforeStarted && afterStarted) {
            result = stringy.get("runtimeStatusToStringStartCluster.success", name);
        } else if (beforeStarted && !afterStarted) {
            result = stringy.get("runtimeStatusToStringStartCluster.startedToStopped", name, afterString);
            System.err.println(result);
        } else if (!beforeStarted && !afterStarted) {
            result = stringy.get("runtimeStatusToStringStartCluster.error", name, beforeString, afterString);
        }
        Vector messages = this.getRecentErrorMessages();
        for (int i = 0; i < messages.size(); ++i) {
            result = result + "\n" + stringy.get("error") + " " + i + " " + (String)messages.get(i);
        }
        return result;
    }

    public String toStringStopCluster() {
        if (this.beforeRTStatus == null) {
            return this.toStringRegular();
        }
        int afterCode = this.getStatus().getStatusCode();
        int beforeCode = this.beforeRTStatus.getStatus().getStatusCode();
        boolean beforeStopped = beforeCode == 3;
        boolean afterStopped = afterCode == 3;
        LocalStringsImpl stringy = new LocalStringsImpl();
        String name = this.getName();
        String beforeString = this.beforeRTStatus.getStatus().getStatusString();
        String afterString = this.getStatus().getStatusString();
        String result = "";
        if (beforeStopped && afterStopped) {
            result = stringy.get("runtimeStatusToStringStopCluster.alreadyStopped", name);
        } else if (!beforeStopped && afterStopped) {
            result = stringy.get("runtimeStatusToStringStopCluster.success", name);
        } else if (beforeStopped && !afterStopped) {
            result = stringy.get("runtimeStatusToStringStopCluster.stoppedToRunning", name, afterString);
            System.err.println(result);
        } else if (!beforeStopped && !afterStopped) {
            result = stringy.get("runtimeStatusToStringStopCluster.error", name, beforeString, afterString);
        }
        Vector messages = this.getRecentErrorMessages();
        for (int i = 0; i < messages.size(); ++i) {
            result = result + "\n" + stringy.get("error") + " " + i + " " + (String)messages.get(i);
        }
        return result;
    }

    private String toStringRegular() {
        LocalStringsImpl stringy = new LocalStringsImpl();
        String result = stringy.get("runtimeStatusToString", this.getName(), this.getStatus().getStatusString());
        result = this.isRestartNeeded() ? result + ", " + stringy.get("requiresRestartYes") : result + ", " + stringy.get("requiresRestartNo");
        Vector messages = this.getRecentErrorMessages();
        for (int i = 0; i < messages.size(); ++i) {
            result = result + "\n" + stringy.get("error") + " " + i + " " + (String)messages.get(i);
        }
        return result;
    }
}

