/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.pe;

import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.ShutdownEvent;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.servermgmt.InstancesManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.admin.servermgmt.launch.ASLauncher;
import com.sun.enterprise.admin.servermgmt.launch.ASLauncherException;
import com.sun.enterprise.admin.servermgmt.launch.ASNativeLauncher;
import com.sun.enterprise.admin.servermgmt.pe.InstanceTimer;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.admin.servermgmt.pe.TimerCallback;
import com.sun.enterprise.util.JvmInfoUtil;
import com.sun.enterprise.util.ProcessExecutor;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEInstancesManager
extends RepositoryManager
implements InstancesManager {
    protected static final int NO_PROCESS = -1;
    private static final StringManager _strMgr = StringManager.getManager(PEInstancesManager.class);
    private final RepositoryConfig _config;
    private Properties systemPropsCopy;
    private String[] securityInfo;
    private boolean verbose = false;
    private boolean debug = true;
    private boolean nativeLauncher = false;
    private Properties envProps;
    private RMIClient rmiClient = null;

    public PEInstancesManager(RepositoryConfig config) {
        this._config = config;
    }

    @Override
    public String getNativeName() {
        return "appservDAS";
    }

    protected RepositoryConfig getConfig() {
        return this._config;
    }

    @Override
    public void createInstance() throws InstanceException {
        throw new UnsupportedOperationException(_strMgr.getString("notSupported"));
    }

    @Override
    public void deleteInstance() throws InstanceException {
        throw new UnsupportedOperationException(_strMgr.getString("notSupported"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Process startInstance(String[] SecurityInfo, String[] commandLineArgs, Properties EnvProps) throws InstanceException {
        Process process = null;
        this.securityInfo = SecurityInfo;
        this.envProps = EnvProps;
        if (this.envProps == null) {
            this.envProps = new Properties();
        }
        this.nativeLauncher = Boolean.getBoolean("com.sun.aas.nativeLauncher");
        String s = System.getenv("OLD_LAUNCHER");
        if (s != null && s.equals("true")) {
            return this.startInstanceUsingScript(commandLineArgs);
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            try {
                this.saveSystemProps();
                process = this.startInstanceAllJava(commandLineArgs);
            }
            finally {
                this.restoreSystemProps();
            }
        }
        if (!this.verbose || this.nativeLauncher) {
            this.waitUntilStarting(null);
            this.waitUntilStarted();
            this.postStart();
        }
        return process;
    }

    @Override
    public Process startInstance(String[] interativeOptions, String[] commandLineArgs) throws InstanceException {
        return this.startInstance(interativeOptions, commandLineArgs, null);
    }

    @Override
    public Process startInstance() throws InstanceException {
        return this.startInstance(null, null);
    }

    @Override
    public Process startInstance(String[] interativeOptions) throws InstanceException {
        String[] commandLineArgs = null;
        return this.startInstance(interativeOptions, commandLineArgs);
    }

    private Process startInstanceAllJava(String[] commandLineArgs) throws InstanceException {
        Process process;
        block12: {
            process = null;
            try {
                this.verbose = false;
                this.debug = false;
                this.preStart();
                if (this.isTrue((Boolean)this.getConfig().get("domain.verbose"))) {
                    this.verbose = true;
                }
                if (this.isTrue((Boolean)this.getConfig().get("domain.debug"))) {
                    this.debug = true;
                }
                this.setSecurity();
                ArrayList<String> args = new ArrayList<String>();
                args.add("start");
                if (this.nativeLauncher) {
                    args.add("display");
                }
                if (this.debug) {
                    args.add("debug");
                }
                if (this.verbose) {
                    args.add("verbose");
                }
                if (commandLineArgs != null) {
                    for (String arg : commandLineArgs) {
                        if (args.contains(arg)) continue;
                        args.add(arg);
                    }
                }
                String[] launcherArgs = args.toArray(new String[args.size()]);
                System.setProperty("com.sun.aas.instanceRoot", this.getConfig().getRepositoryRoot() + File.separator + this.getConfig().getRepositoryName());
                if (this.nativeLauncher) {
                    ASNativeLauncher launcher = new ASNativeLauncher(this);
                    launcher.preProcess(launcherArgs, this.envProps);
                    try {
                        process = launcher.launch(launcherArgs, this.securityInfo);
                        break block12;
                    }
                    catch (ASLauncherException e) {
                        throw new InstanceException(e);
                    }
                }
                ASLauncher launcher = new ASLauncher();
                launcher.setRefreshConfigContext(this._config.getRefreshConfigContext());
                launcher.preProcess(launcherArgs, this.envProps);
                process = launcher.process(launcherArgs, this.securityInfo);
            }
            catch (Exception ex) {
                throw new InstanceException(this.getMessages().getInstanceStartupExceptionMessage(this.getConfig().getDisplayName()), ex);
            }
        }
        return process;
    }

    private Process startInstanceUsingScript(String[] commandLineArgs) throws InstanceException {
        this.preStart();
        Boolean v = (Boolean)this.getConfig().get("domain.verbose");
        this.verbose = false;
        if (v != null) {
            this.verbose = v;
        }
        Boolean d = (Boolean)this.getConfig().get("domain.debug");
        this.debug = false;
        if (d != null) {
            this.debug = d;
        }
        String[] command = null;
        File script = this.getFileLayout(this.getConfig()).getStartServ();
        Process process = null;
        ArrayList<String> alCmd = new ArrayList<String>();
        alCmd.add(script.getAbsolutePath());
        alCmd.add("cli");
        if (System.getProperty("com.sun.aas.processLauncher") == null && this.verbose) {
            try {
                System.setProperty("com.sun.aas.instanceRoot", this.getConfig().getRepositoryRoot() + File.separator + this.getConfig().getRepositoryName());
                ArrayList<String> args = new ArrayList<String>();
                args.add("s1as-server");
                args.add("-Dcom.sun.aas.instanceName=server");
                args.add("start");
                if (this.debug) {
                    args.add("debug");
                }
                if (this.verbose) {
                    args.add("verbose");
                }
                if (commandLineArgs != null) {
                    for (int ii = 0; ii < commandLineArgs.length; ++ii) {
                        args.add(commandLineArgs[ii]);
                    }
                }
                String[] argStrings = args.toArray(new String[args.size()]);
                Class<?> launcherClass = Class.forName("LauncherBootstrap");
                Class[] paramClasses = new Class[]{String[].class};
                Object[] argsArray = new Object[]{argStrings};
                Method mainMethod = launcherClass.getMethod("main", paramClasses);
                mainMethod.invoke(null, argsArray);
            }
            catch (Exception ex) {
                throw new InstanceException(this.getMessages().getInstanceStartupExceptionMessage(this.getConfig().getDisplayName()), ex);
            }
        } else if (System.getProperty("com.sun.aas.processLauncher") != null && this.verbose) {
            if (this.nativeLauncher) {
                alCmd.add("native");
            }
            if (this.debug) {
                alCmd.add("debug");
            }
            if (this.verbose) {
                alCmd.add("verbose");
            }
            if (commandLineArgs != null) {
                for (int ii = 0; ii < commandLineArgs.length; ++ii) {
                    alCmd.add(commandLineArgs[ii]);
                }
            }
            command = new String[alCmd.size()];
            command = alCmd.toArray(command);
            try {
                ProcessExecutor exec = new ProcessExecutor(command, this.securityInfo);
                exec.setVerbose(this.verbose);
                exec.execute(false, false);
                process = exec.getSubProcess();
                int exitValue = process.waitFor();
                System.exit(exitValue);
            }
            catch (Exception e) {
                throw new InstanceException(_strMgr.getString("procExecError"), e);
            }
        } else {
            if (this.nativeLauncher) {
                alCmd.add("native");
            }
            if (this.debug) {
                alCmd.add("debug");
            }
            if (commandLineArgs != null) {
                for (int ii = 0; ii < commandLineArgs.length; ++ii) {
                    alCmd.add(commandLineArgs[ii]);
                }
            }
            command = new String[alCmd.size()];
            command = alCmd.toArray(command);
            ProcessExecutor processExec = this.startInstanceExecute(command, this.securityInfo);
            process = processExec.getSubProcess();
            this.waitUntilStarting(processExec);
            this.waitUntilStarted();
            this.postStart();
        }
        return process;
    }

    protected ProcessExecutor startInstanceExecute(String[] command, String[] SecurityInfo) throws InstanceException {
        return this.execute(command, SecurityInfo);
    }

    @Override
    public void stopInstance() throws InstanceException {
        if (!this.isStoppable()) {
            return;
        }
        RMIClient rmiClient = this.getRMIClient();
        String instanceName = this.getConfig().getInstanceName();
        if (!this.ok(instanceName)) {
            instanceName = "server";
        }
        ShutdownEvent shutdownEvent = new ShutdownEvent(instanceName);
        AdminEventResult result = rmiClient.sendNotification(shutdownEvent);
        this.waitUntilStopped(60);
        this.postStop();
    }

    @Override
    public boolean stopInstanceWithinTime(int timeout) throws InstanceException {
        if (!this.isStoppable()) {
            return true;
        }
        RMIClient rmiClient = this.getRMIClient();
        String instanceName = this.getConfig().getInstanceName();
        if (!this.ok(instanceName)) {
            instanceName = "server";
        }
        ShutdownEvent shutdownEvent = new ShutdownEvent(instanceName);
        AdminEventResult result = rmiClient.sendNotification(shutdownEvent);
        this.waitUntilStopped(timeout);
        if (this.isInstanceNotRunning()) {
            this.postStop();
            return true;
        }
        return false;
    }

    public void stopInstanceScript() throws InstanceException {
        if (!this.isStoppable()) {
            return;
        }
        this.execute(this.getFileLayout(this.getConfig()).getStopServ());
        this.waitUntilStopped(60);
        this.postStop();
    }

    @Override
    public String[] listInstances() throws InstanceException {
        throw new UnsupportedOperationException(_strMgr.getString("notSupported"));
    }

    public boolean isInstanceStarting() throws InstanceException {
        return this.getInstanceStatus() == 1;
    }

    public boolean isInstanceRunning() throws InstanceException {
        return 0 == this.getInstanceStatus();
    }

    public boolean isInstanceFailed() throws InstanceException {
        return 8 == this.getInstanceStatus();
    }

    public boolean isInstanceNotRunning() throws InstanceException {
        return 3 == this.getInstanceStatus();
    }

    @Override
    public boolean isRestartNeeded() throws InstanceException {
        boolean isRestartNeeded = false;
        try {
            isRestartNeeded = this.getRMIClient().isRestartNeeded();
        }
        catch (Exception e) {
            throw new InstanceException(e.getMessage(), e);
        }
        return isRestartNeeded;
    }

    protected void preStart() throws InstanceException {
        int state = this.getInstanceStatus();
        if (3 != state) {
            throw new InstanceException(this.getMessages().getCannotStartInstanceInvalidStateMessage(this.getConfig().getDisplayName(), Status.getStatusString(state)));
        }
    }

    void postStart() throws InstanceException {
        if (this.isInstanceFailed()) {
            int port = this.getConflictedPort();
            this.abortServer();
            throw new InstanceException(this.getMessages().getStartupFailedMessage(this.getConfig().getDisplayName(), port));
        }
        if (!this.isInstanceRunning() && !this.isInstanceNotRunning()) {
            try {
                this.stopInstance();
            }
            catch (Exception e) {
                throw new InstanceException(this.getMessages().getStartInstanceTimeOutMessage(this.getConfig().getDisplayName()), e);
            }
            throw new InstanceException(this.getMessages().getStartInstanceTimeOutMessage(this.getConfig().getDisplayName()));
        }
        if (this.isInstanceNotRunning()) {
            throw new InstanceException(this.getMessages().getStartupFailedMessage(this.getConfig().getDisplayName()));
        }
        this.setRMIClient(null);
    }

    private boolean isStoppable() throws InstanceException {
        int state = this.getInstanceStatus();
        return state == 0 || state == 1;
    }

    void postStop() throws InstanceException {
        if (!this.isInstanceNotRunning()) {
            throw new InstanceException(this.getMessages().getCannotStopInstanceMessage(this.getConfig().getDisplayName()));
        }
        this.setRMIClient(null);
    }

    protected void waitUntilStarting(ProcessExecutor processExec) throws InstanceException {
        this.waitUntilStarting(processExec, 180);
    }

    protected void waitUntilStarting(ProcessExecutor processExec, int timeoutSeconds) throws InstanceException {
        InstanceTimer timer = new InstanceTimer(timeoutSeconds, 0, new TimerCallback(){

            public boolean check() throws Exception {
                return PEInstancesManager.this.isInstanceStarting() || PEInstancesManager.this.isInstanceRunning() || PEInstancesManager.this.isInstanceFailed();
            }
        });
        timer.run();
        if (this.getInstanceStatus() == 3) {
            throw new InstanceException(this.getMessages().getTimeoutStartingMessage(this.getConfig().getDisplayName()));
        }
    }

    protected void waitUntilStarted() throws InstanceException {
        this.waitUntilStarted(1200);
    }

    protected void waitUntilStarted(int timeoutSeconds) throws InstanceException {
        InstanceTimer timer = new InstanceTimer(timeoutSeconds, 0, new TimerCallback(){

            public boolean check() throws Exception {
                return PEInstancesManager.this.isInstanceRunning() || PEInstancesManager.this.isInstanceFailed() || PEInstancesManager.this.isInstanceNotRunning();
            }
        });
        timer.run();
    }

    void waitUntilStopped(int timeout) throws InstanceException {
        InstanceTimer timer = new InstanceTimer(timeout, 0, new TimerCallback(){

            public boolean check() throws Exception {
                return PEInstancesManager.this.isInstanceNotRunning();
            }
        });
        timer.run();
    }

    void execute(File script) throws InstanceException {
        try {
            ProcessExecutor exec = new ProcessExecutor(new String[]{script.getAbsolutePath()});
            exec.execute();
        }
        catch (Exception e) {
            throw new InstanceException(_strMgr.getString("procExecError"), e);
        }
    }

    ProcessExecutor execute(String[] command) throws InstanceException {
        return this.execute(command, null);
    }

    ProcessExecutor execute(String[] command, String[] interativeOptions) throws InstanceException {
        try {
            ProcessExecutor exec = new ProcessExecutor(command, interativeOptions);
            if (this.nativeLauncher) {
                exec.execute(false, false);
            } else {
                exec.execute();
            }
            return exec;
        }
        catch (Exception e) {
            throw new InstanceException(_strMgr.getString("procExecError"), e);
        }
    }

    protected PEFileLayout getFileLayout() {
        return super.getFileLayout(this.getConfig());
    }

    int getConflictedPort() {
        int port = 0;
        try {
            port = this.getRMIClient().getConflictedPort();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port;
    }

    void abortServer() {
        try {
            this.getRMIClient().triggerServerExit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public int getInstanceStatus() throws InstanceException {
        int status2 = Integer.MIN_VALUE;
        try {
            status2 = this.getRMIClient().getInstanceStatusCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return status2;
    }

    @Override
    public void killRelatedProcesses() throws InstanceException {
        List<String> pids = this.getPIDsToBeKilled();
        if (!pids.isEmpty()) {
            int exitValue = this.executeKillServ(pids);
            if (this.debug) {
                System.out.println("Exit value is = " + exitValue);
            }
            if (exitValue != 0) {
                throw new InstanceException(this.getMessages().getCannotStopInstanceMessage(this.getConfig().getDisplayName()));
            }
        } else {
            throw new InstanceException(_strMgr.getString("noPidsToKill"));
        }
    }

    protected List<String> getPIDsToBeKilled() throws InstanceException {
        File pidFile;
        ArrayList<String> pids = new ArrayList<String>();
        int pid = -1;
        File pidFileDir = this.getFileLayout().getConfigRoot();
        if (!this.isPIDFileValid(pidFileDir, pidFile = new File(pidFileDir, ".__com_sun_appserv_pid"))) {
            return pids;
        }
        pid = JvmInfoUtil.getPIDfromFileAndDelete(pidFile);
        if (pid != -1) {
            pids.add("" + pid);
        }
        return pids;
    }

    protected boolean isPIDFileValid(File pidFileDir, File pidFile) {
        File refTSFile = new File(pidFileDir, "admsn");
        return pidFile.lastModified() >= refTSFile.lastModified();
    }

    protected int executeKillServ(List<String> pidList) throws InstanceException {
        if (this.debug) {
            System.out.println("PID fed to killserv is = " + pidList);
        }
        try {
            String killServScript = this.fetchKillServ();
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add(killServScript);
            cmds.addAll(pidList);
            ProcessBuilder pb = new ProcessBuilder(cmds);
            Process killer = pb.start();
            return killer.waitFor();
        }
        catch (Exception ex) {
            throw new InstanceException(ex);
        }
    }

    private String fetchKillServ() throws Exception {
        File killServ;
        String killServScript = this.getConfig().getRepositoryRoot() + File.separator + this.getConfig().getRepositoryName() + File.separator;
        if (this.getConfig().getInstanceName() != null) {
            killServScript = killServScript + this.getConfig().getInstanceName() + File.separator;
        }
        if ((killServ = new File(killServScript = killServScript + "bin" + File.separator + PEFileLayout.KILL_SERV_OS)).exists()) {
            return killServScript;
        }
        String installLibKillServ = this.getFileLayout().getInstallRootDir().getAbsolutePath() + File.separator + "lib" + File.separator + PEFileLayout.KILL_SERV_OS;
        return installLibKillServ;
    }

    private RMIClient getRMIClient() {
        if (this.rmiClient == null) {
            String stubPath = this.getFileLayout().getStubFile().getAbsolutePath();
            String seedPath = this.getFileLayout().getSeedFile().getAbsolutePath();
            this.rmiClient = new RMIClient(false, stubPath, seedPath);
        }
        return this.rmiClient;
    }

    private void setRMIClient(RMIClient client) {
        this.rmiClient = client;
    }

    private void saveSystemProps() {
        this.systemPropsCopy = new Properties();
        this.systemPropsCopy.putAll((Map<?, ?>)System.getProperties());
    }

    private void restoreSystemProps() {
        System.setProperties(this.systemPropsCopy);
    }

    private boolean isTrue(Boolean b) {
        return Boolean.TRUE.equals(b);
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private void setSecurity() {
        boolean gotAtLeastOne;
        boolean bl = gotAtLeastOne = this.securityInfo != null && this.securityInfo.length >= 3 && (this.ok(this.securityInfo[0]) || this.ok(this.securityInfo[1]) || this.ok(this.securityInfo[2]));
        if (gotAtLeastOne) {
            System.setProperty("com.sun.aas.promptForIdentity", "true");
        } else {
            this.securityInfo = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum InstanceType {
        domain,
        nodeAgent;

    }
}

