/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.lifecycle.reconfig;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.wsmgmt.TransformationRuleEvent;
import com.sun.enterprise.admin.event.wsmgmt.TransformationRuleEventListener;
import com.sun.enterprise.admin.wsmgmt.config.impl.WebServiceConfigImpl;
import com.sun.enterprise.admin.wsmgmt.filter.spi.Filter;
import com.sun.enterprise.admin.wsmgmt.transform.TransformFilter;
import com.sun.enterprise.admin.wsmgmt.transform.TransformHandler;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.TransformationRule;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.config.serverbeans.WebServiceEndpoint;

public class TransformationRuleEventListenerImpl
implements TransformationRuleEventListener {
    public void handleDelete(TransformationRuleEvent event) throws AdminEventListenerException {
        this.handleReconfiguration(event, true, true);
    }

    private void handleReconfiguration(TransformationRuleEvent event, boolean takeOld, boolean isRemove) throws AdminEventListenerException {
        try {
            ConfigBean bean = this.getTRBean(event, takeOld);
            if (bean instanceof TransformationRule) {
                TransformationRule tr = (TransformationRule)bean;
                String appId = this.getApplicationId(tr);
                WebServiceConfigImpl wsc = new WebServiceConfigImpl((WebServiceEndpoint)tr.parent());
                TransformHandler trh = new TransformHandler(wsc, appId);
                Filter f = trh.getFilter(appId, wsc);
                TransformFilter tf = null;
                if (f != null) {
                    tf = (TransformFilter)f;
                }
                ConfigBean newBean = this.getTRBean(event, false);
                WebServiceConfigImpl nwsc = null;
                if (newBean == null) {
                    if (!isRemove) {
                        throw new AdminEventListenerException();
                    }
                    nwsc = wsc;
                } else {
                    nwsc = new WebServiceConfigImpl((WebServiceEndpoint)newBean.parent());
                }
                if (tf == null) {
                    tf = (TransformFilter)trh.registerFilter(wsc);
                } else if (isRemove) {
                    com.sun.enterprise.admin.wsmgmt.config.spi.TransformationRule[] rtrs;
                    String applyTo = tr.getApplyTo();
                    if (applyTo.equals("both") || applyTo.equals("request")) {
                        rtrs = nwsc.getRequestTransformationRule();
                        tf.resetRequestChain(this.pruneList(rtrs, tr.getName()));
                    }
                    if (applyTo.equals("both") || applyTo.equals("response")) {
                        rtrs = nwsc.getResponseTransformationRule();
                        tf.resetResponseChain(this.pruneList(rtrs, tr.getName()));
                    }
                } else {
                    tf.resetRequestChain(nwsc.getRequestTransformationRule());
                    tf.resetResponseChain(nwsc.getResponseTransformationRule());
                }
            }
        }
        catch (Exception e) {
            throw new AdminEventListenerException(e);
        }
    }

    private com.sun.enterprise.admin.wsmgmt.config.spi.TransformationRule[] pruneList(com.sun.enterprise.admin.wsmgmt.config.spi.TransformationRule[] tRules, String name) {
        if (tRules == null || tRules.length < 1) {
            return tRules;
        }
        com.sun.enterprise.admin.wsmgmt.config.spi.TransformationRule[] newRules = new com.sun.enterprise.admin.wsmgmt.config.spi.TransformationRule[tRules.length - 1];
        int newIndex = 0;
        for (int index = 0; index < tRules.length; ++index) {
            if (tRules[index].getName().equals(name)) continue;
            if (newIndex >= tRules.length - 1) {
                throw new RuntimeException();
            }
            newRules[newIndex++] = tRules[index];
        }
        return newRules;
    }

    public void handleUpdate(TransformationRuleEvent event) throws AdminEventListenerException {
        this.handleReconfiguration(event, false, false);
    }

    public void handleCreate(TransformationRuleEvent event) throws AdminEventListenerException {
        this.handleReconfiguration(event, false, false);
    }

    private ConfigBean getTRBean(TransformationRuleEvent event, boolean old) throws ConfigException {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        ConfigBean bean = null;
        ConfigContext ctx = null;
        String xpath = event.getElementXPath();
        ctx = old ? event.getOldConfigContext() : event.getConfigContext();
        if (ctx != null) {
            bean = ctx.exactLookup(xpath);
        }
        return bean;
    }

    private String getApplicationId(TransformationRule trBean) {
        String name = null;
        ConfigBean bean = null;
        if (trBean != null && !((bean = (ConfigBean)trBean.parent()) instanceof WebServiceEndpoint)) {
            throw new RuntimeException();
        }
        if (bean != null) {
            ConfigBean parent = (ConfigBean)bean.parent();
            if (parent instanceof J2eeApplication) {
                J2eeApplication app = (J2eeApplication)parent;
                name = app.getName();
            } else if (parent instanceof WebModule) {
                WebModule wm = (WebModule)parent;
                name = wm.getName();
            } else if (parent instanceof EjbModule) {
                EjbModule em = (EjbModule)parent;
                name = em.getName();
            }
        }
        return name;
    }
}

