/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.registry;

import com.sun.enterprise.admin.wsmgmt.WebServiceMgrBackEnd;
import com.sun.enterprise.admin.wsmgmt.registry.ConfigHelper;
import com.sun.enterprise.admin.wsmgmt.registry.RegistryAccessObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;

public class RegistryAccessObjectImpl
implements RegistryAccessObject {
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private WebServiceMgrBackEnd mgrBE = WebServiceMgrBackEnd.getManager();
    private Map webServiceInfoMap = null;
    private static final String DEFAULT_ORGANIZATION = "Sun Microsystems";
    private static final String DEFAULT_DESCRIPTION = "Default Description for Sun Java Application Server Web Service";
    private boolean isUDDI = false;
    private boolean isEbxml = false;
    private static int MINUS_ONE = -1;
    private static String JAXR_CONNECTION_FACTORY = "com.sun.connector.jaxr.JaxrConnectionFactory";
    private static String EBXML_CONNECTION_FACTORY = "com.sun.jaxr.ra.ebxml.JaxrConnectionFactory";
    private String MOCK_REGISTRY = "com.sun.appserv.admin.wsmgmt.registry.mock";
    private boolean mockRegistry = false;

    public boolean publish(String[] registryLocations, String webServiceName, String lbhost, int lbport, int lbsslport, String[] categories, String organization, String description, String wsdlFile) {
        this.webServiceInfoMap = this.getWebServiceInfoMap(webServiceName);
        if (!this.isWebServiceNameValid(webServiceName)) {
            _logger.log(Level.SEVERE, "registry.invalid_webservice_name_publish_failure", webServiceName);
            return false;
        }
        ConfigHelper ch = ConfigHelper.getInstanceToUpdateConfig(this.webServiceInfoMap);
        String[] duplicate = ch.checkForDuplicateRegistries(registryLocations);
        if (duplicate != null) {
            StringBuffer message = new StringBuffer("Trying to publish Web Service with jndi entries pointing to the same registry. Remove jndi names that point to the same connector pool and retry. The duplicate entries are :  ");
            for (int i = 0; i < duplicate.length; ++i) {
                message.append(duplicate[i]);
                if (i == duplicate.length - 1) {
                    message.append(".");
                    continue;
                }
                message.append(",");
            }
            throw new RuntimeException(message.toString());
        }
        String[] alreadyPublishedRegistries = ch.listAlreadyPublishedRegistryLocations(webServiceName, registryLocations);
        ArrayList<String> publishTo = new ArrayList<String>(Arrays.asList(registryLocations));
        if (alreadyPublishedRegistries != null) {
            publishTo.removeAll(new ArrayList<String>(Arrays.asList(alreadyPublishedRegistries)));
        }
        if (publishTo.size() == 0) {
            String message = "Web Service " + webServiceName + " already published to  the registries! Unpublish and " + "republish.";
            _logger.log(Level.WARNING, message);
            throw new RuntimeException(message);
        }
        if (wsdlFile == null) {
            _logger.log(Level.SEVERE, "registry.wsdl_absent_publish_failure", webServiceName);
            return false;
        }
        HashMap<String, String> publishedTo = new HashMap<String, String>();
        for (String registryLocation : publishTo) {
            try {
                boolean isPublished = false;
                this.mockRegistry = Boolean.getBoolean(this.MOCK_REGISTRY);
                if (!this.mockRegistry) {
                    ConnectionFactory cf = this.lookupConnection(registryLocation);
                    if (cf != null) {
                        isPublished = this.publishWSDL(wsdlFile, cf, lbhost, lbport, lbsslport, categories, organization, description, webServiceName);
                    } else {
                        _logger.log(Level.WARNING, "registry.registry_location_absent_publish_failure", registryLocation);
                    }
                } else {
                    isPublished = true;
                }
                if (!isPublished) continue;
                publishedTo.put(registryLocation, organization);
            }
            catch (NamingException ne) {
                _logger.log(Level.SEVERE, "registry.registry_location_absent_publish_failure", registryLocation);
                _logger.log(Level.SEVERE, "registry.registry_location_naming_exception_publish_failure", ne);
            }
        }
        if (publishedTo.size() <= 0) {
            _logger.log(Level.WARNING, "registry.not_published", webServiceName);
            return false;
        }
        ch.addToConfig(webServiceName, publishedTo);
        return true;
    }

    public boolean unpublishFromRegistry(String[] registryLocations, String webServiceName) {
        this.webServiceInfoMap = this.getWebServiceInfoMap(webServiceName);
        if (!this.isWebServiceNameValid(webServiceName)) {
            _logger.log(Level.SEVERE, "registry.invalid_webservice_name_unpublish_failure", webServiceName);
            return false;
        }
        ArrayList<String> unpublishedFrom = new ArrayList<String>();
        for (int i = 0; i < registryLocations.length; ++i) {
            try {
                boolean unpublished = false;
                this.mockRegistry = Boolean.getBoolean(this.MOCK_REGISTRY);
                if (!this.mockRegistry) {
                    ConnectionFactory cf = this.lookupConnection(registryLocations[i]);
                    unpublished = this.unpublishFromRegistry(cf, webServiceName, registryLocations[i]);
                } else {
                    unpublished = true;
                }
                if (!unpublished) continue;
                unpublishedFrom.add(registryLocations[i]);
                continue;
            }
            catch (NamingException ne) {
                _logger.log(Level.SEVERE, "registry.registry_location_absent_unpublish_failure", registryLocations[i]);
                _logger.log(Level.SEVERE, "registry.registry_location_naming_exception_unpublish_failure", ne);
            }
        }
        if (unpublishedFrom.size() <= 0) {
            _logger.log(Level.WARNING, "registry.not_unpublished", webServiceName);
            return false;
        }
        ConfigHelper ch = ConfigHelper.getInstanceToUpdateConfig(this.webServiceInfoMap);
        String[] unpublished = new String[unpublishedFrom.size()];
        unpublished = unpublishedFrom.toArray(unpublished);
        ch.deleteFromConfig(webServiceName, unpublished);
        return true;
    }

    public String[] listRegistryLocations() {
        ConfigHelper ch = ConfigHelper.getInstanceToQueryRegistryLocations();
        String[] list = null;
        list = ch.listRegistryLocations();
        return list;
    }

    private boolean publishWSDL(String wsdlFile, ConnectionFactory cf, String lbhost, int lbport, int lbsslport, String[] categories, String organization, String description, String webServiceName) {
        boolean value = false;
        try {
            String aURI = (String)this.webServiceInfoMap.get("EndPointURI");
            StringBuffer sbuf = null;
            StringBuffer secureSbuf = null;
            if (lbport != -1) {
                sbuf = new StringBuffer();
                sbuf.append("http://" + lbhost + ":" + lbport);
                if (!aURI.startsWith("/")) {
                    sbuf.append("/");
                }
                sbuf.append(aURI + "?wsdl");
                _logger.log(Level.INFO, "registry.access_url", new Object[]{webServiceName, sbuf.toString()});
            }
            if (lbsslport != -1) {
                secureSbuf = new StringBuffer();
                secureSbuf.append("https://" + lbhost + ":" + lbsslport);
                if (!aURI.startsWith("/")) {
                    secureSbuf.append("/");
                }
                secureSbuf.append(aURI + "?wsdl");
                _logger.log(Level.INFO, "registry.access_url", new Object[]{webServiceName, secureSbuf.toString()});
            }
            String[] accessURI = lbport != MINUS_ONE && lbsslport != MINUS_ONE ? new String[]{sbuf.toString(), secureSbuf.toString()} : new String[]{sbuf != null ? sbuf.toString() : secureSbuf.toString()};
            Connection con = this.getConnection(cf);
            RegistryService rs = con.getRegistryService();
            BusinessLifeCycleManager blcm = rs.getBusinessLifeCycleManager();
            BusinessQueryManager bqm = rs.getBusinessQueryManager();
            if (organization == null) {
                organization = DEFAULT_ORGANIZATION;
            }
            Organization org = blcm.createOrganization(organization);
            if (description == null) {
                description = DEFAULT_DESCRIPTION;
            }
            org.setName(blcm.createInternationalString(organization));
            org.setDescription(blcm.createInternationalString(description));
            org = this.createClassificationSchemeAndClassification(blcm, bqm, org, webServiceName);
            org = this.createServiceAndServiceBindingsAndExternalLink(blcm, org, description, accessURI, webServiceName);
            org = this.categorizeCategoriesViaSlots(blcm, org, webServiceName, categories);
            value = this.publishOrg(blcm, org);
        }
        catch (JAXRException je) {
            _logger.log(Level.SEVERE, "registry.publish_failure_exception", je);
            throw new RuntimeException(je);
        }
        return value;
    }

    private boolean publishOrg(BusinessLifeCycleManager blcm, Organization org) throws JAXRException {
        boolean value = false;
        ArrayList<Organization> orgs = new ArrayList<Organization>();
        orgs.add(org);
        BulkResponse response = blcm.saveOrganizations(orgs);
        if (response.getStatus() == 0) {
            _logger.log(Level.INFO, "registry.successful_publish", org.getName().getValue());
            value = true;
        } else {
            _logger.log(Level.SEVERE, "registry.organization_not_published", org.getName().getValue());
            Collection exceptions = response.getExceptions();
            this.displayExceptions(exceptions, Level.SEVERE);
            value = false;
        }
        return value;
    }

    private Organization createClassificationSchemeAndClassification(BusinessLifeCycleManager blcm, BusinessQueryManager bqm, Organization org, String webServiceName) throws JAXRException {
        try {
            ClassificationScheme classScheme = null;
            Collection findQualifiers = this.createFindQualifiers();
            classScheme = bqm.findClassificationSchemeByName(findQualifiers, webServiceName);
            if (classScheme == null) {
                classScheme = blcm.createClassificationScheme(webServiceName, webServiceName);
                ArrayList<ClassificationScheme> classificationSchemeList = new ArrayList<ClassificationScheme>();
                classificationSchemeList.add(classScheme);
                if (this.isUDDI) {
                    blcm.saveClassificationSchemes(classificationSchemeList);
                }
            }
            if (this.isUDDI) {
                classScheme = bqm.findClassificationSchemeByName(findQualifiers, webServiceName);
            }
            if (classScheme == null) {
                _logger.log(Level.SEVERE, "registr.cannot_find_classification_scheme", webServiceName);
                return org;
            }
            Collection classificationExists = classScheme.getClassifications();
            Classification wsdlSpecClassification = null;
            if (!classificationExists.isEmpty()) {
                for (Classification classification : classificationExists) {
                    if (!classification.getName().getValue().equals(webServiceName)) continue;
                    wsdlSpecClassification = classification;
                    break;
                }
            }
            if (wsdlSpecClassification == null) {
                if (this.isUDDI) {
                    wsdlSpecClassification = blcm.createClassification(classScheme, "wsdlSpec", "wsdlSpec");
                    wsdlSpecClassification.setValue(webServiceName);
                } else {
                    wsdlSpecClassification = blcm.createClassification(classScheme, webServiceName, webServiceName);
                    wsdlSpecClassification.setValue(webServiceName);
                    wsdlSpecClassification.setClassificationScheme(classScheme);
                    wsdlSpecClassification.setName(blcm.createInternationalString(webServiceName));
                }
                classScheme.addClassification(wsdlSpecClassification);
                ArrayList<ClassificationScheme> classificationSchemeList = new ArrayList<ClassificationScheme>();
                classificationSchemeList.add(classScheme);
                if (this.isUDDI) {
                    blcm.saveClassificationSchemes(classificationSchemeList);
                }
            }
            org.addClassification(wsdlSpecClassification);
        }
        catch (JAXRException je) {
            _logger.log(Level.SEVERE, "registry.classification_creation_failed");
            throw je;
        }
        return org;
    }

    private Organization categorizeCategoriesViaSlots(BusinessLifeCycleManager blcm, Organization org, String webServiceName, String[] categories) throws JAXRException {
        try {
            if (categories == null || categories.length <= 0) {
                return org;
            }
            for (int i = 0; i < categories.length; ++i) {
                ArrayList<String> slotValues = new ArrayList<String>();
                slotValues.add(webServiceName);
                Slot slot = blcm.createSlot(categories[i], slotValues, null);
                org.addSlot(slot);
            }
        }
        catch (JAXRException je) {
            _logger.log(Level.SEVERE, "registry.slot_creation_failed");
            throw je;
        }
        return org;
    }

    private ServiceBinding createServiceBinding(BusinessLifeCycleManager blcm, String description, String accessURI, String name) throws JAXRException {
        ServiceBinding binding = null;
        try {
            binding = blcm.createServiceBinding();
            binding.setDescription(blcm.createInternationalString(description));
            binding.setValidateURI(false);
            binding.setAccessURI(accessURI);
            binding.setName(blcm.createInternationalString(name + accessURI));
        }
        catch (JAXRException je) {
            _logger.log(Level.SEVERE, "registry.service_binding_creation_failed");
            throw je;
        }
        return binding;
    }

    private Organization createServiceAndServiceBindingsAndExternalLink(BusinessLifeCycleManager blcm, Organization org, String description, String[] accessURI, String webServiceName) throws JAXRException {
        try {
            String serviceName = org.getName().toString() + ":" + webServiceName;
            Service service = blcm.createService(serviceName);
            service.setDescription(blcm.createInternationalString(description));
            for (String uri : accessURI) {
                ServiceBinding binding = this.createServiceBinding(blcm, description, uri, webServiceName);
                service.addServiceBinding(binding);
                ExternalLink wsdlLink = blcm.createExternalLink(uri, description);
                wsdlLink.setValidateURI(false);
                wsdlLink.setName(blcm.createInternationalString(serviceName));
                if (!this.isUDDI) {
                    service.addExternalLink(wsdlLink);
                }
                org.addExternalLink(wsdlLink);
            }
            org.addService(service);
        }
        catch (JAXRException je) {
            _logger.log(Level.SEVERE, "registry.service_creation_failed");
            throw je;
        }
        return org;
    }

    private boolean unpublishFromRegistry(ConnectionFactory cf, String webServiceName, String registryLocation) {
        boolean retvalue = false;
        try {
            Connection con = this.getConnection(cf);
            RegistryService rs = con.getRegistryService();
            BusinessLifeCycleManager blcm = rs.getBusinessLifeCycleManager();
            BusinessQueryManager bqm = rs.getBusinessQueryManager();
            Collection findQualifiers = this.createFindQualifiers();
            ClassificationScheme classificationScheme = bqm.findClassificationSchemeByName(findQualifiers, webServiceName);
            if (classificationScheme == null) {
                _logger.log(Level.SEVERE, "registry.cannot_find_classification_scheme", webServiceName);
                retvalue = false;
            }
            Classification classification = null;
            if (this.isUDDI) {
                classification = blcm.createClassification(classificationScheme, "wsdlSpec", "wsdlSpec");
                classification.setValue(webServiceName);
            } else {
                classification = blcm.createClassification(classificationScheme, webServiceName, webServiceName);
                classification.setValue(webServiceName);
            }
            classification.setName(blcm.createInternationalString(webServiceName));
            Collection<Classification> classList = null;
            if (classificationScheme != null) {
                classificationScheme.addClassification(classification);
                classList = classificationScheme.getClassifications();
            } else {
                classList = new ArrayList<Classification>();
                classList.add(classification);
            }
            this.webServiceInfoMap = this.getWebServiceInfoMap(webServiceName);
            if (!this.isWebServiceNameValid(webServiceName)) {
                _logger.log(Level.SEVERE, "registry.invalid_webservice_name_unpublish_failure", webServiceName);
                return false;
            }
            ConfigHelper ch = ConfigHelper.getInstanceToUpdateConfig(this.webServiceInfoMap);
            String org = ch.getOrganizationName(webServiceName, registryLocation);
            if (org == null) {
                _logger.log(Level.SEVERE, "Cannot find Organization Name for web service in the appserver");
                return false;
            }
            ArrayList<String> orgs = new ArrayList<String>();
            orgs.add(org);
            BulkResponse br = bqm.findOrganizations(findQualifiers, orgs, null, null, null, null);
            boolean deletedOrg = true;
            if (br.getStatus() == 0) {
                Collection orgCollection = br.getCollection();
                for (Organization organization : orgCollection) {
                    String orgName = organization.getName().getValue();
                    if (orgName == null || !orgName.equals(org)) continue;
                    _logger.log(Level.INFO, "registry.about_to_unpublish", new Object[]{webServiceName, orgName});
                    this.deleteServicesAndServiceBindingsAndExternalLinks(organization, webServiceName, blcm);
                    organization.removeClassifications(organization.getClassifications());
                    this.deleteOrg(blcm, organization, webServiceName);
                    break;
                }
                this.deleteClassificationScheme(blcm, classificationScheme, webServiceName);
                retvalue = true;
            }
        }
        catch (JAXRException je) {
            _logger.log(Level.SEVERE, "registry.unpublish_failed", je);
            retvalue = false;
        }
        return retvalue;
    }

    private void deleteServicesAndServiceBindingsAndExternalLinks(Organization organization, String webServiceName, BusinessLifeCycleManager blcm) throws JAXRException {
        Collection servicesCollection = organization.getServices();
        ArrayList<Key> servicesKey = new ArrayList<Key>();
        for (Service service : servicesCollection) {
            Collection binding = service.getServiceBindings();
            ArrayList<Key> bindingsKey = new ArrayList<Key>();
            for (ServiceBinding sb : binding) {
                String bindingString = sb.getName().toString();
                bindingsKey.add(sb.getKey());
            }
            service.removeServiceBindings(binding);
            BulkResponse bulkResponse = blcm.deleteServiceBindings(bindingsKey);
            Collection exceptions = bulkResponse.getExceptions();
            if (exceptions != null) {
                _logger.log(Level.WARNING, "registry.delete_servicebindings_failed", new Object[]{webServiceName});
                this.displayExceptions(exceptions, Level.SEVERE);
            }
            if (!this.isUDDI) {
                service.removeExternalLinks(service.getExternalLinks());
            }
            servicesKey.add(service.getKey());
        }
        this.deleteExternalLinks(organization, webServiceName, blcm);
        organization.removeServices(servicesCollection);
        BulkResponse bulkResponse = blcm.deleteServices(servicesKey);
        Collection exceptions = bulkResponse.getExceptions();
        if (exceptions != null) {
            _logger.log(Level.SEVERE, "registry.delete_services_failed", new Object[]{webServiceName});
            this.displayExceptions(exceptions, Level.SEVERE);
        }
    }

    private void deleteExternalLinks(Organization organization, String webServiceName, BusinessLifeCycleManager blcm) {
        try {
            Collection exlink = organization.getExternalLinks();
            ArrayList<Key> key = new ArrayList<Key>();
            for (ExternalLink link : exlink) {
                key.add(link.getKey());
            }
            organization.removeExternalLinks(exlink);
            BulkResponse bulkResponse = blcm.deleteObjects(key);
            Collection exceptions = bulkResponse.getExceptions();
            if (exceptions != null) {
                _logger.log(Level.SEVERE, "registry.delete_externallink_failed", new Object[]{webServiceName});
                this.displayExceptions(exceptions, Level.SEVERE);
            }
        }
        catch (JAXRException je) {
            _logger.log(Level.INFO, "Could not lookup ExternalLinks (URI) for webservice " + webServiceName + ". Nothing to delete!");
        }
    }

    private boolean deleteClassificationScheme(BusinessLifeCycleManager blcm, ClassificationScheme scheme, String webServiceName) throws JAXRException {
        Key key = scheme.getKey();
        ArrayList<Key> keysToDelete = new ArrayList<Key>();
        keysToDelete.add(key);
        BulkResponse bulkResponse = blcm.deleteClassificationSchemes(keysToDelete);
        Collection exceptions = bulkResponse.getExceptions();
        if (exceptions != null) {
            _logger.log(Level.SEVERE, "registry.classification_scheme_delete_unsuccessful", scheme.getName().getValue());
            this.displayExceptions(exceptions, Level.SEVERE);
            return false;
        }
        _logger.log(Level.INFO, "registry.classification_scheme_delete_successful", new Object[]{scheme.getName().getValue(), webServiceName});
        return true;
    }

    private boolean deleteOrg(BusinessLifeCycleManager blcm, Organization org, String webServiceName) throws JAXRException {
        Key orgKey = org.getKey();
        Collection services = org.getServices();
        if (!services.isEmpty()) {
            _logger.log(Level.SEVERE, "registry.cleanup_services_first", org.getName().getValue());
            return false;
        }
        ArrayList<Key> keysToDelete = new ArrayList<Key>();
        keysToDelete.add(orgKey);
        BulkResponse bulkResponse = blcm.deleteOrganizations(keysToDelete);
        Collection exceptions = bulkResponse.getExceptions();
        if (exceptions != null) {
            _logger.log(Level.SEVERE, "registry.delete_org_failed", org.getName().getValue());
            this.displayExceptions(exceptions, Level.SEVERE);
            return false;
        }
        _logger.log(Level.INFO, "registry.delete_org_succeeded", new Object[]{org.getName().getValue(), webServiceName});
        return true;
    }

    private boolean deleteOrg(BusinessLifeCycleManager blcm, String key, String webServiceName) throws JAXRException {
        Key orgKey = blcm.createKey(key);
        ArrayList<Key> keysToDelete = new ArrayList<Key>();
        keysToDelete.add(orgKey);
        BulkResponse bulkResponse = blcm.deleteOrganizations(keysToDelete);
        Collection exceptions = bulkResponse.getExceptions();
        if (exceptions != null) {
            _logger.log(Level.SEVERE, "registry.delete_org_failed", key);
            this.displayExceptions(exceptions, Level.SEVERE);
            return false;
        }
        _logger.log(Level.INFO, "registry.delete_org_succeeded", new Object[]{key, webServiceName});
        return true;
    }

    private Connection getConnection(ConnectionFactory cf) throws JAXRException {
        Connection con = null;
        try {
            Method method = cf.getClass().getMethod("getConnection", null);
            con = (Connection)method.invoke((Object)cf, (Object[])null);
            if (JAXR_CONNECTION_FACTORY.equals(cf.getClass().getName())) {
                this.isUDDI = true;
            } else if (EBXML_CONNECTION_FACTORY.equals(cf.getClass().getName())) {
                this.isEbxml = true;
            }
            if (con == null) {
                con = cf.createConnection();
            }
        }
        catch (NoSuchMethodException nsme) {
            con = cf.createConnection();
        }
        catch (IllegalAccessException iae) {
            con = cf.createConnection();
        }
        catch (InvocationTargetException ite) {
            con = cf.createConnection();
        }
        return con;
    }

    private boolean isWebServiceNameValid(String webServiceName) {
        if (webServiceName == null) {
            return false;
        }
        boolean retValue = this.webServiceInfoMap != null;
        return retValue;
    }

    private Map getWebServiceInfoMap(String webServiceName) {
        this.webServiceInfoMap = webServiceName == null ? null : this.mgrBE.getWebServiceInfoMap(webServiceName);
        return this.webServiceInfoMap;
    }

    private ConnectionFactory lookupConnection(String registryLocation) throws NamingException {
        InitialContext ic = new InitialContext();
        ConnectionFactory cf = (ConnectionFactory)ic.lookup(registryLocation);
        _logger.fine("RegistryAccessObject.lookupConnection : for registryLocation " + registryLocation);
        return cf;
    }

    private Collection createFindQualifiers() {
        ArrayList<String> findQualifiers = new ArrayList<String>();
        findQualifiers.add("sortByNameDesc");
        return findQualifiers;
    }

    private void displayExceptions(Collection exceptions, Level level) {
        for (Exception e : exceptions) {
            _logger.log(level, " JAXR Exception ", e);
        }
    }
}

