/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.repository.impl;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.wsmgmt.repository.impl.cache.CacheMgr;
import com.sun.enterprise.admin.wsmgmt.repository.impl.cache.J2eeApplication;
import com.sun.enterprise.admin.wsmgmt.repository.spi.RepositoryException;
import com.sun.enterprise.admin.wsmgmt.repository.spi.RepositoryProvider;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.io.ApplicationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppServRepositoryProvider
implements RepositoryProvider {
    private static final String WEB_INF = "WEB-INF";
    private static final String META_INF = "META-INF";
    private static final String WEBSERVICES_XML = "webservices.xml";
    private static final String WEB_XML = "web.xml";
    private static final String SUN_WEB_XML = "sun-web.xml";
    private static final String EJB_JAR_XML = "ejb-jar.xml";
    private static final String SUN_EJB_JAR_XML = "sun-ejb-jar.xml";
    private static final String APPLICATION_XML = "application.xml";
    private static final String SUN_DASH = "sun-";
    private static String instanceRoot = null;
    private static Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    public static final String PROVIDER_ID = "com.sun.enterprise.admin.wsmgmt.repository.impl.AppServRepositoryProvider";

    public AppServRepositoryProvider() {
        if (instanceRoot == null) {
            instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
        }
    }

    public String getProviderID() {
        return PROVIDER_ID;
    }

    public Map getWebServiceModules() {
        Map m;
        HashMap map = new HashMap();
        ConfigContext configCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        CacheMgr mgr = CacheMgr.getInstance();
        Map apps = mgr.getJ2eeApplications();
        Collection aValues = apps.values();
        for (J2eeApplication app : aValues) {
            List webBundles;
            List ejbBundles = app.getEjbBundles();
            if (ejbBundles != null) {
                for (String ejb : ejbBundles) {
                    try {
                        Map m2 = this.getEjbBundleInfo(configCtx, app.getName(), ejb);
                        map.put(m2.get("sun.ejb.jar.xml.location"), m2);
                    }
                    catch (RepositoryException re) {}
                }
            }
            if ((webBundles = app.getWebBundles()) == null) continue;
            for (String web : webBundles) {
                try {
                    m = this.getWebBundleInfo(configCtx, app.getName(), web);
                    map.put(m.get("sun.web.xml.location"), m);
                }
                catch (RepositoryException re) {}
            }
        }
        Map ejbs = mgr.getEjbModules();
        Collection eValues = ejbs.values();
        for (String ejbMod : eValues) {
            try {
                Map m3 = this.getEjbModuleInfo(configCtx, ejbMod);
                map.put(m3.get("sun.ejb.jar.xml.location"), m3);
            }
            catch (RepositoryException re) {}
        }
        Map webs = mgr.getWebModules();
        Collection wValues = webs.values();
        for (String webMod : wValues) {
            try {
                m = this.getWebModuleInfo(configCtx, webMod);
                map.put(m.get("sun.web.xml.location"), m);
            }
            catch (RepositoryException re) {}
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAltDD(String bundleName, String appXML, boolean ejbBundle) {
        String altDD = null;
        FileInputStream fis = null;
        try {
            File f = new File(appXML);
            if (!f.exists() || bundleName == null) {
                String string = null;
                return string;
            }
            ApplicationDeploymentDescriptorFile addf = new ApplicationDeploymentDescriptorFile();
            fis = new FileInputStream(f);
            Application app = (Application)addf.read(fis);
            Iterator itr = app.getModules();
            while (itr.hasNext()) {
                ModuleDescriptor md = (ModuleDescriptor)itr.next();
                String uri = md.getArchiveUri();
                if (!bundleName.equals(uri)) continue;
                altDD = md.getAlternateDescriptor();
                break;
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Error while reading alt-dd", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
        return altDD;
    }

    private Map getEjbBundleInfo(ConfigContext ctx, String name, String bundleName) throws RepositoryException {
        if (bundleName == null || ctx == null || name == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("module.type", "ejb.module.type");
            map.put("application.id", name);
            map.put("bundle.name", bundleName);
            String xmlDir = instanceRoot + File.separator + "generated" + File.separator + "xml" + File.separator + "j2ee-apps" + File.separator + name;
            String bundleRoot = xmlDir + File.separator + FileUtils.makeFriendlyFileName(bundleName);
            map.put("bundle.root.location", bundleRoot);
            String ejbXML = null;
            String sunEjbXML = null;
            String appXML = xmlDir + File.separator + META_INF + File.separator + APPLICATION_XML;
            map.put(APPLICATION_XML, this.getFormattedFileContents(appXML));
            String altDD = this.getAltDD(bundleName, appXML, true);
            if (altDD == null) {
                ejbXML = bundleRoot + File.separator + META_INF + File.separator + EJB_JAR_XML;
                sunEjbXML = bundleRoot + File.separator + META_INF + File.separator + SUN_EJB_JAR_XML;
            } else {
                ejbXML = xmlDir + File.separator + altDD;
                sunEjbXML = xmlDir + File.separator + SUN_DASH + new File(ejbXML).getName();
            }
            map.put("ejb.jar.xml.location", this.getFormattedFileContents(ejbXML));
            map.put("sun.ejb.jar.xml.location", sunEjbXML);
            map.put("sun.ejb.jar.xml", this.getFormattedFileContents(sunEjbXML));
            String wsXML = bundleRoot + File.separator + META_INF + File.separator + WEBSERVICES_XML;
            map.put("ws.xml.location", wsXML);
            map.put("ws.xml", this.getFormattedFileContents(wsXML));
        }
        catch (Exception e) {
            throw new RepositoryException(e);
        }
        return map;
    }

    private Map getWebBundleInfo(ConfigContext ctx, String name, String bundleName) throws RepositoryException {
        if (bundleName == null || ctx == null || name == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("module.type", "web.module.type");
            map.put("application.id", name);
            map.put("bundle.name", bundleName);
            String xmlDir = instanceRoot + File.separator + "generated" + File.separator + "xml" + File.separator + "j2ee-apps" + File.separator + name;
            String bundleRoot = xmlDir + File.separator + FileUtils.makeFriendlyFileName(bundleName);
            map.put("bundle.root.location", bundleRoot);
            String webXML = null;
            String sunWebXML = null;
            String appXML = xmlDir + File.separator + META_INF + File.separator + APPLICATION_XML;
            map.put(APPLICATION_XML, this.getFormattedFileContents(appXML));
            String altDD = this.getAltDD(bundleName, appXML, false);
            if (altDD == null) {
                webXML = bundleRoot + File.separator + WEB_INF + File.separator + WEB_XML;
                sunWebXML = bundleRoot + File.separator + WEB_INF + File.separator + SUN_WEB_XML;
            } else {
                webXML = xmlDir + File.separator + altDD;
                sunWebXML = xmlDir + File.separator + SUN_DASH + new File(webXML).getName();
            }
            map.put("web.xml.location", this.getFormattedFileContents(webXML));
            map.put("sun.web.xml.location", sunWebXML);
            map.put("sun.web.xml", this.getFormattedFileContents(sunWebXML));
            String wsXML = bundleRoot + File.separator + WEB_INF + File.separator + WEBSERVICES_XML;
            map.put("ws.xml.location", wsXML);
            map.put("ws.xml", this.getFormattedFileContents(wsXML));
        }
        catch (Exception e) {
            throw new RepositoryException(e);
        }
        return map;
    }

    private Map getEjbModuleInfo(ConfigContext ctx, String name) throws RepositoryException {
        if (ctx == null || name == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("module.type", "ejb.module.type");
            map.put("application.id", name);
            map.put("bundle.name", null);
            String xmlDir = instanceRoot + File.separator + "generated" + File.separator + "xml" + File.separator + "j2ee-modules" + File.separator + name;
            map.put("bundle.root.location", xmlDir);
            String ejbXML = xmlDir + File.separator + META_INF + File.separator + EJB_JAR_XML;
            map.put("ejb.jar.xml.location", this.getFormattedFileContents(ejbXML));
            String sunEjbXML = xmlDir + File.separator + META_INF + File.separator + SUN_EJB_JAR_XML;
            map.put("sun.ejb.jar.xml.location", sunEjbXML);
            map.put("sun.ejb.jar.xml", this.getFormattedFileContents(sunEjbXML));
            String wsXML = xmlDir + File.separator + META_INF + File.separator + WEBSERVICES_XML;
            map.put("ws.xml.location", wsXML);
            map.put("ws.xml", this.getFormattedFileContents(wsXML));
        }
        catch (Exception e) {
            throw new RepositoryException(e);
        }
        return map;
    }

    private Map getWebModuleInfo(ConfigContext ctx, String name) throws RepositoryException {
        if (ctx == null || name == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("module.type", "web.module.type");
            map.put("application.id", name);
            map.put("bundle.name", null);
            String xmlDir = instanceRoot + File.separator + "generated" + File.separator + "xml" + File.separator + "j2ee-modules" + File.separator + name;
            map.put("bundle.root.location", xmlDir);
            String webXML = xmlDir + File.separator + WEB_INF + File.separator + WEB_XML;
            map.put("web.xml.location", this.getFormattedFileContents(webXML));
            String sunWebXML = xmlDir + File.separator + WEB_INF + File.separator + SUN_WEB_XML;
            map.put("sun.web.xml.location", sunWebXML);
            map.put("sun.web.xml", this.getFormattedFileContents(sunWebXML));
            String wsXML = xmlDir + File.separator + WEB_INF + File.separator + WEBSERVICES_XML;
            map.put("ws.xml.location", wsXML);
            map.put("ws.xml", this.getFormattedFileContents(wsXML));
        }
        catch (Exception e) {
            throw new RepositoryException(e);
        }
        return map;
    }

    private String getFormattedFileContents(String filePath) {
        String str = null;
        try {
            str = FileUtils.getFileContents(filePath);
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Error reading dd file contents", e);
        }
        return str;
    }
}

