/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.iiop.PEORBConfigurator;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.login.LoginCallbackHandler;
import com.sun.enterprise.util.InjectionManagerImpl;
import com.sun.enterprise.util.InvocationManagerImpl;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;

public class AppContainer {
    public static final int USERNAME_PASSWORD = 1;
    public static final int CERTIFICATE = 2;
    public static final int ALL = 3;
    private static final boolean debug = false;
    private ApplicationClientDescriptor descriptor = null;
    private Switch sw = Switch.getSwitch();
    private NamingManager nm = null;
    private static CallbackHandler handler = null;
    private boolean guiAuth = true;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.appclient");

    public AppContainer(ApplicationClientDescriptor desc, boolean useGuiAuth) {
        this.sw.setContainerType(1);
        this.descriptor = desc;
        this.guiAuth = useGuiAuth;
    }

    public static CallbackHandler getCallbackHandler() {
        return handler;
    }

    public String preInvoke(Properties props) throws Exception {
        return this.preInvoke(AppContainer.initializeNaming(props), Thread.currentThread().getContextClassLoader());
    }

    public String preInvoke(InitialContext ic, ClassLoader loader) throws Exception {
        ComponentInvocation ci = new ComponentInvocation(null, this);
        this.sw.getInvocationManager().preInvoke(ci);
        String callbackHandler = this.descriptor.getCallbackHandler();
        _logger.fine("Callback Handler:" + callbackHandler);
        this.initializeCallbackHandler(callbackHandler, loader);
        this.performUserLogin();
        String mainClass = this.descriptor.getMainClassName();
        this.sw.setDescriptorFor(this, this.descriptor);
        this.nm = Switch.getSwitch().getNamingManager();
        this.nm.bindObjects(this.descriptor);
        return mainClass;
    }

    public void postInvoke() throws Exception {
        this.nm.unbindObjects(this.descriptor);
    }

    public void performUserLogin() {
        boolean doLogin = Boolean.valueOf(System.getProperty("startup.login", "false"));
        if (doLogin) {
            _logger.info("acc.init_login");
            String loginMech = System.getProperty("com.sun.enterprise.loginMech", "password");
            if (loginMech.equalsIgnoreCase("ssl")) {
                LoginContextDriver.doClientLogin(2, handler);
            } else if (loginMech.equalsIgnoreCase("all")) {
                LoginContextDriver.doClientLogin(3, handler);
            } else {
                LoginContextDriver.doClientLogin(1, handler);
            }
        }
    }

    public static InitialContext initializeNaming(Properties iiopProperties) throws NamingException {
        InitialContext result = new InitialContext(iiopProperties);
        Switch sw = Switch.getSwitch();
        InvocationManagerImpl im = new InvocationManagerImpl();
        sw.setInvocationManager(im);
        PEORBConfigurator.initTransactionService(null, new Properties());
        J2EETransactionManager tm = J2EETransactionManagerImpl.createTransactionManager();
        sw.setTransactionManager(tm);
        sw.setNamingManager(new NamingManagerImpl(result));
        InjectionManagerImpl injectionMgr = new InjectionManagerImpl();
        sw.setInjectionManager(injectionMgr);
        return result;
    }

    private void initializeCallbackHandler(String callbackHandler, ClassLoader loader) {
        Class<?> handlerClass = null;
        handler = null;
        try {
            if (callbackHandler != null) {
                handlerClass = Class.forName(callbackHandler, true, loader);
                handler = (CallbackHandler)handlerClass.newInstance();
            } else {
                handler = new LoginCallbackHandler(this.guiAuth);
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Could not instantiate specified callback handler:" + e.getMessage(), e);
            _logger.info("acc.using_default_callback");
            handler = new LoginCallbackHandler(this.guiAuth);
        }
    }
}

