/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient.jws;

import com.sun.enterprise.appclient.jws.SignedStaticContent;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.security.AccessControlException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.security.tools.JarSigner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASJarSigner {
    private static final String USER_SPECIFIED_ALIAS_PROPERTYNAME = "com.sun.aas.jws.signing.alias";
    private static final String JKS_KEYSTORE_TYPE_VALUE = "jks";
    private static final String DEFAULT_ALIAS_VALUE = "s1as";
    private static final String userAlias = System.getProperty("com.sun.aas.jws.signing.alias");
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static final StringManager localStrings = StringManager.getManager(ASJarSigner.class);
    private static SigningInfo signingInfo = null;
    private File unsignedJar;
    private File signedJar;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long signJar(File unsignedJar, File signedJar) throws Exception {
        Class<ASJarSigner> clazz = ASJarSigner.class;
        synchronized (ASJarSigner.class) {
            if (signingInfo == null) {
                signingInfo = ASJarSigner.createSigningInfo();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ASJarSigner signer = new ASJarSigner(unsignedJar, signedJar);
            return signer.sign();
        }
    }

    private ASJarSigner(File unsignedJar, File signedJar) throws Exception {
        this.unsignedJar = unsignedJar;
        this.signedJar = signedJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long sign() throws Exception {
        long startTime = System.currentTimeMillis();
        String[] args = signingInfo.getSigningArgs(this.unsignedJar, this.signedJar);
        Class<SignedStaticContent> clazz = SignedStaticContent.class;
        synchronized (SignedStaticContent.class) {
            SecurityManager mgr = System.getSecurityManager();
            try {
                try {
                    NoExitSecurityManager noExitMgr = new NoExitSecurityManager(mgr);
                    System.setSecurityManager(noExitMgr);
                    JarSigner.main((String[])args);
                }
                catch (Throwable t) {
                    this.signedJar.delete();
                    throw new Exception(localStrings.getString("jws.sign.errorSigning", this.signedJar.getAbsolutePath()), t);
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                System.setSecurityManager(mgr);
                int i = 0;
                while (true) {
                    if (i >= args.length) {
                        long duration = System.currentTimeMillis() - startTime;
                        logger.fine("Signing " + this.unsignedJar.getAbsolutePath() + " took " + duration + " ms");
                        throw throwable;
                    }
                    args[i] = null;
                    ++i;
                }
            }
            System.setSecurityManager(mgr);
            for (int i = 0; i < args.length; ++i) {
                args[i] = null;
            }
            long duration = System.currentTimeMillis() - startTime;
            logger.fine("Signing " + this.unsignedJar.getAbsolutePath() + " took " + duration + " ms");
            // ** MonitorExit[clazz] (shouldn't be in output)
            return System.currentTimeMillis() - startTime;
        }
    }

    private static synchronized SigningInfo getSigningInfo() throws Exception {
        if (signingInfo == null) {
            signingInfo = ASJarSigner.createSigningInfo();
        }
        return signingInfo;
    }

    private static SigningInfo createSigningInfo() throws Exception {
        String[] keystorePWs = SecurityUtil.getSecuritySupport().getKeyStorePasswords();
        String[] tokenNames = SecurityUtil.getSecuritySupport().getTokenNames();
        ArrayList<SigningInfo> signingInfoForDefaultAlias = new ArrayList<SigningInfo>();
        ArrayList<SigningInfo> signingInfoForUserAlias = new ArrayList<SigningInfo>();
        int keystoreSlot = 0;
        for (KeyStore ks : SecurityUtil.getSecuritySupport().getKeyStores()) {
            if (userAlias != null && ks.containsAlias(userAlias)) {
                signingInfoForUserAlias.add(SigningInfo.newInstance(userAlias, keystorePWs[keystoreSlot], ks, tokenNames[keystoreSlot]));
            }
            if (ks.containsAlias(DEFAULT_ALIAS_VALUE)) {
                signingInfoForDefaultAlias.add(SigningInfo.newInstance(DEFAULT_ALIAS_VALUE, keystorePWs[keystoreSlot], ks, tokenNames[keystoreSlot]));
            }
            ++keystoreSlot;
        }
        SigningInfo result = ASJarSigner.selectSigningInfo(signingInfoForUserAlias, signingInfoForDefaultAlias);
        logger.fine(localStrings.getString("jws.sign.signingInfo", result.toString()));
        return result;
    }

    private static SigningInfo selectSigningInfo(ArrayList<SigningInfo> signingInfoForUserAlias, ArrayList<SigningInfo> signingInfoForDefaultAlias) {
        String aliasOfInterest;
        ArrayList<SigningInfo> signingInfoOfInterest;
        if (userAlias != null) {
            if (signingInfoForUserAlias.size() == 0) {
                logger.log(Level.WARNING, localStrings.getString("jws.sign.userAliasAbsent", userAlias));
                signingInfoOfInterest = signingInfoForDefaultAlias;
                aliasOfInterest = DEFAULT_ALIAS_VALUE;
            } else {
                signingInfoOfInterest = signingInfoForUserAlias;
                aliasOfInterest = userAlias;
            }
        } else {
            signingInfoOfInterest = signingInfoForDefaultAlias;
            aliasOfInterest = DEFAULT_ALIAS_VALUE;
        }
        if (signingInfoOfInterest.size() == 0) {
            throw new IllegalArgumentException(localStrings.getString("jws.sign.aliasNotFound", aliasOfInterest));
        }
        if (signingInfoOfInterest.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (SigningInfo si : signingInfoOfInterest) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(si);
            }
            logger.log(Level.WARNING, localStrings.getString("jws.sign.aliasFoundMult", aliasOfInterest, sb.toString()));
        }
        return signingInfoOfInterest.get(0);
    }

    public static class ASJarSignerException
    extends Exception {
        public ASJarSignerException(String msg, Throwable t) {
            super(msg, t);
        }
    }

    private class NoExitSecurityManager
    extends SecurityManager {
        private SecurityManager originalManager;

        public NoExitSecurityManager(SecurityManager originalManager) {
            this.originalManager = originalManager;
        }

        public void checkExit(int status2) {
            throw new AccessControlException("System.exit");
        }

        public void checkPermission(Permission p) {
            if (this.originalManager != null) {
                this.originalManager.checkPermission(p);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SigningInfo {
        private static final String SIGNEDJAR_OPTION = "-signedjar";
        private static final String KEYSTORE_OPTION = "-keystore";
        private static final String STOREPASS_OPTION = "-storepass";
        private static final String STORETYPE_OPTION = "-storetype";
        private KeyStore keystore;
        private String alias;
        private String password;
        private PrivateKey key;
        private String token;

        static SigningInfo newInstance(String alias, String password, KeyStore keystore, String token) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            if (keystore.getType().equalsIgnoreCase(ASJarSigner.JKS_KEYSTORE_TYPE_VALUE)) {
                return new JKSSigningInfo(alias, password, keystore, token);
            }
            return new PKCS11SigningInfo(alias, password, keystore, token);
        }

        public SigningInfo(String alias, String password, KeyStore keystore, String token) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            this.keystore = keystore;
            this.alias = alias;
            this.password = password;
            this.token = token;
            this.key = this.validateKey();
        }

        public String getAlias() {
            return this.alias;
        }

        private PrivateKey validateKey() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            Key tempKey = this.keystore.getKey(this.alias, this.password.toCharArray());
            if (tempKey instanceof PrivateKey) {
                return (PrivateKey)tempKey;
            }
            throw new IllegalArgumentException(localStrings.getString("jws.sign.keyNotPrivate", this.alias));
        }

        public String getProviderName() {
            return this.keystore.getProvider().getName();
        }

        public String getToken() {
            return this.token;
        }

        public String getPassword() {
            return this.password;
        }

        public String getStoreType() {
            return this.keystore.getType();
        }

        public X509Certificate[] getCertificateChain() throws KeyStoreException {
            Certificate[] certs = this.keystore.getCertificateChain(this.alias);
            X509Certificate[] X509certs = new X509Certificate[certs.length];
            int slot = 0;
            for (Certificate c : certs) {
                if (!(c instanceof X509Certificate)) {
                    throw new IllegalArgumentException(localStrings.getString("jws.sign.notX509Cert", this.alias));
                }
                X509certs[slot++] = (X509Certificate)c;
            }
            return X509certs;
        }

        public String toString() {
            return this.getClass().getName() + ": alias=" + this.alias + "; keystore type=" + this.keystore.getType() + "; provider=" + this.keystore.getProvider().getName();
        }

        public KeyStore getKeyStore() {
            return this.keystore;
        }

        public String[] getSigningArgs(File unsignedJar, File signedJar) {
            ArrayList<String> args = new ArrayList<String>();
            this.addKeyStoreTypeSpecificArgs(args);
            args.add(STORETYPE_OPTION);
            args.add(this.getKeyStore().getType());
            args.add(STOREPASS_OPTION);
            int passwordSlot = args.size();
            args.add(signingInfo.getPassword());
            args.add(SIGNEDJAR_OPTION);
            args.add(signedJar.getAbsolutePath());
            args.add(unsignedJar.getAbsolutePath());
            args.add(signingInfo.getAlias());
            String[] result = args.toArray(new String[args.size()]);
            args.set(passwordSlot, "");
            return result;
        }

        protected abstract void addKeyStoreTypeSpecificArgs(Collection<String> var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class JKSSigningInfo
        extends SigningInfo {
            private static final String KEYSTORE_PATH_PROPERTYNAME = "javax.net.ssl.keyStore";

            private static String getJKSKeystoreAbsolutePath() {
                return System.getProperty(KEYSTORE_PATH_PROPERTYNAME);
            }

            public JKSSigningInfo(String alias, String password, KeyStore keystore, String token) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
                super(alias, password, keystore, token);
            }

            @Override
            protected void addKeyStoreTypeSpecificArgs(Collection<String> args) {
                args.add(SigningInfo.KEYSTORE_OPTION);
                args.add(JKSSigningInfo.getJKSKeystoreAbsolutePath());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class PKCS11SigningInfo
        extends SigningInfo {
            private static final String PKCS11_PROVIDERNAME_OPTION = "-providerName";
            private static final String PKCS11_KEYSTORE_OPTION_VALUE = "NONE";

            public PKCS11SigningInfo(String alias, String password, KeyStore keystore, String token) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
                super(alias, password, keystore, token);
            }

            @Override
            protected void addKeyStoreTypeSpecificArgs(Collection<String> args) {
                args.add(SigningInfo.KEYSTORE_OPTION);
                args.add(PKCS11_KEYSTORE_OPTION_VALUE);
                args.add(PKCS11_PROVIDERNAME_OPTION);
                args.add(this.getKeyStore().getProvider().getName());
            }
        }
    }
}

