/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config;

import com.sun.enterprise.config.ConfigBeanBase;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigRuntimeException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.impl.ConfigContextImpl;
import com.sun.enterprise.config.pluggable.ConfigBeanInterceptor;
import com.sun.enterprise.config.pluggable.ConfigBeansSettings;
import com.sun.enterprise.config.pluggable.EnvironmentFactory;
import com.sun.enterprise.config.util.LoggerHelper;
import java.io.Serializable;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BaseProperty;
import org.netbeans.modules.schema2beans.Version;
import org.w3c.dom.DocumentType;

public abstract class ConfigBean
extends ConfigBeanBase
implements Serializable {
    private transient ConfigBeanInterceptor _interceptor = null;
    private transient ConfigBeansSettings _cbSettings = null;
    protected transient ConfigContext ctx = null;
    private transient Hashtable transientProperties = null;
    private static final String UNINITIALIZED_ATTRIBUTE_VALUE = "DONOTKNOW";
    private static final long UNINITIALIZED_LAST_MODIFIED_VALUE = -1L;
    private transient long thisLastModified = -1L;
    private transient long globalLastModified = -1L;
    private String xpath;
    private String publicId;
    private String systemId;
    private transient String _state = "valid_state";
    private static final String VALID_STATE = "valid_state";
    private static final String INVALID_STATE = "invalid_state";

    public Object getTransientProperty(String name) {
        if (name == null || this.transientProperties == null) {
            return null;
        }
        return this.transientProperties.get(name);
    }

    public Object setTransientProperty(String name, Object value) {
        if (name == null) {
            return null;
        }
        if (value == null) {
            if (this.transientProperties == null) {
                return null;
            }
            value = this.transientProperties.get(name);
            if (value != null) {
                this.transientProperties.remove(name);
            }
            return value;
        }
        if (this.transientProperties == null) {
            this.transientProperties = new Hashtable();
        }
        return this.transientProperties.put(name, value);
    }

    public void setXPath(String xpath) {
        this.xpath = null != xpath ? xpath.trim() : xpath;
    }

    public String getXPath() {
        return null != this.xpath ? this.xpath.trim() : this.xpath;
    }

    public boolean canHaveSiblings() {
        return this.beanProp() != null && this.beanProp().isIndexed();
    }

    public ConfigContext getConfigContext() {
        return this.ctx;
    }

    public void setConfigContext(ConfigContext ctx) {
        this.ctx = ctx;
    }

    public void cleanup() {
        this.ctx = null;
        this._interceptor = null;
        this.setInvalidState();
    }

    public ConfigBean() {
        super(null, new Version(4, 0, 0));
        this.setThisLastModified();
        this._cbSettings = this.getConfigBeansSettings();
    }

    public ConfigBean(Vector comps, Version version) {
        super(comps, version);
        this.setThisLastModified();
        this._cbSettings = this.getConfigBeansSettings();
    }

    public static boolean toBoolean(String value) {
        String v = null != value ? value.trim() : value;
        return null != v && (v.equals("true") || v.equals("yes") || v.equals("on") || v.equals("1"));
    }

    public void setAttributeValue(String name, String value) {
        try {
            this.setAttributeValue(name, value, true);
        }
        catch (StaleWriteConfigException swce) {
            String url = this.ctx == null ? " " : this.ctx.getUrl();
            LoggerHelper.finest("Detected external changes to config file \"" + url + "\". Ignoring the condition and proceeding");
        }
    }

    public void setAttributeValue(String name, String value, boolean overwrite) throws StaleWriteConfigException {
        String vl;
        String nm = null != name ? name.trim() : name;
        String string = vl = null != value ? value.trim() : value;
        if (this.getAttributeValueSafe(nm) != null && this.getAttributeValueSafe(nm).equals(vl)) {
            return;
        }
        if (!overwrite && this.ctx != null && this.ctx.isFileChangedExternally()) {
            throw new StaleWriteConfigException("ConfigBean: cannot change since FileChangedExternally");
        }
        String oldValue = UNINITIALIZED_ATTRIBUTE_VALUE;
        if (this._cbSettings.isSpecialElement(nm)) {
            oldValue = this.preSetAttributeValueSpecial(nm);
            super.setValue(nm, vl);
            this.postSetAttributeValueSpecial(nm, vl, oldValue);
        } else {
            oldValue = this.preSetAttributeValue(nm, vl);
            super.setAttributeValue(nm, vl);
            this.postSetAttributeValue(nm, vl, oldValue);
        }
    }

    public ConfigBean[] getChildBeansByName(String childBeanName) {
        this.validateState();
        if (childBeanName == null) {
            return null;
        }
        childBeanName = childBeanName.trim();
        childBeanName = this._cbSettings.mapElementName(childBeanName);
        ConfigBean[] ret = null;
        try {
            ret = (ConfigBean[])this.getValues(childBeanName);
        }
        catch (Exception e) {
            ret = this.getChildBeanByName(childBeanName);
        }
        return ret;
    }

    public ConfigBean[] getAllChildBeans() {
        ArrayList<ConfigBean> cbRet = new ArrayList<ConfigBean>();
        String[] childNames = this.getChildBeanNames();
        if (childNames == null || childNames.length == 0) {
            return null;
        }
        for (int i = 0; i < childNames.length; ++i) {
            ConfigBean[] cb = this.getChildBeansByName(childNames[i]);
            if (cb == null) continue;
            for (int k = 0; k < cb.length; ++k) {
                cbRet.add(cb[k]);
            }
        }
        return this.toConfigBeanArray(cbRet);
    }

    private String[] getChildBeanNames() {
        BaseProperty[] bp = super.listProperties();
        if (bp == null) {
            return null;
        }
        String[] s = new String[bp.length];
        for (int i = 0; i < bp.length; ++i) {
            s[i] = bp[i].getDtdName();
        }
        return s;
    }

    public int removeChild(ConfigBean child) throws ConfigException {
        return this.removeChild(child, true);
    }

    public int removeChild(ConfigBean child, boolean overwrite) throws ConfigException {
        if (!overwrite && this.ctx != null && this.ctx.isFileChangedExternally()) {
            throw new StaleWriteConfigException("ConfigBean: cannot change since FileChangedExternally");
        }
        if (child == null) {
            throw new ConfigException("Cannot remove null child");
        }
        return this.removeValue(child.name(), (Object)child);
    }

    public int addValue(String name, Object value) {
        int i = 0;
        try {
            i = this.addValue(name, value, true);
        }
        catch (StaleWriteConfigException swce) {
            // empty catch block
        }
        return i;
    }

    public int addValue(String name, Object value, boolean overwrite) throws StaleWriteConfigException {
        if (null != name) {
            name = name.trim();
        }
        if (!overwrite && this.ctx != null && this.ctx.isFileChangedExternally()) {
            throw new StaleWriteConfigException("ConfigBean: cannot change since FileChangedExternally");
        }
        this.preAddValue(name, value);
        int i = super.addValue(name, value);
        this.postAddValue(name, value);
        return i;
    }

    public int removeValue(String name, Object value) {
        if (null != name) {
            name = name.trim();
        }
        int i = 0;
        try {
            i = this.removeValue(name, value, true);
        }
        catch (StaleWriteConfigException swce) {
            // empty catch block
        }
        return i;
    }

    public int removeValue(String name, Object value, boolean overwrite) throws StaleWriteConfigException {
        if (null != name) {
            name = name.trim();
        }
        if (!overwrite && this.ctx != null && this.ctx.isFileChangedExternally()) {
            throw new StaleWriteConfigException("ConfigBean: cannot change since FileChangedExternally");
        }
        this.preRemoveValue(name, value);
        int i = super.removeValue(name, value);
        this.postRemoveValue(name, value);
        return i;
    }

    public Object getValue(String name) {
        if (null != name) {
            name = name.trim();
        }
        Object res = super.getValue(name);
        res = this.postGetValue(name, res);
        return res;
    }

    public Object getValue(String name, int index) {
        if (null != name) {
            name = name.trim();
        }
        Object res = super.getValue(name, index);
        res = this.postGetValue(name, res);
        return res;
    }

    public Object getValueById(String name, int id) {
        if (null != name) {
            name = name.trim();
        }
        Object res = super.getValueById(name, id);
        res = this.postGetValue(name, res);
        return res;
    }

    public Object[] getValues(String name) {
        if (null != name) {
            name = name.trim();
        }
        Object[] res = super.getValues(name);
        res = this.postGetValues(name, res);
        return res;
    }

    public void setValue(String name, Object value) {
        if (null != name) {
            name = name.trim();
        }
        try {
            this.setValue(name, value, true);
        }
        catch (StaleWriteConfigException staleWriteConfigException) {
            // empty catch block
        }
    }

    public void setValue(String name, Object value, boolean overwrite) throws StaleWriteConfigException {
        if (null != name) {
            name = name.trim();
        }
        if (!overwrite && this.ctx != null && this.ctx.isFileChangedExternally()) {
            throw new StaleWriteConfigException("ConfigBean: cannot change since FileChangedExternally");
        }
        Object oldValue = super.getValue(name);
        this.preSetValue(name, value);
        super.setValue(name, value);
        if (oldValue != null && oldValue != value && oldValue instanceof ConfigBean) {
            this.postRemoveValue(name, oldValue);
        }
        this.postSetValue(name, value);
    }

    public void setValue(String name, Object[] value) {
        if (null != name) {
            name = name.trim();
        }
        this.preSetArrayValue(name, value);
        super.setValue(name, value);
        this.postSetArrayValue(name, value);
    }

    public static String getDefaultAttributeValueFromDtd(String attr) {
        if (null != attr) {
            attr = attr.trim();
        }
        return ConfigBean.getDefaultAttributeValue(attr);
    }

    public static String getDefaultAttributeValue(String attr) {
        return null;
    }

    protected String getRelativeXPath() {
        return null;
    }

    public String getAbsoluteXPath(String parentXpath) {
        if (this.xpath != null) {
            return this.xpath.trim();
        }
        if (parentXpath == null) {
            return null;
        }
        String rel = this.getRelativeXPath();
        if (rel == null) {
            return null;
        }
        return parentXpath.trim() + "/" + this.getRelativeXPath().trim();
    }

    public synchronized String getAttributeValue(String name) {
        if (null != name) {
            name = name.trim();
        }
        String res = this.getRawAttributeValue(name);
        return this.postGetAttributeValue(name, res);
    }

    public synchronized Object clone() {
        Object orig = this.preClone();
        ConfigBean result = (ConfigBean)super.clone();
        if (this == this.parent()) {
            result.setDoctype(this.getPublicId(), this.getSystemId());
        }
        this.postClone(orig, result);
        result.setGlobalLastModified(this.getThisLastModified());
        return result;
    }

    private void setDoctype(String pid, String sid) {
        this.publicId = null != pid ? pid.trim() : pid;
        String string = this.systemId = null != sid ? sid.trim() : sid;
        if (this.graphManager() != null) {
            this.graphManager().setDoctype(pid, sid);
        }
    }

    private String getPublicId() {
        if (this.getDoctype() != null) {
            this.publicId = this.getDoctype().getPublicId();
        }
        return this.publicId.trim();
    }

    private String getSystemId() {
        if (this.getDoctype() != null) {
            this.systemId = this.getDoctype().getSystemId();
        }
        return this.systemId.trim();
    }

    private DocumentType getDoctype() {
        return this.graphManager().getXmlDocument() != null ? this.graphManager().getXmlDocument().getDoctype() : (DocumentType)null;
    }

    public String getRawAttributeValue(String name) {
        if (null != name) {
            name = name.trim();
        }
        if (this._cbSettings.isSpecialElement(name)) {
            String v = (String)super.getValue(name);
            return null != v ? v.trim() : v;
        }
        this.preRawGetAttributeValue(name);
        String s = super.getAttributeValue(name);
        this.postRawGetAttributeValue(name, s);
        return null != s ? s.trim() : s;
    }

    public void dumpAttributes(String name, int index, StringBuffer str, String indent) {
        if (null != name) {
            name = name.trim();
        }
        String[] names = this.getAttributeNames(name);
        for (int i = 0; i < names.length; ++i) {
            String v = null;
            v = names[i].indexOf("Password") != -1 || names[i].indexOf("UserName") != -1 ? "*****" : this.getAttributeValue(name, index, names[i]);
            if (v == null) continue;
            str.append(indent + "\t  attr: ");
            str.append(names[i]);
            str.append("=");
            str.append(v);
        }
    }

    public void changed() {
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
    }

    public boolean isMonitoringEnabled() {
        return false;
    }

    public static String camelize(String name) {
        if (null != name) {
            name = name.trim();
        }
        StringBuffer n = new StringBuffer();
        boolean up = true;
        boolean keepCase = false;
        StringCharacterIterator ci = new StringCharacterIterator(name);
        char c = ci.first();
        while (c != '\uffff') {
            if (Character.isLowerCase(c)) {
                keepCase = true;
                break;
            }
            c = ci.next();
        }
        c = ci.first();
        while (c != '\uffff') {
            if (c == '-' || c == '_') {
                up = true;
            } else {
                if (up) {
                    c = Character.toUpperCase(c);
                } else if (!keepCase) {
                    c = Character.toLowerCase(c);
                }
                n.append(c);
                up = false;
            }
            c = ci.next();
        }
        return n.toString();
    }

    private void setThisLastModified() {
        this.thisLastModified = System.currentTimeMillis();
    }

    private void setGlobalLastModified(long timestamp) {
        this.globalLastModified = timestamp;
    }

    public long getGlobalLastModified() {
        return this.globalLastModified;
    }

    public long getThisLastModified() {
        return this.thisLastModified;
    }

    public synchronized void setInterceptor(ConfigBeanInterceptor cbi) {
        this._interceptor = cbi;
    }

    public synchronized ConfigBeanInterceptor getInterceptor() {
        if (null != this._interceptor) {
            return this._interceptor;
        }
        ConfigBeanInterceptor cbi = null;
        if (null != this.ctx) {
            cbi = ((ConfigContextImpl)this.ctx).getConfigBeanInterceptor();
        } else {
            ConfigBean parent = (ConfigBean)this.parent();
            if (null != parent && this != parent) {
                cbi = parent.getInterceptor();
            }
        }
        return cbi;
    }

    private ConfigBeansSettings getConfigBeansSettings() {
        return EnvironmentFactory.getEnvironmentFactory().getConfigEnvironment().getConfigBeansSettings();
    }

    private Object postGetValue(String name, Object res) {
        this.addXPathToChild(res);
        return this.getInterceptor() == null ? res : this.getInterceptor().postGetValue(this, name, res);
    }

    private Object[] postGetValues(String name, Object[] res) {
        this.addXPathToChild(res);
        return this.getInterceptor() == null ? res : this.getInterceptor().postGetValues(name, res);
    }

    private String postGetAttributeValue(String name, String res) {
        String s = this.getInterceptor() == null ? res : this.getInterceptor().postGetAttributeValue(name, res);
        return null != s ? s.trim() : s;
    }

    private Object preClone() {
        if (this.getInterceptor() != null) {
            return this.getInterceptor().preClone();
        }
        return null;
    }

    private void postClone(Object o, Object result) {
        ConfigBeanInterceptor cbi = this.getInterceptor();
        if (cbi != null) {
            cbi.postClone(o);
        }
    }

    private String getAttributeValueSafe(String name) {
        try {
            return this.getAttributeValue(name);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void addToConfigChangeList(String xpath, String tag, String oldValue, String newValue) {
        ConfigChange cChange = null;
        if (this.ctx != null && (cChange = this.ctx.addToConfigChangeList(null != xpath ? xpath.trim() : xpath, null != tag ? tag.trim() : tag, null != oldValue ? oldValue.trim() : oldValue, null != newValue ? newValue.trim() : newValue)) != null) {
            cChange.setGlobalLastModified(this.getGlobalLastModified());
        }
    }

    private String preSetAttributeValue(String name, String value) {
        this.preConfigChange(name, value, "PRE_UPDATE_CHANGE", "UPDATE", null != this.name() ? this.name().trim() : this.name());
        return this.getAttributeValueSafe(name);
    }

    private void preAddValue(String name, Object value) {
        this.preConfigChange(name, value, "PRE_ADD_CHANGE", "ADD");
    }

    private void preRemoveValue(String name, Object value) {
        this.preConfigChange(name, value, "PRE_DELETE_CHANGE", "DELETE");
    }

    private void preSetValue(String name, Object value) {
        this.preConfigChange(name, value, "PRE_SET_CHANGE", "SET");
    }

    private void preConfigChange(String name, Object value, String type, String operation) {
        this.preConfigChange(name, value, type, operation, null);
    }

    private void preConfigChange(String name, Object value, String type, String operation, String beanName) {
        this.validateState();
        if (this.ctx != null) {
            ConfigContextEvent ccce = new ConfigContextEvent(this.ctx, type, name, value, operation, beanName);
            ccce.setClassObject(this);
            this.ctx.preChange(ccce);
        }
    }

    private void postSetAttributeValue(String name, String value, String oldValue) {
        this.setThisLastModified();
        ConfigChange cChange = null;
        if (this.ctx != null) {
            cChange = this.ctx.addToConfigChangeList(this.xpath, name, oldValue, value);
            if (cChange != null) {
                cChange.setGlobalLastModified(this.getGlobalLastModified());
            }
            ConfigContextEvent ccce = new ConfigContextEvent(this.ctx, "POST_UPDATE_CHANGE", name, value, "UPDATE");
            this.ctx.postChange(ccce);
        }
    }

    private void postAddValue(String name, Object value) {
        this.setThisLastModified();
        if (this.ctx != null) {
            if (value instanceof ConfigBean) {
                try {
                    ConfigChange cChange = this.ctx.addToConfigChangeList(this.xpath, ((ConfigBean)value).getAbsoluteXPath(this.xpath), name, this.ctx.getRootConfigBean());
                    if (cChange != null) {
                        cChange.setGlobalLastModified(this.getGlobalLastModified());
                    }
                }
                catch (Exception ce) {
                    ce.printStackTrace();
                }
                ((ConfigBean)value).setConfigContext(this.ctx);
                ((ConfigBean)value).setXPath(((ConfigBean)value).getAbsoluteXPath(this.xpath));
            }
            ConfigContextEvent ccce = new ConfigContextEvent(this.ctx, "POST_ADD_CHANGE", name, value, "ADD");
            this.ctx.postChange(ccce);
        }
    }

    private void postSetValue(String name, Object value) {
        this.setThisLastModified();
        if (this.ctx != null) {
            if (value instanceof ConfigBean) {
                ConfigChange cChange = this.ctx.addToConfigChangeList(this.xpath, name, ((ConfigBean)value).clone(), null);
                if (cChange != null) {
                    cChange.setGlobalLastModified(this.getGlobalLastModified());
                }
                ((ConfigBean)value).setConfigContext(this.ctx);
                ((ConfigBean)value).setXPath(((ConfigBean)value).getAbsoluteXPath(this.xpath));
                ConfigContextEvent ccce = new ConfigContextEvent(this.ctx, "POST_SET_CHANGE", name, value, "SET");
                this.ctx.postChange(ccce);
            } else {
                ConfigChange cChange = this.ctx.addToConfigChangeList(this.xpath, name, value, null);
                if (cChange != null) {
                    cChange.setGlobalLastModified(this.getGlobalLastModified());
                }
            }
        }
    }

    private void postRemoveValue(String name, Object value) {
        this.setThisLastModified();
        if (value instanceof ConfigBean && this.ctx != null) {
            ConfigChange cChange = this.ctx.addToConfigChangeList(((ConfigBean)value).getXPath());
            if (cChange != null) {
                cChange.setGlobalLastModified(this.getGlobalLastModified());
            }
            ConfigContextEvent ccce = new ConfigContextEvent(this.ctx, "POST_DELETE_CHANGE", name, value, "DELETE");
            this.ctx.postChange(ccce);
        }
    }

    private String preSetAttributeValueSpecial(String name) {
        return this.getAttributeValueSafe(name);
    }

    private void postSetAttributeValueSpecial(String name, String value, String oldValue) {
        this.setThisLastModified();
        this.addToConfigChangeList(this.xpath, name, oldValue, value);
    }

    private ConfigBean[] toConfigBeanArray(ArrayList cbRet) {
        ConfigBean[] ret = new ConfigBean[cbRet.size()];
        for (int j = 0; j < cbRet.size(); ++j) {
            ret[j] = (ConfigBean)cbRet.get(j);
        }
        return ret;
    }

    private ConfigBean[] getChildBeanByName(String childBeanName) {
        ConfigBean[] ret = null;
        try {
            ConfigBean cb = (ConfigBean)this.getValue(childBeanName);
            if (cb != null) {
                ret = new ConfigBean[]{cb};
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private void addXPathToChild(Object obj) {
        if (obj != null && obj instanceof ConfigBean) {
            ConfigBean cb = (ConfigBean)obj;
            if (cb.xpath == null && this.xpath != null) {
                cb.setXPath(cb.getAbsoluteXPath(this.xpath));
            }
        }
    }

    private void addXPathToChild(Object[] obj) {
        if (obj == null) {
            return;
        }
        for (int i = 0; i < obj.length; ++i) {
            this.addXPathToChild(obj[i]);
        }
    }

    private void preRawGetAttributeValue(String name) {
        this.validateState();
        if (this.ctx != null) {
            ConfigContextEvent ccce = new ConfigContextEvent(this.ctx, "PRE_ACCESS");
            ccce.setClassObject(this);
            this.ctx.preChange(ccce);
        }
    }

    private void postRawGetAttributeValue(String name, String s) {
        if (this.ctx != null) {
            ConfigContextEvent ccce = new ConfigContextEvent(this.ctx, "POST_ACCESS");
            this.ctx.postChange(ccce);
        }
    }

    private void preSetArrayValue(String name, Object[] value) {
        this.validateState();
        if (this.ctx != null) {
            ConfigContextEvent ccce = new ConfigContextEvent(this.ctx, "PRE_SET_CHANGE", name, value, "SET");
            ccce.setClassObject(this);
            ccce.setBeanName(this.name());
            this.ctx.preChange(ccce);
        }
    }

    private void postSetArrayValue(String name, Object[] value) {
        this.setThisLastModified();
        if (this.ctx != null) {
            ConfigChange cChange = this.ctx.addToConfigChangeList(this.xpath, name, null, value);
            if (cChange != null) {
                cChange.setGlobalLastModified(this.getGlobalLastModified());
            }
            ConfigContextEvent ccce = new ConfigContextEvent(this.ctx, "POST_SET_CHANGE", name, value, "SET");
            ccce.setBeanName(this.name());
            try {
                this.ctx.postChange(ccce);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void validateState() {
        if (!VALID_STATE.equals(this._state)) {
            throw new ConfigRuntimeException("Config API Usage Error: State of ConfigBean is INVALID. No operations are permitted");
        }
    }

    private void setInvalidState() {
        this._state = INVALID_STATE;
    }
}

