/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.clientbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.clientbeans.AuthRealm;
import com.sun.enterprise.config.clientbeans.ClientCredential;
import com.sun.enterprise.config.clientbeans.ElementProperty;
import com.sun.enterprise.config.clientbeans.LogService;
import com.sun.enterprise.config.clientbeans.MessageSecurityConfig;
import com.sun.enterprise.config.clientbeans.TargetServer;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.ValidateException;
import org.netbeans.modules.schema2beans.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ClientContainer
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    private static final Version runtimeVersion = new Version(4, 2, 0);
    public static final String TARGET_SERVER = "TargetServer";
    public static final String AUTH_REALM = "AuthRealm";
    public static final String CLIENT_CREDENTIAL = "ClientCredential";
    public static final String LOG_SERVICE = "LogService";
    public static final String MESSAGE_SECURITY_CONFIG = "MessageSecurityConfig";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public ClientContainer() {
        this(null, 1);
    }

    public ClientContainer(Node doc, int options) {
        this(2);
        try {
            this.initFromNode(doc, options);
        }
        catch (Schema2BeansException e) {
            throw new RuntimeException(e);
        }
    }

    protected void initFromNode(Node doc, int options) throws Schema2BeansException {
        if (doc == null && (doc = GraphManager.createRootElementNode("client-container")) == null) {
            throw new Schema2BeansException(Common.getMessage("CantCreateDOMRoot_msg", "client-container"));
        }
        Node n = GraphManager.getElementNode("client-container", doc);
        if (n == null) {
            throw new Schema2BeansException(Common.getMessage("DocRootNotInDOMGraph_msg", "client-container", doc.getFirstChild().getNodeName()));
        }
        this.graphManager.setXmlDocument(doc);
        this.createBean(n, this.graphManager());
        this.initialize(options);
    }

    public ClientContainer(int options) {
        super(comparators, runtimeVersion);
        this.initOptions(options);
    }

    protected void initOptions(int options) {
        this.graphManager = new GraphManager(this);
        this.createRoot("client-container", "ClientContainer", 544, ClientContainer.class);
        this.initPropertyTables(6);
        this.createProperty("target-server", TARGET_SERVER, 66112, TargetServer.class);
        this.createAttribute(TARGET_SERVER, "name", "Name", 257, null, null);
        this.createAttribute(TARGET_SERVER, "address", "Address", 257, null, null);
        this.createAttribute(TARGET_SERVER, "port", "Port", 257, null, null);
        this.createProperty("auth-realm", AUTH_REALM, 66064, AuthRealm.class);
        this.createAttribute(AUTH_REALM, "name", "Name", 257, null, null);
        this.createAttribute(AUTH_REALM, "classname", "Classname", 257, null, null);
        this.createProperty("client-credential", CLIENT_CREDENTIAL, 66064, ClientCredential.class);
        this.createAttribute(CLIENT_CREDENTIAL, "user-name", "UserName", 257, null, null);
        this.createAttribute(CLIENT_CREDENTIAL, "password", "Password", 257, null, null);
        this.createAttribute(CLIENT_CREDENTIAL, "realm", "Realm", 513, null, null);
        this.createProperty("log-service", LOG_SERVICE, 66064, LogService.class);
        this.createAttribute(LOG_SERVICE, "file", "File", 513, null, null);
        this.createAttribute(LOG_SERVICE, "level", "Level", 1, null, "SEVERE");
        this.createProperty("message-security-config", MESSAGE_SECURITY_CONFIG, 66096, MessageSecurityConfig.class);
        this.createAttribute(MESSAGE_SECURITY_CONFIG, "auth-layer", "AuthLayer", 257, null, null);
        this.createAttribute(MESSAGE_SECURITY_CONFIG, "default-provider", "DefaultProvider", 513, null, null);
        this.createAttribute(MESSAGE_SECURITY_CONFIG, "default-client-provider", "DefaultClientProvider", 513, null, null);
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.createAttribute("send-password", "SendPassword", 1, null, "true");
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setTargetServer(int index, TargetServer value) {
        this.setValue(TARGET_SERVER, index, (Object)value);
    }

    public TargetServer getTargetServer(int index) {
        return (TargetServer)this.getValue(TARGET_SERVER, index);
    }

    public void setTargetServer(TargetServer[] value) {
        this.setValue(TARGET_SERVER, value);
    }

    public TargetServer[] getTargetServer() {
        return (TargetServer[])this.getValues(TARGET_SERVER);
    }

    public int sizeTargetServer() {
        return this.size(TARGET_SERVER);
    }

    public int addTargetServer(TargetServer value) throws ConfigException {
        return this.addTargetServer(value, true);
    }

    public int addTargetServer(TargetServer value, boolean overwrite) throws ConfigException {
        TargetServer old = this.getTargetServerByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(ClientContainer.class).getString("cannotAddDuplicate", TARGET_SERVER));
        }
        return this.addValue(TARGET_SERVER, value, overwrite);
    }

    public int removeTargetServer(TargetServer value) {
        return this.removeValue(TARGET_SERVER, (Object)value);
    }

    public int removeTargetServer(TargetServer value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(TARGET_SERVER, value, overwrite);
    }

    public TargetServer getTargetServerByName(String id) {
        TargetServer[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getTargetServer()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName("name")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public void setAuthRealm(AuthRealm value) {
        this.setValue(AUTH_REALM, value);
    }

    public AuthRealm getAuthRealm() {
        return (AuthRealm)this.getValue(AUTH_REALM);
    }

    public void setClientCredential(ClientCredential value) {
        this.setValue(CLIENT_CREDENTIAL, value);
    }

    public ClientCredential getClientCredential() {
        return (ClientCredential)this.getValue(CLIENT_CREDENTIAL);
    }

    public void setLogService(LogService value) {
        this.setValue(LOG_SERVICE, value);
    }

    public LogService getLogService() {
        return (LogService)this.getValue(LOG_SERVICE);
    }

    public void setMessageSecurityConfig(int index, MessageSecurityConfig value) {
        this.setValue(MESSAGE_SECURITY_CONFIG, index, (Object)value);
    }

    public MessageSecurityConfig getMessageSecurityConfig(int index) {
        return (MessageSecurityConfig)this.getValue(MESSAGE_SECURITY_CONFIG, index);
    }

    public void setMessageSecurityConfig(MessageSecurityConfig[] value) {
        this.setValue(MESSAGE_SECURITY_CONFIG, value);
    }

    public MessageSecurityConfig[] getMessageSecurityConfig() {
        return (MessageSecurityConfig[])this.getValues(MESSAGE_SECURITY_CONFIG);
    }

    public int sizeMessageSecurityConfig() {
        return this.size(MESSAGE_SECURITY_CONFIG);
    }

    public int addMessageSecurityConfig(MessageSecurityConfig value) throws ConfigException {
        return this.addMessageSecurityConfig(value, true);
    }

    public int addMessageSecurityConfig(MessageSecurityConfig value, boolean overwrite) throws ConfigException {
        MessageSecurityConfig old = this.getMessageSecurityConfigByAuthLayer(value.getAuthLayer());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(ClientContainer.class).getString("cannotAddDuplicate", MESSAGE_SECURITY_CONFIG));
        }
        return this.addValue(MESSAGE_SECURITY_CONFIG, value, overwrite);
    }

    public int removeMessageSecurityConfig(MessageSecurityConfig value) {
        return this.removeValue(MESSAGE_SECURITY_CONFIG, (Object)value);
    }

    public int removeMessageSecurityConfig(MessageSecurityConfig value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(MESSAGE_SECURITY_CONFIG, value, overwrite);
    }

    public MessageSecurityConfig getMessageSecurityConfigByAuthLayer(String id) {
        MessageSecurityConfig[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getMessageSecurityConfig()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName("auth-layer")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public void setElementProperty(int index, ElementProperty value) {
        this.setValue(ELEMENT_PROPERTY, index, (Object)value);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(ClientContainer.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, (Object)value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName("name")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public boolean isSendPassword() {
        return ClientContainer.toBoolean(this.getAttributeValue("send-password"));
    }

    public void setSendPassword(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("send-password", "" + v, overwrite);
    }

    public void setSendPassword(boolean v) {
        this.setAttributeValue("send-password", "" + v);
    }

    public static String getDefaultSendPassword() {
        return "true".trim();
    }

    public TargetServer newTargetServer() {
        return new TargetServer();
    }

    public AuthRealm newAuthRealm() {
        return new AuthRealm();
    }

    public ClientCredential newClientCredential() {
        return new ClientCredential();
    }

    public LogService newLogService() {
        return new LogService();
    }

    public MessageSecurityConfig newMessageSecurityConfig() {
        return new MessageSecurityConfig();
    }

    public ElementProperty newElementProperty() {
        return new ElementProperty();
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "client-container";
        return null != ret ? ret.trim() : null;
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).equals("send-password")) {
            return "true".trim();
        }
        return null;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static ClientContainer createGraph(Node doc) {
        return new ClientContainer(doc, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientContainer createGraph(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        try {
            ClientContainer clientContainer = ClientContainer.createGraph(in, false);
            return clientContainer;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static ClientContainer createGraph(InputStream in) {
        return ClientContainer.createGraph(in, false);
    }

    public static ClientContainer createGraph(InputStream in, boolean validate) {
        try {
            Document doc = GraphManager.createXmlDocument(in, validate);
            return ClientContainer.createGraph(doc);
        }
        catch (Exception t) {
            throw new RuntimeException(Common.getMessage("DOMGraphCreateFailed_msg", t));
        }
    }

    public static ClientContainer createGraph() {
        return new ClientContainer();
    }

    public void validate() throws ValidateException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.write(baos);
        String str = baos.toString();
        out.writeUTF(str);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.init(comparators, runtimeVersion);
            String strDocument = in.readUTF();
            ByteArrayInputStream bais = new ByteArrayInputStream(strDocument.getBytes());
            Document doc = GraphManager.createXmlDocument(bais, false);
            this.initOptions(2);
            this.initFromNode(doc, 2);
        }
        catch (Schema2BeansException e) {
            throw new RuntimeException(e);
        }
    }

    public void _setSchemaLocation(String location) {
        if (this.beanProp().getAttrProp("xsi:schemaLocation", true) == null) {
            this.createAttribute("xmlns:xsi", "xmlns:xsi", 513, null, "http://www.w3.org/2001/XMLSchema-instance");
            this.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.createAttribute("xsi:schemaLocation", "xsi:schemaLocation", 513, null, location);
        }
        this.setAttributeValue("xsi:schemaLocation", location);
    }

    public String _getSchemaLocation() {
        if (this.beanProp().getAttrProp("xsi:schemaLocation", true) == null) {
            this.createAttribute("xmlns:xsi", "xmlns:xsi", 513, null, "http://www.w3.org/2001/XMLSchema-instance");
            this.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.createAttribute("xsi:schemaLocation", "xsi:schemaLocation", 513, null, null);
        }
        return this.getAttributeValue("xsi:schemaLocation");
    }

    public void dump(StringBuffer str, String indent) {
        ConfigBean n;
        int i;
        str.append(indent);
        str.append("TargetServer[" + this.sizeTargetServer() + "]");
        for (i = 0; i < this.sizeTargetServer(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getTargetServer(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(TARGET_SERVER, i, str, indent);
        }
        str.append(indent);
        str.append(AUTH_REALM);
        n = this.getAuthRealm();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(AUTH_REALM, 0, str, indent);
        str.append(indent);
        str.append(CLIENT_CREDENTIAL);
        n = this.getClientCredential();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(CLIENT_CREDENTIAL, 0, str, indent);
        str.append(indent);
        str.append(LOG_SERVICE);
        n = this.getLogService();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(LOG_SERVICE, 0, str, indent);
        str.append(indent);
        str.append("MessageSecurityConfig[" + this.sizeMessageSecurityConfig() + "]");
        for (i = 0; i < this.sizeMessageSecurityConfig(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getMessageSecurityConfig(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(MESSAGE_SECURITY_CONFIG, i, str, indent);
        }
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("ClientContainer\n");
        this.dump(str, "\n  ");
        return str.toString();
    }
}

