/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.clientbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.clientbeans.ElementProperty;
import com.sun.enterprise.config.clientbeans.RequestPolicy;
import com.sun.enterprise.config.clientbeans.ResponsePolicy;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.ValidateException;
import org.netbeans.modules.schema2beans.Version;

public class ProviderConfig
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    private static final Version runtimeVersion = new Version(4, 2, 0);
    public static final String REQUEST_POLICY = "RequestPolicy";
    public static final String RESPONSE_POLICY = "ResponsePolicy";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public ProviderConfig() {
        this(1);
    }

    public ProviderConfig(int options) {
        super(comparators, runtimeVersion);
        this.initPropertyTables(3);
        this.createProperty("request-policy", REQUEST_POLICY, 66064, RequestPolicy.class);
        this.createAttribute(REQUEST_POLICY, "auth-source", "AuthSource", 514, new String[]{"sender", "content"}, null);
        this.createAttribute(REQUEST_POLICY, "auth-recipient", "AuthRecipient", 514, new String[]{"before-content", "after-content"}, null);
        this.createProperty("response-policy", RESPONSE_POLICY, 66064, ResponsePolicy.class);
        this.createAttribute(RESPONSE_POLICY, "auth-source", "AuthSource", 514, new String[]{"sender", "content"}, null);
        this.createAttribute(RESPONSE_POLICY, "auth-recipient", "AuthRecipient", 514, new String[]{"before-content", "after-content"}, null);
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setRequestPolicy(RequestPolicy value) {
        this.setValue(REQUEST_POLICY, value);
    }

    public RequestPolicy getRequestPolicy() {
        return (RequestPolicy)this.getValue(REQUEST_POLICY);
    }

    public void setResponsePolicy(ResponsePolicy value) {
        this.setValue(RESPONSE_POLICY, value);
    }

    public ResponsePolicy getResponsePolicy() {
        return (ResponsePolicy)this.getValue(RESPONSE_POLICY);
    }

    public void setElementProperty(int index, ElementProperty value) {
        this.setValue(ELEMENT_PROPERTY, index, (Object)value);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(ProviderConfig.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, (Object)value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName("name")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getProviderId() {
        return this.getAttributeValue("provider-id");
    }

    public void setProviderId(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("provider-id", v, overwrite);
    }

    public void setProviderId(String v) {
        this.setAttributeValue("provider-id", v);
    }

    public String getProviderType() {
        return this.getAttributeValue("provider-type");
    }

    public void setProviderType(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("provider-type", v, overwrite);
    }

    public void setProviderType(String v) {
        this.setAttributeValue("provider-type", v);
    }

    public String getClassName() {
        return this.getAttributeValue("class-name");
    }

    public void setClassName(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("class-name", v, overwrite);
    }

    public void setClassName(String v) {
        this.setAttributeValue("class-name", v);
    }

    public RequestPolicy newRequestPolicy() {
        return new RequestPolicy();
    }

    public ResponsePolicy newResponsePolicy() {
        return new ResponsePolicy();
    }

    public ElementProperty newElementProperty() {
        return new ElementProperty();
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "provider-config" + (this.canHaveSiblings() ? "[@provider-id='" + this.getAttributeValue("provider-id") + "']" : "");
        return null != ret ? ret.trim() : null;
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        attr = attr.trim();
        return null;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public void validate() throws ValidateException {
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append(REQUEST_POLICY);
        ConfigBean n = this.getRequestPolicy();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(REQUEST_POLICY, 0, str, indent);
        str.append(indent);
        str.append(RESPONSE_POLICY);
        n = this.getResponsePolicy();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(RESPONSE_POLICY, 0, str, indent);
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (int i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("ProviderConfig\n");
        this.dump(str, "\n  ");
        return str.toString();
    }
}

