/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.JMSServiceType;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.util.SystemPropertyConstants;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppserverClusterViewFromCacheRepository {
    private final String myName;
    private final ConfigContext domainCC;

    public AppserverClusterViewFromCacheRepository(String domainXmlUrl) throws ConfigException {
        if (domainXmlUrl == null) {
            throw new IllegalArgumentException("null_arg");
        }
        this.myName = System.getProperty("com.sun.aas.instanceName");
        String url = domainXmlUrl;
        this.domainCC = ConfigFactory.createConfigContext(url, true, true, false, false);
    }

    public ConfigContext getUnResolvedConfigContext() {
        return this.domainCC;
    }

    public Map<String, JmsHost> getResolvedLocalJmsHostsInCluster(String clusterName) throws ConfigException {
        Server[] buddies;
        HashMap<String, JmsHost> map = new HashMap<String, JmsHost>();
        String myCluster = ClusterHelper.getClusterByName(this.domainCC, clusterName).getName();
        for (Server as : buddies = ServerHelper.getServersInCluster(this.domainCC, myCluster)) {
            try {
                JmsHost copy = this.getResolvedJmsHost(as);
                map.put(as.getName(), copy);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return map;
    }

    public Map<String, JmsHost> getResolvedLocalJmsHostsInMyCluster(boolean includeMe) throws ConfigException {
        HashMap<String, JmsHost> map = new HashMap<String, JmsHost>();
        if (ServerHelper.isServerClustered(this.domainCC, this.myName)) {
            Server[] buddies;
            String myCluster = ClusterHelper.getClusterForInstance(this.domainCC, this.myName).getName();
            for (Server as : buddies = ServerHelper.getServersInCluster(this.domainCC, myCluster)) {
                if (!includeMe && this.myName.equals(as.getName())) continue;
                try {
                    JmsHost copy = this.getResolvedJmsHost(as);
                    map.put(as.getName(), copy);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return map;
    }

    public JmsHost getResolvedJmsHost(Server as) throws ConfigException {
        JmsHost jmsHost = this.getResolvedLocalJmsHostInServer(as);
        JmsHost copy = new JmsHost();
        String hostName = this.getNodeAgentHostName(as);
        if (jmsHost != null) {
            copy.setHost(hostName);
            copy.setName(jmsHost.getName());
            String resolved = this.resolve(as.getName(), SystemPropertyConstants.unSystemProperty(jmsHost.getPort()));
            copy.setPort(resolved);
            copy.setAdminPassword(jmsHost.getAdminPassword());
            copy.setAdminUserName(jmsHost.getAdminUserName());
        }
        return copy;
    }

    public Map<String, JmsHost> getResolvedLocalJmsHostsInMyCluster() throws ConfigException {
        return this.getResolvedLocalJmsHostsInMyCluster(false);
    }

    public JmsHost getMasterJmsHostInCluster(String clusterName) throws ConfigException {
        Server[] buddies;
        String myCluster = ClusterHelper.getClusterByName(this.domainCC, clusterName).getName();
        for (Server as : buddies = ServerHelper.getServersInCluster(this.domainCC, myCluster)) {
            try {
                JmsHost copy = this.getResolvedJmsHost(as);
                return copy;
            }
            catch (Exception e) {
            }
        }
        throw new RuntimeException("No JMS hosts available to select as Master");
    }

    public JmsService getJmsServiceForMasterBroker(String clusterName) throws ConfigException {
        String myCluster = ClusterHelper.getClusterByName(this.domainCC, clusterName).getName();
        Server[] buddies = ServerHelper.getServersInCluster(this.domainCC, myCluster);
        Config cfg = ServerHelper.getConfigForServer(this.domainCC, buddies[0].getName());
        return cfg.getJmsService();
    }

    private JmsHost getResolvedLocalJmsHostInServer(Server server) throws ConfigException {
        Config cfg = ServerHelper.getConfigForServer(this.domainCC, server.getName());
        JmsService jmsService = cfg.getJmsService();
        JmsHost jmsHost = null;
        if (JMSServiceType.LOCAL.toString().equals(jmsService.getType()) || JMSServiceType.EMBEDDED.toString().equals(jmsService.getType())) {
            jmsHost = this.getDefaultJmsHost(jmsService);
        }
        return jmsHost;
    }

    private JmsHost getDefaultJmsHost(JmsService jmsService) {
        JmsHost[] jmsHosts = jmsService.getJmsHost();
        String defaultHostName = jmsService.getDefaultJmsHost();
        JmsHost defaultJmsHost = null;
        for (JmsHost h : jmsHosts) {
            String name = h.getName();
            if (!name.equals(defaultHostName)) continue;
            defaultJmsHost = h;
            break;
        }
        return defaultJmsHost;
    }

    public String getNodeAgentHostName(Server as) throws ConfigException {
        NodeAgent na = NodeAgentHelper.getNodeAgentForServer(this.domainCC, as.getName());
        boolean dasShookHandsWithNodeAgent = NodeAgentHelper.hasNodeAgentRendezvousd(this.domainCC, na);
        if (!dasShookHandsWithNodeAgent) {
            throw new RuntimeException("Error: NA: " + na.getName() + " has not rendezvous'ed with DAS");
        }
        String naHost = NodeAgentHelper.getNodeAgentSystemConnector(this.domainCC, na.getName()).getElementPropertyByName("client-hostname").getValue();
        return naHost;
    }

    private String resolve(String server, String value) throws ConfigException {
        PropertyResolver pr = new PropertyResolver(this.domainCC, server);
        String resolved = pr.getPropertyValue(value, true);
        if (resolved == null) {
            resolved = value;
        }
        return resolved;
    }
}

