/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.Orb;
import com.sun.enterprise.config.serverbeans.SslClientConfig;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.ValidateException;
import org.netbeans.modules.schema2beans.Version;

public class IiopService
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    private static final Version runtimeVersion = new Version(4, 2, 0);
    public static final String ORB = "Orb";
    public static final String SSL_CLIENT_CONFIG = "SslClientConfig";
    public static final String IIOP_LISTENER = "IiopListener";

    public IiopService() {
        this(1);
    }

    public IiopService(int options) {
        super(comparators, runtimeVersion);
        this.initPropertyTables(3);
        this.createProperty("orb", ORB, 66080, Orb.class);
        this.createAttribute(ORB, "use-thread-pool-ids", "UseThreadPoolIds", 257, null, null);
        this.createAttribute(ORB, "message-fragment-size", "MessageFragmentSize", 1, null, "1024");
        this.createAttribute(ORB, "max-connections", "MaxConnections", 1, null, "1024");
        this.createProperty("ssl-client-config", SSL_CLIENT_CONFIG, 66064, SslClientConfig.class);
        this.createProperty("iiop-listener", IIOP_LISTENER, 66096, IiopListener.class);
        this.createAttribute(IIOP_LISTENER, "id", "Id", 257, null, null);
        this.createAttribute(IIOP_LISTENER, "address", "Address", 257, null, null);
        this.createAttribute(IIOP_LISTENER, "port", "Port", 1, null, "1072");
        this.createAttribute(IIOP_LISTENER, "security-enabled", "SecurityEnabled", 1, null, "false");
        this.createAttribute(IIOP_LISTENER, "enabled", "Enabled", 1, null, "true");
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setOrb(Orb value) {
        this.setValue(ORB, value);
    }

    public Orb getOrb() {
        return (Orb)this.getValue(ORB);
    }

    public void setSslClientConfig(SslClientConfig value) {
        this.setValue(SSL_CLIENT_CONFIG, value);
    }

    public SslClientConfig getSslClientConfig() {
        return (SslClientConfig)this.getValue(SSL_CLIENT_CONFIG);
    }

    public IiopListener getIiopListener(int index) {
        return (IiopListener)this.getValue(IIOP_LISTENER, index);
    }

    public void setIiopListener(IiopListener[] value) {
        this.setValue(IIOP_LISTENER, value);
    }

    public IiopListener[] getIiopListener() {
        return (IiopListener[])this.getValues(IIOP_LISTENER);
    }

    public int sizeIiopListener() {
        return this.size(IIOP_LISTENER);
    }

    public int addIiopListener(IiopListener value) throws ConfigException {
        return this.addIiopListener(value, true);
    }

    public int addIiopListener(IiopListener value, boolean overwrite) throws ConfigException {
        IiopListener old = this.getIiopListenerById(value.getId());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(IiopService.class).getString("cannotAddDuplicate", IIOP_LISTENER));
        }
        return this.addValue(IIOP_LISTENER, value, overwrite);
    }

    public int removeIiopListener(IiopListener value) {
        return this.removeValue(IIOP_LISTENER, (Object)value);
    }

    public int removeIiopListener(IiopListener value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(IIOP_LISTENER, value, overwrite);
    }

    public IiopListener getIiopListenerById(String id) {
        IiopListener[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getIiopListener()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName("id")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public boolean isClientAuthenticationRequired() {
        return IiopService.toBoolean(this.getAttributeValue("client-authentication-required"));
    }

    public void setClientAuthenticationRequired(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("client-authentication-required", "" + v, overwrite);
    }

    public void setClientAuthenticationRequired(boolean v) {
        this.setAttributeValue("client-authentication-required", "" + v);
    }

    public static String getDefaultClientAuthenticationRequired() {
        return "false".trim();
    }

    public Orb newOrb() {
        return new Orb();
    }

    public SslClientConfig newSslClientConfig() {
        return new SslClientConfig();
    }

    public IiopListener newIiopListener() {
        return new IiopListener();
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "iiop-service";
        return null != ret ? ret.trim() : null;
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).equals("client-authentication-required")) {
            return "false".trim();
        }
        return null;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public void validate() throws ValidateException {
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append(ORB);
        ConfigBean n = this.getOrb();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(ORB, 0, str, indent);
        str.append(indent);
        str.append(SSL_CLIENT_CONFIG);
        n = this.getSslClientConfig();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(SSL_CLIENT_CONFIG, 0, str, indent);
        str.append(indent);
        str.append("IiopListener[" + this.sizeIiopListener() + "]");
        for (int i = 0; i < this.sizeIiopListener(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getIiopListener(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(IIOP_LISTENER, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("IiopService\n");
        this.dump(str, "\n  ");
        return str.toString();
    }
}

