/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.ValidateException;
import org.netbeans.modules.schema2beans.Version;

public class JmxConnector
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    private static final Version runtimeVersion = new Version(4, 2, 0);
    public static final String SSL = "Ssl";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public JmxConnector() {
        this(1);
    }

    public JmxConnector(int options) {
        super(comparators, runtimeVersion);
        this.initPropertyTables(2);
        this.createProperty("ssl", SSL, 66064, Ssl.class);
        this.createAttribute(SSL, "cert-nickname", "CertNickname", 257, null, null);
        this.createAttribute(SSL, "ssl2-enabled", "Ssl2Enabled", 1, null, "false");
        this.createAttribute(SSL, "ssl2-ciphers", "Ssl2Ciphers", 513, null, null);
        this.createAttribute(SSL, "ssl3-enabled", "Ssl3Enabled", 1, null, "true");
        this.createAttribute(SSL, "ssl3-tls-ciphers", "Ssl3TlsCiphers", 513, null, null);
        this.createAttribute(SSL, "tls-enabled", "TlsEnabled", 1, null, "true");
        this.createAttribute(SSL, "tls-rollback-enabled", "TlsRollbackEnabled", 1, null, "true");
        this.createAttribute(SSL, "client-auth-enabled", "ClientAuthEnabled", 1, null, "false");
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setSsl(Ssl value) {
        this.setValue(SSL, value);
    }

    public Ssl getSsl() {
        return (Ssl)this.getValue(SSL);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(JmxConnector.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, (Object)value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName("name")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getName() {
        return this.getAttributeValue("name");
    }

    public void setName(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("name", v, overwrite);
    }

    public void setName(String v) {
        this.setAttributeValue("name", v);
    }

    public boolean isEnabled() {
        return JmxConnector.toBoolean(this.getAttributeValue("enabled"));
    }

    public void setEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("enabled", "" + v, overwrite);
    }

    public void setEnabled(boolean v) {
        this.setAttributeValue("enabled", "" + v);
    }

    public static String getDefaultEnabled() {
        return "true".trim();
    }

    public String getProtocol() {
        return this.getAttributeValue("protocol");
    }

    public void setProtocol(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("protocol", v, overwrite);
    }

    public void setProtocol(String v) {
        this.setAttributeValue("protocol", v);
    }

    public static String getDefaultProtocol() {
        return "rmi_jrmp".trim();
    }

    public String getAddress() {
        return this.getAttributeValue("address");
    }

    public void setAddress(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("address", v, overwrite);
    }

    public void setAddress(String v) {
        this.setAttributeValue("address", v);
    }

    public String getPort() {
        return this.getAttributeValue("port");
    }

    public void setPort(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("port", v, overwrite);
    }

    public void setPort(String v) {
        this.setAttributeValue("port", v);
    }

    public boolean isAcceptAll() {
        return JmxConnector.toBoolean(this.getAttributeValue("accept-all"));
    }

    public void setAcceptAll(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("accept-all", "" + v, overwrite);
    }

    public void setAcceptAll(boolean v) {
        this.setAttributeValue("accept-all", "" + v);
    }

    public static String getDefaultAcceptAll() {
        return "false".trim();
    }

    public String getAuthRealmName() {
        return this.getAttributeValue("auth-realm-name");
    }

    public void setAuthRealmName(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("auth-realm-name", v, overwrite);
    }

    public void setAuthRealmName(String v) {
        this.setAttributeValue("auth-realm-name", v);
    }

    public boolean isSecurityEnabled() {
        return JmxConnector.toBoolean(this.getAttributeValue("security-enabled"));
    }

    public void setSecurityEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("security-enabled", "" + v, overwrite);
    }

    public void setSecurityEnabled(boolean v) {
        this.setAttributeValue("security-enabled", "" + v);
    }

    public static String getDefaultSecurityEnabled() {
        return "true".trim();
    }

    public Ssl newSsl() {
        return new Ssl();
    }

    public ElementProperty newElementProperty() {
        return new ElementProperty();
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "jmx-connector" + (this.canHaveSiblings() ? "[@name='" + this.getAttributeValue("name") + "']" : "");
        return null != ret ? ret.trim() : null;
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).equals("enabled")) {
            return "true".trim();
        }
        if (attr.equals("protocol")) {
            return "rmi_jrmp".trim();
        }
        if (attr.equals("accept-all")) {
            return "false".trim();
        }
        if (attr.equals("security-enabled")) {
            return "true".trim();
        }
        return null;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public void validate() throws ValidateException {
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append(SSL);
        ConfigBean n = this.getSsl();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(SSL, 0, str, indent);
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (int i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("JmxConnector\n");
        this.dump(str, "\n  ");
        return str.toString();
    }
}

