/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.CustomResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.PersistenceManagerFactoryResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.validation.AttrType;
import com.sun.enterprise.config.serverbeans.validation.ValidationContext;
import java.util.logging.Level;

public class AttrUniqueJNDI
extends AttrType {
    public AttrUniqueJNDI(String name, String type, boolean optional) {
        super(name, type, optional);
    }

    public void validate(Object o, ValidationContext valCtx) {
        super.validate(o, valCtx);
        String jndiName = null;
        String choice = valCtx.choice;
        boolean flag = false;
        if (o == null || o.equals("")) {
            return;
        }
        jndiName = (String)o;
        if (choice.equals("ADD") && this.isResourceBeingUsed(valCtx.context, jndiName)) {
            valCtx.result.failed(valCtx.smh.getLocalString(this.getClass().getName() + ".jndiNameBeingUsed", "Attribute({0}={1}) :  name already used by some other resource", new Object[]{valCtx.attrName, jndiName}));
        }
        if (jndiName.indexOf("'") != -1) {
            valCtx.result.failed(valCtx.smh.getLocalString(this.getClass().getName() + ".invalidJndiName", "Apostrophe not allowed in jndi name: {0}", new Object[]{jndiName}));
        }
    }

    public boolean isResourceBeingUsed(ConfigContext context, String jndi) {
        boolean count = false;
        try {
            int i;
            Resources resources = ((Domain)context.getRootConfigBean()).getResources();
            AdminObjectResource[] admin = resources.getAdminObjectResource();
            ConnectorResource[] connres = resources.getConnectorResource();
            CustomResource[] custom = resources.getCustomResource();
            ExternalJndiResource[] external = resources.getExternalJndiResource();
            JdbcResource[] jdbcres = resources.getJdbcResource();
            MailResource[] mailres = resources.getMailResource();
            PersistenceManagerFactoryResource[] pers = resources.getPersistenceManagerFactoryResource();
            for (i = 0; i < admin.length; ++i) {
                if (!jndi.equals(admin[i].getJndiName())) continue;
                return true;
            }
            for (i = 0; i < connres.length; ++i) {
                if (!jndi.equals(connres[i].getJndiName())) continue;
                return true;
            }
            for (i = 0; i < custom.length; ++i) {
                if (!jndi.equals(custom[i].getJndiName())) continue;
                return true;
            }
            for (i = 0; i < external.length; ++i) {
                if (!jndi.equals(external[i].getJndiName())) continue;
                return true;
            }
            for (i = 0; i < jdbcres.length; ++i) {
                if (!jndi.equals(jdbcres[i].getJndiName())) continue;
                return true;
            }
            for (i = 0; i < mailres.length; ++i) {
                if (!jndi.equals(mailres[i].getJndiName())) continue;
                return true;
            }
            for (i = 0; i < pers.length; ++i) {
                if (!jndi.equals(pers[i].getJndiName())) continue;
                return true;
            }
        }
        catch (ConfigException e) {
            _logger.log(Level.FINE, "domainxmlverifier_error", e);
        }
        return false;
    }
}

