/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.admin.AdminValidationException;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigContextEventListener;
import com.sun.enterprise.config.serverbeans.validation.AttrAddress;
import com.sun.enterprise.config.serverbeans.validation.AttrClassName;
import com.sun.enterprise.config.serverbeans.validation.AttrFile;
import com.sun.enterprise.config.serverbeans.validation.AttrInt;
import com.sun.enterprise.config.serverbeans.validation.AttrString;
import com.sun.enterprise.config.serverbeans.validation.AttrType;
import com.sun.enterprise.config.serverbeans.validation.AttrUniqueJNDI;
import com.sun.enterprise.config.serverbeans.validation.DomainCheck;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.NameListMgr;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.StringManagerHelper;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.XPathHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomainMgr
implements ConfigContextEventListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    HashMap tests = new HashMap();
    private transient long lastModified = 0L;
    public NameListMgr _nameListMgr;
    public MBeanRegistry _mbeanRegistry;
    public static final String TEST_PACKAGE = "com.sun.enterprise.config.serverbeans.validation.tests.";

    public DomainMgr() {
        this(MBeanRegistryFactory.getAdminContext().getAdminConfigContext(), false);
    }

    public DomainMgr(ConfigContext ctx, boolean bStaticContext) {
        this(ctx, bStaticContext, null);
    }

    public DomainMgr(ConfigContext ctx, boolean bStaticContext, MBeanRegistry registry) {
        this.loadDescriptors();
        this._nameListMgr = new NameListMgr(ctx, bStaticContext);
        this._mbeanRegistry = registry == null ? MBeanRegistryFactory.getAdminMBeanRegistry() : registry;
    }

    MBeanRegistry getMBeanRegistry() {
        return this._mbeanRegistry;
    }

    private String getTestFile() throws Exception {
        URL propertiesFile = DomainMgr.class.getClassLoader().getResource("com/sun/enterprise/config/serverbeans/validation/config/ServerTestList.xml");
        return propertiesFile.toString();
    }

    public boolean loadDescriptors() {
        boolean allIsWell = true;
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource(this.getTestFile());
            Document doc = db.parse(is);
            NodeList list = doc.getElementsByTagName("element");
            for (int i = 0; i < list.getLength(); ++i) {
                String key;
                Element e = (Element)list.item(i);
                String elementName = e.getAttribute("name");
                String elementXPath = e.getAttribute("xpath");
                String elementCustomClass = e.getAttribute("custom-class");
                String testName = e.getAttribute("test-name");
                if (testName == null || testName.length() == 0) {
                    testName = XPathHelper.convertName(elementName);
                }
                if (null == elementCustomClass || elementCustomClass.length() == 0) {
                    elementCustomClass = testName;
                }
                String[] required_children = null;
                String[] exclusive_list = null;
                String elemList = e.getAttribute("required-children");
                if (elemList != null && elemList.length() > 0) {
                    required_children = elemList.split(",");
                }
                if ((elemList = e.getAttribute("exclusive-list")) != null && elemList.length() > 0) {
                    exclusive_list = elemList.split(",");
                }
                if ((key = e.getAttribute("key")) != null && key.length() == 0) {
                    key = null;
                }
                Vector<AttrType> attributes = new Vector<AttrType>();
                NodeList nl = e.getChildNodes();
                int index = 0;
                for (int j = 0; j < nl.getLength(); ++j) {
                    String temp;
                    String nodeName = nl.item(j).getNodeName().trim();
                    String nameValue = null;
                    String typeValue = null;
                    NamedNodeMap nodeMap = null;
                    AttrType attr = null;
                    Node n = nl.item(j);
                    if (!"attribute".equals(nodeName) && !"optional-attribute".equals(nodeName)) continue;
                    nodeMap = n.getAttributes();
                    nameValue = this.getAttr(nodeMap, "name");
                    typeValue = this.getAttr(nodeMap, "type");
                    if ("string".equals(typeValue)) {
                        attr = new AttrString(nameValue, typeValue, "optional-attribute".equals(nodeName));
                        temp = this.getAttr(nodeMap, "max-length");
                        if (temp != null) {
                            ((AttrString)attr).setMaxLength(Integer.parseInt(temp));
                        }
                        if ((temp = this.getAttr(nodeMap, "enumeration")) != null) {
                            Vector<String> ee = new Vector<String>();
                            String[] strs = temp.split(",");
                            for (int k = 0; k < strs.length; ++k) {
                                ee.add(strs[k]);
                            }
                            ((AttrString)attr).setEnumstring(ee);
                        }
                        ((AttrString)attr).setRegExpression(this.getAttr(nodeMap, "regex"));
                    } else if ("file".equals(typeValue)) {
                        attr = new AttrFile(nameValue, typeValue, "optional-attribute".equals(nodeName));
                        if ("true".equals(this.getAttr(nodeMap, "exists"))) {
                            ((AttrFile)attr).setCheckExists(true);
                        }
                    } else if ("integer".equals(typeValue)) {
                        attr = new AttrInt(nameValue, typeValue, "optional-attribute".equals(nodeName));
                        temp = this.getAttr(nodeMap, "range");
                        if (temp != null) {
                            String[] strs = temp.split(",");
                            if (!strs[0].equals("NA")) {
                                ((AttrInt)attr).setLowRange(Integer.parseInt(strs[0]));
                            }
                            if (!strs[1].equals("NA")) {
                                ((AttrInt)attr).setHighRange(Integer.parseInt(strs[1]));
                            }
                        }
                    } else if ("classname".equals(typeValue)) {
                        attr = new AttrClassName(nameValue, typeValue, "optional-attribute".equals(nodeName));
                    } else if ("address".equals(typeValue)) {
                        attr = new AttrAddress(nameValue, typeValue, "optional-attribute".equals(nodeName));
                    } else if ("jndi-unique".equals(typeValue)) {
                        attr = new AttrUniqueJNDI(nameValue, typeValue, "optional-attribute".equals(nodeName));
                    }
                    if (attr == null) continue;
                    attr.addRuleValue("belongs-to", this.getAttrAsList(nodeMap, "belongs-to"));
                    attr.addRuleValue("references-to", this.getAttrAsList(nodeMap, "references-to"));
                    attr.addRuleValue("le-than", this.getAttr(nodeMap, "le-than"));
                    attr.addRuleValue("ls-than", this.getAttr(nodeMap, "ls-than"));
                    attr.addRuleValue("ge-than", this.getAttr(nodeMap, "ge-than"));
                    attr.addRuleValue("gt-than", this.getAttr(nodeMap, "gt-than"));
                    attributes.add(index++, attr);
                }
                ValidationDescriptor desc = new ValidationDescriptor(this, elementName, elementXPath, elementCustomClass, key, attributes, required_children, exclusive_list);
                GenericValidator validator = this.getGenericValidator(desc);
                if (validator == null) continue;
                this.tests.put(testName, validator);
            }
        }
        catch (ParserConfigurationException e) {
            _logger.log(Level.WARNING, "parser_error", e);
            allIsWell = false;
        }
        catch (SAXException e) {
            _logger.log(Level.WARNING, "sax_error", e);
            allIsWell = false;
        }
        catch (IOException e) {
            _logger.log(Level.WARNING, "error_loading_xmlfile", e);
            allIsWell = false;
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "error", e);
            allIsWell = false;
        }
        return allIsWell;
    }

    private String getAttr(NamedNodeMap nodeMap, String attrName) {
        Node node = nodeMap.getNamedItem(attrName);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    private String[] getAttrAsList(NamedNodeMap nodeMap, String attrName) {
        String attrValue = this.getAttr(nodeMap, attrName);
        if (attrValue == null) {
            return null;
        }
        return attrValue.split(",");
    }

    GenericValidator getGenericValidator(ValidationDescriptor v) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Class c = this.getValidatorClass(v.getCustomValidatorClass());
        try {
            Constructor con = c.getConstructor(ValidationDescriptor.class);
            return (GenericValidator)con.newInstance(v);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    Class getValidatorClass(String className) {
        Class<Object> c;
        String cn = TEST_PACKAGE + className + "Test";
        try {
            c = Class.forName(cn);
        }
        catch (ClassNotFoundException cnfe2) {
            c = GenericValidator.class;
        }
        _logger.log(Level.CONFIG, "validator using class \"" + c.getName() + "\" to validate \"" + cn + "\"");
        return c;
    }

    public Result check(ConfigContextEvent cce) {
        String name = cce.getName();
        String beanName = cce.getBeanName();
        Result result = null;
        if (name == null && beanName == null) {
            return result;
        }
        DomainCheck validator = (DomainCheck)this.tests.get(name);
        if (validator == null && beanName != null) {
            validator = (DomainCheck)this.tests.get(beanName);
        }
        try {
            if (validator != null) {
                result = validator.validate(cce);
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "domainxmlverifier.error_on_validation", e);
        }
        return result;
    }

    public void postAccessNotification(ConfigContextEvent ccce) {
    }

    public void postChangeNotification(ConfigContextEvent ccce) {
    }

    public void preAccessNotification(ConfigContextEvent ccce) {
    }

    public void preChangeNotification(ConfigContextEvent cce) {
        Result result = null;
        try {
            result = this.check(cce);
        }
        catch (Throwable t) {
            _logger.log(Level.WARNING, "Exception during validation ", t);
        }
        if (result != null && result.getStatus() == 1) {
            _logger.log(Level.WARNING, "Validation error: " + result.getErrorDetails().toString());
            throw new AdminValidationException(result.getErrorDetailsAsString());
        }
    }

    ValidationDescriptor findValidationDescriptor(String beanName) {
        GenericValidator genVal;
        if (beanName != null && (genVal = (GenericValidator)this.tests.get(beanName)) != null) {
            return genVal.desc;
        }
        return null;
    }

    GenericValidator findConfigBeanValidator(ConfigBean configBean) {
        String className;
        int iLastDot;
        if (configBean != null && (iLastDot = (className = configBean.getClass().getName()).lastIndexOf(46)) > 0) {
            return (GenericValidator)this.tests.get(className.substring(iLastDot + 1));
        }
        return null;
    }
}

