/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.validation.AttrType;
import com.sun.enterprise.config.serverbeans.validation.DomainCheck;
import com.sun.enterprise.config.serverbeans.validation.DomainXmlVerifier;
import com.sun.enterprise.config.serverbeans.validation.ReportHelper;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.StringManagerHelper;
import com.sun.enterprise.config.serverbeans.validation.ValidationContext;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.XPathHelper;
import com.sun.enterprise.config.serverbeans.validation.tests.StaticTest;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenericValidator
implements DomainCheck {
    protected static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    protected LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    ValidationDescriptor desc;

    public GenericValidator(ValidationDescriptor desc) {
        this.desc = desc;
        StringManagerHelper.setLocalStringsManager(DomainXmlVerifier.class);
        this.smh = StringManagerHelper.getLocalStringsManager();
    }

    public ValidationContext initialize(ConfigContextEvent cce) {
        ValidationContext valCtx = new ValidationContext(new Result(), cce.getObject(), cce.getClassObject(), cce.getBeanName(), cce.getConfigContext(), cce.getName(), cce.getChoice(), this.desc.getKey(), this.smh, this.desc);
        String key = this.desc.getKey();
        String element = this.desc.getElementName();
        if (valCtx.value instanceof ConfigBean) {
            valCtx.result.setAssertion(element);
            try {
                valCtx.result.setTestName(this.smh.getLocalString(GenericValidator.class.getName() + ".Elementkeyvalue", "{0} = {1}", new Object[]{key, ((ConfigBean)valCtx.value).getAttributeValue(key)}));
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "domainxmlverifier.keynotfound", e);
            }
        }
        valCtx.result.setStatus(0);
        if (!valCtx.isVALIDATE()) {
            String strDefault;
            String strLocalTag;
            String elementName = GenericValidator.getTargetElementPrintName(valCtx, true, false);
            if (valCtx.isADD() || valCtx.isSET()) {
                strLocalTag = "add_operation_descr";
                strDefault = "Creation config element for {0}";
            } else if (valCtx.isDELETE()) {
                strLocalTag = "delete_operation_descr";
                strDefault = "Deletion of config element for {0}";
            } else {
                strLocalTag = "update_operation_descr";
                strDefault = "Update of config element for {0}";
            }
            valCtx.result.setOperationPrintName(valCtx.smh.getLocalString(strLocalTag, strDefault, new Object[]{elementName}));
        }
        return valCtx;
    }

    private void validateAttribute(AttrType attr, ValidationContext valCtx) {
        if (valCtx.choice == null) {
            return;
        }
        String attrName = attr.getName();
        Object value = null;
        ConfigBean ownerBean = null;
        if (valCtx.isADD() || valCtx.isVALIDATE() || valCtx.isSET() || valCtx.isDELETE()) {
            ownerBean = (ConfigBean)valCtx.value;
            value = ((ConfigBean)valCtx.value).getAttributeValue(attrName);
        } else if (valCtx.isUPDATE() && attr.getName().equals(valCtx.name)) {
            ownerBean = (ConfigBean)valCtx.classObject;
            value = valCtx.value;
        }
        if (ownerBean != null) {
            valCtx.setAttrName(attrName);
            valCtx.attrValue = value;
            this.validateAttribute(ownerBean, attr, value, valCtx);
        }
    }

    public void validateAttribute(ConfigBean ownerBean, AttrType attr, Object value, ValidationContext valCtx) {
        if (!StaticTest.valueContainsTokenExpression((String)value)) {
            attr.validate(value, valCtx);
        }
    }

    public void validateElement(ValidationContext valCtx) {
        String key = this.desc.getKey();
        String element = this.desc.getElementName();
        if (valCtx.isADD() || valCtx.isSET()) {
            ConfigBean thisBean = (ConfigBean)valCtx.value;
            ConfigBean parentBean = (ConfigBean)valCtx.classObject;
            String[] names = this.desc.requiredChildren;
            for (int i = 0; names != null && i < names.length; ++i) {
                String printParentName;
                ConfigBean[] beans;
                String childName = names[i];
                if (names[i].endsWith("*")) {
                    childName = names[i].substring(0, names[i].length() - 1);
                }
                if ((beans = thisBean.getChildBeansByName(childName = XPathHelper.convertName(childName))) != null && beans.length != 0) continue;
                if (names[i].endsWith("*")) {
                    printParentName = this.getConfigElementPrintName(GenericValidator.getFutureXPath(thisBean, parentBean), false, false);
                    valCtx.result.failed(valCtx.smh.getLocalString(GenericValidator.class.getName() + ".multipleRequiredElemAbsent", "At least one required element {0} should be present in created {1}", new Object[]{names[i].substring(0, names[i].length() - 1), printParentName}));
                    continue;
                }
                printParentName = this.getConfigElementPrintName(GenericValidator.getFutureXPath(thisBean, parentBean), false, false);
                valCtx.result.failed(valCtx.smh.getLocalString(GenericValidator.class.getName() + ".requiredElemAbsent", "Required element {0} should be present in created {1}", new Object[]{names[i], printParentName}));
            }
            names = this.desc.exclusiveChildren;
            String alreadyFound = null;
            for (int i = 0; names != null && i < names.length; ++i) {
                String childName = names[i];
                ConfigBean[] beans = thisBean.getChildBeansByName(childName = XPathHelper.convertName(childName));
                if (beans == null || beans.length == 0) continue;
                if (alreadyFound == null) {
                    alreadyFound = names[i];
                    continue;
                }
                String printParentName = this.getConfigElementPrintName(GenericValidator.getFutureXPath(thisBean, parentBean), false, false);
                valCtx.result.failed(valCtx.smh.getLocalString(GenericValidator.class.getName() + ".childrenCanExistTogether", "{0} can not contain both sub-elements {1} and {2} in the same time.", new Object[]{printParentName, alreadyFound, names[i]}));
            }
        }
    }

    public void validatePropertyChanges(ValidationContext valCtx) {
    }

    public void validateAsParent(ValidationContext valCtx) {
        ConfigBean childBean;
        String childBeanName;
        ConfigBean parentBean;
        ConfigBean[] beans;
        if (valCtx.isADD() || valCtx.isSET()) {
            int i;
            ConfigBean newChildBean = (ConfigBean)valCtx.value;
            String newChildBeanName = GenericValidator.getBeanElementName(newChildBean);
            ConfigBean parentBean2 = (ConfigBean)valCtx.classObject;
            String[] names = this.desc.exclusiveChildren;
            boolean bNewChildIsInList = false;
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    if (!newChildBeanName.equals(names[i])) continue;
                    bNewChildIsInList = true;
                    break;
                }
            }
            if (bNewChildIsInList) {
                for (i = 0; i < names.length; ++i) {
                    ConfigBean[] beans2;
                    String childName = names[i];
                    if (childName.equals(newChildBeanName) || (beans2 = parentBean2.getChildBeansByName(childName = XPathHelper.convertName(childName))) == null || beans2.length <= 0) continue;
                    String printParentName = this.getConfigElementPrintName(parentBean2.getXPath(), false, false);
                    valCtx.result.failed(valCtx.smh.getLocalString(GenericValidator.class.getName() + ".childrenCanExistTogether", "{0} can not contain both sub-elements {1} and {2} in the same time.", new Object[]{printParentName, newChildBeanName, names[i]}));
                }
            }
        } else if (valCtx.isDELETE() && (beans = (parentBean = (ConfigBean)valCtx.classObject).getChildBeansByName(childBeanName = XPathHelper.convertName(GenericValidator.getBeanElementName(childBean = (ConfigBean)valCtx.value)))) != null && beans.length == 1) {
            ValidationDescriptor parentDescr = this.desc;
            String[] names = null;
            if (parentDescr != null) {
                names = parentDescr.requiredChildren;
            }
            String compareTo = GenericValidator.getBeanElementName(childBean);
            String compareTo2 = compareTo + '*';
            for (int i = 0; names != null && i < names.length; ++i) {
                if (compareTo.equals(names[i])) {
                    String printParentName = this.getConfigElementPrintName(parentBean.getXPath(), false, false);
                    String printChildName = this.getConfigElementPrintName(childBean.getXPath(), false, false);
                    valCtx.result.failed(valCtx.smh.getLocalString(GenericValidator.class.getName() + ".requiredElemDelete", "Required element {0} can not be deleted from {1}", new Object[]{printChildName, printParentName}));
                } else {
                    if (!compareTo2.equals(names[i])) continue;
                    String printParentName = this.getConfigElementPrintName(parentBean.getXPath(), false, false);
                    String printChildName = this.getConfigElementPrintName(childBean.getXPath(), false, false);
                    valCtx.result.failed(valCtx.smh.getLocalString(GenericValidator.class.getName() + ".lastRequiredElemDelete", "At least one required {0} should be present in {1}. Deletion rejected.", new Object[]{printChildName, printParentName}));
                }
                break;
            }
        }
        if (valCtx.getTargetBean() instanceof ElementProperty) {
            this.validatePropertyChanges(valCtx);
        }
    }

    public Result validate(ConfigContextEvent cce) {
        ValidationContext valCtx = this.initialize(cce);
        _logger.log(Level.CONFIG, "GenericValidator processing choice: " + valCtx.choice);
        this.validate(valCtx);
        return valCtx.result;
    }

    public void validate(ValidationContext valCtx) {
        GenericValidator parentValidator;
        this.validateElement(valCtx);
        ConfigBean parentBean = valCtx.getParentBean();
        if (parentBean != null && (parentValidator = this.desc.domainMgr.findConfigBeanValidator(parentBean)) != null) {
            parentValidator.validateAsParent(valCtx);
        }
        Vector attrs = this.desc.getAttributes();
        for (int i = 0; i < attrs.size(); ++i) {
            try {
                this.validateAttribute((AttrType)attrs.get(i), valCtx);
                continue;
            }
            catch (IllegalArgumentException e) {
                valCtx.result.failed(e.getMessage());
                continue;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "domainxmlverifier.errorinvokingmethod", e);
            }
        }
    }

    static String getConfigElementPrintName(ValidationContext valCtx, String xpath, boolean bIncludingKey, boolean bReplaceRefByParentElem) {
        return valCtx.validationDescriptor.domainMgr.getMBeanRegistry().getConfigElementPrintName(xpath, bIncludingKey, bReplaceRefByParentElem);
    }

    String getConfigElementPrintName(String xpath, boolean bIncludingKey, boolean bReplaceRefByParentElem) {
        return this.desc.domainMgr.getMBeanRegistry().getConfigElementPrintName(xpath, bIncludingKey, bReplaceRefByParentElem);
    }

    static String getTargetElementPrintName(ValidationContext valCtx, boolean bIncludingKey, boolean bReplaceRefByParentElem) {
        ConfigBean targetBean = valCtx.getTargetBean();
        if (targetBean == null) {
            return null;
        }
        ConfigBean parentBean = valCtx.getParentBean();
        return GenericValidator.getConfigElementPrintName(valCtx, GenericValidator.getFutureXPath(targetBean, parentBean), bIncludingKey, bReplaceRefByParentElem);
    }

    protected static String getFutureXPath(ConfigBean childBean, ConfigBean parentBean) {
        String[] tokens = XPathHelper.extractTokens(childBean.getAbsoluteXPath(""));
        if (parentBean == null) {
            return "/" + tokens[tokens.length - 1];
        }
        return parentBean.getXPath() + "/" + tokens[tokens.length - 1];
    }

    protected static String getBeanElementName(ConfigBean bean) {
        String[] tokens = XPathHelper.extractTokens(bean.getAbsoluteXPath(""));
        if (tokens.length < 1) {
            return null;
        }
        String last = tokens[tokens.length - 1];
        int idx = last.indexOf(91);
        if (idx > 0) {
            return last.substring(0, idx);
        }
        return last;
    }

    public static void reportValidationError(ValidationContext valCtx, String msgNameSuffix, String defaultMsg, Object[] values) {
        ReportHelper.reportValidationError(valCtx, msgNameSuffix, defaultMsg, values);
    }
}

