/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.validation.StringManagerHelper;
import com.sun.enterprise.config.serverbeans.validation.XPathHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;

public class NameList {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    LocalStringManagerImpl _localStrings = StringManagerHelper.getLocalStringsManager();
    ConfigContext _ctx;
    ArrayList _srcXPathes;
    ArrayList _refXPathes;
    Hashtable _srcLists = null;
    Hashtable _refLists = null;
    boolean _bKeepList = false;
    String _name;
    String _fullName;
    String _scope;
    int _scope_depth;

    public NameList(String name, String fullName, String scope, ArrayList srcXPathes, ArrayList refXPathes, ConfigContext ctx, boolean bPreCreateAndKeepList) {
        this._name = name;
        this._fullName = fullName;
        this._srcXPathes = srcXPathes;
        this._refXPathes = refXPathes;
        if (scope != null && !scope.equals("/")) {
            this._scope = scope.trim();
            this._scope_depth = XPathHelper.getNumberOfElemTokens(this._scope);
        }
        this._ctx = ctx;
        this._bKeepList = bPreCreateAndKeepList;
        this._srcLists = new Hashtable();
        this._refLists = new Hashtable();
        if (bPreCreateAndKeepList) {
            this.buildLists(null);
        }
    }

    public String toString() {
        int i;
        Object[] keys;
        Hashtable list;
        String str = "domain name: " + this._name;
        if (this._srcLists != null) {
            for (String key : this._srcLists.keySet()) {
                str = str + "\n    " + "list name: " + key;
                list = (Hashtable)this._srcLists.get(key);
                if (list == null) continue;
                keys = list.keySet().toArray();
                for (i = 0; i < keys.length; ++i) {
                    str = str + "\n      " + keys[i];
                }
            }
        }
        if (this._refLists != null) {
            for (String key : this._refLists.keySet()) {
                str = str + "\n    " + "Referencees list name: " + key;
                list = (Hashtable)this._refLists.get(key);
                if (list == null) continue;
                keys = list.keySet().toArray();
                for (i = 0; i < keys.length; ++i) {
                    str = str + "\n      " + keys[i];
                }
            }
        }
        return str;
    }

    public String getDomainValueSourceXPath(Object value, String xpath, boolean bRef) {
        String listName;
        if (xpath == null || value == null || (listName = this.getListNameForXpath(xpath)) == null) {
            return null;
        }
        Hashtable list = this.getNamedList(listName, bRef, false);
        if (list != null) {
            return (String)list.get(value);
        }
        return null;
    }

    public boolean isValueInNameDomain(Object value, String xpath, boolean bRef) {
        return this.getDomainValueSourceXPath(value, xpath, bRef) != null;
    }

    protected void buildLists(String onlyPrefix) {
        this._srcLists.clear();
        this._refLists.clear();
        this.buildList(this._srcXPathes, onlyPrefix, false);
        this.buildList(this._refXPathes, onlyPrefix, true);
    }

    private void buildList(ArrayList xpathes, String onlyPrefix, boolean bRef) {
        AttributeList arr = XPathHelper.resolve(this._ctx, xpathes, onlyPrefix);
        for (int i = 0; i < arr.size(); ++i) {
            Attribute attr = (Attribute)arr.get(i);
            String[] values = ((String)attr.getValue()).split(",");
            for (int j = 0; j < values.length; ++j) {
                this.addValueToProperList(attr.getName(), values[j], bRef);
            }
        }
    }

    private String addValueToProperList(String xpath, Object value, boolean bRef) {
        String listName;
        if (xpath == null || value == null || (listName = this.getListNameForXpath(xpath)) == null) {
            return null;
        }
        this.addValueToNamedList(listName, xpath, value, bRef);
        return listName;
    }

    private void addValueToNamedList(String listName, String sourceXPath, Object value, boolean bRef) {
        Hashtable list;
        if (listName != null && value != null && (list = this.getNamedList(listName, bRef, true)).get(value) == null) {
            list.put(value, sourceXPath);
        }
    }

    private Hashtable getNamedList(String listName, boolean bRef, boolean bCreateIfNotFound) {
        Hashtable lists = bRef ? this._refLists : this._srcLists;
        Hashtable list = (Hashtable)lists.get(listName);
        if (list == null && bCreateIfNotFound) {
            list = new Hashtable();
            lists.put(listName, list);
        }
        return list;
    }

    private String getListNameForXpath(String xpath) {
        return XPathHelper.getXPathPrefix(xpath, this._scope_depth);
    }
}

