/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.validation.NameList;
import com.sun.enterprise.config.serverbeans.validation.StringManagerHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NameListMgr {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    LocalStringManagerImpl _localStrings = StringManagerHelper.getLocalStringsManager();
    Hashtable _lists = new Hashtable();
    boolean _precreateAndKeepLists;
    ConfigContext _ctx;

    public NameListMgr(ConfigContext ctx, boolean precreateAndKeepLists) {
        this._precreateAndKeepLists = precreateAndKeepLists;
        this._ctx = ctx;
        this.loadDescriptors();
    }

    public String toString() {
        String str = "";
        if (this._lists != null) {
            Enumeration keys = this._lists.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                str = str + "\n" + ((NameList)this._lists.get(key)).toString();
            }
        }
        return str;
    }

    private NameList getNameList(String nameDomainName) {
        NameList list = null;
        if (this._lists != null) {
            list = (NameList)this._lists.get(nameDomainName);
        }
        if (list != null && !this._precreateAndKeepLists) {
            list.buildLists(null);
        }
        return list;
    }

    public String getDomainValueSourceXPath(String nameDomainName, Object value, String xpath) {
        NameList list = this.getNameList(nameDomainName);
        if (list != null) {
            return list.getDomainValueSourceXPath(value, xpath, false);
        }
        return null;
    }

    public String getDomainValueReferenceeXPath(String nameDomainName, Object value, String xpath) {
        NameList list = this.getNameList(nameDomainName);
        if (list != null) {
            return list.getDomainValueSourceXPath(value, xpath, true);
        }
        return null;
    }

    public boolean isUniqueValueInNameDomain(String nameDomainName, Object value, String xpath) {
        NameList list = this.getNameList(nameDomainName);
        if (list != null && list.isValueInNameDomain(value, xpath, false)) {
            String sourceXPath = list.getDomainValueSourceXPath(value, xpath, false);
            return xpath.equals(sourceXPath);
        }
        return true;
    }

    public boolean isValueInNameDomain(String nameDomainName, Object value, String xpath) {
        NameList list = this.getNameList(nameDomainName);
        if (list != null) {
            return list.isValueInNameDomain(value, xpath, false);
        }
        return false;
    }

    public boolean isValueInNameDomainReferenced(String nameDomainName, Object value, String xpath) {
        NameList list = this.getNameList(nameDomainName);
        if (list != null) {
            return list.isValueInNameDomain(value, xpath, true);
        }
        return false;
    }

    public String getDescriptionForNameDomain(String nameDomainName) {
        NameList list = this.getNameList(nameDomainName);
        if (list != null && list._fullName != null) {
            return list._fullName;
        }
        return nameDomainName;
    }

    private String getDescriptorsFilePath() throws Exception {
        URL propertiesFile = NameListMgr.class.getClassLoader().getResource("com/sun/enterprise/config/serverbeans/validation/config/name-domains.xml");
        return propertiesFile.toString();
    }

    public boolean loadDescriptors() {
        boolean allIsWell = true;
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource(this.getDescriptorsFilePath());
            Document doc = db.parse(is);
            NodeList list = doc.getElementsByTagName("name-list");
            for (int i = 0; i < list.getLength(); ++i) {
                Element e = (Element)list.item(i);
                String name = e.getAttribute("name");
                String fullName = e.getAttribute("full-name");
                String scope = e.getAttribute("scope");
                NodeList nl = e.getElementsByTagName("forms-from");
                ArrayList<String> xpath_arr = new ArrayList<String>();
                for (int j = 0; j < nl.getLength(); ++j) {
                    String xpath = ((Element)nl.item(j)).getAttribute("xpath");
                    if (xpath == null || xpath.length() <= 0) continue;
                    xpath_arr.add(xpath);
                }
                nl = e.getElementsByTagName("referenced-by");
                ArrayList<String> ref_xpath_arr = new ArrayList<String>();
                for (int j = 0; j < nl.getLength(); ++j) {
                    String xpath = ((Element)nl.item(j)).getAttribute("xpath");
                    if (xpath == null || xpath.length() <= 0) continue;
                    ref_xpath_arr.add(xpath);
                }
                this._lists.put(name, new NameList(name, fullName, scope, xpath_arr, ref_xpath_arr, this._ctx, this._precreateAndKeepLists));
            }
        }
        catch (ParserConfigurationException e) {
            _logger.log(Level.WARNING, "parser_error", e);
            allIsWell = false;
        }
        catch (SAXException e) {
            _logger.log(Level.WARNING, "sax_error", e);
            allIsWell = false;
        }
        catch (IOException e) {
            _logger.log(Level.WARNING, "error_loading_xmlfile", e);
            allIsWell = false;
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "error", e);
            allIsWell = false;
        }
        return allIsWell;
    }
}

