/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.validation.ValidationContext;
import java.util.HashMap;
import java.util.Map;

public abstract class PropertyHelper {
    static final String ELEMENT_PROPERTY = "ElementProperty";
    static final String PROP_NAME_ATTRNAME = "name";
    static final String PROP_VALUE_ATTRNAME = "value";

    public static Map getPropertiesMap(ConfigBean parent) {
        ElementProperty[] props;
        HashMap<String, String> map = new HashMap<String, String>();
        if (parent != null && (props = (ElementProperty[])parent.getValues(ELEMENT_PROPERTY)) != null) {
            for (int i = 0; i < props.length; ++i) {
                map.put(props[i].getName(), props[i].getValue());
            }
        }
        return map;
    }

    public static boolean isPropertyChanged(ValidationContext propValCtx, String name) {
        ElementProperty prop = (ElementProperty)propValCtx.getTargetBean();
        if (!(prop.getName().equals(name) || propValCtx.isUPDATE() && PROP_NAME_ATTRNAME.equals(propValCtx.name) && name.equals(propValCtx.value))) {
            return false;
        }
        Map map = PropertyHelper.getPropertiesMap(propValCtx.getParentBean());
        String oldValue = (String)map.get(name);
        PropertyHelper.addChangesToPropertiesMap(propValCtx, map);
        String newValue = (String)map.get(name);
        return (oldValue != null || newValue != null) && (oldValue == null || !oldValue.equals(newValue));
    }

    public static Map getFuturePropertiesMap(ValidationContext propValCtx) {
        Map map = PropertyHelper.getPropertiesMap(propValCtx.getParentBean());
        return PropertyHelper.addChangesToPropertiesMap(propValCtx, map);
    }

    private static Map addChangesToPropertiesMap(ValidationContext propValCtx, Map map) {
        if (propValCtx.isADD() || propValCtx.isSET()) {
            ElementProperty prop = (ElementProperty)propValCtx.getTargetBean();
            map.put(prop.getName(), prop.getValue());
        } else if (propValCtx.isUPDATE()) {
            ElementProperty prop = (ElementProperty)propValCtx.getTargetBean();
            if (PROP_NAME_ATTRNAME.equals(propValCtx.name)) {
                map.remove(prop.getName());
                map.put(propValCtx.value, prop.getValue());
            } else {
                map.put(prop.getName(), propValCtx.value);
            }
        }
        return map;
    }
}

