/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import java.util.logging.Level;

public class HttpListenerTest
extends GenericValidator {
    private static final String DELIMITER = ",";

    public HttpListenerTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        Result result;
        block16: {
            result = super.validate(cce);
            String choice = cce.getChoice();
            if (choice.equals("ADD") || choice.equals("VALIDATE")) {
                HttpListener h = (HttpListener)cce.getObject();
                String vsId = h.getDefaultVirtualServer();
                try {
                    Config config = (Config)((HttpService)cce.getClassObject()).parent();
                    if (config == null) break block16;
                    boolean exists = this.checkVSExists(vsId, config);
                    if (!exists) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".virtualserverNotFound", "Attribute(default-virtual-server={0}) : Virtual Server not found", new Object[]{vsId}));
                    } else if (h.isEnabled() && !this.isVirtualServerOn(h, config, result)) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotAddVsNotOn", "Cannot add this HttpListener \"{0}\" because it is enabled but its virtual server \"{1}\" has a state other than \"on\" ({2})", new Object[]{h.getId(), vsId, this.getDefaultVirtualServer(vsId, config).getState()}));
                    }
                }
                catch (Exception e) {
                    _logger.log(Level.FINE, "domainxmlverifier.error", e);
                }
            } else if (choice.equals("UPDATE")) {
                HttpListener h;
                if (cce.getName().equals("enabled") && ConfigBean.toBoolean((String)cce.getObject())) {
                    HttpListener h2 = (HttpListener)cce.getClassObject();
                    Config c = (Config)((HttpService)h2.parent()).parent();
                    VirtualServer vs = this.getDefaultVirtualServer(h2.getDefaultVirtualServer(), c);
                    if (null != vs && !vs.getState().equals("on")) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotUpdateVSNotOn", "Cannot enable this HttpListener \"{0}\" because its virtual server \"{1}\" has a state other than \"on\" ({2})", new Object[]{h2.getId(), vs.getId(), vs.getState()}));
                    }
                } else if ("enabled".equals(cce.getName()) && !ConfigBean.toBoolean((String)cce.getObject()) && "admin-listener".equals((h = (HttpListener)cce.getClassObject()).getId())) {
                    String locmsg = this.getClass().getName() + ".cantDisableAdminVS";
                    String enmsg = "ADMVAL1076: The http-listener reserved for administrative purposes can not be disabled.";
                    String msg = this.smh.getLocalString(locmsg, "ADMVAL1076: The http-listener reserved for administrative purposes can not be disabled.");
                    result.failed(msg);
                }
            } else if ("DELETE".equals(choice)) {
                HttpListener h;
                if (cce.getObject() instanceof HttpListener && "admin-listener".equals((h = (HttpListener)cce.getObject()).getId())) {
                    String locmsg = this.getClass().getName() + ".cantDeleteAdminListener";
                    String enmsg = "ADMVAL1075: The http-listener reserved for administrative purposes can not be deleted.";
                    String msg = this.smh.getLocalString(locmsg, "ADMVAL1075: The http-listener reserved for administrative purposes can not be deleted.");
                    result.failed(msg);
                }
            } else {
                _logger.log(Level.SEVERE, "domainxmlverifier.unknownchoice", choice);
            }
        }
        return result;
    }

    private final boolean isVirtualServerOn(HttpListener h, Config c, Result result) {
        VirtualServer vs = this.getDefaultVirtualServer(h.getDefaultVirtualServer(), c);
        return null != vs && vs.getState().equals("on");
    }

    private boolean checkVSExists(String vsID, Config config) {
        return this.getDefaultVirtualServer(vsID, config) != null;
    }

    private final VirtualServer getDefaultVirtualServer(String vsID, Config config) {
        VirtualServer[] virtualServer = config.getHttpService().getVirtualServer();
        for (int i = 0; i < virtualServer.length; ++i) {
            if (!vsID.equals(virtualServer[i].getId())) continue;
            return virtualServer[i];
        }
        return null;
    }
}

