/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import java.util.Set;
import java.util.logging.Level;

public class ServerTest
extends GenericValidator {
    public ServerTest(ValidationDescriptor desc) {
        super(desc);
    }

    void validateAdd(ConfigContextEvent cce, Result result) throws ConfigException {
        this.checkNameNotAgent(cce, result);
        this.checkConfigRefValidity(cce, result);
    }

    void validateUpdate(ConfigContextEvent cce, Result result) throws ConfigException {
        this.validateAttributeChange(cce, result);
    }

    protected final String getName(ConfigContextEvent cce) throws ConfigException {
        return this.getServer(cce).getName();
    }

    protected final boolean isReferenced(ConfigContextEvent cce) throws ConfigException {
        return ServerBeansFactory.isReferenced(this.getServer(cce), cce.getConfigContext());
    }

    protected final Set getReferers(ConfigContextEvent cce) throws ConfigException {
        return ServerBeansFactory.getReferers(this.getServer(cce), cce.getConfigContext());
    }

    private void checkNameNotAgent(ConfigContextEvent cce, Result result) throws ConfigException {
        Server s = this.getServer(cce);
        if ("agent".equals(s.getName())) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".illegalServerName", "Illegal Server Name {0}", new Object[]{s.getName()}));
        }
    }

    private Server getServer(ConfigContextEvent cce) throws ConfigException {
        return (Server)cce.getValidationTarget();
    }

    private void preventChangeToNodeAgentRef(ConfigContextEvent cce, Result result) {
        if (cce.getName().equals("node-agent-ref")) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".noChangeToNodeAgentRef", "Cannot change a node agent ref"));
        }
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        boolean flag = false;
        String choice = cce.getChoice();
        try {
            if (choice.equals("SET")) {
                this.validateSet(cce, result);
            } else if (choice.equals("UPDATE")) {
                this.validateUpdate(cce, result);
            } else if (choice.equals("ADD")) {
                this.validateAdd(cce, result);
            } else if (choice.equals("VALIDATE")) {
                Domain domain = (Domain)cce.getConfigContext().getRootConfigBean();
                Servers servers = domain.getServers();
                Server[] server = servers.getServer();
                String svrName = server[0].getName();
                if (!server[0].getName().equals("server")) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidserverName", "Invalid Server Name {0}: Required 'server'", new Object[]{svrName}));
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "domainxmlverifier.exception", e);
        }
        return result;
    }

    private void validateSet(ConfigContextEvent cce, Result result) throws ConfigException {
        this.validateAttributeChange(cce, result);
    }

    private void validateAttributeChange(ConfigContextEvent cce, Result result) throws ConfigException {
        this.checkNameNotAgent(cce, result);
        this.preventChangeToNodeAgentRef(cce, result);
        if (this.isReferenced(cce)) {
            this.preventChangeToConfigRef(cce, result);
        } else {
            this.preventInvalidConfigRef(cce, result);
        }
    }

    private final void preventInvalidConfigRef(ConfigContextEvent cce, Result result) throws ConfigException {
        if (cce.getName().equals("config-ref")) {
            this.checkConfigRefValidity((String)cce.getObject(), result);
        }
    }

    private final void checkConfigRefValidity(ConfigContextEvent cce, Result result) throws ConfigException {
        this.checkConfigRefValidity(this.getServer(cce).getConfigRef(), result);
    }

    private void checkConfigRefValidity(String config_ref, Result result) {
        if (config_ref.equals("server-config")) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotHaveDASasConfig", "The configuration of the Domain Administration Server (named {0}) cannot be referenced by a server", new Object[]{"server-config"}));
        } else if (config_ref.equals("default-config")) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotHaveTemplateConfig", "The default configuration template (named {0}) cannot be referenced by a server", new Object[]{"default-config"}));
        }
    }

    private void preventChangeToConfigRef(ConfigContextEvent cce, Result result) {
        if (cce.getName().equals("config-ref")) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".noChangeToConfigRefInCluster", "Cannot change a config-ref when the instance is part of a cluster"));
        }
    }
}

