/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.appserv.connectors.spi.ConfigurableTransactionSupport;
import com.sun.appserv.connectors.spi.TransactionSupport;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.PrintWriterAdapter;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.connectors.util.SetMethodAction;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ManagedConnectionFactory;

public class ActiveOutboundResourceAdapter
implements ActiveResourceAdapter {
    protected ConnectorDescriptor desc_;
    protected String moduleName_;
    protected ClassLoader jcl_;
    protected ConnectionDefDescriptor[] connectionDefs_;
    protected ConnectorRuntime connectorRuntime_ = null;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private StringManager localStrings = StringManager.getManager(ActiveOutboundResourceAdapter.class);

    public ActiveOutboundResourceAdapter(ConnectorDescriptor desc, String moduleName, ClassLoader jcl) {
        this.desc_ = desc;
        this.moduleName_ = moduleName;
        this.jcl_ = jcl;
        this.connectorRuntime_ = ConnectorRuntime.getRuntime();
        this.connectionDefs_ = ConnectorDDTransformUtils.getConnectionDefs(this.desc_);
    }

    public String getModuleName() {
        return this.moduleName_;
    }

    public void setup() throws ConnectorRuntimeException {
        if (this.connectionDefs_ == null || this.connectionDefs_.length != 1) {
            _logger.log(Level.SEVERE, "rardeployment.invalid_connector_desc", this.moduleName_);
            String i18nMsg = this.localStrings.getString("ccp_adm.invalid_connector_desc", this.moduleName_);
            throw new ConnectorRuntimeException(i18nMsg);
        }
        ResourcesUtil resUtil = ResourcesUtil.createInstance();
        if (this.isServer() && !resUtil.belongToSystemRar(this.moduleName_)) {
            this.createAllConnectorResources();
        }
        _logger.log(Level.FINE, "Completed Active Resource adapter setup", this.moduleName_);
    }

    protected boolean isServer() {
        return this.connectorRuntime_.getEnviron() == 1;
    }

    protected void createAllConnectorResources() throws ConnectorRuntimeException {
        try {
            if (this.desc_.getSunDescriptor() != null && this.desc_.getSunDescriptor().getResourceAdapter() != null) {
                String jndiName = (String)this.desc_.getSunDescriptor().getResourceAdapter().getValue("JndiName");
                if (jndiName == null || jndiName.equals("")) {
                    this.createDefaultConnectorConnectionPools(true);
                } else {
                    this.createSunRAConnectionPool();
                    this.createDefaultConnectorConnectionPools(false);
                }
            } else {
                this.createDefaultConnectorConnectionPools(false);
            }
            this.createDefaultConnectorResources();
        }
        catch (ConnectorRuntimeException cre) {
            _logger.log(Level.SEVERE, "rardeployment.defaultpoolresourcecreation.failed", cre);
            _logger.log(Level.FINE, "Error while trying to create the default connectorconnection pool and resource", cre);
        }
    }

    protected void destroyAllConnectorResources() {
        if (!ResourcesUtil.createInstance().belongToSystemRar(this.moduleName_)) {
            String jndiName;
            this.deleteDefaultConnectorResources();
            this.deleteDefaultConnectorConnectionPools();
            if (this.desc_.getSunDescriptor() != null && this.desc_.getSunDescriptor().getResourceAdapter() != null && (jndiName = (String)this.desc_.getSunDescriptor().getResourceAdapter().getValue("JndiName")) != null && !jndiName.equals("")) {
                this.deleteSunRAConnectionPool();
            }
        }
    }

    protected void deleteDefaultConnectorConnectionPools() {
        for (int i = 0; i < this.connectionDefs_.length; ++i) {
            String connectionDefName = this.connectionDefs_[i].getConnectionFactoryIntf();
            String resourceJndiName = this.connectorRuntime_.getDefaultPoolName(this.moduleName_, connectionDefName);
            try {
                this.connectorRuntime_.deleteConnectorConnectionPool(resourceJndiName);
                continue;
            }
            catch (ConnectorRuntimeException cre) {
                _logger.log(Level.WARNING, "rar.undeployment.default_resource_delete_fail", resourceJndiName);
            }
        }
    }

    protected void deleteDefaultConnectorResources() {
        for (int i = 0; i < this.connectionDefs_.length; ++i) {
            String connectionDefName = this.connectionDefs_[i].getConnectionFactoryIntf();
            String resourceJndiName = this.connectorRuntime_.getDefaultResourceName(this.moduleName_, connectionDefName);
            try {
                this.connectorRuntime_.deleteConnectorResource(resourceJndiName);
                continue;
            }
            catch (ConnectorRuntimeException cre) {
                _logger.log(Level.WARNING, "rar.undeployment.default_resource_delete_fail", resourceJndiName);
                _logger.log(Level.FINE, "Error while trying to delete the default connector resource", cre);
            }
        }
    }

    public void destroy() {
        if (this.isServer()) {
            this.destroyAllConnectorResources();
        }
    }

    public ConnectorDescriptor getDescriptor() {
        return this.desc_;
    }

    public ManagedConnectionFactory[] createManagedConnectionFactories(ConnectorConnectionPool ccp, ClassLoader jcl) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public ManagedConnectionFactory createManagedConnectionFactory(ConnectorConnectionPool ccp, ClassLoader jcl) {
        final String mcfClass = ccp.getConnectorDescriptorInfo().getManagedConnectionFactoryClass();
        try {
            ManagedConnectionFactory mcf = null;
            if (this.moduleName_.equals("jmsra")) {
                Object tmp = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return ActiveOutboundResourceAdapter.this.instantiateMCF(mcfClass);
                    }
                });
                mcf = (ManagedConnectionFactory)tmp;
            } else {
                mcf = this.instantiateMCF(mcfClass);
            }
            if (mcf instanceof ConfigurableTransactionSupport) {
                TransactionSupport ts = ConnectionPoolObjectsUtils.getTransactionSupport(ccp.getTransactionSupport());
                ((ConfigurableTransactionSupport)((Object)mcf)).setTransactionSupport(ts);
            }
            SetMethodAction setMethodAction = new SetMethodAction(mcf, ccp.getConnectorDescriptorInfo().getMCFConfigProperties());
            setMethodAction.run();
            _logger.log(Level.FINE, "Created MCF object : ", mcfClass);
            return mcf;
        }
        catch (PrivilegedActionException ex) {
            _logger.log(Level.SEVERE, "rardeployment.privilegedaction_error", new Object[]{mcfClass, ex.getException().getMessage()});
            _logger.log(Level.FINE, "rardeployment.privilegedaction_error", ex.getException());
            return null;
        }
        catch (ClassNotFoundException Ex) {
            _logger.log(Level.SEVERE, "rardeployment.class_not_found", new Object[]{mcfClass, Ex.getMessage()});
            _logger.log(Level.FINE, "rardeployment.class_not_found", Ex);
            return null;
        }
        catch (InstantiationException Ex) {
            _logger.log(Level.SEVERE, "rardeployment.class_instantiation_error", new Object[]{mcfClass, Ex.getMessage()});
            _logger.log(Level.FINE, "rardeployment.class_instantiation_error", Ex);
            return null;
        }
        catch (IllegalAccessException Ex) {
            _logger.log(Level.SEVERE, "rardeployment.illegalaccess_error", new Object[]{mcfClass, Ex.getMessage()});
            _logger.log(Level.FINE, "rardeployment.illegalaccess_error", Ex);
            return null;
        }
        catch (Exception Ex) {
            _logger.log(Level.SEVERE, "rardeployment.mcfcreation_error", new Object[]{mcfClass, Ex.getMessage()});
            _logger.log(Level.FINE, "rardeployment.mcfcreation_error", Ex);
            return null;
        }
    }

    private void setLogWriter(ManagedConnectionFactory mcf, Logger logger) {
        PrintWriterAdapter adapter = new PrintWriterAdapter(ConnectorRuntime.getRuntime().getResourceAdapterLogWriter());
        try {
            mcf.setLogWriter(adapter);
        }
        catch (Exception e) {
            Object[] params = new Object[]{mcf.getClass().getName(), e.getMessage()};
            _logger.log(Level.WARNING, "rardeployment.logwriter_error", params);
            _logger.log(Level.FINE, "Unable to set LogWriter for ManagedConnectionFactory : " + mcf.getClass().getName(), e);
        }
    }

    private ManagedConnectionFactory instantiateMCF(String mcfClass) throws Exception {
        ManagedConnectionFactory mcf = null;
        mcf = this.jcl_ != null ? (ManagedConnectionFactory)this.jcl_.loadClass(mcfClass).newInstance() : (ManagedConnectionFactory)Class.forName(mcfClass).newInstance();
        this.setLogWriter(mcf, _logger);
        return mcf;
    }

    protected void createDefaultConnectorResources() throws ConnectorRuntimeException {
        for (int i = 0; i < this.connectionDefs_.length; ++i) {
            String connectionDefName = this.connectionDefs_[i].getConnectionFactoryIntf();
            String resourceName = this.connectorRuntime_.getDefaultResourceName(this.moduleName_, connectionDefName);
            String poolName = this.connectorRuntime_.getDefaultPoolName(this.moduleName_, connectionDefName);
            this.connectorRuntime_.createConnectorResource(resourceName, poolName, null);
            _logger.log(Level.FINE, "Created default connector resource : ", resourceName);
        }
    }

    protected void createDefaultConnectorConnectionPools(boolean useSunRA) throws ConnectorRuntimeException {
        for (int i = 0; i < this.connectionDefs_.length; ++i) {
            String poolName = this.connectorRuntime_.getDefaultPoolName(this.moduleName_, this.connectionDefs_[i].getConnectionFactoryIntf());
            ConnectorDescriptorInfo connectorDescriptorInfo = ConnectorDDTransformUtils.getConnectorDescriptorInfo(this.connectionDefs_[i]);
            connectorDescriptorInfo.setRarName(this.moduleName_);
            connectorDescriptorInfo.setResourceAdapterClassName(this.desc_.getResourceAdapterClass());
            ConnectorConnectionPool connectorPoolObj = useSunRA ? ConnectionPoolObjectsUtils.createSunRaConnectorPoolObject(poolName, this.desc_, this.moduleName_) : ConnectionPoolObjectsUtils.createDefaultConnectorPoolObject(poolName, this.moduleName_);
            connectorPoolObj.setConnectorDescriptorInfo(connectorDescriptorInfo);
            this.connectorRuntime_.createConnectorConnectionPool(connectorPoolObj);
            _logger.log(Level.FINE, "Created default connection pool : ", poolName);
        }
    }

    public void createSunRAConnectionPool() throws ConnectorRuntimeException {
        String defaultPoolName = this.connectorRuntime_.getDefaultPoolName(this.moduleName_, this.connectionDefs_[0].getConnectionFactoryIntf());
        String sunRAPoolName = defaultPoolName + "sunRAPool";
        ConnectorDescriptorInfo connectorDescriptorInfo = ConnectorDDTransformUtils.getConnectorDescriptorInfo(this.connectionDefs_[0]);
        connectorDescriptorInfo.setRarName(this.moduleName_);
        connectorDescriptorInfo.setResourceAdapterClassName(this.desc_.getResourceAdapterClass());
        ConnectorConnectionPool connectorPoolObj = ConnectionPoolObjectsUtils.createSunRaConnectorPoolObject(sunRAPoolName, this.desc_, this.moduleName_);
        connectorPoolObj.setConnectorDescriptorInfo(connectorDescriptorInfo);
        this.connectorRuntime_.createConnectorConnectionPool(connectorPoolObj);
        _logger.log(Level.FINE, "Created SUNRA connection pool:", sunRAPoolName);
        String jndiName = (String)this.desc_.getSunDescriptor().getResourceAdapter().getValue("JndiName");
        this.connectorRuntime_.createConnectorResource(jndiName, sunRAPoolName, null);
        _logger.log(Level.FINE, "Created SUNRA connector resource : ", jndiName);
    }

    public void deleteSunRAConnectionPool() {
        String defaultPoolName = this.connectorRuntime_.getDefaultPoolName(this.moduleName_, this.connectionDefs_[0].getConnectionFactoryIntf());
        String sunRAPoolName = defaultPoolName + "sunRAPool";
        try {
            this.connectorRuntime_.deleteConnectorConnectionPool(sunRAPoolName);
        }
        catch (ConnectorRuntimeException cre) {
            _logger.log(Level.WARNING, "rar.undeployment.default_resource_delete_fail", sunRAPoolName);
        }
    }

    public ClassLoader getClassLoader() {
        return this.jcl_;
    }
}

