/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.authentication;

import com.sun.ejb.Container;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.Switch;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.authentication.AuthenticationService;
import com.sun.enterprise.connectors.authentication.RuntimeSecurityMap;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.web.WebModule;
import com.sun.logging.LogDomains;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBContext;
import javax.security.auth.Subject;

public class BasicPasswordAuthenticationService
implements AuthenticationService {
    private String rarName_;
    private String poolName_;
    ConnectorRegistry connectorRegistry_ = ConnectorRegistry.getInstance();
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private Object containerContext = null;

    public BasicPasswordAuthenticationService(String rarName, String poolName) {
        this.rarName_ = rarName;
        this.poolName_ = poolName;
        _logger.log(Level.FINE, "Contructor:BasicPasswordAuthenticationService");
    }

    public Principal mapPrincipal(Principal callerPrincipal, Set principalSet) {
        RuntimeSecurityMap runtimeSecurityMap = this.connectorRegistry_.getRuntimeSecurityMap(this.poolName_);
        if (runtimeSecurityMap == null) {
            return null;
        }
        String principalName = callerPrincipal.getName();
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Principal p : principalSet) {
            if (((Object)p).equals(callerPrincipal)) continue;
            String groupName = p.getName();
            groupNames.add(groupName);
        }
        if (this.isContainerContextAWebModuleObject()) {
            String roleName = this.getRoleName(callerPrincipal);
            return this.doMap(principalName, groupNames, roleName, runtimeSecurityMap);
        }
        return this.doMap(principalName, groupNames, null, runtimeSecurityMap);
    }

    private Principal doMap(String principalName, List groupNames, String roleName, RuntimeSecurityMap runtimeSecurityMap) {
        HashMap userNameSecurityMap = runtimeSecurityMap.getUserMap();
        HashMap groupNameSecurityMap = runtimeSecurityMap.getGroupMap();
        if (userNameSecurityMap.containsKey(principalName)) {
            return (Principal)userNameSecurityMap.get(principalName);
        }
        if (this.isContainerContextAWebModuleObject() && roleName != null && groupNameSecurityMap.containsKey(roleName)) {
            return (Principal)groupNameSecurityMap.get(roleName);
        }
        if (this.isContainerContextAContainerObject() && roleName == null) {
            ComponentInvocation componentInvocation = Switch.getSwitch().getInvocationManager().getCurrentInvocation();
            EJBContext ejbcontext = (EJBContext)((Object)componentInvocation.context);
            Set s = groupNameSecurityMap.keySet();
            for (String entry : s) {
                boolean isInRole = false;
                try {
                    isInRole = ejbcontext.isCallerInRole(entry);
                }
                catch (Exception ex) {
                    _logger.log(Level.FINE, "asciPasswordAuthentication::caller not in role " + entry);
                }
                if (!isInRole) continue;
                return (Principal)groupNameSecurityMap.get(entry);
            }
        }
        for (int j = 0; j < groupNames.size(); ++j) {
            String groupName = (String)groupNames.get(j);
            if (!groupNameSecurityMap.containsKey(groupName)) continue;
            return (Principal)groupNameSecurityMap.get(groupName);
        }
        if (userNameSecurityMap.containsKey("*")) {
            return (Principal)userNameSecurityMap.get("*");
        }
        if (groupNameSecurityMap.containsKey("*")) {
            return (Principal)groupNameSecurityMap.get("*");
        }
        return null;
    }

    private String getRoleName(Principal callerPrincipal) {
        String roleName2 = null;
        WebModule _webmodule = (WebModule)this.getContainerContext();
        SecurityRoleMapperFactory securityRoleMapperFactory = SecurityRoleMapperFactoryMgr.getFactory();
        SecurityRoleMapper securityRoleMapper = securityRoleMapperFactory.getRoleMapper(_webmodule.getID());
        Map map = securityRoleMapper.getRoleToSubjectMapping();
        Set roleSet = map.keySet();
        for (String roleName2 : roleSet) {
            Subject subject = (Subject)map.get(roleName2);
            Set<Principal> principalSet = subject.getPrincipals();
            if (!principalSet.contains(callerPrincipal)) continue;
            return roleName2;
        }
        return "";
    }

    private Object getContainerContext() {
        if (this.containerContext == null) {
            ComponentInvocation componentInvocation = Switch.getSwitch().getInvocationManager().getCurrentInvocation();
            this.containerContext = componentInvocation.getContainerContext();
        }
        return this.containerContext;
    }

    private boolean isContainerContextAContainerObject() {
        return this.getContainerContext() instanceof Container;
    }

    private boolean isContainerContextAWebModuleObject() {
        return this.getContainerContext() instanceof WebModule;
    }
}

