/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.enterprise.config.serverbeans.BackendPrincipal;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.authentication.ConnectorSecurityMap;
import com.sun.enterprise.connectors.authentication.EisBackendPrincipal;
import com.sun.enterprise.connectors.authentication.RuntimeSecurityMap;
import com.sun.enterprise.deployment.ResourcePrincipal;
import java.util.HashMap;

public class SecurityMapUtils {
    private static ConnectorRegistry _registry = ConnectorRegistry.getInstance();
    public static final String USERMAP = "usermap";
    public static final String GROUPMAP = "groupmap";

    public static RuntimeSecurityMap processSecurityMaps(ConnectorSecurityMap[] securityMaps) {
        if (securityMaps == null || securityMaps.length == 0) {
            return new RuntimeSecurityMap();
        }
        HashMap<String, ResourcePrincipal> userMap = new HashMap<String, ResourcePrincipal>();
        HashMap<String, ResourcePrincipal> groupMap = new HashMap<String, ResourcePrincipal>();
        for (int i = 0; i < securityMaps.length; ++i) {
            ConnectorSecurityMap map = securityMaps[i];
            ResourcePrincipal principal = SecurityMapUtils.generateResourcePrincipal(map);
            String[] principalNames = map.getPrincipals();
            for (int j = 0; j < principalNames.length; ++j) {
                userMap.put(principalNames[j], principal);
            }
            String[] groupNames = map.getUserGroups();
            for (int j = 0; j < groupNames.length; ++j) {
                groupMap.put(groupNames[j], principal);
            }
        }
        RuntimeSecurityMap runtimeSecurityMap = new RuntimeSecurityMap(userMap, groupMap);
        return runtimeSecurityMap;
    }

    public static ConnectorSecurityMap[] getConnectorSecurityMaps(SecurityMap[] securityMaps) {
        ConnectorSecurityMap[] maps = new ConnectorSecurityMap[securityMaps.length];
        for (int i = 0; i < securityMaps.length; ++i) {
            maps[i] = SecurityMapUtils.convertSecurityMapConfigBeanToSecurityMap(securityMaps[i]);
        }
        return maps;
    }

    private static ConnectorSecurityMap convertSecurityMapConfigBeanToSecurityMap(SecurityMap securityMap) {
        String name = securityMap.getName();
        String[] principal = securityMap.getPrincipal();
        String[] userGroup = securityMap.getUserGroup();
        EisBackendPrincipal backendPrincipal = SecurityMapUtils.transformBackendPrincipal(securityMap.getBackendPrincipal());
        ConnectorSecurityMap convertedSecurityMap = new ConnectorSecurityMap(name, principal, userGroup, backendPrincipal);
        return convertedSecurityMap;
    }

    private static ResourcePrincipal generateResourcePrincipal(ConnectorSecurityMap securityMap) {
        EisBackendPrincipal backendPrincipal = securityMap.getBackendPrincipal();
        String userName = backendPrincipal.getUserName();
        String password = backendPrincipal.getPassword();
        ResourcePrincipal resPrincipal = new ResourcePrincipal(userName, password);
        return resPrincipal;
    }

    private static EisBackendPrincipal transformBackendPrincipal(BackendPrincipal principal) {
        String userName = principal.getUserName();
        String password = principal.getPassword();
        EisBackendPrincipal backendPrincipal = new EisBackendPrincipal(userName, password);
        return backendPrincipal;
    }
}

