/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work.monitor;

import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.connectors.ActiveInboundResourceAdapter;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.connectors.work.monitor.ConnectorWorkMgmtStatsImpl;
import com.sun.enterprise.connectors.work.monitor.MonitorableWorkManager;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.Stats;

public final class ConnectorWorkMonitoringLevelListener
implements MonitoringLevelListener {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private MonitoringRegistry registry_;

    public void setLevel(MonitoringLevel level) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, Stats handback) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType type) {
        if (from == to) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ServerContext ctxt = ApplicationServer.getServerContext();
                if (ctxt != null) {
                    ConnectorWorkMonitoringLevelListener.this.registry_ = ctxt.getMonitoringRegistry();
                }
                return null;
            }
        });
        if (from == MonitoringLevel.OFF && (to == MonitoringLevel.HIGH || to == MonitoringLevel.LOW)) {
            this.switchOnMonitoring();
        }
        if ((from == MonitoringLevel.HIGH || from == MonitoringLevel.LOW) && to == MonitoringLevel.OFF) {
            this.switchOffMonitoring();
        }
    }

    private void switchOffMonitoring() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Switching level form ON to OFF");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ActiveResourceAdapter[] allRAs = ConnectorRegistry.getInstance().getAllActiveResourceAdapters();
                if (allRAs == null) {
                    return null;
                }
                ActiveInboundResourceAdapter inboundRA = null;
                for (int i = 0; i < allRAs.length; ++i) {
                    if (allRAs[i] == null || !(allRAs[i] instanceof ActiveInboundResourceAdapter)) continue;
                    try {
                        inboundRA = (ActiveInboundResourceAdapter)allRAs[i];
                        String moduleName = inboundRA.getModuleName();
                        if (ResourcesUtil.createInstance().belongToSystemRar(moduleName) && !ConnectorAdminServiceUtils.isJMSRA(moduleName)) continue;
                        ConnectorWorkMonitoringLevelListener.this.registry_.unregisterConnectorWorkMgmtStats(ConnectorAdminServiceUtils.getApplicationName(moduleName), ConnectorAdminServiceUtils.getConnectorModuleName(moduleName), ConnectorAdminServiceUtils.isJMSRA(moduleName));
                        ConnectorWorkMonitoringLevelListener.this.setWorkManagementMonitoring(inboundRA, false);
                        continue;
                    }
                    catch (Exception mre) {
                        _logger.log(Level.INFO, "poolmon.cannot_unreg");
                    }
                }
                return null;
            }
        });
    }

    private void switchOnMonitoring() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Switching level form OFF to ON");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ActiveResourceAdapter[] allRAs = ConnectorRegistry.getInstance().getAllActiveResourceAdapters();
                if (allRAs == null) {
                    return null;
                }
                ActiveInboundResourceAdapter inboundRA = null;
                for (int i = 0; i < allRAs.length; ++i) {
                    if (allRAs[i] == null || !(allRAs[i] instanceof ActiveInboundResourceAdapter)) continue;
                    try {
                        inboundRA = (ActiveInboundResourceAdapter)allRAs[i];
                        ConnectorWorkMgmtStatsImpl workstatsimpl = new ConnectorWorkMgmtStatsImpl(inboundRA);
                        String moduleName = inboundRA.getModuleName();
                        if (ResourcesUtil.createInstance().belongToSystemRar(moduleName) && !ConnectorAdminServiceUtils.isJMSRA(moduleName)) continue;
                        ConnectorWorkMonitoringLevelListener.this.setWorkManagementMonitoring(inboundRA, true);
                        ConnectorWorkMonitoringLevelListener.this.registry_.registerConnectorWorkMgmtStats(workstatsimpl, ConnectorAdminServiceUtils.getApplicationName(moduleName), ConnectorAdminServiceUtils.getConnectorModuleName(moduleName), ConnectorAdminServiceUtils.isJMSRA(moduleName), null);
                        continue;
                    }
                    catch (Exception mre) {
                        _logger.log(Level.WARNING, "poolmon.cannot_reg", mre.getMessage());
                    }
                }
                return null;
            }
        });
    }

    private void setWorkManagementMonitoring(ActiveInboundResourceAdapter adapter, boolean isEnabled) {
        MonitorableWorkManager mwm = (MonitorableWorkManager)adapter.getBootStrapContext().getWorkManager();
        mwm.setMonitoringEnabled(isEnabled);
    }
}

