/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ddgenerator.sun;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.enterprise.deploy.shared.ModuleType;

public class DescriptorArchivist {
    public void write(Application application, AbstractArchive out) throws IOException {
        if (application.isVirtual()) {
            ModuleDescriptor aModule = (ModuleDescriptor)application.getModules().next();
            Archivist moduleArchivist = ArchivistFactory.getArchivistForType(aModule.getModuleType());
            this.write(aModule.getDescriptor(), moduleArchivist, out);
        } else {
            Iterator modules = application.getModules();
            while (modules.hasNext()) {
                ModuleDescriptor aModule = (ModuleDescriptor)modules.next();
                Archivist moduleArchivist = ArchivistFactory.getArchivistForType(aModule.getModuleType());
                if (aModule.getAlternateDescriptor() != null) {
                    String runtimeDDPath = "sun-" + aModule.getAlternateDescriptor();
                    DeploymentDescriptorFile ddFile = moduleArchivist.getConfigurationDDFile();
                    if (ddFile == null) continue;
                    OutputStream os = out.putNextEntry(runtimeDDPath);
                    ddFile.write((Descriptor)aModule.getDescriptor(), os);
                    out.closeEntry();
                    continue;
                }
                AbstractArchive moduleArchive = out.getEmbeddedArchive(aModule.getArchiveUri());
                this.write(aModule.getDescriptor(), moduleArchivist, moduleArchive);
            }
            ApplicationArchivist archivist = new ApplicationArchivist();
            archivist.setDescriptor(application);
            archivist.writeRuntimeDeploymentDescriptors(out);
        }
    }

    public void write(BundleDescriptor bundle, AbstractArchive out) throws IOException {
        Archivist archivist = ArchivistFactory.getArchivistForArchive(out);
        this.write(bundle, archivist, out);
    }

    protected void write(BundleDescriptor bundle, Archivist archivist, AbstractArchive out) throws IOException {
        WebBundleDescriptor webBundle;
        archivist.setDescriptor(bundle);
        archivist.writeRuntimeDeploymentDescriptors(out);
        if (bundle.getModuleType().equals(ModuleType.WAR) && (webBundle = (WebBundleDescriptor)bundle).hasWebServices()) {
            archivist.writeStandardDeploymentDescriptors(out);
        }
    }
}

