/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.autodeploy;

import com.sun.enterprise.deployment.autodeploy.AutoDeployer;
import com.sun.enterprise.deployment.autodeploy.AutoDeploymentException;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.util.DeploymentProperties;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.Properties;

public class AutoDirReDeployer
extends AutoDeployer {
    private DeploymentRequest req;
    private static StringManager localStrings = StringManager.getManager(AutoDirReDeployer.class);

    public AutoDirReDeployer(DeploymentRequest req) {
        if (req == null) {
            throw new IllegalArgumentException("nullarg");
        }
        this.req = req;
    }

    public boolean redeploy() throws AutoDeploymentException {
        boolean status2 = false;
        int deployResult = 2;
        try {
            this.init();
            this.verify();
            File source = this.req.getFileSource().getFile();
            String name = this.req.getName();
            deployResult = this.deploy(source, null, name);
        }
        catch (AutoDeploymentException ade) {
            throw ade;
        }
        catch (Exception e) {
            throw new AutoDeploymentException("Error in AutoDirReDeployer.redeploy", e);
        }
        status2 = deployResult == 1;
        return status2;
    }

    boolean invokeDeploymentService(File deployablefile, String action, Object[] params, String[] signature) throws AutoDeploymentException {
        boolean status2 = false;
        try {
            Object result = this.getMBeanServer().invoke(this.getMBeanName(), action, params, signature);
            int returnStatus = this.parseResult(result);
            status2 = returnStatus == 2 || returnStatus == 1;
        }
        catch (AutoDeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            String msg = "Error in AutoReDeployer.invokeDeploymentService";
            throw new AutoDeploymentException(msg, e);
        }
        return status2;
    }

    protected Properties getUndeployActionProperties(String name) {
        DeploymentProperties dProps = (DeploymentProperties)super.getUndeployActionProperties(name);
        dProps.setReload(true);
        return dProps;
    }

    private void verify() throws AutoDeploymentException {
        if (!(this.req.isApplication() || this.req.isEjbModule() || this.req.isWebModule())) {
            throw new AutoDeploymentException(this.getString("wrongType"));
        }
        if (!FileUtils.safeIsDirectory(this.req.getFileSource().getFile())) {
            throw new AutoDeploymentException(this.getString("notDir") + this.req.getFileSource().getFile().getAbsolutePath());
        }
        if (!StringUtils.ok(this.req.getName())) {
            throw new AutoDeploymentException(this.getString("noName"));
        }
    }

    private String getString(String s) {
        return localStrings.getString("enterprise.deployment.AutoDirRedeploy." + s);
    }
}

