/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.ejb.codegen.IASEJBCTimes;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.backend.ClientJarMakerThread;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.DeploymentUtils;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.DeploymentPlanArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.util.ModuleContentLinker;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.PELaunch;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import org.xml.sax.SAXParseException;

public abstract class Deployer {
    public static final String WEB_INF_LIB_PREFIX = "WEB-INF/lib/";
    public static final String TEMP_DIRECTORY_SUFFIX = "__temp";
    public static final String FLAG_FILE = "META-INF" + File.separator + "jbi.xml";
    protected Collection<File> undeletedFiles = new ArrayList<File>();
    protected long liquidateTimeStamp;
    private static String CLIENT_JAR_MAKER_CHOICE = System.getProperty("client.jar.maker.choice");
    protected DeploymentRequest request;
    protected Logger logger = DeploymentLogger.get();
    protected StringBuffer summary = new StringBuffer();
    private InstanceEnvironment instanceEnv;
    private ModuleEnvironment moduleEnv;
    private long timeDeployStarted;
    private long ejbcTime = 0L;
    private long jspcTime = 0L;
    private File lockFile = null;
    private static StringManager localStrings = StringManager.getManager(Deployer.class);
    private static final boolean keepFailedStubsValue;
    private static final String FAILED_SUFFIX = "_failed";
    private static String validationLevel;
    private IASEJBCTimes ejbcTiming = null;

    public abstract void doRequest() throws IASDeploymentException;

    public abstract void doRequestPrepare() throws IASDeploymentException;

    public abstract void doRequestFinish() throws IASDeploymentException;

    public abstract void cleanup_internal();

    protected abstract List getModuleClasspath(Archivist var1, AbstractArchive var2) throws IASDeploymentException;

    public final void cleanup() {
        this.cleanup_internal();
    }

    public String toString() {
        return this.summary.toString();
    }

    public static final boolean getKeepFailedStubsValue() {
        return keepFailedStubsValue;
    }

    Deployer(DeploymentRequest r) throws IASDeploymentException {
        if (r == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.null_deployment_request_object");
            throw new IASDeploymentException(msg);
        }
        this.request = r;
        this.instanceEnv = this.request.getInstanceEnv();
        if (this.instanceEnv == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.null_instanceenvironment_in_deployment_request");
            throw new IASDeploymentException(msg);
        }
    }

    protected final InstanceEnvironment getInstanceEnv() {
        return this.instanceEnv;
    }

    protected final DeploymentRequest getRequest() {
        return this.request;
    }

    protected final boolean isDirectory() throws IASDeploymentException {
        return this.request.isDirectory();
    }

    protected final boolean isArchive() throws IASDeploymentException {
        return this.request.isArchive();
    }

    protected void addToSummary(String s) {
        this.summary.append(s);
        this.summary.append("\n");
    }

    protected void begin() throws IASDeploymentException {
        this.timeDeployStarted = System.currentTimeMillis();
        try {
            this.instanceEnv.verify();
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static String getValidationLevel() throws IASDeploymentException {
        Deployer.init();
        return validationLevel;
    }

    protected Application loadDescriptors() throws IASDeploymentException {
        BaseManager manager = this.getManager();
        if (manager == null) {
            throw new IASDeploymentException(localStrings.getString("enterprise.deployment.backend.no_manager_registered", this.request.getType()));
        }
        Deployer.init();
        boolean validateXml = true;
        try {
            Archivist archivist = ArchivistFactory.getArchivistForType(this.request.getType().getModuleType());
            archivist.setAnnotationProcessingRequested(true);
            String appDir = this.request.getDeployedDirectory().getAbsolutePath();
            FileArchive in = new FileArchive();
            in.open(appDir);
            if (this.request.isVerifying()) {
                archivist.setRuntimeXMLValidation(true);
                archivist.setRuntimeXMLValidationLevel("full");
            }
            if (validationLevel.equals("none")) {
                archivist.setXMLValidation(false);
            } else {
                archivist.setXMLValidation(true);
                archivist.setXMLValidationLevel(validationLevel);
            }
            if (this.request.getDeploymentPlan() != null) {
                DeploymentPlanArchive dpa = new DeploymentPlanArchive();
                dpa.open(this.request.getDeploymentPlan().getAbsolutePath());
                if (this.request.isApplication()) {
                    ApplicationArchivist aa = (ApplicationArchivist)archivist;
                    aa.copyInto(this.request.getDescriptor(), (AbstractArchive)dpa, in, false);
                } else {
                    archivist.copyInto((AbstractArchive)dpa, (AbstractArchive)in, false);
                }
            }
            ClassLoader parent = Boolean.getBoolean("com.sun.aas.useNewClassLoader") ? PELaunch.getAppServerChain() : ClassLoader.getSystemClassLoader();
            DeploymentUtils.setParentClassLoader(parent, this.getManager(), this.request);
            List allClassPaths = this.request.getParentClasspath();
            ClassLoader sharedClassLoader = this.request.getParentClassLoader();
            List moduleClasspath = this.getModuleClasspath(archivist, in);
            this.request.setModuleClasspath(moduleClasspath);
            allClassPaths.addAll(moduleClasspath);
            EJBClassLoader ejbClassLoader = DeploymentUtils.getClassLoader(moduleClasspath, sharedClassLoader, null);
            this.request.setEjbClassLoader(ejbClassLoader);
            this.request.setCompleteClasspath(allClassPaths);
            archivist.setClassLoader(ejbClassLoader);
            ClassLoader origContextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ejbClassLoader);
            Application application = this.request.getDescriptor();
            if (application != null && ModuleType.EAR.equals(archivist.getModuleType())) {
                archivist.readPersistenceDeploymentDescriptors(in, application);
                archivist.setHandleRuntimeInfo(false);
                boolean modulesReadSuccess = ((ApplicationArchivist)archivist).readModulesDescriptors(application, in);
                if (modulesReadSuccess) {
                    archivist.setHandleRuntimeInfo(true);
                    archivist.readRuntimeDeploymentDescriptor(in, application);
                } else {
                    application = null;
                }
            } else {
                application = ApplicationArchivist.openArchive(archivist, in, true);
            }
            if (application == null) {
                throw new IASDeploymentException(localStrings.getString("enterprise.deployment.backend.error_loading_dds", new Object[]{this.request.getName(), " "}));
            }
            application.setRegistrationName(this.request.getName());
            application.setClassLoader(ejbClassLoader);
            archivist.setDescriptor(application);
            if (!archivist.performOptionalPkgDependenciesCheck(in)) {
                throw new IASDeploymentException(localStrings.getString("enterprise.deployment.backend.archive_opt_dep_not_satisfied", new Object[]{in.getArchiveUri()}));
            }
            archivist.validate(ejbClassLoader);
            if (!application.getWebServiceDescriptors().isEmpty()) {
                ModuleContentLinker visitor = new ModuleContentLinker(in);
                application.visit(visitor);
            }
            this.request.setDescriptor(application);
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
            return application;
        }
        catch (SAXParseException spe) {
            IASDeploymentException e = new IASDeploymentException(localStrings.getString("enterprise.deployment.backend.saxerror_loading_dds", this.request.getName(), String.valueOf(spe.getLineNumber()), String.valueOf(spe.getColumnNumber()), spe.getLocalizedMessage()));
            e.initCause(spe);
            throw e;
        }
        catch (IASDeploymentException e) {
            throw e;
        }
        catch (Throwable t) {
            IASDeploymentException e = new IASDeploymentException(localStrings.getString("enterprise.deployment.backend.error_loading_dds", this.request.getName(), t.getMessage()));
            e.initCause(t);
            throw e;
        }
    }

    protected void copyAutodeployedClassFile(File srcFile, File destDir) throws IOException {
        File autodeployDir = srcFile.getParentFile();
        String packageNameDirs = "";
        while (!autodeployDir.getName().equals("autodeploy")) {
            packageNameDirs = autodeployDir.getName() + File.separator + packageNameDirs;
            autodeployDir = autodeployDir.getParentFile();
        }
        destDir = new File(destDir, packageNameDirs);
        File destFile = new File(destDir, srcFile.getName());
        FileUtils.copy(this.request.getFileSource().getFile(), destFile);
    }

    protected final void createClientJar(ZipItem[] clientStubs) throws IASDeploymentException {
        Properties props = this.request.getOptionalArguments();
        String clientJarRequested = props.getProperty("clientJarRequested");
        File appDirectory = this.request.getGeneratedXMLDirectory();
        if (appDirectory == null || !FileUtils.safeIsDirectory(appDirectory)) {
            appDirectory = this.request.getDeployedDirectory();
        }
        File clientJar = new File(appDirectory, this.request.getName() + "Client.jar");
        if (clientJarRequested != null && Boolean.valueOf(clientJarRequested).booleanValue()) {
            ClientJarMakerThread.createClientJar(this.request, clientJar, clientStubs, CLIENT_JAR_MAKER_CHOICE);
            this.request.setClientJar(clientJar);
        } else {
            ClientJarMakerThread clientJarThread = new ClientJarMakerThread(this.request, clientJar, clientStubs, CLIENT_JAR_MAKER_CHOICE);
            clientJarThread.start();
        }
    }

    private static void init() throws IASDeploymentException {
        if (validationLevel != null) {
            return;
        }
        try {
            ConfigContext ctx = ApplicationServer.getServerContext().getConfigContext();
            DasConfig dc = ServerBeansFactory.getDasConfigBean(ctx);
            validationLevel = dc.getDeployXmlValidation();
        }
        catch (ConfigException ce) {
            IASDeploymentException e = new IASDeploymentException(localStrings.getString("enterprise.deployment.backend.cannot_get_validationlevel", ce.getMessage()));
            e.initCause(ce);
            throw e;
        }
    }

    void checkRegisteredAnywhereElse(String id) throws IASDeploymentException {
        String error = BaseManager.isRegisteredAnywhere(this.instanceEnv, id);
        if (error != null) {
            String msg = localStrings.getString("enterprise.deployment.backend.nameAlreadyExists", new Object[]{id, error});
            throw new IASDeploymentException(msg);
        }
    }

    protected void addEJBCTime(IASEJBCTimes ejbcT) {
        this.ejbcTime += ejbcT.getTotalTime();
        this.ejbcTiming = ejbcT;
    }

    protected void addJSPCTime(long time) {
        this.jspcTime += time;
    }

    protected final void finish() throws IASDeploymentException {
        long total = System.currentTimeMillis() - this.timeDeployStarted;
        if (total <= 0L) {
            total = 1L;
        }
        int percentEJBC = (int)((double)this.ejbcTime / (double)total * 100.0);
        int percentJSPC = (int)((double)this.jspcTime / (double)total * 100.0);
        this.deleteLockFile();
        StringBuffer timing = new StringBuffer("Total Deployment Time: ");
        timing.append(total);
        timing.append(" msec, ");
        if (this.jspcTime > 0L) {
            timing.append("Total JSP Compile Time: ");
            timing.append(this.jspcTime);
            timing.append(" msec (").append(percentJSPC).append("%),  ");
        }
        timing.append("Total EJB Compiler Module Time: ");
        timing.append(this.ejbcTime);
        timing.append(" msec, Portion spent EJB Compiling: ");
        timing.append(percentEJBC);
        timing.append("%");
        if (this.ejbcTiming != null) {
            timing.append("\nBreakdown of EJBC Module Time: " + this.ejbcTiming);
        }
        this.logger.fine(timing.toString());
        this.logger.finer(this.toString());
        this.releaseClassLoader();
    }

    public final void releaseClassLoader() {
        try {
            ClassLoader ejbCL;
            ClassLoader parentCL = this.request.getParentClassLoader();
            if (parentCL != null && parentCL instanceof EJBClassLoader) {
                ((EJBClassLoader)parentCL).done();
            }
            if ((ejbCL = this.request.getEjbClassLoader()) != null && ejbCL instanceof EJBClassLoader) {
                ((EJBClassLoader)ejbCL).done();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void DeleteOrKeepFailedStubs(File stubsDir) {
        if (!FileUtils.safeIsDirectory(stubsDir)) {
            return;
        }
        if (keepFailedStubsValue) {
            File failedStubsDir = new File(stubsDir.getPath() + FAILED_SUFFIX);
            FileUtils.whack(failedStubsDir);
            stubsDir.renameTo(failedStubsDir);
            this.logger.info("com.sun.aas.deployment.KeepFailedStubs is set.  Backdoor is open.  Saving failed generated ejb files in: " + failedStubsDir.getPath());
        } else {
            FileUtils.whack(stubsDir);
        }
    }

    protected void cleanAndCheck(File dir) {
        if (FileUtils.safeIsDirectory(dir)) {
            FileUtils.whack(dir, this.undeletedFiles);
        }
    }

    protected void handleUndeletedFiles() {
        if (this.undeletedFiles.size() == 0) {
            return;
        }
        String allUndeletedFilesMsg = localStrings.getString("enterprise.deployment.backend.all_undeleted_files", FileUtils.formatFileCollection(this.undeletedFiles));
        this.logger.fine(allUndeletedFilesMsg);
        Iterator<File> files = this.undeletedFiles.iterator();
        while (files.hasNext()) {
            File file = files.next();
            if (file.lastModified() <= this.liquidateTimeStamp) continue;
            files.remove();
        }
        if (this.undeletedFiles.size() > 0 && !FileUtils.deleteLeftoverFiles(this.undeletedFiles)) {
            String untouchedUndeletedFilesMsg = localStrings.getString("enterprise.deployment.backend.untouched_undeleted_files", FileUtils.formatFileCollection(this.undeletedFiles));
            DeploymentStatus handleUndeletedFilesStatus = new DeploymentStatus(this.request.getCurrentDeploymentStatus());
            handleUndeletedFilesStatus.setStageStatus(1);
            handleUndeletedFilesStatus.setStageStatusMessage(untouchedUndeletedFilesMsg);
            this.logger.warning(untouchedUndeletedFilesMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getResourceType(File appDir) {
        String string;
        FileInputStream fis = null;
        try {
            try {
                File manifestFile = new File(appDir, "META-INF/MANIFEST.MF");
                fis = new FileInputStream(manifestFile);
                Manifest manifest = new Manifest(fis);
                Attributes attrs = manifest.getMainAttributes();
                string = attrs.getValue("Application-Type");
                Object var8_9 = null;
            }
            catch (Throwable t) {
                String string2 = null;
                Object var8_10 = null;
                try {
                    if (fis == null) return string2;
                    fis.close();
                    return string2;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return string2;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {}
            catch (IOException ioe) {
                throw throwable;
            }
            if (fis == null) throw throwable;
            fis.close();
            throw throwable;
        }
        try {}
        catch (IOException ioe) {
            // empty catch block
            return string;
        }
        if (fis == null) return string;
        fis.close();
        return string;
    }

    protected boolean isExternallyManagedApp(File appDir) {
        File file = new File(appDir, FLAG_FILE);
        return file.exists();
    }

    private final void deleteLockFile() {
        if (this.lockFile != null) {
            this.lockFile.delete();
        }
    }

    protected abstract BaseManager getManager();

    protected boolean checkAppclientsMainClasses() {
        boolean result = true;
        StringBuilder sb = new StringBuilder();
        Iterator it = this.request.getDescriptor().getModules();
        while (it != null && it.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)it.next();
            if (md.getModuleType() != ModuleType.CAR) continue;
            String archiveURI = md.getArchiveUri();
            ApplicationClientDescriptor acd = (ApplicationClientDescriptor)md.getDescriptor();
            String mainClassName = acd.getMainClassName();
            if (mainClassName != null && mainClassName.length() != 0) continue;
            result = false;
            this.logger.log(Level.WARNING, localStrings.getString("enterprise.deployment.backend.no_main_class"), archiveURI);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(archiveURI);
        }
        if (!result) {
            DeploymentStatus mainClassesNotOKStatus = new DeploymentStatus(this.request.getCurrentDeploymentStatus());
            mainClassesNotOKStatus.setStageDescription(localStrings.getString("enterprise.deployment.backend.appclient_mainclass_checking"));
            mainClassesNotOKStatus.setStageStatus(1);
            mainClassesNotOKStatus.setStageStatusMessage(localStrings.getString("enterprise.deployment.backend.appclient_mainclass_checking_failed", sb.toString()));
        }
        return result;
    }

    protected void generatePolicy() throws IASDeploymentException {
    }

    public abstract void removePolicy() throws IASDeploymentException;

    static {
        validationLevel = null;
        String s = DeploymentUtils.getSystemPropertyIgnoreCase("com.sun.aas.deployment.KeepFailedStubs");
        keepFailedStubsValue = s != null && s.compareToIgnoreCase("true") == 0;
    }
}

