/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.ejb.codegen.IASEJBC;
import com.sun.ejb.codegen.IASEJBCTimes;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.EjbcContextImpl;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.ModulesManager;
import com.sun.enterprise.instance.UniqueIdGenerator;
import com.sun.enterprise.security.application.EJBSecurityManager;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class EJBCompiler {
    private String name;
    private ModulesManager moduleManager;
    private AppsManager appManager;
    private DeploymentRequest request;
    private EjbcContextImpl ejbcContext;
    private List classpathForCompilation;
    private static final Logger _logger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(EJBCompiler.class);

    public EJBCompiler(String name, File srcDir, File stubsDir, BaseManager manager, DeploymentRequest request, IASEJBCTimes timing) throws IASDeploymentException {
        this(name, srcDir, stubsDir, manager, request, timing, request.getCompleteClasspath());
    }

    public EJBCompiler(String name, File srcDir, File stubsDir, BaseManager manager, DeploymentRequest request, IASEJBCTimes timing, List classpathForCompilation) throws IASDeploymentException {
        assert (StringUtils.ok(name));
        assert (FileUtils.safeIsDirectory(srcDir));
        assert (manager != null);
        assert (request != null);
        assert (timing != null);
        try {
            this.name = name;
            this.request = request;
            this.classpathForCompilation = classpathForCompilation;
            this.ejbcContext = new EjbcContextImpl();
            this.ejbcContext.setSrcDir(srcDir);
            this.ejbcContext.setStubsDir(stubsDir);
            this.ejbcContext.setTiming(timing);
            this.ejbcContext.setRmicOptions(manager.getRmicOptions());
            this.ejbcContext.setJavacOptions(manager.getJavacOptions());
            this.ejbcContext.setOptionalArguments(this.request.getOptionalArguments());
            this.ejbcContext.setDeploymentRequest(request);
            if (manager instanceof ModulesManager) {
                this.moduleManager = (ModulesManager)manager;
                this.appManager = null;
            } else if (manager instanceof AppsManager) {
                this.appManager = (AppsManager)manager;
                this.moduleManager = null;
            } else assert (false);
        }
        catch (Throwable t) {
            throw this.wrapException(t);
        }
    }

    public ZipItem[] compile() throws IASDeploymentException {
        ZipItem[] clientStubs = null;
        try {
            if (this.request.getNoEJBC()) {
                _logger.info("**********  EJBC Skipped! ************");
                return new ZipItem[0];
            }
            clientStubs = this.appManager != null ? this.preDeployApp() : this.preDeployModule();
            Application app = this.ejbcContext.getDescriptor();
            if (app != null) {
                Iterator iter = app.getEjbDescriptors().iterator();
                while (iter.hasNext()) {
                    EJBSecurityManager.loadPolicyConfiguration((EjbDescriptor)iter.next());
                }
            }
        }
        catch (Throwable t) {
            throw this.wrapException(t);
        }
        return clientStubs;
    }

    private ZipItem[] preDeployApp() throws Exception {
        ZipItem[] clientStubs = null;
        Application application = this.request.getDescriptor();
        String appRoot = this.ejbcContext.getSrcDir().getCanonicalPath();
        this.setEjbClasspath(this.request.getModuleClasspath());
        this.ejbcContext.setDescriptor(application);
        String[] classPathUrls = new String[this.classpathForCompilation.size()];
        classPathUrls = this.classpathForCompilation.toArray(classPathUrls);
        this.ejbcContext.setClasspathUrls(classPathUrls);
        this.verifyContext();
        clientStubs = IASEJBC.ejbc(this.ejbcContext);
        UniqueIdGenerator uidGenerator = UniqueIdGenerator.getInstance();
        long uid = uidGenerator.getNextUniqueId();
        application.setUniqueId(uid);
        this.appManager.saveAppDescriptor(this.name, application, this.request.getDeployedDirectory().getCanonicalPath(), this.request.getGeneratedXMLDirectory().getCanonicalPath(), false);
        return clientStubs;
    }

    private void setEjbClasspath(List ejbClassPath) {
        String[] ejbClassPathUrls = new String[ejbClassPath.size()];
        ejbClassPathUrls = ejbClassPath.toArray(ejbClassPathUrls);
        this.ejbcContext.setEjbClasspathUrls(ejbClassPathUrls);
    }

    private ZipItem[] preDeployModule() throws Exception {
        ZipItem[] clientStubs = null;
        Application application = this.request.getDescriptor();
        this.ejbcContext.setDescriptor(application);
        String[] classPathUrls = new String[this.classpathForCompilation.size()];
        classPathUrls = this.classpathForCompilation.toArray(classPathUrls);
        this.ejbcContext.setClasspathUrls(classPathUrls);
        this.verifyContext();
        clientStubs = IASEJBC.ejbc(this.ejbcContext);
        UniqueIdGenerator uidGenerator = UniqueIdGenerator.getInstance();
        long uid = uidGenerator.getNextUniqueId();
        for (EjbBundleDescriptor bundleDesc : application.getEjbBundleDescriptors()) {
            bundleDesc.setUniqueId(uid);
        }
        this.moduleManager.saveAppDescriptor(this.name, application, this.request.getDeployedDirectory().getCanonicalPath(), this.request.getGeneratedXMLDirectory().getCanonicalPath(), true);
        return clientStubs;
    }

    void verifyContext() throws IASDeploymentException {
        if (this.ejbcContext.getSrcDir() == null || this.ejbcContext.getStubsDir() == null || this.ejbcContext.getDescriptor() == null || this.ejbcContext.getRmicOptions() == null || this.ejbcContext.getJavacOptions() == null || this.ejbcContext.getTiming() == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.bad_ejbc_ctx");
            throw new IASDeploymentException(msg);
        }
    }

    IASDeploymentException wrapException(Throwable t) {
        String msg = localStrings.getString("enterprise.deployment.backend.fatal_ejbc_error");
        if (t instanceof RemoteException) {
            msg = msg + localStrings.getString("enterprise.deployment.backend.ejbc_remoteexception", t);
        }
        return new IASDeploymentException(msg, t);
    }
}

