/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.appserv.server.util.ASClassLoaderUtil;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.runtime.web.JspConfig;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.jasper.JspC;

public final class JSPCompiler {
    private static final String startMessage = JSPCompiler.getStringManager().getStringWithDefault("enterprise.deployment.backend.start_jspc", "Beginning JSP Precompile...");
    private static final String finishMessage = JSPCompiler.getStringManager().getStringWithDefault("enterprise.deployment.backend.finish_jspc", "Finished JSP Precompile");
    private static final Logger logger = DeploymentLogger.get();

    public static void compile(File inWebDir, File outWebDir, WebBundleDescriptor wbd) throws IASDeploymentException {
        JSPCompiler.compile(inWebDir, outWebDir, wbd, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void compile(File inWebDir, File outWebDir, WebBundleDescriptor wbd, List classpathList) throws IASDeploymentException {
        block12: {
            block10: {
                String[] files2222;
                String classpath;
                JspC jspc = new JspC();
                if (classpathList != null && (classpath = JSPCompiler.getClasspath(classpathList)) != null) {
                    jspc.setClassPath(classpath);
                }
                String appName = wbd.getApplication().getName();
                String sysClassPath = ASClassLoaderUtil.getWebModuleClassPath(appName);
                jspc.setSystemClassPath(sysClassPath);
                JSPCompiler.verify(inWebDir, outWebDir);
                JSPCompiler.configureJspc(jspc, wbd);
                jspc.setOutputDir(outWebDir.getAbsolutePath());
                jspc.setUriroot(inWebDir.getAbsolutePath());
                jspc.setCompile(true);
                logger.info(startMessage);
                try {
                    try {
                        jspc.execute();
                    }
                    catch (Exception je) {
                        throw new IASDeploymentException("JSP Compilation Error: " + je, je);
                    }
                    Object var9_7 = null;
                    files2222 = outWebDir.list();
                    if (files2222 == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    String[] files2222 = outWebDir.list();
                    if (files2222 == null || files2222.length <= 0) {
                        outWebDir.delete();
                    }
                    logger.info(finishMessage);
                    throw throwable;
                }
                if (files2222.length > 0) break block12;
            }
            outWebDir.delete();
        }
        logger.info(finishMessage);
    }

    private static void verify(File inWebDir, File outWebDir) throws IASDeploymentException {
        if (!FileUtils.safeIsDirectory(inWebDir)) {
            throw new IASDeploymentException("inWebDir is not a directory: " + inWebDir);
        }
        if (!FileUtils.safeIsDirectory(outWebDir)) {
            outWebDir.mkdirs();
            if (!FileUtils.safeIsDirectory(outWebDir)) {
                throw new IASDeploymentException("outWebDir is not a directory, and it can't be created: " + outWebDir);
            }
        }
    }

    private static String getClasspath(List paths) {
        if (paths == null) {
            return null;
        }
        String classpath = null;
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String path : paths) {
            if (first) {
                first = false;
            } else {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(path);
        }
        if (sb.length() > 0) {
            classpath = sb.toString();
        }
        return classpath;
    }

    private static void configureJspc(JspC jspc, WebBundleDescriptor wbd) {
        JspConfig jspConfig;
        Set set;
        SunWebApp sunWebApp = wbd.getSunDescriptor();
        if (sunWebApp == null) {
            return;
        }
        if (sunWebApp.sizeWebProperty() > 0) {
            WebProperty[] props = sunWebApp.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String pName = props[i].getAttributeValue("name");
                String pValue = props[i].getAttributeValue("value");
                if (pName == null || pValue == null) {
                    throw new IllegalArgumentException("Missing sun-web-app property name or value");
                }
                if (!"enableTldValidation".equals(pName)) continue;
                jspc.setIsValidationEnabled(Boolean.valueOf(pValue));
            }
        }
        if (!(set = wbd.getWebComponentDescriptorsSet()).isEmpty()) {
            for (WebComponentDescriptor webComponentDesc : set) {
                if (!"jsp".equals(webComponentDesc.getCanonicalName())) continue;
                Enumeration en = webComponentDesc.getInitializationParameters();
                if (en == null) break;
                while (en.hasMoreElements()) {
                    InitializationParameter initP = (InitializationParameter)en.nextElement();
                    JSPCompiler.configureJspc(jspc, initP.getName(), initP.getValue());
                }
                break block1;
            }
        }
        if ((jspConfig = sunWebApp.getJspConfig()) == null) {
            return;
        }
        WebProperty[] props = jspConfig.getWebProperty();
        for (int i = 0; props != null && i < props.length; ++i) {
            JSPCompiler.configureJspc(jspc, props[i].getAttributeValue("name"), props[i].getAttributeValue("value"));
        }
    }

    private static void configureJspc(JspC jspc, String pName, String pValue) {
        if (pName == null || pValue == null) {
            throw new IllegalArgumentException("Null property name or value");
        }
        if ("xpoweredBy".equals(pName)) {
            jspc.setXpoweredBy(Boolean.valueOf(pValue));
        } else if ("classdebuginfo".equals(pName)) {
            jspc.setClassDebugInfo(Boolean.valueOf(pValue));
        } else if ("enablePooling".equals(pName)) {
            jspc.setPoolingEnabled(Boolean.valueOf(pValue));
        } else if ("ieClassId".equals(pName)) {
            jspc.setIeClassId(pValue);
        } else if ("trimSpaces".equals(pName)) {
            jspc.setTrimSpaces(Boolean.valueOf(pValue));
        } else if ("genStrAsCharArray".equals(pName)) {
            jspc.setGenStringAsCharArray(Boolean.valueOf(pValue));
        } else if ("errorOnUseBeanInvalidClassAttribute".equals(pName)) {
            jspc.setErrorOnUseBeanInvalidClassAttribute(Boolean.valueOf(pValue));
        } else if ("ignoreJspFragmentErrors".equals(pName)) {
            jspc.setIgnoreJspFragmentErrors(Boolean.valueOf(pValue));
        }
    }

    private static StringManager getStringManager() {
        return StringManager.getManager(JSPCompiler.class);
    }
}

