/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.client;

import com.sun.appserv.management.base.MapCapableBase;
import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.deploy.DeploymentMgr;
import com.sun.appserv.management.deploy.DeploymentProgress;
import com.sun.appserv.management.deploy.DeploymentSourceImpl;
import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.deploy.DeploymentSupport;
import com.sun.enterprise.deployapi.ProgressObjectImpl;
import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployment.client.DeploymentClientUtils;
import com.sun.enterprise.deployment.client.DeploymentFacility;
import com.sun.enterprise.deployment.client.DeploymentFacilityFactory;
import com.sun.enterprise.deployment.client.RollBackAction;
import com.sun.enterprise.deployment.client.ServerConnectionIdentifier;
import com.sun.enterprise.deployment.deploy.shared.Archive;
import com.sun.enterprise.deployment.deploy.shared.MemoryMappedArchive;
import com.sun.enterprise.deployment.util.FileUploadUtil;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.management.Notification;

public final class DeployAction
extends ProgressObjectImpl {
    private DeploymentMgr deplMgr = null;
    private static final int SLEEP_TIME = 100;
    private static final long TIMEOUT_LOOPS = 10000000L;
    private static String JMX_UPLOAD_CHUNK_SIZE = "jmx.upload.chunk.size";
    private static String HTTP_PROXYHOST = "http.proxyHost";
    private final String jmxUploadChunkSizeProp = System.getProperty(JMX_UPLOAD_CHUNK_SIZE);
    private final String httpProxyHostProp = System.getProperty(HTTP_PROXYHOST);
    private static StringManager localStrings = StringManager.getManager(DeployAction.class);
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    public DeployAction(SunTarget[] targets) {
        super(targets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object uploadArchive(Archive module) throws IOException {
        long totalSize = module.getArchiveSize();
        int chunkSize = 32768;
        if (this.jmxUploadChunkSizeProp != null && this.jmxUploadChunkSizeProp.length() > 0) {
            chunkSize = Integer.parseInt(this.jmxUploadChunkSizeProp);
        }
        Object uploadID = null;
        long remaining = totalSize;
        BufferedInputStream bis = null;
        try {
            String name = this.getArchiveName(module);
            if (module instanceof MemoryMappedArchive) {
                byte[] bytes = ((MemoryMappedArchive)module).getByteArray();
                bis = new BufferedInputStream(new ByteArrayInputStream(bytes));
            } else {
                bis = new BufferedInputStream(new FileInputStream(new File(module.getURI().getPath())));
            }
            uploadID = this.deplMgr.initiateFileUpload(name, totalSize);
            while (remaining != 0L) {
                int actual = remaining < (long)chunkSize ? (int)remaining : chunkSize;
                byte[] bytes = new byte[actual];
                try {
                    bis.read(bytes);
                }
                catch (EOFException eof) {
                    break;
                }
                _logger.log(Level.FINE, "Uploading one chunk...");
                this.deplMgr.uploadBytes(uploadID, bytes);
                remaining -= (long)actual;
            }
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
        return uploadID;
    }

    private String uploadArchiveOverHTTP(ServerConnectionIdentifier serverId, Archive module) throws Exception {
        return FileUploadUtil.uploadToServlet(serverId.getHostName(), Integer.toString(serverId.getHostPort()), serverId.getUserName(), serverId.getPassword(), module);
    }

    public void run() {
        ConnectionSource dasConnection = (ConnectionSource)this.args[0];
        Archive deployArchive = (Archive)this.args[1];
        Archive deployPlan = (Archive)this.args[2];
        Map deployOptions = (Map)this.args[3];
        SunTarget[] targetList = (SunTarget[])this.args[4];
        SunTarget domain = (SunTarget)this.args[5];
        boolean isLocalConnectionSource = (Boolean)this.args[6];
        ServerConnectionIdentifier serverId = (ServerConnectionIdentifier)this.args[7];
        Object archiveUploadID = null;
        Object planUploadID = null;
        Map deployedTargets = null;
        Object deployActionID = null;
        boolean isDirectoryDeploy = false;
        boolean isRedeploy = false;
        if (deployArchive == null) {
            this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.archive_not_specified"), domain);
            return;
        }
        if (deployArchive.getURI() != null) {
            File tmpFile = new File(deployArchive.getURI().getPath());
            if (!tmpFile.exists()) {
                this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.archive_not_in_location"), domain);
                return;
            }
            if (!tmpFile.canRead()) {
                this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.archive_no_read_permission"), domain);
                return;
            }
            if (tmpFile.isDirectory()) {
                isDirectoryDeploy = true;
            }
        }
        try {
            this.moduleID = (String)deployOptions.get("X-DeploymentMgr.Name");
            boolean isModuleDeployed = this.isModuleDeployed(dasConnection, this.moduleID);
            if ("false".equals(deployOptions.get("X-DeploymentMgr.Force")) && isModuleDeployed) {
                this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.deploy_error_module_exists"), domain);
                return;
            }
            this.deplMgr = ProxyFactory.getInstance(dasConnection).getDomainRoot().getDeploymentMgr();
            if (targetList.length == 1 && "stand_alone_server".equals(targetList[0].getTargetType()) && !"server".equals(targetList[0].getName())) {
                deployOptions.put("wsdlTargetHint", targetList[0].getName());
            }
            if ("true".equals(deployOptions.get("X-DeploymentMgr.Force")) && isModuleDeployed) {
                isRedeploy = true;
                deployedTargets = DeploymentClientUtils.getDeployedTargetList(dasConnection, this.moduleID);
                if (DeploymentClientUtils.isNewTarget(deployedTargets, targetList)) {
                    this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.useCreateAppRef", this.moduleID), domain);
                }
                if (deployedTargets.size() > 0) {
                    if ("domain".equals(targetList[0].getName())) {
                        DeploymentFacility deploymentFacility = isLocalConnectionSource ? DeploymentFacilityFactory.getLocalDeploymentFacility() : DeploymentFacilityFactory.getDeploymentFacility();
                        deploymentFacility.connect(targetList[0].getConnectionInfo());
                        Set nameSet = deployedTargets.keySet();
                        String[] targetNames = nameSet.toArray(new String[nameSet.size()]);
                        Target[] targetList2 = deploymentFacility.createTargets(targetNames);
                        if (targetList2 == null) {
                            this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.createTargetsFailed"), domain);
                            return;
                        }
                        targetList = new SunTarget[targetList2.length];
                        for (int ii = 0; ii < targetList2.length; ++ii) {
                            targetList[ii] = (SunTarget)targetList2[ii];
                        }
                    } else if (!DeploymentClientUtils.isTargetListComplete(deployedTargets, targetList)) {
                        this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.specifyAllTargets", this.moduleID, "redeploy"), domain);
                        return;
                    }
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.putAll(deployOptions);
                    options.put("redeploy", Boolean.toString(isModuleDeployed));
                    RollBackAction undeplRollback = new RollBackAction(4, this.moduleID, deployOptions);
                    for (int i = 0; i < targetList.length; ++i) {
                        options.put("X-DeploymentMgr.Cascade", "true");
                        DeploymentClientUtils.setResourceOptions(options, "resUndeployment", targetList[i].getName());
                        com.sun.enterprise.deployment.backend.DeploymentStatus stat = DeploymentClientUtils.stopApplication(dasConnection.getExistingMBeanServerConnection(), this.moduleID, targetList[i], options);
                        if (!this.checkStatusAndAddStage(targetList[i], null, localStrings.getString("enterprise.deployment.client.redeploy_stop", targetList[i].getName()), dasConnection, stat)) {
                            return;
                        }
                        options.put("X-DeploymentMgr.Cascade", "false");
                        stat = DeploymentClientUtils.deleteApplicationReference(dasConnection.getExistingMBeanServerConnection(), this.moduleID, targetList[i], options);
                        if (!this.checkStatusAndAddStage(targetList[i], undeplRollback, localStrings.getString("enterprise.deployment.client.redeploy_remove_ref", targetList[i].getName()), dasConnection, stat)) {
                            return;
                        }
                        undeplRollback.addTarget(targetList[i], 3);
                    }
                }
            }
            deployActionID = this.deplMgr.initDeploy();
            HashMap<String, String> dupOptions = new HashMap<String, String>();
            dupOptions.putAll(deployOptions);
            dupOptions.put("X-DeploymentMgr.Enable", Boolean.TRUE.toString());
            dupOptions.put("redeploy", Boolean.toString(isModuleDeployed));
            if ("domain".equals(targetList[0].getName())) {
                if (isRedeploy) {
                    DeploymentClientUtils.setResourceOptions(dupOptions, "resRedeployment", targetList);
                } else {
                    DeploymentClientUtils.setResourceOptions(dupOptions, "resDeployment", targetList);
                }
            } else {
                DeploymentClientUtils.setResourceOptions(dupOptions, "resNoOp", targetList);
            }
            String uploadProp = (String)deployOptions.get("upload");
            boolean upload = new Boolean(uploadProp != null ? uploadProp : "true");
            if (!isDirectoryDeploy && !isLocalConnectionSource && upload) {
                long startTime;
                long endTime = startTime = System.currentTimeMillis();
                if (serverId.isSecure() || this.jmxUploadChunkSizeProp != null && this.jmxUploadChunkSizeProp.length() > 0 || this.httpProxyHostProp != null && this.httpProxyHostProp.length() > 0) {
                    File f;
                    archiveUploadID = this.uploadArchive(deployArchive);
                    if (deployPlan != null && deployPlan.getURI() != null && (f = new File(deployPlan.getURI().getPath())).length() != 0L) {
                        planUploadID = this.uploadArchive(deployPlan);
                    }
                    endTime = System.currentTimeMillis();
                    this.deplMgr.startDeploy(deployActionID, archiveUploadID, planUploadID, dupOptions);
                } else {
                    File f;
                    String archivePath = this.uploadArchiveOverHTTP(serverId, deployArchive);
                    DeploymentSourceImpl archiveSource = new DeploymentSourceImpl(archivePath, true, new String[1], new String[1], new String[1], new HashMap());
                    String planPath = null;
                    MapCapableBase planSource = null;
                    if (deployPlan != null && deployPlan.getURI() != null && (f = new File(deployPlan.getURI().getPath())).length() != 0L) {
                        planPath = this.uploadArchiveOverHTTP(serverId, deployPlan);
                        planSource = new DeploymentSourceImpl(planPath, true, new String[1], new String[1], new String[1], new HashMap());
                    }
                    endTime = System.currentTimeMillis();
                    this.deplMgr.startDeploy(deployActionID, archiveSource.asMap(), planSource == null ? null : planSource.asMap(), dupOptions);
                }
                _logger.log(Level.FINE, "time in upload: " + (endTime - startTime));
            } else {
                if (isDirectoryDeploy && !this.isDomainLocal(domain)) {
                    this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.domainNotLocal"), domain);
                    return;
                }
                DeploymentSourceImpl archive = new DeploymentSourceImpl(deployArchive.getURI().getPath(), true, new String[1], new String[1], new String[1], new HashMap());
                this.deplMgr.startDeploy(deployActionID, archive.asMap(), null, dupOptions);
            }
            if (deployActionID == null) {
                this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.no_deployment_id"), domain);
                return;
            }
            boolean done = false;
            int waitLoopCount = 0;
            DeploymentStatus finalStatusFromMBean = null;
            do {
                Notification[] notifs = this.deplMgr.takeNotifications(deployActionID);
                for (int i = 0; i < notifs.length; ++i) {
                    Map notifType = (Map)notifs[i].getUserData();
                    if (notifType.get("X-DeploymentMgr.DeploymentCompletedStatus") != null) {
                        finalStatusFromMBean = DeploymentSupport.mapToDeploymentStatus(this.deplMgr.getFinalDeploymentStatus(deployActionID));
                        done = true;
                        continue;
                    }
                    if (notifType.get("X-DeploymentMgr.DeploymentProgress") == null) continue;
                    DeploymentProgress prog = DeploymentSupport.mapToDeploymentProgress((Map)notifType.get("X-DeploymentMgr.DeploymentProgress"));
                    String progStr = prog.getDescription() + " : " + prog.getProgressPercent() + "%";
                    this.fireProgressEvent(StateType.RUNNING, progStr, domain);
                }
                if (!done) {
                    if ((long)waitLoopCount > 10000000L) {
                        this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.deployment_time_out"), domain);
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                ++waitLoopCount;
            } while (!done);
            com.sun.enterprise.deployment.backend.DeploymentStatus tmp = DeploymentClientUtils.getDeploymentStatusFromAdminStatus(finalStatusFromMBean);
            if (!this.checkStatusAndAddStage(domain, null, localStrings.getString("enterprise.deployment.client.deploy_in_domain"), dasConnection, tmp)) {
                return;
            }
            if (this.moduleID == null) {
                this.moduleID = tmp.getProperty("moduleid");
            }
            String key = this.moduleID + "_" + "ModuleType";
            this.moduleType = ModuleType.getModuleType(new Integer(tmp.getProperty(key)));
            RollBackAction rollback = new RollBackAction(1, this.moduleID, deployOptions);
            if (!"domain".equals(targetList[0].getName())) {
                for (int i = 0; i < targetList.length; ++i) {
                    if (deployedTargets != null) {
                        dupOptions.put("X-DeploymentMgr.Enable", deployedTargets.get(targetList[i].getName()).toString());
                    } else {
                        dupOptions.put("X-DeploymentMgr.Enable", (String)deployOptions.get("X-DeploymentMgr.Enable"));
                    }
                    com.sun.enterprise.deployment.backend.DeploymentStatus stat = DeploymentClientUtils.createApplicationReference(dasConnection.getExistingMBeanServerConnection(), this.moduleID, targetList[i], dupOptions);
                    if (!this.checkStatusAndAddStage(targetList[i], rollback, localStrings.getString("enterprise.deployment.client.deploy_create_ref", targetList[i].getName()), dasConnection, stat)) {
                        return;
                    }
                    rollback.addTarget(targetList[i], 1);
                    if (deployedTargets != null && Boolean.FALSE.equals(deployedTargets.get(targetList[i].getName()))) continue;
                    if (isRedeploy) {
                        DeploymentClientUtils.setResourceOptions(deployOptions, "resRedeployment", targetList[i].getName());
                    } else {
                        DeploymentClientUtils.setResourceOptions(deployOptions, "resDeployment", targetList[i].getName());
                    }
                    stat = DeploymentClientUtils.startApplication(dasConnection.getExistingMBeanServerConnection(), this.moduleID, targetList[i], deployOptions);
                    this.checkStatusAndAddStage(targetList[i], null, localStrings.getString("enterprise.deployment.client.deploy_start", targetList[i].getName()), dasConnection, stat, true);
                }
            }
            if (!isLocalConnectionSource) {
                try {
                    DeploymentClientUtils.doWsdlFilePublishing(tmp, dasConnection);
                }
                catch (Exception wsdlEx) {
                    com.sun.enterprise.deployment.backend.DeploymentStatus newStatus = new com.sun.enterprise.deployment.backend.DeploymentStatus();
                    newStatus.setStageStatus(0);
                    newStatus.setStageStatusMessage(wsdlEx.getMessage());
                    newStatus.setStageException(wsdlEx);
                    this.checkStatusAndAddStage(domain, rollback, localStrings.getString("enterprise.deployment.client.deploy_publish_wsdl"), dasConnection, newStatus);
                    String msg = localStrings.getString("enterprise.deployment.client.deploy_publish_wsdl_exception", wsdlEx.getMessage());
                    this.setupForAbnormalExit(msg, domain);
                    return;
                }
            }
            this.initializeTargetModuleIDForAllServers(tmp, dasConnection.getMBeanServerConnection(false));
            this.setupForNormalExit(localStrings.getString("enterprise.deployment.client.deploy_application", this.moduleID), domain);
        }
        catch (Throwable ioex) {
            this.finalDeploymentStatus.setStageException(ioex);
            this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.deploy_application_failed", ioex.getMessage()), domain);
            return;
        }
    }

    private boolean isModuleDeployed(ConnectionSource dasConnection, String moduleID) throws Exception {
        return DeploymentClientUtils.isModuleDeployed(dasConnection.getExistingMBeanServerConnection(), moduleID);
    }

    private boolean isDomainLocal(SunTarget domain) {
        if ("localhost".equalsIgnoreCase(domain.getHostName())) {
            return true;
        }
        try {
            InetAddress lh = InetAddress.getLocalHost();
            if (domain.getHostName().equalsIgnoreCase(lh.getCanonicalHostName())) {
                return true;
            }
            if (domain.getHostName().equalsIgnoreCase(lh.getHostName())) {
                return true;
            }
            if (domain.getHostName().equalsIgnoreCase(lh.getHostAddress())) {
                return true;
            }
        }
        catch (UnknownHostException ex) {
            return false;
        }
        return false;
    }

    private String getArchiveName(Archive archive) {
        if (archive.getURI() == null) {
            return null;
        }
        String name = archive.getURI().getPath();
        if (name != null) {
            return name.substring(name.lastIndexOf("/") + 1);
        }
        return name;
    }
}

