/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.client;

import com.sun.appserv.management.base.UploadDownloadMgr;
import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.config.SystemPropertiesAccess;
import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.deploy.DeploymentSupport;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.XModuleType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class DeploymentClientUtils {
    private static final String APPS_CONFIG_MBEAN = "com.sun.appserv:type=applications,category=config";
    private static ObjectName applicationsMBean = JMXUtil.newObjectName("com.sun.appserv:type=applications,category=config");

    public static final String mapModuleTypeToXType(ModuleType moduleType) {
        if (ModuleType.EAR.equals(moduleType)) {
            return "X-J2EEApplicationConfig";
        }
        if (ModuleType.EJB.equals(moduleType)) {
            return "X-EJBModuleConfig";
        }
        if (ModuleType.RAR.equals(moduleType)) {
            return "X-RARModuleConfig";
        }
        if (ModuleType.WAR.equals(moduleType)) {
            return "X-WebModuleConfig";
        }
        if (ModuleType.CAR.equals(moduleType)) {
            return "X-AppClientModuleConfig";
        }
        return null;
    }

    public static final ModuleType getModuleType(MBeanServerConnection mbsc, String moduleID) throws Exception {
        if (mbsc != null) {
            String[] signature = new String[]{"java.lang.String"};
            Object[] params = new Object[]{moduleID};
            Integer modType = (Integer)mbsc.invoke(applicationsMBean, "getModuleType", params, signature);
            if (modType != null) {
                return XModuleType.getModuleType(modType);
            }
        }
        return null;
    }

    public static final com.sun.enterprise.deployment.backend.DeploymentStatus deleteApplicationReference(MBeanServerConnection mbsc, String moduleID, SunTarget target, Map options) throws Exception {
        if (mbsc != null) {
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.util.Map"};
            Object[] params = new Object[]{target.getName(), moduleID, options};
            return (com.sun.enterprise.deployment.backend.DeploymentStatus)mbsc.invoke(applicationsMBean, "deleteApplicationReference", params, signature);
        }
        return null;
    }

    public static final com.sun.enterprise.deployment.backend.DeploymentStatus stopApplication(MBeanServerConnection mbsc, String moduleID, SunTarget target, Map options) throws Exception {
        if (mbsc != null) {
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.util.Map"};
            Object[] params = new Object[]{moduleID, target.getName(), options};
            return (com.sun.enterprise.deployment.backend.DeploymentStatus)mbsc.invoke(applicationsMBean, "stop", params, signature);
        }
        return null;
    }

    public static final com.sun.enterprise.deployment.backend.DeploymentStatus createApplicationReference(MBeanServerConnection mbsc, String moduleID, SunTarget target, Map options) throws Exception {
        if (mbsc != null) {
            Object[] params = new Object[]{target.getName(), moduleID, options};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.util.Map"};
            return (com.sun.enterprise.deployment.backend.DeploymentStatus)mbsc.invoke(applicationsMBean, "createApplicationReference", params, signature);
        }
        return null;
    }

    public static final com.sun.enterprise.deployment.backend.DeploymentStatus startApplication(MBeanServerConnection mbsc, String moduleID, SunTarget target, Map options) throws Exception {
        if (mbsc != null) {
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.util.Map"};
            Object[] params = new Object[]{moduleID, target.getName(), options};
            return (com.sun.enterprise.deployment.backend.DeploymentStatus)mbsc.invoke(applicationsMBean, "start", params, signature);
        }
        return null;
    }

    public static boolean isModuleDeployed(MBeanServerConnection mbsc, String moduleID) throws Exception {
        if (moduleID == null) {
            return false;
        }
        if (mbsc != null) {
            String[] signature = new String[]{"java.lang.String"};
            Object[] params = new Object[]{moduleID};
            Object result = mbsc.invoke(applicationsMBean, "getModuleType", params, signature);
            if (result != null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isLifecycleModule(MBeanServerConnection mbsc, String moduleID) throws Exception {
        if (mbsc != null) {
            String[] signature = new String[]{"java.lang.String"};
            Object[] params = new Object[]{moduleID};
            Boolean ret = (Boolean)mbsc.invoke(applicationsMBean, "isLifecycleModuleRegistered", params, signature);
            if (Boolean.TRUE.equals(ret)) {
                return true;
            }
        }
        return false;
    }

    public static com.sun.enterprise.deployment.backend.DeploymentStatus createLifecycleModuleReference(MBeanServerConnection mbsc, String moduleID, String target, Map options) throws Exception {
        if (mbsc != null) {
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.util.Map"};
            Object[] params = new Object[]{moduleID, target, options};
            return (com.sun.enterprise.deployment.backend.DeploymentStatus)mbsc.invoke(applicationsMBean, "createLifecycleModuleReference", params, signature);
        }
        return null;
    }

    public static com.sun.enterprise.deployment.backend.DeploymentStatus removeLifecycleModuleReference(MBeanServerConnection mbsc, String moduleID, String target) throws Exception {
        if (mbsc != null) {
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            Object[] params = new Object[]{moduleID, target};
            return (com.sun.enterprise.deployment.backend.DeploymentStatus)mbsc.invoke(applicationsMBean, "removeLifecycleModuleReference", params, signature);
        }
        return null;
    }

    public static final void changeStateOfModule(MBeanServerConnection mbsc, String moduleID, String type, SunTarget target, boolean enable) throws Exception {
        if (mbsc != null) {
            Object[] params = new Object[]{moduleID, type, target.getName()};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
            if (enable) {
                mbsc.invoke(applicationsMBean, "enable", params, signature);
            } else {
                mbsc.invoke(applicationsMBean, "disable", params, signature);
            }
        }
    }

    public static boolean isTargetListComplete(Map deployedTargets, SunTarget[] targetList) throws IOException {
        HashMap tmpMap = new HashMap();
        tmpMap.putAll(deployedTargets);
        for (int i = 0; i < targetList.length; ++i) {
            if (tmpMap.get(targetList[i].getName()) == null) continue;
            tmpMap.remove(targetList[i].getName());
        }
        return tmpMap.size() == 0;
    }

    public static boolean isNewTarget(Map deployedTargets, SunTarget[] targetList) throws IOException {
        if (targetList.length == 1 && "domain".equals(targetList[0].getName())) {
            return false;
        }
        if (deployedTargets.size() != targetList.length) {
            return true;
        }
        HashMap tmpMap = new HashMap();
        tmpMap.putAll(deployedTargets);
        for (int i = 0; i < targetList.length; ++i) {
            if (tmpMap.get(targetList[i].getName()) != null) continue;
            return true;
        }
        return false;
    }

    public static Map getDeployedTargetList(ConnectionSource dasConnection, String id) throws IOException {
        DeployedItemRefConfig refProxy;
        SystemPropertiesAccess tgtProxy;
        int i;
        HashMap<String, Boolean> deployedTargets = new HashMap<String, Boolean>();
        DomainConfig domainCfg = ProxyFactory.getInstance(dasConnection).getDomainRoot().getDomainConfig();
        Map<String, StandaloneServerConfig> serverProxies = domainCfg.getStandaloneServerConfigMap();
        Map<String, ClusterConfig> clusterProxies = domainCfg.getClusterConfigMap();
        String[] serverNames = serverProxies.keySet().toArray(new String[0]);
        String[] clusterNames = clusterProxies.keySet().toArray(new String[0]);
        for (i = 0; i < serverNames.length; ++i) {
            tgtProxy = serverProxies.get(serverNames[i]);
            refProxy = (DeployedItemRefConfig)tgtProxy.getContainee("X-DeployedItemRefConfig", id);
            if (refProxy == null) continue;
            deployedTargets.put(serverNames[i], new Boolean(refProxy.getEnabled()));
        }
        for (i = 0; i < clusterNames.length; ++i) {
            tgtProxy = clusterProxies.get(clusterNames[i]);
            refProxy = (DeployedItemRefConfig)tgtProxy.getContainee("X-DeployedItemRefConfig", id);
            if (refProxy == null) continue;
            deployedTargets.put(clusterNames[i], new Boolean(refProxy.getEnabled()));
        }
        return deployedTargets;
    }

    public static com.sun.enterprise.deployment.backend.DeploymentStatus getDeploymentStatusFromAdminStatus(DeploymentStatus stat) {
        com.sun.enterprise.deployment.backend.DeploymentStatus tmp = new com.sun.enterprise.deployment.backend.DeploymentStatus();
        tmp.setStageStatus(stat.getStageStatus());
        if (stat.getThrowable() != null) {
            tmp.setStageException(stat.getThrowable());
        }
        tmp.setStageDescription(stat.getStageDescription());
        tmp.setStageStatusMessage(stat.getStageStatusMessage());
        Iterator<Object> it = stat.getSubStages();
        while (it.hasNext()) {
            DeploymentStatus deploymentStatus = DeploymentSupport.mapToDeploymentStatus(it.next());
            tmp.addSubStage(DeploymentClientUtils.getDeploymentStatusFromAdminStatus(deploymentStatus));
        }
        if (stat.getAdditionalStatus() != null) {
            for (Map.Entry entry : stat.getAdditionalStatus().entrySet()) {
                tmp.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return tmp;
    }

    public static void doWsdlFilePublishing(com.sun.enterprise.deployment.backend.DeploymentStatus status2, ConnectionSource conn) throws IOException {
        if (status2 == null) {
            return;
        }
        String sep = "_";
        String key = "moduleid";
        String moduleID = status2.getProperty(key);
        if (status2.getProperty(key = moduleID + sep + "NumberOfSubModules") == null) {
            DeploymentClientUtils.doWsdlFilePublishing(moduleID, status2, conn);
        } else {
            int counter = Integer.valueOf(status2.getProperty(key));
            for (int i = 0; i < counter; ++i) {
                key = moduleID + sep + "moduleid" + sep + String.valueOf(i);
                String subModuleID = status2.getProperty(key);
                DeploymentClientUtils.doWsdlFilePublishing(subModuleID, status2, conn);
            }
        }
    }

    private static void doWsdlFilePublishing(String keyPrefix, com.sun.enterprise.deployment.backend.DeploymentStatus status2, ConnectionSource conn) throws IOException {
        String sep = "_";
        String key = keyPrefix + sep + "ModuleType";
        ModuleType moduleType = ModuleType.getModuleType(new Integer(status2.getProperty(key)));
        if (!(ModuleType.EAR.equals(moduleType) || ModuleType.WAR.equals(moduleType) || ModuleType.EJB.equals(moduleType))) {
            return;
        }
        key = keyPrefix + sep + "ClientPublishURL";
        String clientPublishURL = status2.getProperty(key);
        if (clientPublishURL == null) {
            return;
        }
        URL u = new URL(clientPublishURL);
        String destinationDir = new File(u.getFile()).getAbsolutePath();
        key = keyPrefix + sep + "WsdlFileEntries" + sep + "NumberOfEntries";
        int counter = Integer.valueOf(status2.getProperty(key));
        for (int i = 0; i < counter; ++i) {
            boolean madeDirs;
            key = keyPrefix + sep + "WsdlFileEntries" + sep + String.valueOf(i);
            String entryName = status2.getProperty(key).replace('/', File.separatorChar);
            key = key + sep + "WsdlFileLocation";
            String wsdlFileLocation = status2.getProperty(key);
            File outputFile = new File(destinationDir, entryName);
            File parentDir = outputFile.getParentFile();
            if (!parentDir.exists() && !(madeDirs = parentDir.mkdirs())) {
                throw new IOException("Error creating " + outputFile);
            }
            DeploymentClientUtils.downloadFile(new File(wsdlFileLocation), outputFile, conn);
        }
    }

    public static String downloadClientStubs(String moduleID, String destDir, ConnectionSource dasConnection) throws IOException {
        Object[] params = new Object[]{moduleID};
        String[] signature = new String[]{"java.lang.String"};
        MBeanServerConnection mbsc = dasConnection.getExistingMBeanServerConnection();
        try {
            ModuleType moduleType = DeploymentClientUtils.getModuleType(mbsc, moduleID);
            if (!(ModuleType.EJB.equals(moduleType) || ModuleType.CAR.equals(moduleType) || ModuleType.EAR.equals(moduleType))) {
                DOLUtils.getDefaultLogger().log(Level.WARNING, "retrieve_client_stub_not_applicable", new Object[]{moduleID, moduleType});
                return null;
            }
            ObjectName ssMBean = ObjectNames.getSystemServicesObjectName();
            String filePath = (String)mbsc.invoke(ssMBean, "getClientStubJarLocation", params, signature);
            File srcFile = new File(filePath);
            DeploymentClientUtils.downloadFile(srcFile, new File(destDir, srcFile.getName()), dasConnection);
            String exportedFileLocation = new File(destDir, srcFile.getName()).getAbsolutePath();
            return exportedFileLocation;
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getLocalizedMessage()).initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(File srcFile, File destFile, ConnectionSource dasConnection) throws IOException {
        File destDir = destFile.getParentFile();
        if (!(destDir.exists() && destDir.isDirectory() && destDir.canWrite())) {
            throw new IOException("Problem accessing directory " + destDir.getPath());
        }
        UploadDownloadMgr downloadMgr = ProxyFactory.getInstance(dasConnection).getDomainRoot().getUploadDownloadMgr();
        int chunkSize = 32768;
        FileOutputStream fos = null;
        try {
            Object downloadID = downloadMgr.initiateDownload(srcFile, false);
            fos = new FileOutputStream(destFile);
            boolean done = false;
            while (!done) {
                byte[] bytes = downloadMgr.downloadBytes(downloadID, chunkSize);
                fos.write(bytes, 0, bytes.length);
                if (bytes.length >= chunkSize) continue;
                done = true;
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void setResourceOptions(Map options, String rAction, SunTarget[] targetList) {
        options.put("resourceAction", rAction);
        options.put("resourceTargetList", DeploymentClientUtils.getTargetStringFromTargetList(targetList));
    }

    public static void setResourceOptions(Map options, String rAction, String target) {
        options.put("resourceAction", rAction);
        options.put("resourceTargetList", target);
    }

    public static String getTargetStringFromTargetList(SunTarget[] targetList) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < targetList.length; ++i) {
            sb.append(targetList[i].getName());
            if (i == targetList.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

