/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.client;

import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.HTTPServiceConfig;
import com.sun.appserv.management.config.VirtualServerConfig;
import com.sun.appserv.management.deploy.DeploymentMgr;
import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.deploy.DeploymentSupport;
import com.sun.enterprise.deployapi.ProgressObjectImpl;
import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployapi.SunTargetModuleID;
import com.sun.enterprise.deployment.client.DeploymentClientUtils;
import com.sun.enterprise.deployment.client.DeploymentFacility;
import com.sun.enterprise.deployment.client.DeploymentFacilityFactory;
import com.sun.enterprise.deployment.client.RollBackAction;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;

public class UndeployAction
extends ProgressObjectImpl {
    private DeploymentMgr deplMgr = null;
    private static StringManager localStrings = StringManager.getManager(UndeployAction.class);

    public UndeployAction(SunTarget[] targets) {
        super(targets);
    }

    public void run() {
        ConnectionSource dasConnection = (ConnectionSource)this.args[0];
        String moduleID = (String)this.args[1];
        Map deployOptions = (Map)this.args[2];
        SunTarget[] targetList = (SunTarget[])this.args[3];
        SunTarget domain = (SunTarget)this.args[4];
        boolean isLocalConnectionSource = (Boolean)this.args[5];
        try {
            if (DeploymentClientUtils.getModuleType(dasConnection.getExistingMBeanServerConnection(), moduleID) == ModuleType.WAR && this.isDefaultWebModule(domain, dasConnection, moduleID)) {
                return;
            }
            this.deplMgr = ProxyFactory.getInstance(dasConnection).getDomainRoot().getDeploymentMgr();
            Map deployedTargets = DeploymentClientUtils.getDeployedTargetList(dasConnection, moduleID);
            ArrayList<SunTargetModuleID> resultTargetModuleIDs = new ArrayList<SunTargetModuleID>();
            if (deployedTargets.size() > 0) {
                if ("domain".equals(targetList[0].getName())) {
                    DeploymentFacility deploymentFacility = isLocalConnectionSource ? DeploymentFacilityFactory.getLocalDeploymentFacility() : DeploymentFacilityFactory.getDeploymentFacility();
                    deploymentFacility.connect(targetList[0].getConnectionInfo());
                    Set nameSet = deployedTargets.keySet();
                    String[] targetNames = nameSet.toArray(new String[nameSet.size()]);
                    Target[] targetList2 = deploymentFacility.createTargets(targetNames);
                    if (targetList2 == null) {
                        this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.createTargetsFailed"), domain);
                        return;
                    }
                    targetList = new SunTarget[targetList2.length];
                    for (int ii = 0; ii < targetList2.length; ++ii) {
                        targetList[ii] = (SunTarget)targetList2[ii];
                    }
                } else if (!DeploymentClientUtils.isTargetListComplete(deployedTargets, targetList)) {
                    this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.specifyAllTargets", moduleID, "undeploy"), domain);
                    return;
                }
                RollBackAction rollback = new RollBackAction(4, moduleID, deployOptions);
                deployOptions.put("X-DeploymentMgr.Force", "false");
                for (int i = 0; i < targetList.length; ++i) {
                    DeploymentClientUtils.setResourceOptions(deployOptions, "resUndeployment", targetList[i].getName());
                    com.sun.enterprise.deployment.backend.DeploymentStatus stat = DeploymentClientUtils.stopApplication(dasConnection.getExistingMBeanServerConnection(), moduleID, targetList[i], deployOptions);
                    if (!this.checkStatusAndAddStage(targetList[i], null, localStrings.getString("enterprise.deployment.client.undeploy_stop", targetList[i].getName()), dasConnection, stat)) {
                        return;
                    }
                    stat = DeploymentClientUtils.deleteApplicationReference(dasConnection.getExistingMBeanServerConnection(), moduleID, targetList[i], deployOptions);
                    if (!this.checkStatusAndAddStage(targetList[i], rollback, localStrings.getString("enterprise.deployment.client.undeploy_remove_ref", targetList[i].getName()), dasConnection, stat)) {
                        return;
                    }
                    rollback.addTarget(targetList[i], 3);
                    resultTargetModuleIDs.add(new SunTargetModuleID(moduleID, targetList[i]));
                }
            }
            if ("domain".equals(targetList[0].getName())) {
                DeploymentClientUtils.setResourceOptions(deployOptions, "resUndeployment", targetList);
            } else {
                DeploymentClientUtils.setResourceOptions(deployOptions, "resNoOp", targetList);
            }
            this.fireProgressEvent(StateType.RUNNING, localStrings.getString("enterprise.deployment.client.undeploying"), domain);
            Map<String, Serializable> undeployStatus = this.deplMgr.undeploy(moduleID, deployOptions);
            DeploymentStatus finalStatusFromMBean = DeploymentSupport.mapToDeploymentStatus(undeployStatus);
            com.sun.enterprise.deployment.backend.DeploymentStatus tmp = DeploymentClientUtils.getDeploymentStatusFromAdminStatus(finalStatusFromMBean);
            if (!this.checkStatusAndAddStage(domain, null, localStrings.getString("enterprise.deployment.client.undeploy_from_domain"), dasConnection, tmp)) {
                return;
            }
            resultTargetModuleIDs.add(new SunTargetModuleID(moduleID, domain));
            this.targetModuleIDs = new TargetModuleID[resultTargetModuleIDs.size()];
            this.targetModuleIDs = resultTargetModuleIDs.toArray(this.targetModuleIDs);
            this.setupForNormalExit(localStrings.getString("enterprise.deployment.client.undeploy_application", moduleID), domain);
        }
        catch (Throwable ioex) {
            this.finalDeploymentStatus.setStageException(ioex);
            this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.undeploy_application_failed", ioex.getMessage()), domain);
            return;
        }
    }

    private boolean isDefaultWebModule(SunTarget domain, ConnectionSource dasConnection, String moduleID) {
        try {
            DomainConfig cfg = ProxyFactory.getInstance(dasConnection).getDomainRoot().getDomainConfig();
            Map<String, ConfigConfig> cfgcfg = cfg.getConfigConfigMap();
            Iterator<String> it1 = cfgcfg.keySet().iterator();
            while (it1.hasNext()) {
                ConfigConfig cf1 = cfgcfg.get(it1.next());
                HTTPServiceConfig httpSvc = cf1.getHTTPServiceConfig();
                Map<String, VirtualServerConfig> vsMap = httpSvc.getVirtualServerConfigMap();
                Iterator<String> it2 = vsMap.keySet().iterator();
                while (it2.hasNext()) {
                    VirtualServerConfig vs = vsMap.get(it2.next());
                    if (!moduleID.equals(vs.getDefaultWebModule())) continue;
                    this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.def_web_module_refs_exist", moduleID), domain);
                    return true;
                }
            }
        }
        catch (Throwable ioex) {
            this.finalDeploymentStatus.setStageException(ioex);
            this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.undeploy_application_failed", ioex.getMessage()), domain);
            return true;
        }
        return false;
    }
}

